// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?  class LMS 6100  


//                 __ 
//        _||__---|  |  
//      _)           |
//        o o O O O_|  

#version 3.6;  
//#version unofficial megapov 1.2;


#include "colors.inc"  
#include "shapes.inc" 
#include "mkmoss.inc"    

#declare showTree=1;

#if(showTree)
#include "black_tupelo.inc" 
#include "my_lombardy_poplar.inc"
#include "my_quaking_aspen.inc"
#end
  

#declare useTestTex = 0;      
#declare cameraView = 0; // 0 = normal, 1 = overhead, 2 = 45 degree            
#declare showTrain = 1;
#declare showBuilding = 1;     
#declare showWalls = 1;
#declare showBeams = 1;          
#declare showShedDoors = 1;
#declare useIso = 1; 
#declare useArea = 1;     
#declare showMoss = 1;
#declare useMossHair=true;    
#declare hfLandRes=900;//900
#declare showLandscape=1;
#declare useFocalBlur=8;//5;    
#declare showGlass = 1;
/******************************************************************************************************
!!!!!!!!!!!!!!!!!! Search for TO_DO to find anything to finish !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! 
******************************************************************************************************/     

// TO_DO - update window texture for front window of train as it looks rubbish!!

#declare use_rad=1;  // radiosity: 0=no rad, 1=load, 2=save


#declare generalRand = seed(582);   

// Macro to return a random number

#macro gr(num)
        rand(generalRand)*num
#end



#declare PRETRACE_END=2/image_width;

/*
Mega pov radiosity
global_settings {
 assumed_gamma 1.0
 ambient_light 0.0 
 max_trace_level 15        
#if(use_rad) 
 radiosity{ 
  // save settings: modified Outdoor settings from rad_def.inc
  #if (use_rad=2) 
    pretrace_start 1
    pretrace_end  PRETRACE_END //1/image_width   
    
    count 150
    nearest_count 10
    //error_bound 0.2   
    error_bound { 0.2 adaptive 2.0, 20 }
  
    low_error_factor .8
    gray_threshold 0
    recursion_limit 2
    brightness 0.8
    adc_bailout 0.01/2
    normal on
    randomize on
    save_file "oldtrain.rad"
  #end
  #if(use_rad=1)
    // load settings  
    pretrace_start 1 pretrace_end 1 
    load_file "oldtrain.rad" 
//    error_bound 0.07    // it's important to specify the same value used to save data
    error_bound { 0.2 adaptive 2.0, 20 }
    recursion_limit 2  // also the same if specified
    always_sample off  // no more samples: specially useful with focal blur
    normal on
    randomize on
  #end
 }
 #end
}  
*/


global_settings{
 assumed_gamma 1.0
 ambient_light 0.0    
 max_trace_level 15
 #if (use_rad)
 radiosity{ 
  // save settings: modified Outdoor settings from rad_def.inc
  #if (use_rad=2) 
    pretrace_start 0.08
    pretrace_end   1/image_width
    count 200
    nearest_count 20
    error_bound 0.1
    recursion_limit 2
    low_error_factor .9
    gray_threshold 0
    minimum_reuse 0.015
    brightness 1
    adc_bailout 0.01/2
    save_file "oldtrain.rad" 
    
  #else
    // load settings  
    pretrace_start 1 pretrace_end 1 
    load_file "oldtrain.rad" 
    error_bound 0.1    // it's important to specify the same value used to save data
    recursion_limit 2  // also the same if specified
    always_sample off  // no more samples: specially useful with focal blur          
  #end
 }
 #end
}
      


      
sky_sphere {
  pigment {
    gradient y  
    triangle_wave
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [1.0 rgb <0.4,0.6,0.9>]
    }
  }         
  pigment
  {
        wrinkles      
        turbulence 0.275
        scallop_wave
        omega 0.7
        lambda 2.8
        colour_map
        {
                [ 0.0 rgbt 1 ]
                [ 0.9 rgbt 1 ]
                [ 0.95 rgbt <1, 1, 1, 0.5> ]
                [ 1.01 rgbt <1, 1, 1, 0.1> ] 
        }  
        scale <1, 0.2, 0.2>
  }  
} 

light_source {
  <0, 0, 0>            // light's position (translated below)
  color (White+(Gold*2))*1.5  // light's color
#if(useArea)
  area_light
  <50, 0, 0> <0, 0, 50> // lights spread out across this distance (x * z)
  10, 10                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
#end
//  translate <1500, 1400, -300>         
  translate <650, 1400, -150>         
  // light_source { ...
  // put this inside a light_source to add light fading
  fade_distance 2500
  fade_power 2

}   
   


// ----------------------------------------

camera {
//  location  <0.0, 0.5, -240.0>
#if(cameraView = 0)
//  location  <170, 75, 50.0>
//  look_at   <-200.0, 20,  500>
  location  <85, 35, 30>
  look_at   <-185.0, 20,  500>
#end
#if(cameraView = 1)
  location  <-30.0, 155, -150.0>
  look_at   <-30.0, 0.0,  -120.0>
#end
#if(cameraView = 2)
  location  <120.0, 45, -250.0>
  look_at   <0, 25.0,  20.0>
#end
#if(useFocalBlur)
  aperture 0.025          // [0...N] larger is narrower depth of field (blurrier)
  blur_samples useFocalBlur*8        // number of rays per pixel for sampling
//  focal_point <15,2,118>    // point that is in focus <X,Y,Z>
  focal_point <-150,20,500>    // point that is in focus <X,Y,Z>
  confidence 0.99999//0.8999+(useFocalBlur/1000)           // [0...<1] when to move on while sampling (smaller is less accurate)
  variance 1/(20000*useFocalBlur)            // [0...1] how precise to calculate (smaller is more accurate)
#end

  direction 1.5*z
  right     x*image_width/image_height
  rotate <0, 0, 0>
}




#declare dummyTex=texture { pigment { rgbt <1, 1, 1, 1> } }
       



// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D


// Moss textures       

#declare mHairTex = texture 
{ 
        pigment
        {
                wrinkles      
                omega 0.625
                lambda 2.5 
                turbulence 0.375
                colour_map
                {
                        [ 0.0 rgb <0.0075, 0.06, 0.0005>*0.75 ]
                        [ 0.25 rgb <0.0085, 0.08, 0.0006>*0.75 ]        
                        [ 0.5 rgb <0.0055, 0.05, 0.0004>*0.75 ]
                        [ 0.7 rgb <0.105, 0.04, 0.0002>*0.75 ]
                        [ 0.8 rgb <0.115, 0.05, 0.0001>*0.75 ]
                        [ 1.0 rgb <0.0065, 0.07, 0.0003>*0.75 ]                                            
                } 
                scale 0.1
        }     
        finish { ambient 0 brilliance 1.2 }
}

#declare mEarthTex = texture  
{ 
        pigment 
        { 
                granite 
                turbulence 0.3 
                omega 0.7 
                lambda 2.8
                colour_map
                {
                        [ 0.0 rgb <0.09, 0.03, 0.001>*0.75 ]
                        [ 0.5 rgb <0.05, 0.02, 0.003>*0.75 ]
                        [ 1.0 rgb <0.1, 0.040, 0.001>*0.75 ]
                }                                     
                scale 0.1
        }                         
        finish { ambient 0 diffuse 0.4 } 
        normal
        {
                wrinkles 3 turbulence 0.6 omega 0.8 scale 0.8
        }
}
     



// End of moss textures



#declare puttyTex = texture
{
        pigment 
        {      
                wrinkles 
                turbulence 0.235
                omega 0.65
                colour_map
                {
                        [ 0.0 rgb <0.65, 0.575, 0.38>*0.8 ]
                        [ 0.1 rgb <0.65, 0.575, 0.38>*0.2 ]
                        [ 0.7 rgb <0.65, 0.575, 0.38>*0.6 ]
                        [ 0.8 rgb <0.1, 0.035, 0.0> ]
                        [ 0.9 rgb <0.65, 0.575, 0.38>*0.8 ]
                        [ 1.0 rgb <0.65, 0.575, 0.38>*0.5 ]
                }
                scale 0.1        
        }                             
        finish { ambient 0 diffuse 0.55 }
        normal 
        { 
                average 
                normal_map
                {
                        [ 1 wrinkles 3.5 turbulence 0.4 scale 0.3 ]
                        [ 1 dents 7 turbulence 0.4 scale 0.2 ]
                }
        }
}     


#declare plank_tex = texture
{
        pigment { rgb <0.35, 0.015, 0.002> }
        finish { phong 0.2 phong_size 15 ambient 0 }
        normal { dents 1 scale 0.125 }
} 
texture 
{
        pigment
        {
                wrinkles 
                turbulence 0.2 
                omega 0.7
                lambda 4
                colour_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.4 rgbt <1, 1, 1, 1> ]
                        [ 0.4 rgbt <0.05, 0.01, 0, 0.5> ]
                        [ 0.46 rgbt <0.1, 0.02, 0.001, 0.1> ]
                        [ 0.5 rgbt <0.15, 0.05, 0.01, 0.1> ]
                        [ 0.55 rgbt <0.1, 0.1, 0.002, 0.4> ]                        
                        [ 0.55 rgbt <1, 1, 1, 1> ]
                        [ 1.0 rgbt <1, 1, 1, 1> ]
                }        
                scale 0.075
               
        }
}    
texture 
{
        pigment
        {
                gradient y 
                turbulence 1 
                omega 0.65
                lambda 4
                colour_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.1 rgbt <1, 1, 1, 1> ]
                        [ 0.1 rgbt <0.05, 0.01, 0, 0.5> ]
                        [ 0.4 rgbt <0.1, 0.02, 0.001, 0.1> ]
                        [ 0.5 rgbt <0.15, 0.05, 0.01, 0.1> ]
                        [ 0.9 rgbt <0.1, 0.1, 0.002, 0.4> ]                        
                        [ 0.9 rgbt <1, 1, 1, 1> ]
                        [ 1.0 rgbt <1, 1, 1, 1> ]
                }    
                scale <10, 50, 10>
        }
}

             



// Dirt textures
// Paint Textures        
#declare TopDirt = texture
{
        pigment 
        {         
                bozo
                turbulence 0.3275  
                omega 0.85
                lambda 3
                colour_map
                {
                        [ 0.0 rgbt <0.06, 0.04, 0.004, 0.5> ]
                        [ 1.0 rgbt <0.06, 0.04, 0.004, 0> ]
                                         
                }    
                scale <0.6, 0.35, 0.4> 
        }
        finish { ambient 0 diffuse 0.15 }     
        normal 
        { 
                average 
                normal_map
                {
                        [ 1 dents 1 scale 0.07 turbulence 0.2 omega 0.6 lambda 2.5 ]
                        [ 0.5 granite 0.5 scale 0.1 turbulence 0.4 omega 0.65 lambda 2.5 ]       
                        [ 0.75 wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5 ]
                }  
        }
}
texture
{
        pigment 
        {         
                bozo
                turbulence 0.475  
                omega 0.85
                lambda 3
                colour_map
                {
                        [ 0.0 rgbt <0.04, 0.03, 0.01, 0.4> ]
                        [ 1.0 rgbt <0.04, 0.03, 0.01, 0> ]
                                         
                }    
                scale <0.7, 2, 0.7> 
        }
        finish { ambient 0 diffuse 0.15 }     
        normal 
        { 
                average 
                normal_map
                {
                        [ 1 dents 1 scale 0.07 turbulence 0.2 omega 0.6 lambda 2.5 ]
                        [ 0.5 granite 0.5 scale 0.1 turbulence 0.4 omega 0.65 lambda 2.5 ]       
                        [ 0.75 wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5 ]
                }  
        }
}

#declare MiddleDirt = texture
{
        pigment 
        {         
                bozo
                turbulence 0.675  
                omega 0.85
                lambda 3
                colour_map
                {
                        [ 0.0 rgbt <0.06, 0.04, 0.004, 0.9> ]
                        [ 1.0 rgbt <0.06, 0.04, 0.004, 0.1> ]
                                         
                }    
                scale <0.7, 1.2, 0.5> 
        }
        finish { ambient 0 diffuse 0.25 }     
        normal 
        { 
                average 
                normal_map
                {
                        [ 1 dents 1 scale 0.07 turbulence 0.2 omega 0.6 lambda 2.5 ]
                        [ 0.5 granite 0.5 scale 0.1 turbulence 0.4 omega 0.65 lambda 2.5 ]       
                        [ 0.75 wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5 ]
                }  
        }
}
texture
{
        pigment 
        {         
                bozo
                turbulence 0.475  
                omega 0.85
                lambda 3
                colour_map
                {
                        [ 0.0 rgbt <0.04, 0.03, 0.01, 0.7> ]
                        [ 1.0 rgbt <0.04, 0.03, 0.01, 0.05> ]
                                         
                }    
                scale <1, 3.75, 1> 
        }
        finish { ambient 0 diffuse 0.2 }     
        normal 
        { 
                average 
                normal_map
                {
                        [ 1 dents 1 scale 0.07 turbulence 0.2 omega 0.6 lambda 2.5 ]
                        [ 0.5 granite 0.5 scale 0.1 turbulence 0.4 omega 0.65 lambda 2.5 ]       
                        [ 0.75 wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5 ]
                }  
        }
}

#declare BottomDirt = texture
{
        pigment 
        {         
                bozo
                turbulence 0.3275  
                omega 0.85
                lambda 3
                colour_map
                {
                        [ 0.0 rgbt <0.06, 0.04, 0.004, 1> ]
                        [ 1.0 rgbt <0.06, 0.04, 0.004, 0> ]
                                         
                }    
                scale <0.8, 0.5, 0.6> 
        }
        finish { ambient 0 diffuse 0.3 }     
        normal 
        { 
                average 
                normal_map
                {
                        [ 1 dents 1 scale 0.07 turbulence 0.2 omega 0.6 lambda 2.5 ]
                        [ 0.5 granite 0.5 scale 0.1 turbulence 0.4 omega 0.65 lambda 2.5 ]       
                        [ 0.75 wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5 ]
                }  
        }
}
texture
{
        pigment 
        {         
                bozo
                turbulence 0.475  
                omega 0.85
                lambda 3
                colour_map
                {
                        [ 0.0 rgbt <0.04, 0.03, 0.01, 0.8> ]
                        [ 1.0 rgbt <0.04, 0.03, 0.01, 0> ]
                                         
                }    
                scale <1, 3, 1> 
        }
        finish { ambient 0 diffuse 0.3 }     
        normal 
        { 
                average 
                normal_map
                {
                        [ 1 dents 1 scale 0.07 turbulence 0.2 omega 0.6 lambda 2.5 ]
                        [ 0.5 granite 0.5 scale 0.1 turbulence 0.4 omega 0.65 lambda 2.5 ]       
                        [ 0.75 wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5 ]
                }  
        }
}


#declare LowLevelDirt = texture
{
        pigment 
        {         
                bozo
                turbulence 0.3275  
                omega 0.85
                lambda 3
                colour_map
                {
                        [ 0.0 rgbt <0.06, 0.04, 0.004, 1> ]
                        [ 1.0 rgbt <0.06, 0.04, 0.004, 0.5> ]
                                         
                }    
                scale <0.8, 0.5, 0.6> 
        }
        finish { ambient 0 diffuse 0.3 }     
        normal 
        { 
                average 
                normal_map
                {
                        [ 1 dents 1 scale 0.07 turbulence 0.2 omega 0.6 lambda 2.5 ]
                        [ 0.5 granite 0.5 scale 0.1 turbulence 0.4 omega 0.65 lambda 2.5 ]       
                        [ 0.75 wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5 ]
                }  
        }
}
texture
{
        pigment 
        {         
                bozo
                turbulence 0.475  
                omega 0.85
                lambda 3
                colour_map
                {
                        [ 0.0 rgbt <0.04, 0.03, 0.01, 1> ]
                        [ 1.0 rgbt <0.04, 0.03, 0.01, 0.4> ]
                                         
                }    
                scale <1, 3, 1> 
        }
        finish { ambient 0 diffuse 0.3 }     
        normal 
        { 
                average 
                normal_map
                {
                        [ 1 dents 1 scale 0.07 turbulence 0.2 omega 0.6 lambda 2.5 ]
                        [ 0.5 granite 0.5 scale 0.1 turbulence 0.4 omega 0.65 lambda 2.5 ]       
                        [ 0.75 wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5 ]
                }  
        }
}





#if(useTestTex)
#declare windowGlass = material
{
texture 
{ 
        pigment { rgbt <0.975, 0.98, 0.99, 0.95> } 
        finish 
        {
                ambient 0
                diffuse 0.2
                brilliance 1.0
        }
}   
}
#else        
#declare windowGlass = material 
{  
        texture 
        {
                pigment 
                { 
                                rgbt<0.975, 0.98, 0.99, 0.95> 
                }
                finish  { phong 0.3 phong_size 120 reflection { 0.005, 0.05 fresnel on } ambient 0 diffuse 0.6 }
        }
        texture 
        {
                pigment 
                { 
                        bozo triangle_wave lambda 3.5 omega 0.6 octaves 10 turbulence 0.475
                        color_map
                        {
                                [ 0.0 rgbt <0.3, 0.12, 0.05, 0.625> ]
                                [ 0.045 rgbt <0.7, 0.45, 0.10, 0.8> ]
                                [ 0.125 rgbt <1.0, 1.0, 1.0, 0.95> ]
                                [ 0.25 rgbt <1.0, 1.0, 1.0, 0.95> ]
                                [ 0.5  rgbt <0.8, 0.5, 0.20, 0.95> ]
                                [ 0.825 rgbt <1.0, 1.0, 1.0, 0.95> ]
                                [ 0.95 rgbt <1.0, 1.0, 1.0, 0.95> ]
                                [ 1.0 rgbt <0.2, 0.07, 0.01, 0.55> ]
                        }            
                        scale <2, 3, 0.5>    
                }
                finish  { phong 0.1 phong_size 20 reflection { 0.0, 0.01 fresnel on } ambient 0 diffuse 0.5 }
        } 
        texture 
        {
                pigment 
                {
                        gradient x     
                        triangle_wave 
                        lambda 4
                        omega 0.6
                        turbulence <0.1, 0.1, 0.02>
                        color_map
                        { 
                                [ 0.0 rgbt <0.1, 0.04, 0.0175, 0.1> ] 
                                [ 0.6 rgbt <0.3, 0.19, 0.07, 0.95> ] 
                                [ 1.0 rgbt <1, 1, 1, 1> ] 
                        }                            
                        scale <3, 1, 8>
                }                
                finish  { phong 0.1 phong_size 20 reflection { 0.0, 0.01 fresnel on } ambient 0 diffuse 0.4 }
        } 
        texture 
        {
                pigment 
                {
                        gradient y     
                        triangle_wave 
                        lambda 4
                        omega 0.6
                        turbulence <0.02, 0.1, 0.1>
                        color_map
                        { 
                                [ 0.0 rgbt <0.1, 0.04, 0.0175, 0.1> ] 
                                [ 0.6 rgbt <0.3, 0.19, 0.07, 0.95> ] 
                                [ 1.0 rgbt <1, 1, 1, 1> ] 
                        }                            
                        scale <8, 1, 2>
                }                
                finish  { phong 0.1 phong_size 20 reflection { 0.0, 0.01 fresnel on } ambient 0 diffuse 0.4 }
        } 
        
        interior { ior 1.6 caustics 1 }  
        translate <-1.6, 0.0, 0>
        scale <0.26, 1, 1>      
} 
#end

        
// TO_DO Need to add DIRT to these textures        
#if(useTestTex)
#declare Chrome_Handle_Tex = texture 
{ 
        pigment { rgb <0.62, 0.61, 0.6> }
        finish { ambient 0 diffuse 0.5 brilliance 2.75 }       
}

#declare couplingTex = texture
{
        pigment { rgb <0.2, 0.2, 0.25> }
        finish { ambient 0 brilliance 3 }
}              
#else  

#declare Chrome_Handle_Tex = texture 
{ 
        pigment { rgb <1, 0.875, 0.75> }
        finish { ambient 0 diffuse 0.65 brilliance 5 specular 2.25 roughness 0.02 phong 0.7 phong_size 75 metallic reflection 0.02 }
        normal { wood 0.2 scale 0.075 }
}  
texture   // add a slight touch of rust
{                                      
        pigment 
        {                 
                wrinkles   
                scallop_wave
                turbulence 0.31 
                omega 0.65 
                lambda 3 
                colour_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.2 rgbt <1, 1, 1, 1> ]
                        [ 0.2 rgbt <0.1, 0.035, 0.005, 1> ] 
                        [ 0.53 rgbt <0.1, 0.035, 0.005, 0.14> ]
                        [ 0.7 rgbt <0.15, 0.085, 0.009, 0.4> ]
                        [ 0.89 rgbt <0.15, 0.085, 0.009, 1> ]
                        [ 1 rgbt <1, 1, 1, 1> ]
                }  
                scale 0.25
        }
        finish { ambient 0 diffuse 0.4 }
        normal { wrinkles 1 }

}      
texture   // add a slight touch of rust
{                                      
        pigment 
        {                 
                wrinkles   
                turbulence 0.51 
                omega 0.675 
                lambda 2.5 
                colour_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.3 rgbt <1, 1, 1, 1> ]
                        [ 0.3 rgbt <0.1, 0.035, 0.005, 1> ] 
                        [ 0.53 rgbt <0.1, 0.035, 0.005, 0.24> ]
                        [ 0.675 rgbt <0.15, 0.085, 0.009, 0.55> ]
                        [ 0.79 rgbt <0.15, 0.085, 0.009, 1> ]
                        [ 1 rgbt <1, 1, 1, 1> ]
                }  
                scale 1
        }
        finish { ambient 0 diffuse 0.4 }
        normal { wrinkles 1 }

}
texture { MiddleDirt }      


#declare couplingTex = texture
{
        pigment 
        { 
                gradient x 
                turbulence 0.025 
                lambda 3 
                omega 0.6 
                colour_map 
                { 
                        [ 0.0 rgb <0.2, 0.2, 0.25> ] 
                        [ 1.0 rgb <0.05, 0.04, 0.02> ] 
                } 
                scale 10 
                translate <5, 0, 0>  
        }
        finish { ambient 0 specular 1 roughness 0.08 reflection 0.025 brilliance 3 metallic }
        normal { agate 0.3 agate_turb 0.235 omega 0.6 lambda 3 }
}               
texture // add grease/dirt
{                         
        pigment 
        {                 
                wrinkles   
                scallop_wave
                turbulence 0.31 
                omega 0.65 
                lambda 3                            
                colour_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.1 rgbt <1, 1, 1, 1> ]
                        [ 0.15 rgbt <0.01, 0.002, 0, 1> ]
                        [ 0.20 rgbt <0.01, 0.002, 0, 0.5> ]
                        [ 0.40 rgbt <0.01, 0.002, 0, 0> ]
                        [ 0.45 rgbt <0.025, 0.01, 0.001, 0> ]
                        [ 0.5 rgbt <0.01, 0.002, 0, 0.5> ]
                        [ 0.525 rgbt <0.01, 0.002, 0, 1> ]
                        [ 0.525 rgbt <1, 1, 1, 1> ]
                        [ 0.8 rgbt <1, 1, 1, 1> ]
                        [ 0.8 rgbt <0.1, 0.035, 0.005, 1> ] 
                        [ 0.81 rgbt <0.1, 0.035, 0.005, 0.04> ]
                        [ 0.9 rgbt <0.15, 0.085, 0.009, 0.1> ]
                        [ 0.94 rgbt <0.15, 0.085, 0.009, 1> ]
                        [ 1 rgbt <1, 1, 1, 1> ]
                }  
                scale 3
        }
        finish { ambient 0 diffuse 0.2 }
        normal { wrinkles 1 }

}
texture // add grease/dirt
{                         
        pigment 
        {                 
                wrinkles   
                
                turbulence 1 
                omega 0.75 
                lambda 3 
                colour_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.1 rgbt <1, 1, 1, 1> ]
                        [ 0.15 rgbt <0.01, 0.002, 0, 1> ]
                        [ 0.20 rgbt <0.01, 0.002, 0, 0.5> ]
                        [ 0.40 rgbt <0.01, 0.002, 0, 0.1> ]
                        [ 0.45 rgbt <0.025, 0.01, 0.001, 0.1> ]
                        [ 0.5 rgbt <0.01, 0.002, 0, 0.5> ]
                        [ 0.525 rgbt <0.01, 0.002, 0, 1> ]
                        [ 0.525 rgbt <1, 1, 1, 1> ]
                        [ 0.8 rgbt <1, 1, 1, 1> ]
                        [ 0.8 rgbt <0.1, 0.035, 0.005, 1> ] 
                        [ 0.81 rgbt <0.1, 0.035, 0.005, 0.4> ]
                        [ 0.9 rgbt <0.15, 0.085, 0.009, 0.2> ]
                        [ 0.94 rgbt <0.15, 0.085, 0.009, 1> ]
                        [ 1 rgbt <1, 1, 1, 1> ]
                }  
                scale 2.5
                rotate <20, 30, 10>
        }
        finish { ambient 0 diffuse 0.2 }
        normal { wrinkles 1 }

}
texture { MiddleDirt }      

#end

#if(useTestTex)
#declare blackBadgeTex = texture     
{
        pigment { rgb <0.0001, 0.0001, 0.00015> }
        finish { ambient 0 diffuse 0.4 phong 0.1 phong_size 20 }     
}            
#else
#declare blackBadgeTex = texture     
{
        pigment { rgb <0.0001, 0.0001, 0.00015> }
        finish { ambient 0 diffuse 0.4 phong 0.1 phong_size 20 }     
        normal 
        { 
                wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5 
        }
}
texture { MiddleDirt }                  
#end


#if(useTestTex)
#declare letterTex = texture 
{
        pigment { rgb <0.85, 0.78, 0.6> }
        finish { ambient 0 diffuse 0.5 brilliance 7 }
}
#else
#declare letterTex = texture 
{
        pigment { rgb <0.85, 0.78, 0.6> }
        finish { ambient 0 diffuse 0.5 specular 2 roughness 0.01 brilliance 7 reflection { 0.05, 0.15 metallic fresnel on } conserve_energy }
} 
texture { MiddleDirt }      
#end



// paint textures

#if(useTestTex)
#declare paintTex1 = texture 
{
        pigment {  rgb <0.6, 0.025, 0.001> }
        finish { phong 0.8 ambient 0 }
}
#else   
#declare paintTex1Base = texture 
{
        pigment { agate turbulence 0.3 omega 0.7 colour_map { [ 0.0 rgb <0.1, 0.035, 0.0> ]  [ 0.6 rgb <0.05, 0.0125, 0.0> ]  [ 1 rgb <0.175, 0.0675, 0.0> ] }  scale 5 }
        finish { ambient 0 diffuse 0.3 phong 0.1 phong_size 150  }     
        normal 
        { 
                average 
                normal_map
                {
                        [ 1 dents 1 scale 0.07 turbulence 0.2 omega 0.6 lambda 2.5 ]
                        [ 0.5 granite 0.5 scale 0.1 turbulence 0.4 omega 0.65 lambda 2.5 ]       
                        [ 0.75 wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5 ]
                }  
        }
}    
texture
{
        pigment 
        {         
                wrinkles              
                turbulence 0.825  
                omega 0.8
                lambda 3
                colour_map
                {
                        [ 0.0 rgbt <0.5, 0.075, 0.015, 0> ]
                        [ 0.4 rgbt <0.5, 0.075, 0.015, 0> ]
                        [ 0.6 rgbt <0.5, 0.075, 0.015, 1> ]
                        [ 1.0 rgbt <0.5, 0.075, 0.015, 1> ]
                                                                               
                }    
                scale 5
        }
        finish { ambient 0 diffuse 0.3 phong 0.15 phong_size 50 }     
        normal 
        { 
                average 
                normal_map
                {
                        [ 1 dents 1 scale 0.07 turbulence 0.2 omega 0.6 lambda 2.5 ]
                        [ 0.5 granite 0.5 scale 0.1 turbulence 0.4 omega 0.65 lambda 2.5 ]       
                        [ 0.75 wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5 ]
                }  
        }
} 

#declare paintTex1Top=texture 
{
        paintTex1Base
}                       
texture 
{
        TopDirt 
}
         
#declare paintTex1Middle=texture 
{
        paintTex1Base
}
texture
{
        MiddleDirt
}                      

#declare paintTex1Bottom=texture 
{
        paintTex1Base
}  
texture
{
        BottomDirt
}                      
                       
                      

#declare paintTex1 = texture
{
        slope { <0.02, -1, 0.01> }
        texture_map
        {
                [ 0 paintTex1Top ] 
                [ 0.3 paintTex1Top  ] 
                [ 0.375 paintTex1Middle  ]   
                [ 0.45 paintTex1Middle  ]   
                [ 0.55 paintTex1Bottom  ]   
                [ 1 paintTex1Bottom  ]   
        }     
} 



#end

#if(useTestTex)
#declare paintTex2 = texture     // will become black
{
        pigment { rgb <0.0001, 0.0001, 0.00015> }
        finish { phong 0.8 ambient 0 }
}
#else
#declare paintTex2Base = texture 
{
        pigment { agate turbulence 0.3 omega 0.7 colour_map { [ 0.0 rgb <0.1, 0.035, 0.0> ]  [ 0.6 rgb <0.05, 0.0125, 0.0> ]  [ 1 rgb <0.175, 0.0675, 0.0> ] }  scale 5 }
        finish { ambient 0 diffuse 0.3 phong 0.1 phong_size 150  }     
        normal 
        { 
                average 
                normal_map
                {
                        [ 1 dents 1 scale 0.07 turbulence 0.2 omega 0.6 lambda 2.5 ]
                        [ 0.5 granite 0.5 scale 0.1 turbulence 0.4 omega 0.65 lambda 2.5 ]       
                        [ 0.75 wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5 ]
                }  
        }
}    
texture
{
        pigment 
        {         
                wrinkles              
                turbulence 0.825  
                omega 0.8
                lambda 3
                colour_map
                {
                        [ 0.0 rgbt <0.0001, 0.0001, 0.00015, 0> ]
                        [ 0.4 rgbt <0.0001, 0.0001, 0.00015, 0> ]
                        [ 0.6 rgbt <0.0001, 0.0001, 0.00015, 1> ]
                        [ 1.0 rgbt <0.0001, 0.0001, 0.00015, 1> ]
                                                                               
                }    
                scale 5
        }
        finish { ambient 0 diffuse 0.3 phong 0.15 phong_size 50 }     
        normal 
        { 
                average 
                normal_map
                {
                        [ 1 dents 1 scale 0.07 turbulence 0.2 omega 0.6 lambda 2.5 ]
                        [ 0.5 granite 0.5 scale 0.1 turbulence 0.4 omega 0.65 lambda 2.5 ]       
                        [ 0.75 wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5 ]
                }  
        }
} 

#declare paintTex2Top=texture 
{
        paintTex2Base
}                       
texture 
{
        TopDirt 
}
         
#declare paintTex2Middle=texture 
{
        paintTex2Base
}
texture
{
        MiddleDirt
}                      

#declare paintTex2Bottom=texture 
{
        paintTex2Base
}  
texture
{
        BottomDirt
}                      
                       
                      

#declare paintTex2 = texture
{
        slope { <0.02, -1, 0.01> }
        texture_map
        {
                [ 0 paintTex2Top ] 
                [ 0.3 paintTex2Top  ] 
                [ 0.375 paintTex2Middle  ]   
                [ 0.45 paintTex2Middle  ]   
                [ 0.55 paintTex2Bottom  ]   
                [ 1 paintTex2Bottom  ]   
        }     
} 

#end

#if(useTestTex)
#declare paintTex3 = texture 
{
        pigment { Gold }
        finish { phong 0.8 ambient 0 }
}
#else
#declare paintTex3Base = texture 
{
        pigment { agate turbulence 0.3 omega 0.7 colour_map { [ 0.0 rgb <0.1, 0.035, 0.0> ]  [ 0.6 rgb <0.05, 0.0125, 0.0> ]  [ 1 rgb <0.175, 0.0675, 0.0> ] }  scale 5 }
        finish { ambient 0 diffuse 0.3 specular 1 roughness 0.01 reflection { 0.025, 0.05 metallic fresnel on } conserve_energy }     
        normal 
        { 
                average 
                normal_map
                {
                        [ 1 dents 1 scale 0.07 turbulence 0.2 omega 0.6 lambda 2.5 ]
                        [ 0.5 granite 0.5 scale 0.1 turbulence 0.4 omega 0.65 lambda 2.5 ]       
                        [ 0.75 wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5 ]
                }  
        }
}    
texture
{
        pigment 
        {         
                wrinkles              
                turbulence 0.825  
                omega 0.8
                lambda 3
                colour_map
                {
                        [ 0.0 rgbt <0.35, 0.325, 0.001, 0> ]
                        [ 0.4 rgbt <0.35, 0.325, 0.001, 0> ]
                        [ 0.6 rgbt <0.35, 0.325, 0.001, 1> ]
                        [ 1.0 rgbt <0.35, 0.325, 0.001, 1> ]
                                                                               
                }    
                scale 5
        }
        finish { ambient 0 diffuse 0.3 specular 1 roughness 0.01 reflection { 0.025, 0.05 metallic fresnel on } conserve_energy }     
        normal 
        { 
                average 
                normal_map
                {
                        [ 1 dents 1 scale 0.07 turbulence 0.2 omega 0.6 lambda 2.5 ]
                        [ 0.5 granite 0.5 scale 0.1 turbulence 0.4 omega 0.65 lambda 2.5 ]       
                        [ 0.75 wrinkles 0.1 scale 2 turbulence 0.2 omega 0.6 lambda 2.5 ]
                }  
        }
} 

#declare paintTex3Top=texture 
{
        paintTex3Base
}                       
texture 
{
        TopDirt 
}
         
#declare paintTex3Middle=texture 
{
        paintTex3Base
}
texture
{
        MiddleDirt
}                      

#declare paintTex3Bottom=texture 
{
        paintTex3Base
}  
texture
{
        BottomDirt
}                      
                       
                      

#declare paintTex3 = texture
{
        slope { <0.02, -1, 0.01> }
        texture_map
        {
                [ 0 paintTex3Top ] 
                [ 0.3 paintTex3Top  ] 
                [ 0.375 paintTex3Middle  ]   
                [ 0.45 paintTex3Middle  ]   
                [ 0.55 paintTex3Bottom  ]   
                [ 1 paintTex3Bottom  ]   
        }     
} 

#end

#declare wheelDriveColour = rgb <0.65, 0.65, 0.65>;
#declare wheelDriveRustColour = rgb <0.3, 0.21, 0.125>;     


#macro mkWheelDriveTex(useLayer, layeredTex)
        #if(useTestTex)  
#declare wdTex = texture
        {
                pigment 
                {
                        rgbt <wheelDriveColour.red, wheelDriveColour.green, wheelDriveColour.blue, 0>
                }     
                finish { ambient 0 }
        };        
        #else 
               
#declare wdTexBase = texture 
        { 
                pigment
                { 
                                rgbt <wheelDriveColour.red, wheelDriveColour.green, wheelDriveColour.blue, 0>  
                }
                finish { phong 0.7 ambient 0 phong_size 30 specular 1 roughness 0.01 reflection { 0.05, 0.3 metallic 1 } brilliance 10 }
                normal 
                { 
                        average 
                        normal_map 
                        { 
                                [ 1 wood 0.1 turbulence 0.0005 ] 
                                [ 1 dents 0.75 slope_map { [0   <0, 1>] [0.35 <1, 1>] [0.4 <1,-1>] [0.7   <0,-1>] } scale <2, 0.1, 0.2> turbulence 0.05  ] } }  

                scale 0.15
        }   
        texture 
        { 
                pigment
                {       
                        agate
                        lambda 3
                        omega 0.625 
                        turbulence 0.0375                                 
                        
                        colour_map
                        {
                                [ 0.0 rgbt <1, 1, 1, 1> ]
                                [ 0.8 rgbt <1, 1, 1, 1> ]
                                [ 0.9 rgbt <wheelDriveRustColour.red, wheelDriveRustColour.green, wheelDriveRustColour.blue, 1.0> ]
                                [ 0.95 rgbt <wheelDriveRustColour.red, wheelDriveRustColour.green, wheelDriveRustColour.blue, 0.55> ]
                                [ 1.0 rgbt <wheelDriveRustColour.red, wheelDriveRustColour.green, wheelDriveRustColour.blue, 0.2> ]
                        }                   
                        scale <2.5, 1.2, 1.675>
                        translate <0, 0, 0>
                }                            
                finish { phong 0.01 phong_size 1 specular 0.05 roughness 0.2 brilliance 1.25 diffuse 0.4 ambient 0 }  
        }    
        texture 
        { 
                pigment
                {       
                        wrinkles
                        lambda 3.5
                        omega 0.675 
                        turbulence 0.1275                                 
                        
                        colour_map
                        {
                                [ 0.0 rgbt <1, 1, 1, 1> ]
                                [ 0.7 rgbt <1, 1, 1, 1> ]
                                [ 0.8 rgbt <wheelDriveRustColour.red, wheelDriveRustColour.green, wheelDriveRustColour.blue, 1.0> ]
                                [ 0.94 rgbt <wheelDriveRustColour.red, wheelDriveRustColour.green, wheelDriveRustColour.blue, 0.55> ]
                                [ 1.0 rgbt <wheelDriveRustColour.red, wheelDriveRustColour.green, wheelDriveRustColour.blue, 0.2> ]
                        }                   
                        scale <3.5, 0.4, 1.375>
                        translate <0, 0, 0>
                }                            
                finish { phong 0.01 phong_size 1 specular 0.05 roughness 0.2 brilliance 1.25 diffuse 0.4 ambient 0 }  
        };
        
        #if(useLayer)
        #declare wdTexTop=texture
        {
                wdTexBase
        }
        texture
        {
                TopDirt
        }
        texture
        {
                layeredTex 
        };
        
        #declare wdTexMiddle=texture
        {
                wdTexBase
        }
        texture
        {
                MiddleDirt
        }
        texture
        {
                layeredTex 
        };

        #declare wdTexBottom=texture
        {
                wdTexBase
        }
        texture
        {
                BottomDirt
        }
        texture
        {
                layeredTex 
        };
        #else
        #declare wdTexTop=texture
        {
                wdTexBase
        }
        texture
        {
                TopDirt
        };             

        #declare wdTexMiddle=texture
        {
                wdTexBase
        }
        texture
        {
                MiddleDirt
        };


        #declare wdTexBottom=texture
        {
                wdTexBase
        }
        texture
        {
                BottomDirt
        };        
        #end
                      
        #declare wdTex = texture
        {
                slope { <0.02, -1, 0.01> }
                texture_map
                {
                        [ 0 wdTexTop ] 
                        [ 0.3 wdTexTop  ] 
                        [ 0.375 wdTexMiddle  ]   
                        [ 0.45 wdTexMiddle  ]   
                        [ 0.55 wdTexBottom  ]   
                        [ 1 wdTexBottom  ]   
                }     
        };
        
        wdTex 

        #end
#end


#declare brakePadColour = rgb <0.65, 0.65, 0.65>;
#declare brakePadRustColour = rgb <0.3, 0.21, 0.125>;     


#if(useTestTex)  
#declare brakePadTex = 
texture
        {
                pigment 
                {
                        rgb <brakePadColour.red, brakePadColour.green, brakePadColour.blue>
                }     
                finish { ambient 0 }
        }        
#else        
#declare brakePadTexBase = texture 
        { 
                pigment
                { 
                                rgb <brakePadColour.red, brakePadColour.green, brakePadColour.blue>  
                }
                finish { phong 0.7 ambient 0 phong_size 30 specular 1 roughness 0.01 reflection { 0.05, 0.3 metallic 1 } brilliance 5 }
                normal 
                { 
                        average 
                        normal_map 
                        { 
                                [ 1 wood 0.1 turbulence 0.0005 ] 
                                [ 1 dents 0.75 slope_map { [0   <0, 1>] [0.35 <1, 1>] [0.4 <1,-1>] [0.7   <0,-1>] } scale <2, 0.1, 0.2> turbulence 0.05  ] } }  

                scale 0.15
        }   
        texture 
        { 
                pigment
                {       
                        agate
                        lambda 3
                        omega 0.625 
                        turbulence 0.0375                                 
                        
                        colour_map
                        {
                                [ 0.0 rgbt <1, 1, 1, 1> ]
                                [ 0.8 rgbt <1, 1, 1, 1> ]
                                [ 0.9 rgbt <brakePadRustColour.red, brakePadRustColour.green, brakePadRustColour.blue, 1.0> ]
                                [ 0.95 rgbt <brakePadRustColour.red, brakePadRustColour.green, brakePadRustColour.blue, 0.55> ]
                                [ 1.0 rgbt <brakePadRustColour.red, brakePadRustColour.green, brakePadRustColour.blue, 0.8> ]
                        }                   
                        scale <2.5, 1.2, 1.675>
                        translate <0, 0, 0>
                }                            
                finish { phong 0.01 phong_size 1 specular 0.05 roughness 0.2 brilliance 0.9 diffuse 0.4 ambient 0 }  
        }    
        texture 
        { 
                pigment
                {       
                        wrinkles
                        lambda 3.5
                        omega 0.675 
                        turbulence 0.1275                                 
                        
                        colour_map
                        {
                                [ 0.0 rgbt <1, 1, 1, 1> ]
                                [ 0.7 rgbt <1, 1, 1, 1> ]
                                [ 0.8 rgbt <brakePadRustColour.red, brakePadRustColour.green, brakePadRustColour.blue, 1.0> ]
                                [ 0.94 rgbt <brakePadRustColour.red, brakePadRustColour.green, brakePadRustColour.blue, 0.55> ]
                                [ 1.0 rgbt <brakePadRustColour.red, brakePadRustColour.green, brakePadRustColour.blue, 0.8> ]
                        }                   
                        scale <3.5, 0.4, 1.375>
                        translate <0, 0, 0>
                }                            
                finish { phong 0.01 phong_size 1 specular 0.05 roughness 0.2 brilliance 0.9 diffuse 0.4 ambient 0 }  
        }
        texture
        {
                pigment
                {
                        wood   
                        poly_wave    
                        omega 0.755
                        lambda 6
                        octaves 10
                        turbulence 0.0035
                        colour_map
                        {
                                [ 0.0 rgbt <0.01, 0.005, 0, 0.01> ]
                                [ 0.41 rgbt <0.02, 0.01, 0, 0.011> ]
                                [ 0.475 rgbt <.05, .02, .001, 0.035> ]
                                [ 0.525 rgbt <.1, .03, .005, 1> ]
                                [ 0.7 rgbt <.1, .03, .005, 1> ]
                                [ 0.7 rgbt <1, 1, 1, 1> ]
                                [ 1.0 rgbt <1, 1, 1, 1> ]
                        }         
                        scale 50  
                }                 
                finish { ambient 0 diffuse 0.25 }
        } 

        #declare brakePadTexTop=texture
        {
                brakePadTexBase
        }
        texture
        {
                TopDirt
        };             

        #declare brakePadTexMiddle=texture
        {
                brakePadTexBase
        }
        texture
        {
                MiddleDirt
        };


        #declare brakePadTexBottom=texture
        {
                brakePadTexBase
        }
        texture
        {
                BottomDirt
        };        

        
        #declare brakePadTex = texture
        {
                slope { <0.02, -1, 0.01> }
                texture_map
                {
                        [ 0 brakePadTexTop ] 
                        [ 0.3 brakePadTexTop  ] 
                        [ 0.375 brakePadTexMiddle  ]   
                        [ 0.45 brakePadTexMiddle  ]   
                        [ 0.55 brakePadTexBottom  ]   
                        [ 1 brakePadTexBottom  ]   
                }     
        };
#end



#declare wheelRimColour = rgb <0.355, 0.365, 0.335>;   
#declare wheelRimRustColour = rgb <0.65, 0.4, 0.25>;   


#macro mkWheelRimTex(useLayer, layeredTex)
        #if(useTestTex)  
        texture
        {
                pigment 
                {
                        rgbt <wheelRimColour.red, wheelRimColour.green, wheelRimColour.blue, 0>
                }         
                finish { ambient 0 }
        }        
        #else        
#declare wheelRimBase = texture 
        { 
                pigment
                { 
                                rgbt <wheelRimColour.red, wheelRimColour.green, wheelRimColour.blue, 0>  
                }
                finish { specular 1 roughness 0.01 ambient 0 reflection { 0.185, 0.8 metallic 1 } brilliance 10 diffuse 0.7 }
                normal { average normal_map { [ 1 wood 0.9 turbulence 0.0005 ] [ 1 dents 0.6 scale 0.15 turbulence 0.2  ] } }  
                scale 0.15
        }   
        texture 
        { 
                pigment
                {       
                        agate
                        lambda 3.5
                        omega 0.725 
                        turbulence 0.275                                 
                        
                        colour_map
                        {
                                [ 0.0 rgbt <1, 1, 1, 1> ]
                                [ 0.3 rgbt <1, 1, 1, 1> ]
                                [ 0.4 rgbt <wheelRimRustColour.red, wheelRimRustColour.green, wheelRimRustColour.blue, 1.0> ]
                                [ 0.65 rgbt <wheelRimRustColour.red, wheelRimRustColour.green, wheelRimRustColour.blue, 0.55> ]
                                [ 1.0 rgbt <wheelRimRustColour.red, wheelRimRustColour.green, wheelRimRustColour.blue, 0.2> ]
                        }                   
                        scale <1.5, 0.9, 0.675>
                        translate <0, 0, 0>
                }                            
                finish { phong 0.01 phong_size 1 ambient 0 specular 0.05 roughness 0.2 brilliance 0.9 diffuse 0.4 }  
        }    
        texture 
        { 
                pigment
                {       
                        wrinkles
                        lambda 3.5
                        omega 0.725 
                        turbulence 0.5275                                 
                        
                        colour_map
                        {
                                [ 0.0 rgbt <1, 1, 1, 1> ]
                                [ 0.4 rgbt <1, 1, 1, 1> ]
                                [ 0.6 rgbt <wheelRimRustColour.red, wheelRimRustColour.green, wheelRimRustColour.blue, 1.0> ]
                                [ 0.75 rgbt <wheelRimRustColour.red, wheelRimRustColour.green, wheelRimRustColour.blue, 0.55> ]
                                [ 1.0 rgbt <wheelRimRustColour.red, wheelRimRustColour.green, wheelRimRustColour.blue, 0.2> ]
                        }                   
                        scale <1.5, 0.9, 0.675>
                        translate <0, 0, 0>
                }                            
                finish { phong 0.01 phong_size 1 ambient 0 specular 0.05 roughness 0.2 brilliance 0.9 diffuse 0.4 }  
        };
        
        #if(useLayer)
        #declare wrTexTop=texture
        {
                wheelRimBase
        }
        texture
        {
                TopDirt
        }
        texture
        {
                layeredTex 
        };
        
        #declare wrTexMiddle=texture
        {
                wheelRimBase
        }
        texture
        {
                MiddleDirt
        }
        texture
        {
                layeredTex 
        };

        #declare wdTexBottom=texture
        {
                wrTexBase
        }
        texture
        {
                wheelRimBase
        }
        texture
        {
                layeredTex 
        };
        #else
        #declare wrTexTop=texture
        {
                wheelRimBase
        }
        texture
        {
                TopDirt
        };             

        #declare wrTexMiddle=texture
        {
                wheelRimBase
        }
        texture
        {
                MiddleDirt
        };


        #declare wrTexBottom=texture
        {
                wheelRimBase
        }
        texture
        {
                BottomDirt
        };        
        #end
                      
        #declare wrTex = texture
        {
                slope { <0.02, -1, 0.01> }
                texture_map
                {
                        [ 0 wrTexTop ] 
                        [ 0.3 wrTexTop  ] 
                        [ 0.375 wrTexMiddle  ]   
                        [ 0.45 wrTexMiddle  ]   
                        [ 0.55 wrTexBottom  ]   
                        [ 1 wrTexBottom  ]   
                }     
        };
        
        texture { wrTex }
           

        #end
#end 
                       


#declare wheelHubColour = rgb <0, 0, 0>;

#macro mkWheelSpokeRimTex(useLayeredTex, layeredTex) 
        #if(useTestTex)  
        texture
        {
                pigment 
                {
                        rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 0>
                }       
                finish { ambient 0 }
        }        
        #else        
        #declare wheelSpokeRimBase = texture 
        { 
                pigment
                {
                        rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 0>
                }                            
                finish { phong 1 ambient 0 phong_size 60 specular 0.5 roughness 0.02 reflection 0.035 brilliance 1 diffuse 0.75 metallic 0.5 }  
                normal { bumps 0.15 scale <0.015, 0.0235, 0.022> turbulence 0.0275 omega 0.6765 }
        }   
        texture 
        { 
                pigment
                {       
                        wood
                        triangle_wave
                        lambda 4
                        omega 0.875 
                        turbulence 0.0375                                 
                        
                        colour_map
                        {
                                [ 0.0 rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 1> ]
                                [ 0.3 rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 1> ]
                                [ 0.4 rgbt <0.8, 0.651, 0.452, 1.0> ]
                                [ 0.55 rgbt <0.8, 0.651, 0.452, 0.8> ]
                                [ 0.8 rgbt <0.8, 0.651, 0.452, 0.6> ]
                                [ 0.95 rgbt <0.8, 0.651, 0.452, 0.25> ]
                                [ 1.0 rgbt <0.8, 0.651, 0.452, 0.1> ]
                        }                   
                        scale <35, 25, 25>
                        translate <-3, 0, 0>
                }                            
                finish { phong 0.01 ambient 0 phong_size 1 brilliance 0.8 diffuse 0.4 }  
                normal { wrinkles 0.45 scale <0.15, 0.085, 0.072> turbulence 0.225 omega 0.6 }
        };

        
        #declare wsrTexTop=texture
        {
                wheelSpokeRimBase
        }
        texture
        {
                TopDirt
        };             

        #declare wsrTexMiddle=texture
        {
                wheelSpokeRimBase
        }
        texture
        {
                MiddleDirt
        };


        #declare wsrTexBottom=texture
        {
                wheelSpokeRimBase
        }
        texture
        {
                BottomDirt
        };        
                      
        #declare wsrTex = texture
        {
                slope { <0.02, -1, 0.01> }
                texture_map
                {
                        [ 0 wsrTexTop ] 
                        [ 0.3 wsrTexTop  ] 
                        [ 0.375 wsrTexMiddle  ]   
                        [ 0.45 wsrTexMiddle  ]   
                        [ 0.55 wsrTexBottom  ]   
                        [ 1 wsrTexBottom  ]   
                }     
        };
        
        texture { wsrTex }
                      
        #end
#end      

 
#macro mkSmallWheelSpokeRimTex() 
        #if(useTestTex)  
        texture
        {
                pigment 
                {
                        rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 0>
                }       
                finish { ambient 0 }
        }        
        #else        
        #declare smallWheelSpokeRimBase = texture 
        { 
                pigment
                {
                        rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 0>
                }                            
                finish { phong 1 ambient 0 phong_size 60 specular 0.5 roughness 0.02 reflection 0.035 brilliance 1 diffuse 0.75 metallic 0.5 }  
                normal { bumps 0.15 scale <0.015, 0.0235, 0.022> turbulence 0.0275 omega 0.6765 }
        }   
        texture 
        { 
                pigment
                {       
                        wood
                        triangle_wave
                        lambda 4
                        omega 0.875 
                        turbulence 0.0375                                 
                        
                        colour_map
                        {
                                [ 0.0 rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 1> ]
                                [ 0.2 rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 1> ]
                                [ 0.3 rgbt <0.8, 0.651, 0.452, 1.0> ]
                                [ 0.45 rgbt <0.8, 0.651, 0.452, 0.8> ]
                                [ 0.7 rgbt <0.8, 0.651, 0.452, 0.6> ]
                                [ 0.85 rgbt <0.8, 0.651, 0.452, 0.25> ]
                                [ 1.0 rgbt <0.8, 0.651, 0.452, 0.1> ]
                        }                   
                        scale <25, 15, 15>
                        translate <-1, 0, 0>
                }                            
                finish { phong 0.01 ambient 0 phong_size 1 brilliance 0.8 diffuse 0.4 }  
                normal { wrinkles 0.45 scale <0.15, 0.085, 0.072> turbulence 0.225 omega 0.6 }
        } 


        
        #declare swsTexTop=texture
        {
                smallWheelSpokeRimBase
        }
        texture
        {
                TopDirt
        };             

        #declare swsTexMiddle=texture
        {
                smallWheelSpokeRimBase
        }
        texture
        {
                MiddleDirt
        };


        #declare swsTexBottom=texture
        {
                smallWheelSpokeRimBase
        }
        texture
        {
                BottomDirt
        };        
                      
        #declare swsTex = texture
        {
                slope { <0.02, -1, 0.01> }
                texture_map
                {
                        [ 0 swsTexTop ] 
                        [ 0.3 swsTexTop  ] 
                        [ 0.375 swsTexMiddle  ]   
                        [ 0.45 swsTexMiddle  ]   
                        [ 0.55 swsTexBottom  ]   
                        [ 1 swsTexBottom  ]   
                }     
        };
        
        texture { swsTex }           
        #end
#end 

#macro mkWheelSpokeTex()  
        #if(useTestTex)  
        texture
        {
                pigment 
                {
                        rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 0>
                }           
                finish { ambient 0 }
        }        
        #else        
        #declare wheelSpokeBase = texture 
        { 
                pigment
                {
                        rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 0>
                }                            
                finish { phong 1 ambient 0 phong_size 60 specular 0.5 roughness 0.02 reflection 0.035 brilliance 1 diffuse 0.75 metallic 0.5 }  
                normal { bumps 0.125 scale <0.2, 0.135, 0.12> turbulence 0.15 }
        }   
        texture 
        { 
                pigment
                {       
                        gradient x    
                        triangle_wave
                        lambda 3.5
                        omega 0.725 
                        turbulence 0.125                                 
                        
                        colour_map
                        {
                                [ 0.0 rgbt <0.8, 0.651, 0.452, 0.1> ]
                                [ 0.1 rgbt <0.8, 0.651, 0.452, 0.25> ]
                                [ 0.2 rgbt <0.8, 0.651, 0.452, 0.6> ]
                                [ 0.6 rgbt <0.8, 0.651, 0.452, 1.0> ]
                                [ 1.0 rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 1> ]
                        }                   
                        scale <17, 5, 5>
                        translate <-19, 0, 0>
                }                            
                finish { phong 0 phong_size 1 ambient 0 roughness 0.2 brilliance 0.8 diffuse 0.4 }  
                normal { wrinkles 0.45 scale <0.5, 0.25, 0.2> turbulence 0.225 }
        } 
        
        
        

        
        #declare wsTexTop=texture
        {
                wheelSpokeBase
        }
        texture
        {
                TopDirt
        };             

        #declare wsTexMiddle=texture
        {
                wheelSpokeBase
        }
        texture
        {
                MiddleDirt
        };


        #declare wsTexBottom=texture
        {
                wheelSpokeBase
        }
        texture
        {
                BottomDirt
        };        
                      
        #declare wsTex = texture
        {
                slope { <0.02, -1, 0.01> }
                texture_map
                {
                        [ 0 wsTexTop ] 
                        [ 0.3 wsTexTop  ] 
                        [ 0.375 wsTexMiddle  ]   
                        [ 0.45 wsTexMiddle  ]   
                        [ 0.55 wsTexBottom  ]   
                        [ 1 wsTexBottom  ]   
                }     
        };       
        
        texture { wsTex }     
        #end
#end

#macro mkSmallWheelSpokeTex()  
        #if(useTestTex)  
        texture
        {
                pigment 
                {
                        rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 0>
                }           
                finish { ambient 0 }
        }        
        #else        
        #declare smallWheelSpokeBase = texture 
        { 
                pigment
                {
                        rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 0>
                }                            
                finish { phong 1 ambient 0 phong_size 60 specular 0.5 roughness 0.02 reflection 0.035 brilliance 1 diffuse 0.75 metallic 0.5 }  
                normal { bumps 0.125 scale <0.2, 0.135, 0.12> turbulence 0.15 }
        }   
        texture 
        { 
                pigment
                {       
                        gradient x    
                        triangle_wave
                        lambda 3.5
                        omega 0.725 
                        turbulence 0.125                                 
                        
                        colour_map
                        {
                                [ 0.0 rgbt <0.8, 0.651, 0.452, 0.1> ]
                                [ 0.1 rgbt <0.8, 0.651, 0.452, 0.25> ]
                                [ 0.2 rgbt <0.8, 0.651, 0.452, 0.6> ]
                                [ 0.6 rgbt <0.8, 0.651, 0.452, 1.0> ]
                                [ 1.0 rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 1> ]
                        }                   
                        scale <7, 5, 5>
                        translate <-19, 0, 0>
                }                            
                finish { phong 0 phong_size 1 ambient 0 roughness 0.2 brilliance 0.8 diffuse 0.4 }  
                normal { wrinkles 0.45 scale <0.5, 0.25, 0.2> turbulence 0.225 }
        }  
        
        
        

        
        #declare smallWSTexTop=texture
        {
                smallWheelSpokeBase
        }
        texture
        {
                TopDirt
        };             

        #declare smallWSTexMiddle=texture
        {
                smallWheelSpokeBase
        }
        texture
        {
                MiddleDirt
        };


        #declare smallWSTexBottom=texture
        {
                smallWheelSpokeBase
        }
        texture
        {
                BottomDirt
        };        
                      
        #declare smallWSTex = texture
        {
                slope { <0.02, -1, 0.01> }
                texture_map
                {
                        [ 0 smallWSTexTop ] 
                        [ 0.3 smallWSTexTop  ] 
                        [ 0.375 smallWSTexMiddle  ]   
                        [ 0.45 smallWSTexMiddle  ]   
                        [ 0.55 smallWSTexBottom  ]   
                        [ 1 smallWSTexBottom  ]   
                }     
        };       
        
        texture { smallWSTex }             
        #end
#end
                                             
#macro mkWheelHubTex() 
        #if(useTestTex)  
        texture
        {
                pigment 
                {
                        rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 0>
                }      
                finish { ambient 0 }
        }        
        #else        
        #declare wheelHubBase = texture 
        { 
                pigment
                {
                        rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 0>
                }                            
                finish { phong 1 ambient 0 phong_size 60 specular 0.5 roughness 0.02 reflection 0.035 brilliance 1 diffuse 0.75 metallic 0.5 }  
                normal { bumps 0.15 scale <0.015, 0.0235, 0.022> turbulence 0.0275 omega 0.6765 }
        }   
        texture 
        { 
                pigment
                {       
                        wood
                        triangle_wave
                        lambda 4
                        omega 0.875 
                        turbulence 0.0375                                 
                        
                        colour_map
                        {
                                [ 0.0 rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 1> ]
                                [ 0.3 rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 1> ]
                                [ 0.4 rgbt <0.8, 0.651, 0.452, 1.0> ]
                                [ 0.55 rgbt <0.8, 0.651, 0.452, 0.8> ]
                                [ 0.8 rgbt <0.8, 0.651, 0.452, 0.6> ]
                                [ 0.95 rgbt <0.8, 0.651, 0.452, 0.25> ]
                                [ 1.0 rgbt <0.8, 0.651, 0.452, 0.1> ]
                        }                   
                        scale <35, 25, 25>
                        translate <-3, 0, 0>
                }                            
                finish { phong 0 phong_size 1 ambient 0 roughness 0.2 brilliance 0.8 diffuse 0.4 }  
                normal { wrinkles 0.45 scale <0.15, 0.085, 0.072> turbulence 0.225 omega 0.6 }
        };  
        
        
        

        
        #declare whTexTop=texture
        {
                wheelHubBase
        }
        texture
        {
                TopDirt
        };             

        #declare whTexMiddle=texture
        {
                wheelHubBase
        }
        texture
        {
                MiddleDirt
        };


        #declare whTexBottom=texture
        {
                wheelHubBase
        }
        texture
        {
                BottomDirt
        };        
                      
        #declare whTex = texture
        {
                slope { <0.02, -1, 0.01> }
                texture_map
                {
                        [ 0 whTexTop ] 
                        [ 0.3 whTexTop  ] 
                        [ 0.375 whTexMiddle  ]   
                        [ 0.45 whTexMiddle  ]   
                        [ 0.55 whTexBottom  ]   
                        [ 1 whTexBottom  ]   
                }     
        };       
        
        texture { whTex }                       
        #end
#end 

#macro mkSmallWheelHubTex() 
        #if(useTestTex)  
        texture
        {
                pigment 
                {
                        rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 0>
                }      
                finish { ambient 0 }
        }        
        #else        
        #declare smallWheelHubBase = texture 
        { 
                pigment
                {
                        rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 0>
                }                            
                finish { phong 1 ambient 0 phong_size 60 specular 0.5 roughness 0.02 reflection 0.035 brilliance 1 diffuse 0.75 metallic 0.5 }  
                normal { bumps 0.15 scale <0.015, 0.0235, 0.022> turbulence 0.0275 omega 0.6765 }
        }   
        texture 
        { 
                pigment
                {       
                        wood
                        triangle_wave
                        lambda 4
                        omega 0.875 
                        turbulence 0.0375                                 
                        
                        colour_map
                        {
                                [ 0.0 rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 1> ]
                                [ 0.2 rgbt <wheelHubColour.red, wheelHubColour.green, wheelHubColour.blue, 1> ]
                                [ 0.3 rgbt <0.8, 0.651, 0.452, 1.0> ]
                                [ 0.45 rgbt <0.8, 0.651, 0.452, 0.8> ]
                                [ 0.7 rgbt <0.8, 0.651, 0.452, 0.6> ]
                                [ 0.85 rgbt <0.8, 0.651, 0.452, 0.25> ]
                                [ 1.0 rgbt <0.8, 0.651, 0.452, 0.1> ]
                        }                   
                        scale <25, 15, 15>
                        translate <-1, 0, 0>
                }                            
                finish { phong 0 phong_size 1 ambient 0 roughness 0.2 brilliance 0.8 diffuse 0.4 }  
                normal { wrinkles 0.45 scale <0.15, 0.085, 0.072> turbulence 0.225 omega 0.6 }
        };
        
        
        
        #declare swhTexTop=texture
        {
                smallWheelHubBase
        }
        texture
        {
                TopDirt
        };             

        #declare swhTexMiddle=texture
        {
                smallWheelHubBase
        }
        texture
        {
                MiddleDirt
        };


        #declare swhTexBottom=texture
        {
                smallWheelHubBase
        }
        texture
        {
                BottomDirt
        };        
                      
        #declare swhTex = texture
        {
                slope { <0.02, -1, 0.01> }
                texture_map
                {
                        [ 0 swhTexTop ] 
                        [ 0.3 swhTexTop  ] 
                        [ 0.375 swhTexMiddle  ]   
                        [ 0.45 swhTexMiddle  ]   
                        [ 0.55 swhTexBottom  ]   
                        [ 1 swhTexBottom  ]   
                }     
        };       
        
        texture { swhTex }                       
        
         
        #end
#end 


#declare wheelHubMiddleColour = rgb <0.25, 0.25, 0.25>;   
#declare wheelHubRustColour = rgb <0.325, 0.1, 0.045>;   


#macro mkWheelHubMidTex() 
        #if(useTestTex)  
        texture
        {
                pigment 
                {
                        rgbt <wheelHubMiddleColour.red, wheelHubMiddleColour.green, wheelHubMiddleColour.blue, 0>
                }       
                finish { ambient 0 }
        }        
        #else        
        #declare wheelHubMidBase = texture 
        { 
                pigment
                { 
                        wood
                        colour_map
                        {
                                [ 0.0 rgbt <wheelHubMiddleColour.red, wheelHubMiddleColour.green, wheelHubMiddleColour.blue, 0>  ]
                                [ 0.15 rgbt <wheelHubMiddleColour.red, wheelHubMiddleColour.green, wheelHubMiddleColour.blue, 0>  ]
                                [ 0.9 rgbt <wheelHubRustColour.red, wheelHubRustColour.green, wheelHubRustColour.blue, 0>  ] 
                                [ 1.0 rgbt <wheelHubRustColour.red, wheelHubRustColour.green, wheelHubRustColour.blue, 0>  ] 
                        }
                }                            
                finish { specular 1 ambient 0 roughness 0.01 reflection { 0.075, 0.35 metallic 1 } brilliance 2 diffuse 0.55 }
                normal { average normal_map { [ 1 wood 0.9 ] [ 1 dents 2 scale 0.15 turbulence 0.2  ] } }  
                scale 0.065
        }   
        texture 
        { 
                pigment
                {       
                        bozo
                        scallop_wave
                        lambda 3.5
                        omega 0.725 
                        turbulence 0.1275                                 
                        
                        colour_map
                        {
                                [ 0.0 rgbt <1, 1, 1, 1> ]
                                [ 0.8 rgbt <1, 1, 1, 1> ]
                                [ 0.9 rgbt <wheelHubRustColour.red, wheelHubRustColour.green, wheelHubRustColour.blue, 1.0> ]
                                [ 0.95 rgbt <wheelHubRustColour.red, wheelHubRustColour.green, wheelHubRustColour.blue, 0.5> ]
                                [ 1.0 rgbt <wheelHubRustColour.red, wheelHubRustColour.green, wheelHubRustColour.blue, 0.1> ]
                        }                   
                        scale <1.0, 0.7, 0.475>
                        translate <0, 0, 0>
                }                            
                finish { phong 0.01 phong_size 1 ambient 0 specular 0.05 roughness 0.2 brilliance 0.9 diffuse 0.4 }  
                normal { average normal_map { [ 1 wood 0.9 ] [ 1 dents 2 scale 0.15 turbulence 0.2 ] } scale 0.065 }  
        };
        
        
        #declare whmTexTop=texture
        {
                wheelHubMidBase
        }
        texture
        {
                TopDirt
        };             

        #declare whmTexMiddle=texture
        {
                wheelHubMidBase
        }
        texture
        {
                MiddleDirt
        };


        #declare whmTexBottom=texture
        {
                wheelHubMidBase
        }
        texture
        {
                BottomDirt
        };        
                      
        #declare whmTex = texture
        {
                slope { <0.02, -1, 0.01> }
                texture_map
                {
                        [ 0 whmTexTop ] 
                        [ 0.3 whmTexTop  ] 
                        [ 0.375 whmTexMiddle  ]   
                        [ 0.45 whmTexMiddle  ]   
                        [ 0.55 whmTexBottom  ]   
                        [ 1 whmTexBottom  ]   
                }     
        };       
        
        texture { whmTex }                   
        #end
#end       



//#declare sliderTex = mkWheelDriveTex(0, dummyTex);                          
#macro sliderSmoothTex()
#declare slLTex = texture
{
        pigment { rgbf <0.4, 0.4, 0.42, 0.2> }
        finish { specular 1 roughness 0.0005 ambient 0 brilliance 8 reflection { 0.3 0.9 metallic fresnel on } conserve_energy }
        normal { wrinkles 0.2 scale <200, 0.2, 0.2> }
};  

#declare ssTex = texture { mkWheelDriveTex(0, slLTex) };

 ssTex 
#end                

#macro sliderTex()
#declare sTex = texture { mkWheelDriveTex(1, dummyTex) };
 sTex 
#end

#if(useTestTex)
#declare pipeTexCopper = texture
{
        pigment { rgb <0.6, 0.25, 0.15> }
        finish { ambient 0 brilliance 6 }  
}     
#else
#declare pipeTexCopperBase = texture
{
        pigment { rgb <0.6, 0.25, 0.15> }
        finish { ambient 0 specular 1 phong 0.25 roughness 0.03 brilliance 6 reflection 0.025 metallic }  
        normal 
        { 
                average 
                normal_map
                {
                        [ 1 dents 0.4 turbulence 3 ]
                        [ 0.7 wrinkles 0.25 turbulence 1 scale 0.05 ]                
                }
        }
}     
texture
{
        pigment
        {
                bozo            
                scallop_wave
                turbulence 0.275
                omega 0.6
                lambda 3.5
                colour_map
                {
                  [ 0.0 rgbt <1, 1, 1, 1> ]
                  [ 0.9 rgbt <1, 1, 1, 1> ]
                  [ 0.95 rgbt <0.06, 0.03, 0.002, 0.7> ] 
                  [ 1.0 rgbt <0.025, 0.01, 0.0, 0.25> ]
                    
                }        
                scale 1
        }
        finish { ambient 0 diffuse 0.35 }
}
texture
{
        pigment
        {
                wrinkles       
                cubic_wave
                turbulence 0.375
                omega 0.65
                lambda 3.5
                colour_map
                {
                  [ 0.0 rgbt <1, 1, 1, 1> ]
                  [ 0.025 rgbt <0.0, 0.08, 0.01, 1> ]
                  [ 0.2 rgbt <0.01, 0.07, 0.02, 0.3> ]
                  [ 0.45 rgbt <0.0, 0.08, 0.01, 1> ]
                  [ 0.5 rgbt <1, 1, 1, 1> ]
                  [ 1.0 rgbt <1, 1, 1, 1> ]
                    
                }        
                scale 0.7
        }
        finish { ambient 0 diffuse 0.4 }
}  

        
        #declare ptcTop=texture
        {
                pipeTexCopperBase
        }
        texture
        {
                TopDirt
        };             

        #declare ptcMiddle=texture
        {
                pipeTexCopperBase
        }
        texture
        {
                MiddleDirt
        };


        #declare ptcBottom=texture
        {
                pipeTexCopperBase
        }
        texture
        {
                BottomDirt
        };        
                      
        #declare pipeTexCopper = texture
        {
                slope { <0.02, -1, 0.01> }
                texture_map
                {
                        [ 0 ptcTop ] 
                        [ 0.3 ptcTop  ] 
                        [ 0.375 ptcMiddle  ]   
                        [ 0.45 ptcMiddle  ]   
                        [ 0.55 ptcBottom  ]   
                        [ 1 ptcBottom  ]   
                }     
        }       
#end     

#declare poleTexBase = texture
{
        pigment { quilted colour_map { [ 0.0 rgb <0.4, 0.4, 0.4> ] [ 1.0 rgb <0.2, 0.14, 0.1> ] } scale 0.2 rotate <40, 0, 40> }
        finish { ambient 0 specular 1 roughness 0.01 brilliance 3 metallic reflection 0.1 }
        normal { quilted bump_size 0.75 scale 0.2 rotate <40, 0, 40> }
} 
texture 
{
        pigment 
        { 
                gradient y turbulence 0.025 omega 0.85 lambda 3  
                colour_map
                {
                        [ 0.0 rgbt <0.02, 0.01, 0, 0.0> ]
                        [ 0.05 rgbt <0.02, 0.01, 0, 0.0> ]
                        [ 0.3 rgbt <0.02, 0.01, 0, 1> ]
                        [ 0.3 rgbt <1, 1, 1, 1> ]
                        [ 0.555 rgbt <1, 1, 1, 1> ]
                        [ 0.555 rgbt <0.02, 0.01, 0, 1> ]
                        [ 0.65 rgbt <0.02, 0.01, 0, 0.1> ]
                        [ 0.77 rgbt <0.02, 0.01, 0, 1> ]
                        [ 0.77 rgbt <1, 1, 1, 1> ]
                        [ 0.91 rgbt <1, 1, 1, 1> ]
                        [ 0.91 rgbt <0.06, 0.04, 0.01, 1> ]
                        [ 0.96 rgbt <0.06, 0.04, 0.01, 0.05> ]
                        [ 0.99 rgbt <0.02, 0.01, 0, 0.1> ]
                                       
                }             
                scale 45
        }
        finish { ambient 0 diffuse 0.375 }
        normal { quilted bump_size 0.75 scale 0.2 rotate <40, 0, 40> }
}  
texture 
{
        pigment 
        { 
                wrinkles sine_wave turbulence 0.45 omega 0.65 lambda 3  
                colour_map
                {
                        [ 0.0 rgbt <0.02, 0.01, 0, 0.05> ]
                        [ 0.15 rgbt <0.02, 0.01, 0, 1> ]
                        [ 0.15 rgbt <1, 1, 1, 1> ]
                        [ 0.7 rgbt <1, 1, 1, 1> ]
                        [ 0.7 rgbt <0.06, 0.04, 0.01, 1> ]
                        [ 0.82 rgbt <0.06, 0.04, 0.01, 0.1> ]
                        [ 0.95 rgbt <0.02, 0.01, 0, 0.05> ]
                                       
                }             
                scale 0.05
        }
        finish { ambient 0 diffuse 0.375 }
        normal { quilted bump_size 0.75 scale 0.2 rotate <40, 0, 40> }
}


#declare ptbTop=texture
{
        poleTexBase
}
texture
{
        TopDirt
};             

#declare ptbMiddle=texture
{
        poleTexBase
}
texture
{
        MiddleDirt
};


#declare ptbBottom=texture
{
        poleTexBase
}
texture
{
        BottomDirt
};        
              
#declare poleTex = texture
{
        slope { <0.02, -1, 0.01> }
        texture_map
        {
                [ 0 ptbTop ] 
                [ 0.3 ptbTop  ] 
                [ 0.375 ptbMiddle  ]   
                [ 0.45 ptbMiddle  ]   
                [ 0.55 ptbBottom  ]   
                [ 1 ptbBottom  ]   
        }     
}       

  

#declare poleBaseTexBase = texture
{
        pigment { rgb <0.65, 0.35, 0.02>  }
        finish { ambient 0 specular 0.25 roughness 0.1 brilliance 6 metallic reflection 0.01 }
} 
texture 
{
        pigment 
        { 
                gradient y turbulence 0.05 omega 0.85 lambda 3  
                colour_map
                {
                        [ 0.0 rgbt <0.02, 0.01, 0, 0.1> ]
                        [ 0.025 rgbt <0.02, 0.01, 0, 0.2> ]
                        [ 0.4 rgbt <0.02, 0.01, 0, 1> ]
                        [ 0.5 rgbt <1, 1, 1, 1> ]
                        [ 0.6 rgbt <1, 1, 1, 1> ]
                        [ 0.6 rgbt <0.06, 0.04, 0.01, 1> ]
                        [ 0.9 rgbt <0.06, 0.04, 0.01, 0.125> ]
                        [ 1 rgbt <0.02, 0.01, 0, 0.1> ]
                                       
                }             
                scale 3.75
        }
        finish { ambient 0 diffuse 0.375 }
}  
texture 
{
        pigment 
        { 
                wrinkles turbulence 0.45 omega 0.75 lambda 3  
                colour_map
                {
                        [ 0.0 rgbt <0.02, 0.01, 0, 0.5> ]
                        [ 0.15 rgbt <0.02, 0.01, 0, 1> ]
                        [ 0.15 rgbt <1, 1, 1, 1> ]
                        [ 0.7 rgbt <1, 1, 1, 1> ]
                        [ 0.7 rgbt <0.06, 0.04, 0.01, 1> ]
                        [ 0.82 rgbt <0.06, 0.04, 0.01, 0.3> ]
                        [ 0.95 rgbt <0.02, 0.01, 0, 0.5> ]
                                       
                }             
                scale 0.5
        }
        finish { ambient 0 diffuse 0.375 }
}  



#declare pbtTop=texture
{
        poleBaseTexBase
}
texture
{
        TopDirt
};             

#declare pbtMiddle=texture
{
        poleBaseTexBase
}
texture
{
        MiddleDirt
};


#declare pbtBottom=texture
{
        poleBaseTexBase
}
texture
{
        BottomDirt
};        
              
#declare poleBaseTex = texture
{
        slope { <0.02, -1, 0.01> }
        texture_map
        {
                [ 0 pbtTop ] 
                [ 0.3 pbtTop  ] 
                [ 0.375 pbtMiddle  ]   
                [ 0.45 pbtMiddle  ]   
                [ 0.55 pbtBottom  ]   
                [ 1 pbtBottom  ]   
        }     
}       



#declare footPlateTexBase = texture
{
        pigment { rgb <0.1, 0.1, 0.1> }
        finish { ambient 0 specular 0.5 roughness 0.05 brilliance 2 metallic reflection 0.02 }
        normal { dents 1 turbulence 0.5 scale 0.5 }
} 
texture 
{
        pigment 
        { 
                wrinkles turbulence 0.45 omega 0.65 lambda 3  
                colour_map
                {
                        [ 0.0 rgbt <0.02, 0.01, 0, 0.05> ]
                        [ 0.25 rgbt <0.02, 0.01, 0, 1> ]
                        [ 0.25 rgbt <1, 1, 1, 1> ]
                        [ 0.5 rgbt <1, 1, 1, 1> ]
                        [ 0.5 rgbt <0.06, 0.04, 0.01, 1> ]
                        [ 0.7 rgbt <0.06, 0.04, 0.01, 0.1> ]
                        [ 0.95 rgbt <0.02, 0.01, 0, 0.05> ]
                                       
                }             
                scale 2
        }
        finish { ambient 0 diffuse 0.375 }
        normal { dents 1 turbulence 0.5 scale 0.5 }
}  

texture 
{
        pigment 
        { 
                agate agate_turb 1 omega 0.75 lambda 3  
                colour_map
                {
                        [ 0.0 rgbt <0.02, 0.01, 0, 0.2> ]
                        [ 0.35 rgbt <0.02, 0.01, 0, 1> ]
                        [ 0.35 rgbt <1, 1, 1, 1> ]
                        [ 0.5 rgbt <1, 1, 1, 1> ]
                        [ 0.5 rgbt <0.06, 0.04, 0.01, 1> ]
                        [ 0.7 rgbt <0.06, 0.04, 0.01, 0.2> ]
                        [ 0.95 rgbt <0.02, 0.01, 0, 0.2> ]
                                       
                }        
        }
        finish { ambient 0 diffuse 0.3 }
        normal { dents 1 turbulence 0.5 scale 0.5 }
}


#declare fpTop=texture
{
        footPlateTexBase
}
texture
{
        TopDirt
};             

#declare fpMiddle=texture
{
        footPlateTexBase
}
texture
{
        MiddleDirt
};


#declare fpBottom=texture
{
        footPlateTexBase
}
texture
{
        BottomDirt
};        
              
#declare footPlateTex = texture
{
        slope { <0.02, -1, 0.01> }
        texture_map
        {
                [ 0 fpTop ] 
                [ 0.3 fpTop  ] 
                [ 0.375 fpMiddle  ]   
                [ 0.45 fpMiddle  ]   
                [ 0.55 fpBottom  ]   
                [ 1 fpBottom  ]   
        }     
}       



#declare dirtTex = texture
{
        pigment 
        { 
                wrinkles turbulence 0.3 omega 0.65 lambda 3  
                colour_map
                {
                        [ 0.0 rgbt <0.02, 0.01, 0, 0.0> ]
                        [ 0.35 rgbt <0.02, 0.01, 0, 0.8> ]
                        [ 0.4 rgbt <0.06, 0.04, 0.01, 0.8> ]
                        [ 0.6 rgbt <0.06, 0.04, 0.01, 0> ]
                        [ 0.95 rgbt <0.02, 0.01, 0, 0.0> ]
                                       
                }
        }
        finish { ambient 0 diffuse 0.375 }       
        normal { granite 1 turbulence 0.75 scale 0.05 }
        
}

#declare nut = union   // faces in x Direction radius 3
{
        difference
        {      
                union
                {
                        cylinder { <-1, 0, 0> <1, 0, 0> 3 }
                        torus { 1.5, 1.5 rotate <0, 0, 90> scale <0.5, 1, 1> translate <-1, 0, 0> }
                        torus { 1.5, 1.5 rotate <0, 0, 90> scale <0.5, 1, 1> translate <-1, 0, 0> }
                } 
                union
                {
                        box { <-2, -4, -4> <2, 4, -2.5> }
                        box { <-2, -4, -4> <2, 4, -2.5> rotate <60, 0, 0> }
                        box { <-2, -4, -4> <2, 4, -2.5> rotate <120, 0, 0> }
                        box { <-2, -4, -4> <2, 4, -2.5> rotate <180, 0, 0> }
                        box { <-2, -4, -4> <2, 4, -2.5> rotate <240, 0, 0> }
                        box { <-2, -4, -4> <2, 4, -2.5> rotate <300, 0, 0> }  
                        // cut hole
                        cylinder { <-2, 0, 0> <2, 0, 0> 1.1 }  
                        cylinder { <-2, 0, 0> <-1.5, 0, 0> 1.35 }    // for smooth edge to hole
                        cylinder { <1.5, 0, 0> <2, 0, 0> 1.35 }      // for smooth edge to hole
                        
                }
        }  
        intersection   // smooth edges to hole
        {                                     
                torus { 1.35, 0.25 rotate <0, 0, 90> }
                cylinder { <-0.3, 0, 0> <0, 0, 0> 1.35 }
                translate <-1.5, 0, 0>
        }
        intersection   // smooth edges to hole
        {                                     
                torus { 1.35, 0.25 rotate <0, 0, 90> }
                cylinder { <0, 0, 0> <0.3, 0, 0> 1.35 }
                translate <1.5, 0, 0>
        }   
        // put threaded bolt end inside nut
        difference
        {
                object { Round_Cylinder_Union(<-2.6, 0, 0>, <2.6, 0, 0>, 1.15, 0.5) }
                #declare tcut = -2.6;
                #while(tcut < 2.6)
                        torus { 1.15, 0.1 rotate <0, 0, 80> translate <tcut, 0, 0> }
                        #declare tcut=tcut+0.25;
                #end         
        }
        
}  

// attached coupling hook   
#declare coupling = union
{     
        // part attached to other end (coal truck/carriage etc)
        union
        {
                union
                {
                        difference
                        {
                                torus { 1.75, 0.7 }
                                box { <-2.51, -0.751, -2.51> <0, 0.751, 2.51> }
                        }                                                    
                        cylinder { <-4.5, 0, -1.75> <0, 0, -1.75> 0.7 }
                        cylinder { <-4.5, 0, 1.75> <0, 0, 1.75> 0.7 }     
                        Round_Cylinder_Union(<-4.5, 0, -2.6>, <-4.5, 0, -0.9>, 1.25, 0.1)
                        Round_Cylinder_Union(<-4.5, 0, 0.9>, <-4.5, 0, 2.6>, 1.25, 0.1)  
                        Round_Cylinder_Union(<-4.5, 0, -2.9>, <-4.5, 0, 2.9>, 0.75, 0.2)     
                        translate <4.5, 0, 0>
                        rotate <0, 0, 4>
                        translate <-4.5, 0, 0>
                }
                Round_Box_Union(<-7, -2.5, -0.6>, <-4, 2.5, 0.6>, 0.2)     
                Round_Box_Union(<-7, -4.5, -4>, <-5, -1.25, 4>, 0.2)     
                Round_Box_Union(<-7, 1.25, -4>, <-5, 4.5, 4>, 0.2)     
                
                object { nut rotate <0, 180, 0> scale 0.275 translate <-5, -3.5, 0> } 
                object { nut rotate <0, 180, 0> scale 0.275 translate <-5, 3.5, 0> } 
                
                
                    
                translate <-2, 0.5, 0>
        }

        difference
        {
                union
                {
                        cylinder { <0, 0, -0.6> <0, 0, 0.6> 2.5 } 
                        torus { 2.5, 0.3 scale <1, 2, 1> rotate <90, 0, 0> } 
                }
                cylinder { <0, 0, -0.61> <0, 0, 0.61> 1.6 scale <1, 1.5, 1> rotate <0, 0, -15> translate <0.25, 1.4, 0> }
        }          
        intersection
        {
                torus { 1.6, 0.3 scale <1, 2, 1> rotate <90, 0, 0> scale <1, 1.5, 1> rotate <0, 0, -15> translate <0.25, 1.4, 0> }
                union
                {
                        cylinder { <0, 0, -0.6> <0, 0, 0.6> 2.5 }  
                        torus { 2.5, 0.3 scale <1, 2, 1> rotate <90, 0, 0> } 
                }
        }  
        union
        {
                // rear part of hook
                cylinder { <0, 0, -0.8> <0, 0, 0.8> 2 }
                torus { 2, 0.4 scale <1, 2, 1> rotate <90, 0, 0> }   
                // start of coupling
                
                Round_Cylinder_Union(<0, 0, -2.1>, <0, 0, -1.1>, 1.75, 0.3)
                Round_Cylinder_Union(<0, 0, -2.6>, <0, 0, -2.3>, 1.4, 0.1)

                // first arm part
                Round_Box_Union(<-0.6, -13, -2.0>, <0.6, -1.5, -1.2>,0.2)             
                // smooth top joint
                cone { <-0.55, -1, -1.6> 0.5 <-0.2, -4.5, -1.6> 0.3 }
                cone { <0.55, -1, -1.6> 0.5 <0.2, -4.5, -1.6> 0.3 }
                // smooth bottom joint
                cone { <-0.55, -12.5, -1.6> 0.5 <-0.2, -9, -1.6> 0.3 }
                cone { <0.55, -12.5, -1.6> 0.5 <0.2, -9, -1.6> 0.3 }
                Round_Cylinder_Union(<0, -13, -2.1>, <0, -13, -1.1>, 1.25, 0.3)   
                
                //holding nut for second joint (at end of first straight part)
                Round_Cylinder_Union(<0, -13, -2.9>, <0, -13, -2.2>, 0.9, 0.2)
                Round_Cylinder_Union(<0, -13, -3.1>, <0, -13, -2.9>, 0.5, 0.075)
                 
                
                // join two sides
                // top joint
                cylinder { <0, 0, -2.3> <0, 0, 2.3> 0.5 }
                // joint at end of first long part
                Round_Cylinder_Union(<0, -13, -1.1>, <0, -13, 1.1>, 1, 0.1)
                cylinder { <0, -13, -3> <0, -13, 3> 0.3 }        
                
                // third part - middle single joint
                union
                {
                        cylinder { <-8.9, 0, 0> <0, 0, 0> 0.7 }    
                        Round_Cylinder_Union(<-9, 0, 0>, <-8.6, 0, 0>, 1, 0.1)
                        difference
                        {
                                Round_Box_Union(<-7.25, -1, -1>, <-5.25, 1, 1>, 0.2)
                                cylinder { <-7.3, 0, 0> <-5, 0, 0> 0.75 }
                        }    
                        // loop part
                        union       
                        {    
                                // right side
                                Round_Cylinder_Union(<0, 0, -2>, <0, 0, -1>, 1.25, 0.4) 
                                Round_Cylinder_Union(<0, 0, -2.2>, <0, 0, -2>, 0.75, 0.075) 
                                cylinder { <-0.65, 0, -1.5> <0, 2, -1.5> 0.5 }
                                cylinder { <0.65, 0, -1.5> <0, 2, -1.5> 0.5 }
                                
                                cylinder { <0, 0, -1.5> <0, 7, -1.5> 0.5 } 

                                // left side
                                Round_Cylinder_Union(<0, 0, 1>, <0, 0, 2>, 1.25, 0.4)    
                                Round_Cylinder_Union(<0, 0, 2>, <0, 0, 2.2>, 0.75, 0.075) 
                                
                                cylinder { <-0.65, 0, 1.5> <0, 2, 1.5> 0.5 }
                                cylinder { <0.65, 0, 1.5> <0, 2, 1.5> 0.5 }
                                
                                cylinder { <0, 0, 1.5> <0, 7, 1.5> 0.5 } 
                                
                                // loop
                                difference
                                {
                                        torus { 1.5, 0.5 rotate <0, 0, 90> }
                                        box { <-0.51, -2.01, -2.01> <0.51, 0, 2.01> }
                                        translate <0, 7, 0> 
                                } 
                                
                                rotate <0, 0, 21>                                        
                                translate <-6.25, 0, 0> 
                        }
                        rotate <0, 0, -31.1> 
                        translate <0, -13, 0> 
                }

                // left side of arm       
                Round_Cylinder_Union(<0, 0, 1.1>, <0, 0, 2.1>, 1.75, 0.3)
                Round_Cylinder_Union(<0, 0, 2.3>, <0, 0, 2.6>, 1.4, 0.1)  

                Round_Box_Union(<-0.6, -13, 1.2>, <0.6, -1.5, 2>,0.2)             
                // smooth top joint
                cone { <-0.55, -1, 1.6> 0.5 <-0.2, -4.5, 1.6> 0.3 }
                cone { <0.55, -1, 1.6> 0.5 <0.2, -4.5, 1.6> 0.3 }
                // smooth bottom joint
                cone { <-0.55, -12.5, 1.6> 0.5 <-0.2, -9, 1.6> 0.3 }
                cone { <0.55, -12.5, 1.6> 0.5 <0.2, -9, 1.6> 0.3 }
                Round_Cylinder_Union(<0, -13, 1.1>, <0, -13, 2.1>, 1.25, 0.3)
                
                //holding nut for second joint (at end of first straight part)
                Round_Cylinder_Union(<0, -13, 2.2>, <0, -13, 2.9>, 0.9, 0.2)
                Round_Cylinder_Union(<0, -13, 2.9>, <0, -13, 3.1>, 0.5, 0.075)   
                
                // rear part attached to train
                union
                {
                        object { Round_Cylinder_Union(<-4, 0, 0>, <0, 0, 0>, 5, 0.1) scale <1, 1, 0.5> }
                        intersection
                        {
                                object { Round_Cylinder_Union(<-6, 0, 0>, <0, 0, 0>, 5, 0.1) scale <1, 0.5, 1>}
                                cylinder { <-6.1, 0, 0> <0.1, 0, 0> 5 scale <1, 1, 0.5> }       
                        }       
                        torus { 1.5, 0.5 rotate <0, 0, 90> scale <0.7, 1, 0.5> translate <-6, 0, 0> }  
                        // add the nuts
                        object { nut scale 0.275 translate <-4.3, 3.5, 0> }
                        object { nut scale 0.275 translate <-4.3, -3.5, 0> }    
                        texture { paintTex1 } 
                        #if(useTestTex = 0)
/*
                        texture                 // add extra dirt TO_DO
                        { 
                                pigment 
                                {                 
                                        gradient x 
                                        turbulence 0.095
                                        omega 0.675
                                        lambda 2.75
                                        colour_map
                                        {     
                                                [ 0.0 rgbt <0.025, 0.01, 0.001, 0> ]
                                                [ 0.8 rgbt <0.025, 0.01, 0.001, 1> ]                                                        
                                                [ 0.8 rgbt <1, 1, 1, 1> ]                                                        
                                        }  
                                        scale 8
                                        translate <-7, 0, 0>
                                }         
                                finish { ambient 0 diffuse 0.3 }
                                normal { wrinkles 0.2 }
                                                              
                        }  
*/
                        #end
                        translate <8, 0, 0>
                }
                
                translate <3.75, 1.5, 0> 
                
        }            
        scale 0.85    
        rotate <0, 180, 0> 
        texture { couplingTex }
}   





// Rivet

#declare rivet = union
{
        sphere { <0, 0, 0> 0.6 scale <1, 1, 0.2> }
        torus { 0.6 ,0.4 rotate <90, 0, 0> }
        scale <1, 1, 0.75> 
}                                                      





#declare suspensionTexDirt1 = texture
{
        pigment 
        { 
                granite 
                turbulence 0.25 
                lambda 3 
                omega 0.6 
                colour_map 
                { 
                        [ 0.0 rgb <0.1, 0.07, 0.035> ] 
                        [ 1.0 rgb <0.06, 0.04, 0.02> ] 
                } 
                scale 2 
               
        }
        finish { ambient 0 specular 1 roughness 0.08 reflection 0.025 brilliance 3 metallic }
        normal 
        { 
                average 
                normal_map 
                { 
                        [ 1 wrinkles 0.4 turbulence 0.235 omega 0.6 lambda 3 ]
                        [ 1 granite 0.5 turbulence 0.35 omega 0.7 lambda 3 scale 3 ]
                }
        }
}              
texture // add grease/dirt
{                         
        pigment 
        {                 
                wrinkles   
                scallop_wave
                turbulence 0.41 
                omega 0.7 
                lambda 4                            
                colour_map
                {
                        [ 0.0 rgbt <0.025, 0.01, 0.001, 0.1> ]
                        [ 0.1 rgbt <0.02, 0.01, 0, 0.2> ]
                        [ 0.12 rgbt <0.02, 0.008, 0, 0.45> ]
                        [ 0.2 rgbt <0.01, 0.003, 0, 0.15> ]
                        [ 0.45 rgbt <0.025, 0.01, 0.001, 0.1> ]
                        [ 0.5 rgbt <0.02, 0.005, 0, 0.075> ]
                        [ 0.525 rgbt <0.01, 0.004, 0, 0.2> ]
                        [ 0.7 rgbt <0.1, 0.035, 0.005, 0.3> ] 
                        [ 0.725 rgbt <0.1, 0.050, 0.005, 0.1> ]
                        [ 0.9 rgbt <0.11, 0.045, 0.009, 0.2> ]
                        [ 0.94 rgbt <0.11, 0.045, 0.009, 0.075> ]
                        [ 1.0 rgbt <0.008, 0.028, 0, 0.1> ]
                }  
                scale 2
        }
        finish { ambient 0 diffuse 0.3 }
        normal 
        { 
                average 
                normal_map 
                { 
                        [ 1 wrinkles 0.4 turbulence 0.235 omega 0.6 lambda 3 ]
                        [ 1 granite 0.5 turbulence 0.35 omega 0.7 lambda 3 scale 3 ]
                }
        }
}

#declare suspensionTexBase1 = texture
{
        pigment 
        { 
                granite 
                turbulence 0.25 
                lambda 3 
                omega 0.6 
                colour_map 
                { 
                        [ 0.0 rgb <0.1, 0.07, 0.035> ] 
                        [ 1.0 rgb <0.06, 0.04, 0.02> ] 
                } 
                scale 2 
               
        }
        finish { ambient 0 specular 1 roughness 0.08 reflection 0.025 brilliance 3 metallic }
        normal 
        { 
                average 
                normal_map 
                { 
                        [ 1 wrinkles 0.4 turbulence 0.235 omega 0.6 lambda 3 ]
                        [ 1 granite 0.5 turbulence 0.35 omega 0.7 lambda 3 scale 3 ]
                }
        }
} 

#declare suspensionTexBase = texture
{                          
        bozo
        turbulence 0.4   
        omega 0.6
        lambda 3      
        scallop_wave
        texture_map
        {
                [ 0.0 suspensionTexBase1 ]
                [ 0.9 suspensionTexBase1 ]
                [ 1.0 suspensionTexDirt1 ]
        }
                                                                                  
}

#declare suspensionTexDirt = texture
{                          
        granite   
        turbulence 0.3
        omega 0.7     
        lambda 3.5
        //sine_wave
        texture_map
        {
                [ 0.0 suspensionTexBase1 ]
                [ 0.1 suspensionTexBase1 ]
                [ 1.0 suspensionTexDirt1 ]
        }           
        scale 0.2
                    
                                                                                  
}
#declare suspensionTex = texture
{
        slope { <0.5, -1, 0.1> }       
        texture_map
        {
                [ 0 suspensionTexDirt ] 
                [ 0.2 suspensionTexDirt ] 
                [ 0.4 suspensionTexBase ]   
                [ 1 suspensionTexBase ]   
        }     
}
     
        // join the wheels together

#declare outerR = 1.65;
#declare innerR = 0.5;    

#declare springSurround = union
{
        object { Round_Box_Union(<-(outerR+innerR), innerR*7, 4>,  <outerR+innerR, innerR*8, 8>, 0.1) translate <-(1.5+outerR), 0, 0> }
        object { Round_Box_Union(<-(outerR+innerR), innerR*10, 4>,  <outerR+innerR, innerR*11, 6.5>, 0.1) translate <-(1.5+outerR), 0, innerR*3> }
        difference
        {    
                union
                {
                        object { Round_Box_Union(<-(outerR+innerR), innerR*7, 4>,  <-outerR, innerR*10.9, 8>, 0.1) }
                        object { Round_Box_Union(<-(innerR*1.5), innerR*7, 4>, <innerR*1.5, innerR*10.9, 8>, 0.1) }
                        object { Round_Box_Union(<outerR, innerR*7, 4>,  <(outerR+innerR), innerR*10.9, 8>, 0.1) }
                }
                cylinder { <-(outerR+innerR+0.1), innerR*11, 4>  <(outerR+innerR+0.1), innerR*11, 4> innerR*3.0 }
                translate <-(1.5+outerR), 0, 0> 
                
        }
}
#declare wheelSuspension = union
{
        difference
        {
                object { Round_Box_Union(<-2, -5, 2>, <2, 5, 6> 0.2 ) }
                object { Round_Cylinder_Union(<0, -(innerR*7), 0>, <0, innerR*7.5, 0>, outerR+innerR+0.2, innerR)  translate <-(1.5+outerR), 0, 4+outerR> }  
                //cylinder { <0, -(innerR*7), 0> <0, innerR*7.5, 0> outerR+innerR+0.2  translate <-(1.5+outerR), 0, 4+outerR> }  
        }                        
        
        Round_Box_Union(<-2, -3.6, 0.835>, <2, 3.6, 3> 0.2 )
        object { Round_Box_Union(<-2, -1, -2>, <2, 0.2, 0.2>, 0.2) rotate <-50, 0, 0> translate <0, 4.8, 2.2> }
        object { Round_Box_Union(<-2, 1, -2>, <2, -0.2, 0.2>, 0.2) rotate <50, 0, 0> translate <0, -4.8, 2.2> }  
        sphere { 0, 0.2 scale <1, 1, 0.4> translate <-1.5, -3, 0.83> }
        sphere { 0, 0.2 scale <1, 1, 0.4> translate <1.5, -3, 0.83> }
        sphere { 0, 0.2 scale <1, 1, 0.4> translate <-1.5, 3, 0.83> }
        sphere { 0, 0.2 scale <1, 1, 0.4> translate <1.5, 3, 0.83> }
        // suspension spring type part
        union
        {
                #declare tC = 0;
                #while(tC < 7)
                        torus { outerR, innerR translate <0, tC*innerR*2, 0> }
                        #declare tC=tC+1;
                #end
                translate <-(1.5+outerR), -(innerR*6), 4+outerR>
        }
        union
        {
                #declare tC = 0;
                #while(tC < 7)
                        torus { outerR, innerR translate <0, tC*innerR*2, 0> }
                        #declare tC=tC+1;
                #end
                translate <(1.5+outerR), -(innerR*6), 4+outerR>
        }     
        // surround above and below spring     
        object { springSurround }      
        object { springSurround scale <-1, 1, 1> } 
        object { springSurround scale <1, -1, 1> } 
        object { springSurround scale <-1, -1, 1> }   
        
        // top part of spring surround
        object { Round_Box_Union(<-(outerR*2.5), innerR*11, 4.25>,  <outerR*2.5, innerR*12, 6.5>, 0.1) translate <0, 0, innerR*3> }     
        // bolt it on
        object { nut scale 0.1 rotate <20, 0, -90> translate <-(outerR*2.0), innerR*12.225, 6.25> }
        object { nut scale 0.1 rotate <20, 0, -90> translate <-(outerR*2.0), innerR*12.225, 7.25> }
        object { nut scale 0.1 rotate <20, 0, -90> translate <(outerR*2.0), innerR*12.225, 6.25> }
        object { nut scale 0.1 rotate <20, 0, -90> translate <(outerR*2.0), innerR*12.225, 7.25> }            
        
        // part joint to coal truck
        object { Round_Box_Union(<-(innerR*2.5), innerR*12, 5>,  <innerR*2.5, 15, 5.75>, 0.1) translate <0, 0, innerR*3> }      
        difference
        {
                object { Round_Box_Union(<-6, 0, 5.1>,  <6, 12, 6>, 0.3) translate <6, 0, 0> rotate <0, 0, 45>  }      
                box { <-10, 8.5, 5> <10, 20, 6.1> }  
                translate <0, 5, (innerR*3)>
        }   
        
        
        //rotate <0, 47, 0> 
        
        
}

#declare driveShaft = union
{
        cylinder { <0, 0, 1> <0, 0, 20> 1.25 }
        Round_Cylinder_Union(<0, 0, 10>, <0, 0, 20>, 3, 1)   
        texture
        {
                pigment { rgb <0.1, 0.1, 0.1> }
                finish { specular 1 ambient 0 diffuse 0.75 roughness 0.01 brilliance 7 reflection 0.1 metallic }
                normal { gradient z scale 0.05 }
        }
        texture
        {
                pigment 
                { 
                        wrinkles    
                        turbulence 0.675
                        omega 0.675
                        lambda 2.5
                        colour_map
                        {
                                [ 0.0 rgbt <0.075, 0.034, 0.0, 0> ]
                                [ 0.2 rgbt <0.075, 0.034, 0.0, 1> ]
                                [ 0.25 rgbt <0.075, 0.034, 0.0, 1> ]
                                [ 0.4 rgbt <0.075, 0.034, 0.0, 0> ]
                                [ 0.575 rgbt <0.075, 0.034, 0.0, 1> ]
                                [ 0.7 rgbt <0.075, 0.034, 0.0, 1> ]
                                [ 0.9 rgbt <0.075, 0.034, 0.0, 0> ]
                                [ 1.0 rgbt <0.075, 0.034, 0.0, 1> ]
                        }   
                        scale 0.5
                }
                finish { ambient 0.0 diffuse 0.375 brilliance 1 reflection 0 specular 0}   
                normal { dents 2 turbulence 0.4 scale 0.1 }   
        } 
        texture
        {
                pigment 
                { 
                        gradient z    
                        turbulence 0.325
                        omega 0.75
                        lambda 2.5
                        colour_map
                        {
                                [ 0.0 rgbt <0.075, 0.034, 0.0, 0> ]
                                [ 0.2 rgbt <0.075, 0.034, 0.0, 0.1> ]
                                [ 0.6 rgbt <0.075, 0.034, 0.0, 1> ]
                                [ 0.6 rgbt <1, 1, 1, 1> ]
                                [ 1.0 rgbt <1, 1, 1, 1> ]
                        }   
                        scale 30
                }
                finish { ambient 0.0 diffuse 0.375 brilliance 1 reflection 0 specular 0 }   
                normal { dents 2 turbulence 0.4 scale 0.1 }   
        } 
        
}




#declare handRailBracket = union
{
        difference
        {
                cylinder { <0, 0, 0> <1.5, 0, 0> 0.65 }
                cylinder { <-0.1, 0, 0> <1.6, 0, 0> 0.45 }
        }
        torus { 0.55, 0.1 rotate <0, 0, 90> }
        torus { 0.55, 0.1 rotate <0, 0, 90> translate <1.5, 0, 0> }
        cylinder { <0, 0, 0> <0, 0, 5> 0.35 }
        Round_Cone_Union(<0, 0, 3>, 0.55, <0, 0, 4>, 0.9, 0.1)
        
}   



#declare WheelNamePlate = union
{       
        // name plate
        difference
        {
                union
                {
                        difference
                        {
                                cylinder { <0, 0, 0.1> <0, 0, 1> 26 } 
                                
                                cylinder { <0, 0, 0> <0, 0, 1.1> 22 } 
                                box { <0, -27, 0> <27, 27, 1.1> rotate <0, 0, -25> }
                                box { <-27, -27, 0> <0, 27, 1.1> rotate <0, 0, 25> }                                                                                                                 
                        }                                                           
                        cylinder { <0, 0, 0.1> <0, 0, 1> 2 translate <0, 24, 0> rotate <0, 0, 25> }
                        cylinder { <0, 0, 0.1> <0, 0, 1> 2 translate <0, 24, 0> rotate <0, 0, -25> }
                }
                union
                {
                        difference
                        {
                                cylinder { <0, 0, 0> <0, 0, 0.5> 25.8 } 
                                
                                cylinder { <0, 0, 0> <0, 0, 1.1> 22.2 } 
                                box { <0, -27, 0> <27, 27, 1.1> rotate <0, 0, -25> }
                                box { <-27, -27, 0> <0, 27, 1.1> rotate <0, 0, 25> }                                                                                                                 
                        }                                                           
                        cylinder { <0, 0, 0> <0, 0, 0.5> 1.8 translate <0, 24, 0> rotate <0, 0, 25> }
                        cylinder { <0, 0, 0> <0, 0, 0.5> 1.8 translate <0, 24, 0> rotate <0, 0, -25> }
                }
                                
                texture { paintTex3 } // badge sign
        }
        union
        {
                difference
                {
                        cylinder { <0, 0, 0.2> <0, 0, 0.5> 25.8 } 
                        
                        cylinder { <0, 0, 0> <0, 0, 1.1> 22.2 } 
                        box { <0, -27, 0> <27, 27, 1.1> rotate <0, 0, -25> }
                        box { <-27, -27, 0> <0, 27, 1.1> rotate <0, 0, 25> }                                                                                                                 
                }                                                           
                cylinder { <0, 0, 0.2> <0, 0, 0.5> 1.8 translate <0, 24, 0> rotate <0, 0, 25> }
                cylinder { <0, 0, 0.2> <0, 0, 0.5> 1.8 translate <0, 24, 0> rotate <0, 0, -25> } 
                texture { blackBadgeTex }         
        }
        // Add the letters  
        #declare names="Chris Cason, Thorsten Froehlich, Nathan Kopp, Ron Parker"
        union
        {
                #declare chCount=1;
                #declare chRotate=25;
                #while(chCount < strlen(names)+1)
                        #declare ch=substr(names, chCount, 1);                                           
                        text { ttf "crystal.ttf", ch, 0.5, 0 scale 0.45 translate <0, 25.3, 0.1> rotate <0, 0, chRotate> } 
                        #declare chCount=chCount+1;
                        #declare chRotate=chRotate-0.9;
                #end
                texture { letterTex }
        }
        #declare names="Steve Anger,   Dieter Bayer,   Chris Daily,   Andreas Dilger"
        union
        {
                #declare chCount=1;
                #declare chRotate=27;
                #while(chCount < strlen(names)+1)
                        #declare ch=substr(names, chCount, 1);                                           
                        text { ttf "crystal.ttf", ch, 0.5, 0 scale 0.45 translate <0, 24.8, 0.1> rotate <0, 0, chRotate> } 
                        #declare chCount=chCount+1;
                        #declare chRotate=chRotate-0.9;
                #end
                texture { letterTex }
        }

        #declare names="Steve Demlow, Alexander Enzmann, Dan Farmer, Eduard Schwan"
        union
        {
                #declare chCount=1;
                #declare chRotate=26.5;
                #while(chCount < strlen(names)+1)
                        #declare ch=substr(names, chCount, 1);                                           
                        text { ttf "crystal.ttf", ch, 0.5, 0 scale 0.45 translate <0, 24.3, 0.1> rotate <0, 0, chRotate> } 
                        #declare chCount=chCount+1;
                        #declare chRotate=chRotate-0.9;
                #end
                texture { letterTex }
        }
        #declare names="Timothy Wegner, Chris Young, Kendall Bennett, Steve A. Bennett"
        union
        {
                #declare chCount=1;
                #declare chRotate=27.5;
                #while(chCount < strlen(names)+1)
                        #declare ch=substr(names, chCount, 1);                                           
                        text { ttf "crystal.ttf", ch, 0.5, 0 scale 0.45 translate <0, 23.8, 0.1> rotate <0, 0, chRotate> } 
                        #declare chCount=chCount+1;
                        #declare chRotate=chRotate-0.9;
                #end
                texture { letterTex }
        }
        #declare names="David K. Buck, Aaron A. Collins, Mark Gordon, Pascal Massimino"
        union
        {
                #declare chCount=1;
                #declare chRotate=27.25;
                #while(chCount < strlen(names)+1)
                        #declare ch=substr(names, chCount, 1);                                           
                        text { ttf "crystal.ttf", ch, 0.5, 0 scale 0.45 translate <0, 23.3, 0.1> rotate <0, 0, chRotate> } 
                        #declare chCount=chCount+1;
                        #declare chRotate=chRotate-0.9;
                #end
                texture { letterTex }
        }
        #declare names="Douglas Muir,  Bill Pulver,  Robert Skinner,  Zsolt Szalavari"
        union
        {
                #declare chCount=1;
                #declare chRotate=27;
                #while(chCount < strlen(names)+1)
                        #declare ch=substr(names, chCount, 1);                                           
                        text { ttf "crystal.ttf", ch, 0.5, 0 scale 0.45 translate <0, 22.8, 0.1> rotate <0, 0, chRotate> } 
                        #declare chCount=chCount+1;
                        #declare chRotate=chRotate-0.9;
                #end
                texture { letterTex }
        }
        #declare names="Scott Taylor                                     Drew Wells"
        union
        {
                #declare chCount=1;
                #declare chRotate=26.5;
                #while(chCount < strlen(names)+1)
                        #declare ch=substr(names, chCount, 1);                                           
                        text { ttf "crystal.ttf", ch, 0.5, 0 scale 0.45 translate <0, 22.35, 0.1> rotate <0, 0, chRotate> } 
                        #declare chCount=chCount+1;
                        #declare chRotate=chRotate-0.9;
                #end
                texture { letterTex }
        } 
        
        // Royal scot nameplate above wheel                        
        union
        {
                difference
                {
                        union
                        {
                                difference
                                {
                                        cylinder { <0, 0, 0.1> <0, 0, 1> 28 } 
                                        
                                        cylinder { <0, 0, 0> <0, 0, 1.1> 26 } 
                                        box { <0, -29, 0> <29, 29, 1.1> rotate <0, 0, -16.25> }
                                        box { <-29, -29, 0> <0, 29, 1.1> rotate <0, 0, 16.25> }                                                                                                                 
                                }                                                           
                                cylinder { <0, 0, 0.1> <0, 0, 1> 1 translate <0, 27, 0> rotate <0, 0, 16.25> }
                                cylinder { <0, 0, 0.1> <0, 0, 1> 1 translate <0, 27, 0> rotate <0, 0, -16.25> }
                        }
                        union
                        {
                                difference
                                {
                                        cylinder { <0, 0, 0> <0, 0, 0.5> 27.8 } 
                                        
                                        cylinder { <0, 0, 0> <0, 0, 1.1> 26.2 }          
                                        box { <0, -29, 0> <29, 29, 1.1> rotate <0, 0, -16.25> }
                                        box { <-29, -29, 0> <0, 29, 1.1> rotate <0, 0, 16.25> }                                                                                                                 
                                }                                                           
                                cylinder { <0, 0, 0> <0, 0, 0.5> 0.8 translate <0, 27, 0> rotate <0, 0, 16.25> }
                                cylinder { <0, 0, 0> <0, 0, 0.5> 0.8 translate <0, 27, 0> rotate <0, 0, -16.25> }
                        }
                                        
                        texture { paintTex3 }
                }
                union
                {
                        difference
                        {
                                cylinder { <0, 0, 0.2> <0, 0, 0.5> 27.8 } 
                                
                                cylinder { <0, 0, 0> <0, 0, 1.1> 26.2 } 
                                box { <0, -29, 0> <29, 29, 1.1> rotate <0, 0, -16.25> }
                                box { <-29, -29, 0> <0, 29, 1.1> rotate <0, 0, 16.25> }                                                                                                                 
                        }                                                           
                        cylinder { <0, 0, 0.2> <0, 0, 0.5> 0.8 translate <0, 27, 0> rotate <0, 0, 16.25> }
                        cylinder { <0, 0, 0.2> <0, 0, 0.5> 0.8 translate <0, 27, 0> rotate <0, 0, -16.25> } 
                        texture { blackBadgeTex }         
                }
                
                // Royal scot badge above wheel
                #declare names="ROYAL SCOT"
                union
                {
                        #declare chCount=1;
                        #declare chRotate=16.1;
                        #while(chCount < strlen(names)+1)
                                #declare ch=substr(names, chCount, 1);                                           
                                text { ttf "ariblk.ttf", ch, 0.5, 0 scale <1.9, 1.9, 1> translate <0, 26.3, 0.1> rotate <0, 0, chRotate> } 
                                #declare chCount=chCount+1;
                                #declare chRotate=chRotate-3.25;
                        #end
                        texture { letterTex }
                } 
        }
}                                     
              


/*
#declare wheelDriveTex = texture 
{
        pigment { Red }
        finish { phong 1 }
}


#declare dirPush = 0;
#declare dirPull = 1;


// macros can have parameters and are useful for 'programming' scenes
#macro Wheels(position, wheelDir)      


#if(position > 1)
        #declare position = 1;
#end

#if(position < -1)
        #declare position = -1;                         
#end                                  
 */
/*

                                      C
                                      /\
                                     /  \
                                  b /    \ a
                                   /      \
                                  /        \
                                 /          \
                              A /____________\ B                                        
                                      c
*/  
/*
#declare a = 7.5;
#declare b = 75+(position*7.5);     //75+ or - 7.5
#declare c = 75;

#declare A = degrees(acos( ((b*b)+(c*c)-(a*a))/(2*b*c)));
#declare B = degrees(acos( ((a*a)+(c*c)-(b*b))/(2*a*c)));
#declare C = degrees(acos( ((a*a)+(b*b)-(c*c))/(2*a*b)));

        
        #if(wheelDir = dirPush)
                #declare A=-A;                
                #declare C=-C;                
        #end
union
{
        box { <0, -1, 0> <75, 1, 0>  texture { wheelDriveTex } rotate <0, 0, A> translate <position*7.5, 0, 0> }

        // wheel
        union
        {
                difference 
                {
                        cylinder { <0, 0, 0> <0, 0, 2> 19.5 }
                        cylinder { <0, 0, -0.01> <0, 0, 2.01> 17.5 }
                }
                cylinder { <0, 0, 0> <0, 0, 2> 3.5 translate <7.5, 0, 0> }
                box { <-17.5, -1, 0> <17.5, 1, 2> pigment { Blue } }
                box { <-17.5, -1, 0> <17.5, 1, 2> rotate <0, 0, 90>  pigment { Red }}
                pigment { Green }
                rotate <0, 0, C>  
                translate <75, 0, 0>
                
                          
        }
}       
        

#end


*/





#declare dirPush = 0;
#declare dirPull = 1;


// macros can have parameters and are useful for 'programming' scenes
#macro Wheels(rotation, motionBlurLevel, motionBlurRotation)     


/*

                                      C
                                      /\
                                     /  \
                                  b /    \ a
                                   /      \
                                  /        \
                                 /          \
                              A /____________\ B                                        
                                      c
*/ 

// Static parts (no motion blur)
union
{
        // mounting slides for piston
        union
        {
                prism 
                {                                
                        linear_sweep  // or conic_sweep for tapering to a point
                        linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
                        0.1,         // height 1
                        1,         // height 2
                        8,           // number of points
                        // (--- the <u,v> points ---)
                        < -1, 0.8>, < -1,  -0.8>, < -0.8, -1>, < 0.8,  -1>, < 1,  -0.8>, 
                        <1,  0.8>, <0.8,  1>, <-0.8, 1>    
                        scale <1, 2, 1>  
                }
                prism 
                {                                
                        conic_sweep  // or conic_sweep for tapering to a point
                        linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
                        0.8,         // height 1
                        1,         // height 2
                        8,           // number of points
                        // (--- the <u,v> points ---)
                        < -1, 0.8>, < -1,  -0.8>, < -0.8, -1>, < 0.8,  -1>, < 1,  -0.8>, 
                        <1,  0.8>, <0.8,  1>, <-0.8, 1>  
                        
                        translate <0, -0.8, 0>
                
                }    
        
                scale <0.75, 33/2, 1>    
                rotate <0, 0, 90>
                texture
                {
                        gradient y
                        texture_map
                        { 
                                [ 0.0 sliderTex() ]
                                [ 0.7 sliderTex() ]
                                [ 0.75 gradient x texture_map { [ 0.0 sliderTex()]  [ 0.2 sliderTex()] [ 0.225 sliderSmoothTex()  ] [ 0.85 sliderSmoothTex() ] [ 0.9 sliderTex() ] } scale 33 translate <1, 0, 0> ]                                    
                                [ 1.0 gradient x texture_map {  [ 0.0 sliderTex()]  [ 0.2 sliderTex()] [ 0.225 sliderSmoothTex() ] [ 0.85 sliderSmoothTex() ] [ 0.9 sliderTex() ] } scale 33 translate <1, 0, 0> ]                                    
                        } 
                        scale <1, 2, 1>   
                        translate <0, 0.85, 0>
                }
                translate <14, -5.25, -2.1>
        }
        union
        {
                prism 
                {                                
                        linear_sweep  // or conic_sweep for tapering to a point
                        linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
                        0.1,         // height 1
                        1,         // height 2
                        8,           // number of points
                        // (--- the <u,v> points ---)
                        < -1, 0.8>, < -1,  -0.8>, < -0.8, -1>, < 0.8,  -1>, < 1,  -0.8>, 
                        <1,  0.8>, <0.8,  1>, <-0.8, 1>    
                        scale <1, 2, 1>
        
                }
                prism 
                {                                
                        conic_sweep  // or conic_sweep for tapering to a point
                        linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
                        0.8,         // height 1
                        1,         // height 2
                        8,           // number of points
                        // (--- the <u,v> points ---)
                        < -1, 0.8>, < -1,  -0.8>, < -0.8, -1>, < 0.8,  -1>, < 1,  -0.8>, 
                        <1,  0.8>, <0.8,  1>, <-0.8, 1>  
                        
                        translate <0, -0.8, 0>
        
                }    
                
                scale <0.75, 33/2, 1>    
                rotate <0, 0, 90>

                texture
                {
                        gradient y
                        texture_map
                        { 

                                [ 0.0 gradient x texture_map { [ 0.0 sliderTex()]  [ 0.2 sliderTex()] [ 0.225 sliderSmoothTex() ] [ 0.85 sliderSmoothTex()  ] [ 0.9 sliderTex() ] } scale 33 translate <1, 0, 0> ]                                    
                                [ 0.25 gradient x texture_map { [ 0.0 sliderTex()]  [ 0.2 sliderTex()] [ 0.225 sliderSmoothTex()  ] [ 0.85 sliderSmoothTex()  ] [ 0.9 sliderTex() ] } scale 33 translate <1, 0, 0> ]                                    
                                [ 0.3 sliderTex() ]
                                [ 1.0 sliderTex() ]
                        } 
                        scale <1, 2, 1>   
                        translate <0, -0.85, 0>
                }

                
                translate <14, 5.25, -2.1>
        }   
        // box at end of piston
        union
        {           
                // main part of box
                union
                {
                        //cylinder { <-19, 0, 0> <0, 0, 0> 8 }
                        //cylinder { <-19, 10, 0> <0, 10, 0> 8 } 
                        //box { <-19, 0, -8> <0, 10, 8> }

                        Round_Cylinder_Union(<-19, 0, 0>, <0, 0, 0>, 8, 0.1)
                        Round_Cylinder_Union(<-19, 10, 0>, <0, 10, 0>, 8, 0.1) 
                        Round_Box_Union(<-19, 0, -8>, <0, 10, 8>, 0.1)
                        
                        texture
                        {
                                gradient x
                                texture_map
                                {
                                        [ 0.02 paintTex2 ]
                                        [ 0.025 paintTex2 ]
                                        [ 0.025 paintTex3 ]
                                        [ 0.05 paintTex3 ]
                                        [ 0.05 paintTex1 ]
                                        [ 0.95 paintTex1 ]
                                        [ 0.95 paintTex3 ]
                                        [ 0.975 paintTex3 ]
                                        [ 0.975 paintTex2 ]                                           
                                        [ 1.0 paintTex2 ]                                           
                                }   
                                scale 19 translate <-19, 0, 0>                            
                        }    
                        translate <0, -1, 0>  
                }   
                // bits at piston end  
                union
                {      
                        // bottom cylinder
                        Round_Cylinder_Union(<0, 0, 0>, <0.5, 0, 0> 5.8, 0.2)
                        // box that piston goes into
                        union
                        {
                                cylinder { <0, 0, 0> <2, 0, 0> 1 translate <0, 2, 2> } 
                                cylinder { <0, 0, 0> <2, 0, 0> 1 translate <0, 2, -2> } 
                                cylinder { <0, 0, 0> <2, 0, 0> 1 translate <0, -2, 2> } 
                                cylinder { <0, 0, 0> <2, 0, 0> 1 translate <0, -2, -2> }   
                                box { <0, -3, -2> <2, 3, 2> }
                                box { <0, -2, -3> <2, 2, 3> }   
                                // hole for piston
                                difference
                                {
                                        Round_Cylinder_Union(<2, 0, 0>, <2.8, 0, 0>, 1.65, 0.1)
                                        cylinder { <0, 0, 0> <2.81, 0, 0> 0.75 } 
                                }
                                rotate <-45, 0, 0> 
                        }       
                        // base of piston sliders 
                        union
                        {
                                Round_Cylinder_Union(<0, -5.25, 0>, <1, -5.25, 0>, 1.5, 0.1)       
                                Round_Cylinder_Union(<0, 5.25, 0>, <1, 5.25, 0>, 1.5, 0.1) 
                                Round_Box_Union(<0, -5.25, -1.5>, <1, 5.25, 1.5>, 0.1)      
                        }   
                        // top cylinder
                        Round_Cylinder_Union(<3, 11, 0>, <4, 11, 0>, 4, 0.1)
                        cylinder { <0, 11, 0> <3.5, 11, 0> 3.8 texture { paintTex2 } } 
                        // bits poking out of top cylinder
                        union
                        {       
                                // large bit attached to cylinder
                                Round_Box_Union(<-0.2, -2, -2>, <3, 2, 2>, 0.1) 
                                Round_Cylinder_Union(<3, 0, -2>, <3, 0, 2>, 2, 0.1) 
                                
                                Round_Box_Union(<-0.45, -2, -3>, <10, -0.75, 1>, 0.5)
                                Round_Box_Union(<-0.45, -1, -3>, <10, 0, 1>, 0.5)
                                Round_Box_Union(<6, 1.5, -3>, <10, 2, 1>, 0.4)
                                Round_Box_Union(<6, 2, -3>, <10, 2.25, 1>, 0.1)   
                                
                                Round_Cylinder_Union(<7, 0, -2>, <7, 1.5, -2>, 0.8, 0.1)  
                                Round_Cylinder_Union(<7, -0.1, -2>, <7, 2.7, -2>, 0.6, 0.1)  
                                Round_Cylinder_Union(<7, -0.1, -2>, <7, 2.9, -2>, 0.3, 0.1)  

                                Round_Cylinder_Union(<9, 0, -2>, <9, 1.5, -2>, 0.8, 0.1)  
                                Round_Cylinder_Union(<9, -0.1, -2>, <9, 2.7, -2>, 0.6, 0.1)  
                                Round_Cylinder_Union(<9, -0.1, -2>, <9, 2.9, -2>, 0.3, 0.1)  
                                
                                translate <4, 11, 0>
                        }
                        texture { mkWheelDriveTex(0, dummyTex) }
                
                }       
                // bits at front end
                union
                {   
                
                        // bottom cylinder
                        union 
                        { 
                                difference
                                {
                                        object { Round_Cylinder_Union(<0, 0, -20.5>, <0, 0, -18> 7.8, 0.2) }
                                        cone { <0, 0, -20.6> 1 <0, 0, -19.5> 0.1 }
                                }   
                                Round_Cylinder_Union(<0, -6, -21.5>, <0, -6, -20>, 1.25, 0.15)
                                Round_Cylinder_Union(<0, -6, -22.5>, <0, -6, -21.5>, 1.25, 0.15)
                                Round_Cylinder_Union(<0, -6, -23.5>, <0, -6, -22.5>, 1.25, 0.15) 
                                torus { 0.85, 0.65 rotate <90, 0, 0> translate <0, -6, -20.4> }
                                 
                                mkWheelHubMidTex()  
                                rotate <0, 90, 0>
                                translate <0, -1.0, 0> 
                        }
                        // top cylinder
                        union
                        {
                                object 
                                { 
                                        Round_Cylinder_Union(<0, 0, -26>, <0, 0, -24>, 6, 0.1) 
                                        mkWheelHubMidTex() 
                                        rotate <0, 90, 0>    
                                        translate <0, 11, 0>
                                }
                                cylinder { <-24.1, 11, 0> <3.5, 11, 0> 5.6 texture { paintTex2 } }       
                                union
                                {
                                        Round_Cylinder_Union(<-32, 11, 0>, <-26, 11, 0>, 1.25, 0.05)  
                                        Round_Cylinder_Union(<-27, 11, 0>, <-26, 11, 0>, 2.75, 0.1)       
                                        // rivetts
                                        #declare rp = 0; 
                                        #while(rp < 6)
                                                union
                                                {
                                                        cylinder { <-27.05, 0, -2> <-26.95, 0, -2> 0.15 }
                                                        torus { 0.15, 0.05 rotate <0, 0, -90> translate <-27, 0, -2> }
                                                        rotate <rp*60, 0, 0>      
                                                        translate <0, 11, 0>
                                                }                           
                                                #declare rp=rp+1;
                                        #end
                                        texture { mkWheelDriveTex(0, dummyTex) }
                                }
                        }
                }  
                // PIPE Work under box
                union
                {
                        cylinder{ <0, 0, 0.5> <22.5, 0, 0> 1.25 } 
                        // ring shaped brackets
                        difference
                        {
                                torus { 1.35, 0.4 rotate <0, 0, 90> }
                                cylinder { <-0.5, 0, 0> <0.5, 0, 0> 1.26 }
                                scale <2, 1, 1>
                                translate <11.5, 0, 0>
                        }
                        cylinder { <11.5, 1.0, 0> <11.5, 5, 0> 0.7 }
                        difference
                        {
                                torus { 1.35, 0.4 rotate <0, 0, 90> }
                                cylinder { <-0.5, 0, 0> <0.5, 0, 0> 1.26 }
                                scale <2, 1, 1>
                                translate <4.5, 0, 0>
                        }
                        cylinder { <4.5, 1.0, 0> <4.5, 5, 0> 0.7 }
                        difference
                        {
                                torus { 1.35, 0.4 rotate <0, 0, 90> }
                                cylinder { <-0.5, 0, 0> <0.5, 0, 0> 1.26 }
                                scale <2, 1, 1>
                                translate <18.5, 0, 0>
                        }                   
                        cylinder { <18.5, 1.0, 0> <18.5, 5, 0> 0.7 }
                        // ends of pipe                            
                        Round_Cylinder_Union(<0, 0, 0>, <0.85, 0, 0>, 1.65, 0.4)
                        Round_Cylinder_Union(<22.15, 0, 0>, <23, 0, 0>, 1.65, 0.4)   
                        
                        // parts pointing down
                        cylinder { <3.0, -2.5, 0> <3.0, 0, 0> 0.75 }
                        Round_Cylinder_Union(<3, -3.25, 0>, <3, -2.5, 0>, 1, 0.35)                          
                        union
                        {
                                intersection
                                {
                                        torus { 1.5, 0.4 rotate <90, 0, 0> }
                                        box { <0, -2, -0.5> <2, 0, 0.5> }
                                }           
                                Round_Cylinder_Union(<-3, -1.5, 0>, <0.1, -1.5, 0>, 0.4, 0.1)                                
                                translate <1.5, -3.25, 0>
                        }
                                                
                        cylinder { <10.0, -2.5, 0> <10.0, 0, 0> 0.75 }
                        Round_Cylinder_Union(<10, -3.25, 0>, <10, -2.5, 0>, 1, 0.35)                          
                        union
                        {
                                intersection
                                {
                                        torus { 2.3, 0.4 rotate <90, 0, 0> }
                                        box { <0, -2.9, -0.5> <2.9, 0, 0.5> }
                                }           
                                Round_Cylinder_Union(<-9.2, -2.3, 0>, <0.1, -2.3, 0>, 0.4, 0.1)                                
                                translate <7.7, -3.25, 0>
                        }

                        cylinder { <17.0, -2.5, 0> <17.0, 0, 0> 0.75 }
                        Round_Cylinder_Union(<17, -3.25, 0>, <17, -2.5, 0>, 1, 0.35)                          
                        union
                        {
                                intersection
                                {
                                        torus { 3.1, 0.4 rotate <90, 0, 0> }
                                        box { <0, -3.6, -0.5> <3.6, 0, 0.5> }
                                }           
                                Round_Cylinder_Union(<-15.4, -3.1, 0>, <0.1, -3.1, 0>, 0.4, 0.1)                                
                                translate <13.9, -3.25, 0>
                        }

                        texture { pipeTexCopper }
                        
                        translate <-21, -11, 0>
                }
                    
                translate <-20, 0, -2.1> 
        }  
        // Part that runs over top of 1st big wheel and attaches to top piston slider
        union  
        {
                difference
                {
                        union
                        {
                                Round_Box_Union(<2, 0, -1.25>, <4, 1, 1.25>, 0.1)
                        }
                        box { <1.9, -0.1, -1.01> <5.1, 0.76, 1.01> }
                }  
                Round_Box_Union(<0, 0.76, -1.15>, <2.2, 1, 1.15>, 0.1)
                
                difference
                {
                        union { Round_Box_Union(<0, 0, -1.15>, <3, 4, 1.15>, 0.1) }
                        box { <-8, 0, -1.2> <0, 5, 1.2> rotate <0, 0, -45> translate <3, 1, 0> }  
                        box { <-0.1, 0.2, -0.9> <3.1, 4.1, 0.9> }
                        translate <0, 1, 0>
                          
                }        
                union
                {                               
                                Round_Box_Union(<-0.5, 0, -3.5>, <0, 5.75, 3.5>, 0.225) 
                                Round_Box_Union(<-0.5, 5, -8.5>, <0, 11, -1.5>, 0.225) 
                                Round_Box_Union(<-0.5, 10, -3.5>, <0, 11, 3.5>, 0.225) 
                                Round_Box_Union(<-0.5, 5, 1.5>, <0, 11, 8.5>, 0.225) 
//                                box { <-0.51, 5.75, -1.5> <0.01, 10, 1.5> }                                         
                                intersection
                                {
                                        Round_Cylinder_Union(<-0.5, 5, -3.5>, <0.0, 5, -3.5>, 5, 0.225)
                                        box { <-0.51, -0.01, -8.51> <0.01, 5.251, -3.249> }                                         
                                }
                                intersection
                                {
                                        Round_Cylinder_Union(<-0.5, 5, 3.5>, <0.0, 5, 3.5>, 5, 0.225)
                                        box { <-0.51, -0.01, 3.249> <0.01, 5.251, 8.501> }                                         
                                }
                }      
                // top part that runs over wheel
                union
                {
                        box { <0, 0, -8.5> <45, 2, -7.5> }      
                        
                        // End parts
                        // Left side 
                        Round_Box_Union(<-0.25, -0.5, -8.75> <0.5, 2, -2>, 0.2)
                        
                        // Right side
                        union
                        {
                                Round_Box_Union(<0, 0, 0> <0.75, 4.5, 8.75>, 0.2)
                                intersection
                                {
                                        object { Round_Box_Union(<-10, 0, 0> <0, 6, 0.5>, 0.1) rotate <0, 0, -25> }
                                        union
                                        {                                                    
                                                box { <-6, 0, -0.1> <0, 4, 0.6> }                                                
                                        }                                        
                                        translate <0, 0.3, 0.5>
                                }
                                translate <44.5, -2.5, -8.75>
                                
                        }
                        // round part behind rivetted disc
                        union
                        {
                                difference
                                {
                                        cylinder { <0, 0, 0> <0, 0, 1.2> 3.5 }
                                        cylinder { <0, 0, -0.1> <0, 0, 0.2> 3 }
                                        cylinder { <0, 0, -0.1> <0, 0, 0.1> 3.1 }
                                        torus { 3.5, 0.1 rotate <90, 0, 0> }        
                                        box { <-4, 0, -0.1> <4, 4, 0.2000001> rotate <0, 0, 35> } 
                                        box { <-4, 0, -0.1> <4, 4, 0.2> rotate <0, 0, -35> } 
                                }
                                difference
                                {
                                        torus { 3.4, 0.1 rotate <90, 0, 0> translate <0, 0, 0.1> } 
                                        box { <-4, 0, -0.1> <4, 4, 0.2000001> rotate <0, 0, 35> } 
                                        box { <-4, 0, -0.1> <4, 4, 0.2> rotate <0, 0, -35> } 
                                }                                        
                                difference
                                {
                                        torus { 3.1, 0.1 rotate <90, 0, 0> translate <0, 0, 0.1> }
                                        box { <-4, 0, -0.1> <4, 4, 0.2000001> rotate <0, 0, 35> } 
                                        box { <-4, 0, -0.1> <4, 4, 0.2> rotate <0, 0, -35> } 
                                }   
                                // left and right sides of riveted disc
                                difference
                                {
                                        box { <-10, -2, 0.2> <10, 3, 1.2> }
                                        cylinder { <0, 0, 0.1> <0, 0, 1.3> 11 translate <-11.25, -8.25, 0> }
                                        cylinder { <0, 0, 0.1> <0, 0, 1.3> 11 translate <11.25, -8.25, 0> }
                                }                                     
                                
                                translate <22.5, -2.5, -8.7>
                        }  
                        // curved part that curves down to round disc
                        union   // left side
                        {
                                difference
                                {
                                        cylinder { <0, 0, 0> <0, 0, 1.2> 11 }
                                        cylinder { <0, 0, -0.1> <0, 0, 1.3> 10.5 }    
                                        cylinder { <0, 0, -0.1> <0, 0, 0.1> 10.6 }
                                        box { <0, -11.1, -0.1> <11.1, 11.1, 1.3> }  
                                        box { <-11.1, -11.1, -0.1> <0, 11.1, 1.3> rotate <0, 0, 55> }
                                        torus { 11, 0.1 rotate <90, 0, 0> }                                        
                                }  
                                difference
                                {
                                        torus { 10.9, 0.1 rotate <90, 0, 0> translate <0, 0, 0.1> }
                                        box { <0, -11.1, -0.1> <11.1, 11.1, 1.3> }  
                                        box { <-11.1, -11.1, -0.1> <0, 11.1, 1.3> rotate <0, 0, 55> }                                        
                                }     
                                difference
                                {
                                        torus { 10.6, 0.1 rotate <90, 0, 0> translate <0, 0, 0.1> }
                                        box { <0, -11.1, -0.1> <11.1, 11.1, 1.3> }  
                                        box { <-11.1, -11.1, -0.1> <0, 11.1, 1.3> rotate <0, 0, 55> }                                        
                                }           
                                
                                // straight part 
                                object { Round_Box_Union(<-11, 10.5, 0>, <0.1, 11, 1.2>, 0.1) rotate <0, 0, 55> }
                                translate <0, -14, 0>
                                rotate <0, 0, -55>
                                translate <22.5, -2.5, -8.7>
                        }
                        union   // right side
                        {
                                difference
                                {
                                        cylinder { <0, 0, 0> <0, 0, 1.2> 11 }
                                        cylinder { <0, 0, -0.1> <0, 0, 1.3> 10.5 }    
                                        cylinder { <0, 0, -0.1> <0, 0, 0.1> 10.6 }
                                        box { <0, -11.1, -0.1> <11.1, 11.1, 1.3> }  
                                        box { <-11.1, -11.1, -0.1> <0, 11.1, 1.3> rotate <0, 0, 55> }
                                        torus { 11, 0.1 rotate <90, 0, 0> }                                        
                                }  
                                difference
                                {
                                        torus { 10.9, 0.1 rotate <90, 0, 0> translate <0, 0, 0.1> }
                                        box { <0, -11.1, -0.1> <11.1, 11.1, 1.3> }  
                                        box { <-11.1, -11.1, -0.1> <0, 11.1, 1.3> rotate <0, 0, 55> }                                        
                                }     
                                difference
                                {
                                        torus { 10.6, 0.1 rotate <90, 0, 0> translate <0, 0, 0.1> }
                                        box { <0, -11.1, -0.1> <11.1, 11.1, 1.3> }  
                                        box { <-11.1, -11.1, -0.1> <0, 11.1, 1.3> rotate <0, 0, 55> }                                        
                                }           
                                
                                // straight part 
                                object { Round_Box_Union(<-11, 10.5, 0>, <0.1, 11, 1.2>, 0.1) rotate <0, 0, 55> }
                                translate <0, -14, 0>
                                rotate <0, 0, -55> 
                                scale <-1, 1, 1>
                                translate <22.5, -2.5, -8.7>
                        }     
                        
                        
                        // round disc
                        difference
                        {
                                union { Round_Cylinder_Union(<22.5, -2.5, -8.75>, <22.5, -2.5, -7.75>, 2.5, 0.05) } 
                                cylinder { <22.5, -2.5, -8.8> <22.5, -2.5, -8.25> 0.375 }
                        
                        }                                                          
                        // rivets
                        sphere { <0, 0, 0> 0.25 scale <1, 1, 0.5> translate <0, -2, 0> rotate <0, 0, 30> translate <22.5, -2.5, -8.75> }
                        sphere { <0, 0, 0> 0.25 scale <1, 1, 0.5> translate <0, -2, 0> rotate <0, 0, 90> translate <22.5, -2.5, -8.75> }
                        sphere { <0, 0, 0> 0.25 scale <1, 1, 0.5> translate <0, -2, 0> rotate <0, 0, 150> translate <22.5, -2.5, -8.75> }
                        sphere { <0, 0, 0> 0.25 scale <1, 1, 0.5> translate <0, -2, 0> rotate <0, 0, 210> translate <22.5, -2.5, -8.75> }
                        sphere { <0, 0, 0> 0.25 scale <1, 1, 0.5> translate <0, -2, 0> rotate <0, 0, 270> translate <22.5, -2.5, -8.75> }
                        sphere { <0, 0, 0> 0.25 scale <1, 1, 0.5> translate <0, -2, 0> rotate <0, 0, 330> translate <22.5, -2.5, -8.75> }
/*                        
                        // temp engine part to see what it would look like
                        union
                        {
                                box { <-60, 0, 30> <160, 3, -30> pigment { rgb <0.1, 0.1, 0.1> } finish { phong 1 } }
                                cylinder { <-60, 20, 0> <160, 20, 0> 20 pigment { Red } finish { phong 1 } }
                                translate <0, 2, 22> 
                        }
*/
                       
                        translate <-0.5, 9, 0> 
                }
                texture { mkWheelDriveTex(0, dummyTex) }            
                translate <5, 5.25, -2.1>
        }                                                                                         
        
/*************************************************************************************************
Brake pad 
*************************************************************************************************/
        union
        {        
                // pad
                union
                {
                        difference
                        {
                                intersection
                                {
                                        object { Round_Box_Union(<-8, -5, 0.1>, <0, 5, 2.9>, 0.05) } 
                                        union
                                        {
                                                object { Round_Box_Union(<-8, -5, 0>, <0, 5, 3>, 0.05) rotate <0, 0, 30> }
                                                object { Round_Box_Union(<-8, -5, 0>, <0, 5, 3>, 0.05) rotate <0, 0, -30> }
                                        }
                                        translate <-15, 0, 0> 
                                }
                                cylinder { <0, 0, 0> <0, 0, 3> 19.525 } 
                                                                     
                        }   
                        // rivets
                        object { rivet scale 0.425 translate <-22, -1, 0> }
                        object { rivet scale 0.425 translate <-22, 1, 0>  }
                }
                // bottom part
                union         
                {
                        object { Round_Box_Union(<-1, 0, 0.2>, <1, 7, 0.8>, 0.05) rotate <0, 0, 9> }
                        object { Round_Box_Union(<-1, 0, 0.2>, <1, 7, 0.8>, 0.05) rotate <0, 0, -9> }
                        object { Round_Cylinder_Union(<0, 0, 0.2>, <0, 0, 0.8>, 1.25, 0.1)  }          
                        object { Round_Box_Union(<-2.02, 0, 0.2>, <2.02, 2, 0.8>, 0.05) translate <0, 6, 0> }

                        object { Round_Box_Union(<-1, 0, 2.4>, <1, 7, 1.8>, 0.05) rotate <0, 0, 9> }
                        object { Round_Box_Union(<-1, 0, 2.4>, <1, 7, 1.8>, 0.05) rotate <0, 0, -9> }
                        object { Round_Cylinder_Union(<0, 0, 2.4>, <0, 0, 1.8>, 1.25, 0.1)  }          
                        object { Round_Box_Union(<-2.02, 0, 2.4>, <2.02, 2, 2.8>, 0.05) translate <0, 6, 0> }  
                        
                        // cylinder between front and back
                        object { Round_Cylinder_Union(<0, 0, 0.1>, <0, 0, 2.9>, 0.75, 0.1) }
                        object { Round_Cylinder_Union(<0, 0, -0.05>, <0, 0, 0.2>, 0.5, 0.1) }  
                        torus { 0.3, 0.2 rotate <90, 0, 0> scale <1, 1, 0.5> translate <0, 0, -0.05> }

                        // part that disappears up behind wheels
                        object { Round_Cylinder_Union(<0, 0, 2.9>, <0, 0, 10>, 1.25, 0.1) }
                        sphere { <0, 0, 10> 1.25 }
                        object { Round_Cylinder_Union(<0, 0, 10>, <0, 20, 10>, 1.25, 0.1) }
                        
                                                
                        rotate <0, 0, -45>
                        translate <-26.5, -4.5, 0>
                        
                }      
                // Thermocouple ( or that's what it looks like )
                union
                {
                        difference
                        {
                                torus { 3, 0.4 rotate <90, 0, 0> }
                                box { <-3.51, 0, -0.41> <3.51, 3.51, 0.41> rotate <0, 0, -55> }
                                box { <0, -3.51, -0.41> <3.51, 3.51, 0.41> rotate <0, 0, -25> }
                        }
                        // bottom part near wheel
                        union
                        {       
                                cylinder { <0, 0, 0> <4, 0, 0> 0.4 }   
                                object { Round_Box_Union(<2.5, -0.55, -0.55>, <3, 0.55, 0.55>, 0.1) rotate <45, 0, 0> }
                                Round_Cylinder_Union(<3, 0, 0>, <3.4, 0, 0>, 0.575, 0.15) 
                                Round_Cylinder_Union(<3.4, 0, 0>, <3.8, 0, 0>, 0.7, 0.1) 
                                Round_Cylinder_Union(<3.6, 0, 0>, <4.2, 0, 0>, 0.55, 0.075) 
                                Round_Cylinder_Union(<4.0, 0, 0>, <10.5, 0, 0>, 0.45, 0.2)
                                translate <0, -3, 0> 
                                rotate <0, 0, -25>
                        }        
                        //upper part that goes into brake pad
                        union
                        {
                                cylinder { <0, 0, 0> <0, 7, 0> 0.4 } 
                                sphere { <0, 7, 0> 0.4 }
                                cylinder { <0, 7, -2.25> <0, 7, 0> 0.4}
                                translate <-3, 0, 0> 
                                rotate <0, 0, -55> 
                        
                        }
                        translate <-25.5, -4.5, 1>
                }                                            
                texture { brakePadTex }
                rotate <0, 0, 25>
                translate <27.6, 0, 0>       
                
        }
        
}
// end of static parts



#declare rStart = rotation;


#declare blurLevel = 0;      
#declare motionBlurStep = motionBlurRotation/motionBlurLevel;    
#declare blurTStep = 0.225/motionBlurLevel;  
#declare blurT = 0.925;



// put all parts in here that need motion blur
#while(blurLevel < motionBlurLevel)

        #declare rotation = rStart-motionBlurRotation;       
        #declare motionBlurRotation = motionBlurRotation-motionBlurStep;
          
        #if(rotation < 0)
                #declare rotation = 360+rotation;
        #end
        
        
        #if(blurLevel = motionBlurLevel-1)
                #declare blurT = 0;
        #else
                #declare blurT = blurT-blurTStep;
        #end
        
        #declare a = 7.5;
        #declare c = 75;   
        #if(rotation > 180)
                #declare C = 360-rotation;  
                #declare Wheeldir=-1;
        #else
                #declare C = rotation;
                #declare Wheeldir=1;
        #end
        //#declare C = degrees(acos( ((a*a)+(b*b)-(c*c))/(2*a*b)));
        
        // know C a and c so
        // Sin A = a sin(C)
        //         ---------
        //            c
        #declare A = degrees(asin( (a*sin(radians(C)))/c));// 
        
        #declare B = 180-(C+A); 
        
        #declare b = (a*sin(radians(B)))/sin(radians(A));
        
        #if(C = 0)
                #declare b = 75+7.5;
        #end 
        
        #if(C = 180)
                #declare b = 75-7.5;
        #end 
        
        /*
                #if(wheelDir = dirPush)
                        #declare A=-A;                
                        #declare C=-C;                
                #end
        */
        union
        {      
                // piston that pushes the wheels
                // slider box/piston
                union           
                {
                        // top 
                        difference
                        {
                                object { Round_Box_Union(<-4, 3, 0>, <4, 5, 3.0>, 0.2) }
                                box { <-4.1, 4.475, 0.45> <4.1, 5.01, 2.55> }
                                bounded_by { box { <-4, 3, 0> <4, 5, 3> } }
                        }
                        // bottom 
                        difference
                        {
                                object { Round_Box_Union(<-4, -5, 0>, <4, -3, 3.0>, 0.2) }
                                box { <-4.1, -5.01, 0.45> <4.1, -4.475, 2.55> }      
                                bounded_by { box { <-4, -5, 0> <4, -3, 3> } }
                        }

                        // middle front
                        object { Round_Box_Union(<-2.5, -4, 0>, <2.5, 4, 0.49> 0.2) }      

                        // middle back
                        object { Round_Box_Union(<-2.5, -4, 2.51>, <2.5, 4, 3> 0.2) } 
                        
                        // small block at top
                        object { Round_Box_Union(<-1.1, 2.45, -0.65>, <1.1, 3.55, 3.25> 0.2) }      
                        // small block at bottom
                        // arm comming off of the bottom
                        union
                        {
                                Round_Cylinder_Union(<0, -3, -0.4>, <0, -3, 0>, 1, 0.1)
                                Round_Box_Union(<-1, -4.9, -0.4>, <1, -3, 0>, 0.1)    
                                scale <1.5, 1, 1>
                        }      
                        // three rivets/bolts
                        sphere { 0, 0.3 scale <1, 1, 0.3> translate <-1, -3, -0.4> }
                        sphere { 0, 0.3 scale <1, 1, 0.3> translate <0, -2.5, -0.4> }
                        sphere { 0, 0.3 scale <1, 1, 0.3> translate <1, -3, -0.4> }  



#declare bracket_Circ=pi*(40);
#declare bracket_Dist=b-75;
#declare bracket_B=(bracket_Dist/bracket_Circ)*360;

#declare bracket_SM_Circ=pi*20;                


#declare bracket_SM_Dist=vlength((vrotate(<0, -20, 0>, <0, 0, bracket_B>)+<75-b, 20, 0>));
#declare bracket_SM_C=(bracket_SM_Dist/bracket_SM_Circ)*360;



                        // bracket part   
                        union
                        {
                                difference
                                {
                                        Round_Cylinder_Union(<-1, 0, 0>, <1, 0, 0>, 2.5, 0.1)
                                        cylinder { <-1.1, 0, 0> <1.1, 0, 0> 1.9 }
                                        box { <-1.1, -2.6, -2.6> <1.1, 0, 2.6> }
                                        box { <-1.1, -2.6, 0> <1.1, 2.6, 2.6> }  
                                        texture { mkWheelDriveTex(0, dummyTex) }
                                }      
                                // bottom static bar (only moves left and right) (nope and up and down..) 
                                Round_Cylinder_Union(<0, 0, -2.7>, <0, 0, -1.0>, 1.125, 0.1)  
                                union
                                {
                                        Round_Box_Union(<-10, -0.8, -2.4>, <0, 0.8, -1.2>, 0.1) 
                                        object { Round_Cylinder_Union(<0, 0, -3.1>, <0, 0, -1.0>, 0.75, 0.15)  mkWheelHubMidTex() translate <-10, 0, 0> }
                                        difference
                                        {
                                                Round_Cylinder_Union(<-10, 0, -2.7>, <-10, 0, -1.0>, 1.125, 0.1)  
                                                box { <-10.75, -1.2, -2.45> <-9.25, 1.2, -1.25> }
                                        }       
                                        texture { mkWheelDriveTex(0, dummyTex) }
                                        rotate <0, 0, -bracket_SM_C>
                                }
                                // arm which goes upwards      
                                union
                                {
                                        //cylinder { <0, -20, 0> <0, 0, 0> 1 }
                                        box { <-0.7, -20, 0> <0.7, -8, 1> }
                                        cylinder { <-0.5, -20, 0> <-0.5, -8, 0> 0.2 }
                                        cylinder { <0.5, -20, 0> <0.5, -8, 0> 0.2 }  
                                        
                                        union
                                        {
                                                difference
                                                {       
                                                        union
                                                        {
                                                                cylinder { <-0.7, 0, 0> <0.7, 0, 0> 3 }
                                                                torus { 3, 0.2 rotate <0, 0, 90> translate <-0.5, 0, 0> }
                                                                torus { 3, 0.2 rotate <0, 0, 90> translate <0.5, 0, 0> }
                                                        }
                                                        cylinder { <-0.71, 0, 0> <0.71, 0, 0> 2 } 
                                                        box { <-0.71, -3.21, -3.21> <0.71, 0, 3.21> }
                                                        box { <-0.71, -3.21, 0> <0.71, 3.21, 3.21> }    
                                                        bounded_by { box { <-0.7, 0, -3.2> <0.7, 3.2, 0> } }                                                                                                            
                                                }       
                                                difference
                                                {       
                                                        cylinder { <-0.7, 0, 0> <0.7, 0, 0> 3 }
                                                        cylinder { <-0.71, 0, 0> <0.71, 0, 0> 2 } 
                                                        box { <-0.71, -3.01, -3.01> <0.71, 3.01, 0> }
                                                        box { <-0.71, 0, -3.01> <0.71, 3.01, 3.01> }    
                                                        bounded_by { box { <-0.7, -3, 0> <0.7, 0, 3> } }                                                                                                            
                                                        translate <0, 5, 0>
                                                }  
                                                difference
                                                {
                                                        union
                                                        {
                                                                torus { 2, 0.2 rotate <0, 0, 90> translate <-0.5, 0, 0> }
                                                                torus { 2, 0.2 rotate <0, 0, 90> translate <0.5, 0, 0> }
                                                        }
                                                        box { <-0.71, -2.21, -2.21> <0.71, 2.21, 0> }
                                                        box { <-0.71, 0, -2.21> <0.71, 2.21, 2.21> }
                                                        
                                                        translate <0, 5, 0>        
                                                } 
                                                union
                                                { 
                                                        difference
                                                        {
                                                                union
                                                                {
                                                                        box { <-0.7, 0, 0> <0.7, 4, 1> }
                                                                        cylinder { <-0.5, 0, 0> <-0.5, 4, 0> 0.2 }
                                                                        cylinder { <0.5, 0, 0> <0.5, 4, 0> 0.2 }                                      
                                                                        Round_Cylinder_Union(<0, 4, -0.2>, <0, 4, 1.2>, 0.9, 0.2)
                                                                }
                                                                cylinder { <0, 4, -0.21> <0, 4, 1.21> 0.4 }     
                                                                
                                                        }       
                                                        
                                                        
                                                        translate <0, 5, 2> 
                                                }     
                                                
                                                // long arm which extends to above first large wheel
                                                union
                                                {
                                                        Round_Cylinder_Union(<0, 0, -0.2>, <0, 0, 1.2>, 0.9, 0.1)
                                                        Round_Cylinder_Union(<0, 0, -0.35>, <0, 0, 1.35>, 0.3, 0.05)
                                                        object { Round_Box_Union(<0, -0.3, 0> <45, 0.3, 1>, 0.01) rotate <0, 0, 0.5> translate <0, 0.5, 0> }
                                                        object { Round_Box_Union(<0, -0.3, 0> <45, 0.3, 1>, 0.01) rotate <0, 0, -0.5> translate <0, -0.5, 0> }
                                                        difference
                                                        {
                                                                box { <0, -0.8, 0.25> <40, 0.8, 1> }
                                                                cylinder { <40, 0, 0> <40, 0, 1.1> 0.6 }
                                                        }  
                                                        difference
                                                        {
                                                                box { <42, -0.9, 0.1> <45, 0.9, 1> }
                                                                cylinder { <42, 0, 0> <42, 0, 1.1> 0.6 }
                                                        }  
                                                        difference
                                                        {
                                                                object { Round_Cylinder_Union(<45, 0, 0>, <45, 0, 1>, 1.23, 0.05) }
                                                                cylinder { <45, 0, -0.1> <45, 0, 0.2> 0.6 }
                                                                box { <44, -0.6, -0.1> <45, 0, 0.2> } 
                                                        }   
                                                        texture { mkWheelDriveTex(0, dummyTex) }
                                                        //box 
                                                        //{       
                                                         //       <0, -0.5, 0> <45, 0.5, 1> 
                                                                rotate <0, 0, -5+(-bracket_B)+bracket_B/10>    
                                                        //}       
                                                        translate <0, 9, 0.625>
                                                } 
                                                                                      
                                                translate <0, -8, 3>  
                                        }      
                                        texture { mkWheelDriveTex(0, dummyTex) }                                 
                                        rotate <0, 0, bracket_B> translate <-10-(b-75), 20, -2.25>    
                                        
                                }
                                translate <0, -7, -0.25> 
                        }                        
                        // small arm off of long arm which extends to above first large wheel  
                        union
                        {
//                                box { <-12, -0.5, 0> <0, 0.5, 1> }
//                                rotate <0, 0, 19+(-bracket_B*0.375)>
                                intersection
                                {
                                        union
                                        {
                                                box { <-13, -1, 0> <0, 1, 0.45> }
                                                box { <-13, -1, 1.55> <0, 1, 2> }
                                        }       
                                        cone { <-13, 0, 0> 0.5 <0, 0, 0> 1 scale <1, 1, 3> translate <0, 0, 1> }
                                }
                                Round_Cylinder_Union(<0, 0, -0.2>, <0, 0, 2.2>, 1, 0.1)
                                Round_Cylinder_Union(<-13, 0, -0.2>, <-13, 0, 2.2>, 0.5, 0.1)
                                 
                                //box { <-14, -0.5, 0> <0, 0.5, 1> }
                                texture { mkWheelDriveTex(0, dummyTex) }
                                rotate <0, 0, (-bracket_B*0.3)+16>
                                translate <-10-(b-75), 20, 0>
                                translate <54, -6, 0.625>    
                                
                                
                        
                        }
                        
                        
                        object { Round_Cylinder_Union(<0, 0, -0.7>, <0, 0, 3.4>, 1.5, 0.3) mkWheelHubMidTex() }    
                        
                        // piston part
                        union
                        {          
                                // end of piston
                                object { Round_Cylinder_Union(<-5.5, 0, 1.5>, <-2.5, 0, 1.5>, 1.4, 0.15) }
                                object { Round_Box_Union(<-4.8, -0.325, -1.75>, <-3.2, 0.325, 1.75>, 0.125) rotate <35, 0, 0> translate <0, 0, 1.5> }
                                // main piston shaft
                                cylinder { <-26, 0, 0> <0, 0, 0> 0.65 texture { sliderTex() scale <26, 1, 1>  } translate <0, 0, 1.5> } 
                                texture { mkWheelDriveTex(0, dummyTex) }            
                                
                        }
                
                        texture { mkWheelDriveTex(0, dummyTex) }
                        scale 1+(blurT/10000) 
                        translate <(b-75)+1, 0, -3.6>  
                }                                 
 
                
                
                // piston to wheel connector
                union
                {
                        difference
                        {
                                box { <0, -2.5, 0>  <75, 2.5, 1> }   
                                box { <-0.1, -3, -0.01> <77, 0, 1.01> rotate <0, 0, -1> translate <0, -0.75, 0> }
                                box { <-0.1, 0, -0.01> <77, 3, 1.01> rotate <0, 0, 1> translate <0, 0.75, 0> }  
                                bounded_by { box { <0, -2.5, 0>  <75, 2.5, 1> }  }
                        } 
                        object { Round_Cylinder_Union(0, z*1, 3, 0.3) translate <75, 0, 0> }   
                        cylinder { <0, 0, 0> <72.5, 0, 0> 0.3 rotate <0, 0, -1> translate <0, -0.45, 0> }    
                        sphere { <0, 0, 0> 0.3 translate <0, -0.45, 0> }
                        sphere { <72.5, 0, 0> 0.3 rotate <0, 0, -1> translate <0, -0.45, 0> }
                        cylinder { <0, 0, 0> <72.5, 0, 0> 0.3 rotate <0, 0, 1> translate <0, 0.45, 0> }
                        sphere { <0, 0, 0> 0.3 translate <0, 0.45, 0> }
                        sphere { <72.5, 0, 0> 0.3 rotate <0, 0, 1> translate <0, 0.45, 0> }
                        scale 1+(blurT/10000)    
                        texture { mkWheelDriveTex(0, dummyTex) }

                        rotate <0, 0, A*Wheeldir> translate <b-75, 0, -3.1> 
                }       
                // small shaft comming off of middle wheel
                union
                {
                        Round_Cylinder_Union(0, z*1, 2.5, 0.1) 
                        intersection
                        {
                                cone { <-10, 0, 0> 1.25 <0, 0, 0> 2.3 translate <0, 0, 0.5> }
                                box { <-10, -2.3, 0> <0, 2.3, 1> }
                        }
                        // rivets 
                        sphere { 0 0.3 scale <1, 1, 0.3> translate <-.8, .8, -0.01> }
                        sphere { 0 0.3 scale <1, 1, 0.3> translate <-.8, -.8, -0.01> }
                        sphere { 0 0.3 scale <1, 1, 0.3> translate <.8, .8, -0.01> }
                        sphere { 0 0.3 scale <1, 1, 0.3> translate <.8, -.8, -0.01> }   
                        // top part of arm
                        Round_Cylinder_Union(<-10, 0, 0>, <-10, 0, 1>, 1.5, 0.1)
                        
                        
                        scale 1+(blurT/10000)                        
                        texture { mkWheelDriveTex(0, dummyTex) }
                        //rotate <0, 0, -rotation> 
                        translate <7.5, 0, 0>
                        rotate <0, 0, rotation>
                        translate <75, 0, -4.2>
                        
                    //    pigment { Green }
                }       
                // arm from above to top small arm near body
                union
                {       
                        object { Round_Box_Union(<-45, 0, 0> <0, 0.5, 1>, 0.25) rotate <0, 0, 0.325> translate <0, 0.65, 0> }
                        object { Round_Box_Union(<-45, -0.5, 0> <0, 0, 1>, 0.25) rotate <0, 0, -0.325> translate <0, -0.65, 0> }
                                
                        box { <-45, -0.651, 0.25> <0, 0.651, 0.75> }    
                        
                        Round_Cylinder_Union(0, z*1, 1.5, 0.25) 
                        object { Round_Cylinder_Union(z*-0.2, z*1.2, 1, 0.2)  mkWheelHubMidTex() rotate <0, 0, rotation> }
                        object { Round_Cylinder_Union(0, z*1, 1, 0.25) translate <-45, 0, 0> } 
                        
                        texture { mkWheelDriveTex(0, dummyTex) } 
                        rotate <0, 0, (-rotation)-(sind(rotation)*5)-5> 
                        translate <-3, 0, 0>
                        rotate <0, 0, rotation>
                        translate <75, 0, -5.25>  
                               
                        
                        
                      //  pigment { Green }
                }   
                // small arm attached to above which goes to long flat part of body
                union
                {                                 
                        //#declare endP = vrotate(vtransform(vrotate(<-45, 0, 0> , <0, 0, (-rotation)-(sind(rotation)*5)-5>), transform { translate  <-3, 0 ,0> }), <0, 0, rotation>);
                        #declare endP = vrotate(vtransform(vrotate(<-45, 0, 0> , <0, 0, (-rotation)-(sind(rotation)*5)-5>), transform { translate  <-3, 0 ,0> }), <0, 0, rotation>);
                        #declare targetP = <-49, 10, 0>;
                        
                        difference
                        {
                                union
                                {
                                        sphere { <0, 0, 0> 1.1 scale <1, 1, 0.5> translate <0, 0, -1.5> }
                                        sphere { <0, 0, 0> 1.1 scale <1, 1, 0.5> translate <0, 0, 1.5> }
                                        cylinder { <0, 0, -1.5> <0, 0, 1.5> 1.1 }
                                }
                                //box { <-0.5, 0, 0> <0.5, 15, 1> }
                                union
                                {
                                        box { <-1.5, -1.5, -1.05> <1.5, 2, 1.05> }
                                        box { <-1.2, -1.2, -2.2> <1.2, 1.2, -1.985> }
                                }
                        
                        }    
                        difference
                        {
                                cylinder { <0, 0, -1.9> <0, 0, 1.9> 10 }
                                
                                union
                                {
                                        cylinder { <0, 0, -1.95> <0, 0, 1.95> 8.5 }
                                        box { <-10.1, -10.1, -1.95> <10.1, 0, 1.95> }
                                        box { <0, -10.1, -1.95> <10.1, 10.1, 1.95> }  
                                        box { <-11, 0, -1.95> <0, 11, 1.95> rotate <0, 0, -25> }   
                                        cylinder { <0, 0, -1.05> <0, 0, 1.05> 10.1 }                                    
                                }          
                                translate <9.25, 0, 0>                  
                                rotate <0, 0, 20>
                                
                                
                        }          
                        cylinder { <0, 0, -1.7> <0, 0, 1.7> 1.1 translate <-9.25, 0, 0> rotate <0, 0, -25> 
                                translate <9.25, 0, 0> rotate <0, 0, 20> 
                                }
                        union
                        {                      
                                difference
                                {
                                        union
                                        {
                                                Round_Box_Union(<-1.15, 0, 0> <1.15, 10, 0.5>, 0.15)
                                        }                                                           
                                        union
                                        {
                                                box { <-0.3, 3, -0.1> <0.3, 7, 0.6> }    
                                                cylinder { <0, 3, -0.1> <0, 3, 0.6> 0.3 }
                                                cylinder { <0, 7, -0.1> <0, 7, 0.6> 0.3 }
                                        }       
                                        translate <0, 0, -2.1> 
                                }          
                                difference
                                {
                                        union
                                        {
                                                Round_Box_Union(<-1.15, 0, 0> <1.15, 10, 0.5>, 0.15)
                                        }                                                           
                                        union
                                        {
                                                box { <-0.3, 3, -0.1> <0.3, 7, 0.6> }    
                                                cylinder { <0, 3, -0.1> <0, 3, 0.6> 0.3 }
                                                cylinder { <0, 7, -0.1> <0, 7, 0.6> 0.3 }
                                        }       
                                        translate <0, 0, 1.6>       
                                }          
                                Round_Cylinder_Union(<-0.5, 1.0, -2.3>, <-0.5, 1.0, 2.3>, 0.3, 0.075)
                                Round_Cylinder_Union(<0.5, 1.0, -2.3>, <0.5, 1.0, 2.3>, 0.3, 0.075)
                                
                                rotate <0, 0, -20>       
                                translate <-9.25, 0, 0>
                                rotate <0, 0, -20>
                                translate <9.25, 0, -2.1>
                                rotate <0, 0, 20>
                        }        
                        texture { mkWheelDriveTex(0, dummyTex) }
                                                             //47.829  
                        
                        #warning str(rotation, 0, 3)
                        #declare p1=<0, -10, 0>;
                        #declare p2=vrotate(p1, <0, 0, rotation>);
                        
                                                      
                        rotate <0, 0, VRotationD(<targetP.x-endP.x, targetP.y-endP.y, 0>, <0, 10, 0>, <0, 0, 0>)>
                        translate endP     
                        
                        translate <75, 0, -5.25>                             
                       
                }
                
        
                // straight piston
                #declare sp = vrotate(<7.5, 0, 0>, <0, 0, rotation>);   
                
                union   
                {       
                        // rounded edges to long bars
                        union
                        {
                                cylinder { <3, 1.125, 0> <46, 1.125, 0> 0.375 }
                                cylinder { <3, -1.125, 0> <46, -1.125, 0> 0.375 }
                                sphere { <3, 1.125, 0> 0.375 }
                                sphere { <3, -1.125, 0> 0.375 }
                                sphere { <46, 1.125, 0> 0.375 }
                                sphere { <46, -1.125, 0> 0.375 }
        
                                cylinder { <-45, 1.125, 0> <-3, 1.125, 0> 0.375 }
                                cylinder { <-45, -1.125, 0> <-3, -1.125, 0> 0.375 }
                                sphere { <-3, 1.125, 0> 0.375 }
                                sphere { <-3, -1.125, 0> 0.375 }
                                sphere { <-45, 1.125, 0> 0.375 }
                                sphere { <-45, -1.125, 0> 0.375 }                  
                                scale <1, 1, 0.5>
                                translate <0, 0, 0.2>
                        }                        
                        
                        // large discs that join to wheels and middle of long bar
                        difference
                        {
                                union
                                {
                                        Round_Cylinder_Union(0, z*1, 3, 0.3)  
                                        union
                                        {
                                                Round_Cylinder_Union(0, z*1, 2.5, 0.3)  
                                                translate <49, 0, 0>
                                        }
                                        union
                                        {
                                                Round_Cylinder_Union(0, z*1, 2.5, 0.3)  
                                                translate <-47, 0, 0>
                                        }
                                        box { <0, -1.5, 0.2> <49, 1.5, 1>  }   
                                        box { <-47, -1.5, 0.2> <0, 1.5, 1>  }   
                                }
                                union
                                {
                                        cylinder { <3, 0, 0> <46, 0, 0> 0.75 }
                                        sphere { <3, 0, 0> 0.75 }
                                        sphere { <46, 0, 0> 0.75 }
                                        scale <1, 1, 0.5>
                                        translate <0, 0, 0.2>
                                }
                                union
                                {
                                        cylinder { <-44, 0, 0> <-3 0, 0> 0.75 }
                                        sphere { <-3 0, 0> 0.75 }
                                        sphere { <-44, 0, 0> 0.75 }
                                        scale <1, 1, 0.5>
                                        translate <0, 0, 0.2>
                                }
                        }  
                        scale 1+(blurT/10000) 
                        translate sp                         
                        
                        texture { mkWheelDriveTex(0, dummyTex) }                  

                        translate <75, 0, -1.9>
                }                        

/******************************************************************************************
Front small wheels
*******************************************************************************************/


                union
                {          
                        union
                        {
                                difference    // wheel rim
                                {
                                        union
                                        {
                                                cylinder { <0, 0, 0.075> <0, 0, 3> 9.5 }   
                                                cylinder { <0, 0, 0> <0, 0, 3> 9.425 }
                                        }
                                        cylinder { <0, 0, -0.01> <0, 0, 3.01> 7.575 }   
                                }  
                                difference 
                                {
                                        cylinder { <0, 0, 0.075> <0, 0, 3> 9.0 }
                                        cylinder { <0, 0, -0.01> <0, 0, 3.01> 7.5 }
                                        
                                }       
                                torus { 9.425, 0.075 rotate x*90 translate <0, 0, 0.075> }  
                                torus { 7.575, 0.075 rotate x*90 translate z*0.075 }
                                // outer part of wheel that holds to track
                                difference
                                {
                                        Round_Cone_Union(z*2.95, 9.5, z*4, 11, 0.1)
                                        cylinder { <0, 0, -0.01> <0, 0, 4.01> 7.5 }
                                }
                                scale 1+(blurT/10000)
                                mkWheelRimTex(0, dummyTex)
                        }
                        
                        // 12 spokes  
                        #declare sprotate = 0;
                        #declare spstep = 360/12;  // num spokes was 12
                        #while(sprotate < 360)   
                                intersection
                                {
                                        union
                                        {
                                                cone { <-7.25, 0, 0> 0.3 <-2.5, 0, 0> 0.349 }
                                                sphere { <-7.25, 0, 0> 0.3 }    
                                                sphere { <0, 0, 0> 0.39 scale <4, 1, 1>  translate <-2.65, 0, 0> }
                                        }
                                        box { <-7.5, -0.5, -0.5> <-2, 0.5, 0> }
                                        bounded_by { box { <-7.5, -0.5, -0.5> <-2, 0.5, 0> } } 
                                        scale <1, 1.5, 6>
                                        scale 1+(blurT/10000) 
                                        translate <0, 0, 3.2>
                                        mkSmallWheelSpokeTex()// { rgbt <0, 0, 1, blurT> }  // spoke texture
                                        rotate <0, 0, sprotate> 
                                }
                                #declare sprotate = sprotate+spstep;
                        #end 
                        // inner rim attached to spokes
                        union
                        {
                                difference 
                                {
                                        cylinder { <0, 0, 0.45> <0, 0, 3> 7.5 }
                                        cylinder { <0, 0, 0.449> <0, 0, 3.01> 6.25 } 
                                        cone { <0, 0, 0.449999> 17.2 <0, 0, 1.5> 6.24999 }                                                                            
                                }  
                                torus { 7.35, 0.15 scale <1, 0.2, 1> rotate <90, 0, 0> translate <0, 0, 0.45> } 
                                scale 1+(blurT/10000)  
                                mkSmallWheelSpokeRimTex()   // spoke rim texture
                        }
                        union
                        {   
                                // main wheel hub
                                union
                                {
                                        union
                                        {
                                                difference
                                                {       
                                                        union
                                                        {
                                                                Round_Cone_Union(0, 2.5, z*3, 4, 0.15)
                                                                Round_Cone_Union(<0, 0, -0.075>, 1.5, <0, 0, 0.2>, 2, 0.05)
                                                        } 
                                                        cylinder { <0, 0, -0.1> <0, 0, 3.01> 1.01 }       
                                                        
                                                }      
                                                // edge of difference above
                                                torus { 1.01, 0.025 rotate x*90 translate z*-0.05 }  
                                                scale 1+(blurT/10000)
                                        }
                                        mkSmallWheelHubTex() 
                                }
                                union
                                {
                                        difference 
                                        {
                                                union
                                                {
                                                        cylinder { <0, 0, 0.1> <0, 0, 2> 1 }
                                                        cylinder { <0, 0, -0.1> <0, 0, 2> 0.8 } 
                                                } 
                                                cone { <0, 0, -0.12> 0.375 <0, 0, 0.35> 0.05 }  
                                                scale 1+(blurT/10000)
                                                
                                        }
                                        torus { 0.8, 0.2 scale 1+(blurT/10000) rotate x*90 translate z*0.1 }    
                                        mkWheelHubMidTex()
                                        
                                } 
                        }         
                        object { driveShaft }
                        rotate <0, 0, rotation>  
                        translate <-9.5, -10, 0>
                                  
                }


// Front small wheel

                union
                {          
                        union
                        {
                                difference    // wheel rim
                                {
                                        union
                                        {
                                                cylinder { <0, 0, 0.075> <0, 0, 3> 9.5 }   
                                                cylinder { <0, 0, 0> <0, 0, 3> 9.425 }
                                        }
                                        cylinder { <0, 0, -0.01> <0, 0, 3.01> 7.575 }   
                                }  
                                difference 
                                {
                                        cylinder { <0, 0, 0.075> <0, 0, 3> 9.0 }
                                        cylinder { <0, 0, -0.01> <0, 0, 3.01> 7.5 }
                                        
                                }       
                                torus { 9.425, 0.075 rotate x*90 translate <0, 0, 0.075> }  
                                torus { 7.575, 0.075 rotate x*90 translate z*0.075 }
                                // outer part of wheel that holds to track
                                difference
                                {
                                        Round_Cone_Union(z*2.95, 9.5, z*4, 11, 0.1)
                                        cylinder { <0, 0, -0.01> <0, 0, 4.01> 7.5 }
                                }
                                scale 1+(blurT/10000)
                                mkWheelRimTex(0, dummyTex)
                        }
                        
                        // 12 spokes  
                        #declare sprotate = 0;
                        #declare spstep = 360/12;  // num spokes was 12
                        #while(sprotate < 360)   
                                intersection
                                {
                                        union
                                        {
                                                cone { <-7.25, 0, 0> 0.3 <-2.5, 0, 0> 0.349 }
                                                sphere { <-7.25, 0, 0> 0.3 }    
                                                sphere { <0, 0, 0> 0.39 scale <4, 1, 1>  translate <-2.65, 0, 0> }
                                        }
                                        box { <-7.5, -0.5, -0.5> <-2, 0.5, 0> }
                                        bounded_by { box { <-7.5, -0.5, -0.5> <-2, 0.5, 0> } } 
                                        scale <1, 1.5, 6>
                                        scale 1+(blurT/10000) 
                                        translate <0, 0, 3.2>
                                        mkSmallWheelSpokeTex()// { rgbt <0, 0, 1, blurT> }  // spoke texture
                                        rotate <0, 0, sprotate> 
                                }
                                #declare sprotate = sprotate+spstep;
                        #end 
                        // inner rim attached to spokes
                        union
                        {
                                difference 
                                {
                                        cylinder { <0, 0, 0.45> <0, 0, 3> 7.5 }
                                        cylinder { <0, 0, 0.449> <0, 0, 3.01> 6.25 } 
                                        cone { <0, 0, 0.449999> 17.2 <0, 0, 1.5> 6.24999 }                                                                            
                                }  
                                torus { 7.35, 0.15 scale <1, 0.2, 1> rotate <90, 0, 0> translate <0, 0, 0.45> } 
                                scale 1+(blurT/10000)  
                                mkSmallWheelSpokeRimTex()   // spoke rim texture
                        }
                        union
                        {   
                                // main wheel hub
                                union
                                {
                                        union
                                        {
                                                difference
                                                {       
                                                        union
                                                        {
                                                                Round_Cone_Union(0, 2.5, z*3, 4, 0.15)
                                                                Round_Cone_Union(<0, 0, -0.075>, 1.5, <0, 0, 0.2>, 2, 0.05)
                                                        } 
                                                        cylinder { <0, 0, -0.1> <0, 0, 3.01> 1.01 }       
                                                        
                                                }      
                                                // edge of difference above
                                                torus { 1.01, 0.025 rotate x*90 translate z*-0.05 }  
                                                scale 1+(blurT/10000)
                                        }
                                        mkSmallWheelHubTex() 
                                }
                                union
                                {
                                        difference 
                                        {
                                                union
                                                {
                                                        cylinder { <0, 0, 0.1> <0, 0, 2> 1 }
                                                        cylinder { <0, 0, -0.1> <0, 0, 2> 0.8 } 
                                                } 
                                                cone { <0, 0, -0.12> 0.375 <0, 0, 0.35> 0.05 }  
                                                scale 1+(blurT/10000)
                                                
                                        }
                                        torus { 0.8, 0.2 scale 1+(blurT/10000) rotate x*90 translate z*0.1 }    
                                        mkWheelHubMidTex()
                                        
                                } 
                        }
                        object { driveShaft }
                        rotate <0, 0, rotation>  
                        translate <-54.5, -10, 0>
                                  
                }


/******************************************************************************************
Large wheels
*******************************************************************************************/
   
                // front large wheel
                union
                {          
                        union
                        {
                                difference    // wheel rim
                                {
                                        union
                                        {
                                                cylinder { <0, 0, 0.075> <0, 0, 3> 19.5 }   
                                                cylinder { <0, 0, 0> <0, 0, 3> 19.425 }
                                        }
                                        cylinder { <0, 0, -0.01> <0, 0, 3.01> 17.575 }   
                                }  
                                difference 
                                {
                                        cylinder { <0, 0, 0.075> <0, 0, 3> 19.0 }
                                        cylinder { <0, 0, -0.01> <0, 0, 3.01> 17.5 }
                                        
                                }       
                                torus { 19.425, 0.075 rotate x*90 translate <0, 0, 0.075> }  
                                torus { 17.575, 0.075 rotate x*90 translate z*0.075 }
                                // outer part of wheel that holds to track
                                difference
                                {
                                        Round_Cone_Union(z*2.95, 19.5, z*4, 21, 0.1)
                                        cylinder { <0, 0, -0.01> <0, 0, 4.01> 17.5 }
                                }
                                scale 1+(blurT/10000)
                                mkWheelRimTex(0, dummyTex)
                        }
                        
                        // 21 spokes  
                        #declare sprotate = 0;
                        #declare spstep = 360/21;  // num spokes was 21
                        #while(sprotate < 360)   
                                intersection
                                {
                                        union
                                        {
                                                cone { <-17.25, 0, 0> 0.4 <-4.5, 0, 0> 0.449 }
                                                sphere { <-17.25, 0, 0> 0.4 }    
                                                sphere { <0, 0, 0> 0.5 scale <4, 1, 1>  translate <-4.65, 0, 0> }
                                        }
                                        box { <-17.5, -0.5, -0.5> <-4, 0.5, 0> }
                                        bounded_by { box { <-17.5, -0.5, -0.5> <-4, 0.5, 0> } } 
                                        scale <1, 1.5, 6>
                                        scale 1+(blurT/10000) 
                                        translate <0, 0, 3.2>
                                        mkWheelSpokeTex()// { rgbt <0, 0, 1, blurT> }  // spoke texture
                                        rotate <0, 0, sprotate> 
                                }
                                #declare sprotate = sprotate+spstep;
                        #end 
                        // inner rim attached to spokes
                        union
                        {
                                difference 
                                {
                                        cylinder { <0, 0, 0.45> <0, 0, 3> 17.5 }
                                        cylinder { <0, 0, 0.449> <0, 0, 3.01> 16.25 } 
                                        cone { <0, 0, 0.449999> 17.2 <0, 0, 1.5> 16.24999 }                                                                            
                                }  
                                torus { 17.35, 0.15 scale <1, 0.2, 1> rotate <90, 0, 0> translate <0, 0, 0.45> } 
                                scale 1+(blurT/10000)  
                                mkWheelSpokeRimTex(0, dummyTex)   // spoke rim texture
                        }
                        // part of wheel attached to drive rod thingy
                        union
                        {   
                                // main wheel hub
                                union
                                {
                                        union
                                        {
                                                difference
                                                {       
                                                        union
                                                        {
                                                                Round_Cone_Union(0, 4.5, z*3, 6, 0.15)
                                                                Round_Cone_Union(<0, 0, -0.075>, 3.5, <0, 0, 0.2>, 4, 0.05)
                                                        } 
                                                        cylinder { <0, 0, -0.1> <0, 0, 3.01> 2.01 }       
                                                        
                                                }      
                                                // edge of difference above
                                                torus { 2.01, 0.025 rotate x*90 translate z*-0.05 }  
                                                scale 1+(blurT/10000)
                                        }
                                        // inner part of wheel hub with cone shaped hole
                                        //  (   )
                                        //   \ /  <- this bit..
                                        //    o
                                        union
                                        {
                                                union
                                                {
                                                        cylinder { <-6, 0, 0.05> <0, 0, 0.05> 0.05 }
                                                        box { <-6, 0, 0> <0, 4.0, 2> }           
                                                        box { <-6, 0, 0> <0, 4, 2> rotate <20, 0, 0> translate <0, -0.05, 0.05> } 
                                                        scale 1+(blurT/10000)
                                                        rotate <0, 0, 10> translate <0, -3.0, 0> 
                                                }
                                                union
                                                {     
                                                        cylinder { <-6, 0, 0.05> <0, 0, 0.05> 0.05 }
                                                        box { <-6, -4.0, 0> <0, 0, 2> }             
                                                        box { <-6, -4, 0> <0, 0, 2> rotate <-20, 0, 0> translate <0, 0.05, 0.05> }
                                                        scale 1+(blurT/10000)
                                                        rotate <0, 0, -10> translate <0, 3.0, 0> 
                                                }
                                                union
                                                {
                                                        Round_Cone_Union(0, 3, z*3, 4.5, 0.1)
                                                        scale 1+(blurT/10000)
                                                } 
                                                translate <7.5, 0, 0>  
                                        }
                                        mkWheelHubTex() 
                                }
                                union
                                {
                                        difference 
                                        {
                                                union
                                                {
                                                        cylinder { <0, 0, 0.1> <0, 0, 2> 2 }
                                                        cylinder { <0, 0, -0.1> <0, 0, 2> 1.8 } 
                                                } 
                                                cone { <0, 0, -0.12> 0.675 <0, 0, 0.5> 0.1 }  
                                                scale 1+(blurT/10000)
                                                
                                        }
                                        torus { 1.8, 0.2 scale 1+(blurT/10000) rotate x*90 translate z*0.1 }    
                                        mkWheelHubMidTex()
                                        
                                } 

                                // washer for levers that drive wheels
                                union
                                {     
                                        cylinder { -z*1.5 z*1 1.25 }
                                        Round_Cylinder_Union(0, z*0.5, 2.5, 0.1) 
                                        texture { mkWheelDriveTex(0, dummyTex) } 
                                        translate <7.5, 0, -0.7>
                                        
                                }

                               
                        }
                        object { driveShaft }
                        rotate <0, 0, rotation>  
                        translate <28, 0, 0>
                        
                                  
                }
                // middle wheel
                union
                {          
                        union
                        {
                                difference    // wheel rim
                                {
                                        union
                                        {
                                                cylinder { <0, 0, 0.075> <0, 0, 3> 19.5 }   
                                                cylinder { <0, 0, 0> <0, 0, 3> 19.425 }
                                        }
                                        cylinder { <0, 0, -0.01> <0, 0, 3.01> 17.575 }   
                                }  
                                difference 
                                {
                                        cylinder { <0, 0, 0.075> <0, 0, 3> 19.0 }
                                        cylinder { <0, 0, -0.01> <0, 0, 3.01> 17.5 }
                                        
                                }       
                                torus { 19.425, 0.075 rotate x*90 translate <0, 0, 0.075> }  
                                torus { 17.575, 0.075 rotate x*90 translate z*0.075 }
                                // outer part of wheel that holds to track
                                difference
                                {
                                        Round_Cone_Union(z*2.95, 19.5, z*4, 21, 0.1)
                                        cylinder { <0, 0, -0.01> <0, 0, 4.01> 17.5 }
                                }
                                scale 1+(blurT/10000)
                                mkWheelRimTex(0, dummyTex)
                        }
                        
                        // 21 spokes  
                        #declare sprotate = 0;
                        #declare spstep = 360/21;  // num spokes was 21
                        #while(sprotate < 360)   
                                intersection
                                {
                                        union
                                        {
                                                cone { <-17.25, 0, 0> 0.4 <-4.5, 0, 0> 0.449 }
                                                sphere { <-17.25, 0, 0> 0.4 }    
                                                sphere { <0, 0, 0> 0.5 scale <4, 1, 1>  translate <-4.65, 0, 0> }
                                        }
                                        box { <-17.5, -0.5, -0.5> <-4, 0.5, 0> }
                                        bounded_by { box { <-17.5, -0.5, -0.5> <-4, 0.5, 0> } } 
                                        scale <1, 1.5, 6>
                                        scale 1+(blurT/10000) 
                                        translate <0, 0, 3.2>
                                        mkWheelSpokeTex()// { rgbt <0, 0, 1, blurT> }  // spoke texture
                                        rotate <0, 0, sprotate> 
                                }
                                #declare sprotate = sprotate+spstep;
                        #end 
                        // inner rim attached to spokes
                        union
                        {
                                difference 
                                {
                                        cylinder { <0, 0, 0.45> <0, 0, 3> 17.5 }
                                        cylinder { <0, 0, 0.449> <0, 0, 3.01> 16.25 } 
                                        cone { <0, 0, 0.449999> 17.2 <0, 0, 1.5> 16.24999 }                                                                            
                                }  
                                torus { 17.35, 0.15 scale <1, 0.2, 1> rotate <90, 0, 0> translate <0, 0, 0.45> } 
                                scale 1+(blurT/10000)  
                                mkWheelSpokeRimTex(0, dummyTex)   // spoke rim texture
                        }
                        // part of wheel attached to drive rod thingy
                        union
                        {   
                                // main wheel hub
                                union
                                {
                                        union
                                        {
                                                difference
                                                {       
                                                        union
                                                        {
                                                                Round_Cone_Union(0, 4.5, z*3, 6, 0.15)
                                                                Round_Cone_Union(<0, 0, -0.075>, 3.5, <0, 0, 0.2>, 4, 0.05)
                                                        } 
                                                        cylinder { <0, 0, -0.1> <0, 0, 3.01> 2.01 }       
                                                        
                                                }      
                                                // edge of difference above
                                                torus { 2.01, 0.025 rotate x*90 translate z*-0.05 }  
                                                scale 1+(blurT/10000)
                                        }
                                        // inner part of wheel hub with cone shaped hole
                                        //  (   )
                                        //   \ /  <- this bit..
                                        //    o
                                        union
                                        {
                                                union
                                                {
                                                        cylinder { <-6, 0, 0.05> <0, 0, 0.05> 0.05 }
                                                        box { <-6, 0, 0> <0, 4.0, 2> }           
                                                        box { <-6, 0, 0> <0, 4, 2> rotate <20, 0, 0> translate <0, -0.05, 0.05> } 
                                                        scale 1+(blurT/10000)
                                                        rotate <0, 0, 10> translate <0, -3.0, 0> 
                                                }
                                                union
                                                {     
                                                        cylinder { <-6, 0, 0.05> <0, 0, 0.05> 0.05 }
                                                        box { <-6, -4.0, 0> <0, 0, 2> }             
                                                        box { <-6, -4, 0> <0, 0, 2> rotate <-20, 0, 0> translate <0, 0.05, 0.05> }
                                                        scale 1+(blurT/10000)
                                                        rotate <0, 0, -10> translate <0, 3.0, 0> 
                                                }
                                                union
                                                {
                                                        Round_Cone_Union(0, 3, z*3, 4.5, 0.1)
                                                        scale 1+(blurT/10000)
                                                } 
                                                translate <7.5, 0, 0>  
                                        }
                                        mkWheelHubTex() 
                                }
                                union
                                {
                                        difference 
                                        {
                                                union
                                                {
                                                        cylinder { <0, 0, 0.1> <0, 0, 2> 2 }
                                                        cylinder { <0, 0, -0.1> <0, 0, 2> 1.8 } 
                                                } 
                                                cone { <0, 0, -0.12> 0.675 <0, 0, 0.5> 0.1 }  
                                                scale 1+(blurT/10000)
                                                
                                        }
                                        torus { 1.8, 0.2 scale 1+(blurT/10000) rotate x*90 translate z*0.1 }    
                                        mkWheelHubMidTex()
                                        
                                }  
                                
                                // washer for levers that drive wheels
                                union
                                {     
                                        cylinder { -z*1.5 z*1 1.25 }
                                        Round_Cylinder_Union(0, z*0.5, 3, 0.1) 
                                        texture { mkWheelDriveTex(0, dummyTex) } 
                                        translate <7.5, 0, -0.7>
                                        
                                }


                               
                        }
                        object { driveShaft }
                        rotate <0, 0, rotation>  
                        translate <75, 0, 0>
                        
                                  
                }
                // Back large wheel
                union
                {          
                        union
                        {
                                difference    // wheel rim
                                {
                                        union
                                        {
                                                cylinder { <0, 0, 0.075> <0, 0, 3> 19.5 }   
                                                cylinder { <0, 0, 0> <0, 0, 3> 19.425 }
                                        }
                                        cylinder { <0, 0, -0.01> <0, 0, 3.01> 17.575 }   
                                }  
                                difference 
                                {
                                        cylinder { <0, 0, 0.075> <0, 0, 3> 19.0 }
                                        cylinder { <0, 0, -0.01> <0, 0, 3.01> 17.5 }
                                        
                                }       
                                torus { 19.425, 0.075 rotate x*90 translate <0, 0, 0.075> }  
                                torus { 17.575, 0.075 rotate x*90 translate z*0.075 }
                                // outer part of wheel that holds to track
                                difference
                                {
                                        Round_Cone_Union(z*2.95, 19.5, z*4, 21, 0.1)
                                        cylinder { <0, 0, -0.01> <0, 0, 4.01> 17.5 }
                                }
                                scale 1+(blurT/10000)
                                mkWheelRimTex(0, dummyTex)
                        }
                        
                        // 21 spokes  
                        #declare sprotate = 0;
                        #declare spstep = 360/21;  // num spokes was 21
                        #while(sprotate < 360)   
                                intersection
                                {
                                        union
                                        {
                                                cone { <-17.25, 0, 0> 0.4 <-4.5, 0, 0> 0.449 }
                                                sphere { <-17.25, 0, 0> 0.4 }    
                                                sphere { <0, 0, 0> 0.5 scale <4, 1, 1>  translate <-4.65, 0, 0> }
                                        }
                                        box { <-17.5, -0.5, -0.5> <-4, 0.5, 0> }
                                        bounded_by { box { <-17.5, -0.5, -0.5> <-4, 0.5, 0> } } 
                                        scale <1, 1.5, 6>
                                        scale 1+(blurT/10000) 
                                        translate <0, 0, 3.2>
                                        mkWheelSpokeTex()// { rgbt <0, 0, 1, blurT> }  // spoke texture
                                        rotate <0, 0, sprotate> 
                                }
                                #declare sprotate = sprotate+spstep;
                        #end 
                        // inner rim attached to spokes
                        union
                        {
                                difference 
                                {
                                        cylinder { <0, 0, 0.45> <0, 0, 3> 17.5 }
                                        cylinder { <0, 0, 0.449> <0, 0, 3.01> 16.25 } 
                                        cone { <0, 0, 0.449999> 17.2 <0, 0, 1.5> 16.24999 }                                                                            
                                }  
                                torus { 17.35, 0.15 scale <1, 0.2, 1> rotate <90, 0, 0> translate <0, 0, 0.45> } 
                                scale 1+(blurT/10000)  
                                mkWheelSpokeRimTex(0, dummyTex)   // spoke rim texture
                        }
                        // part of wheel attached to drive rod thingy
                        union
                        {   
                                // main wheel hub
                                union
                                {
                                        union
                                        {
                                                difference
                                                {       
                                                        union
                                                        {
                                                                Round_Cone_Union(0, 4.5, z*3, 6, 0.15)
                                                                Round_Cone_Union(<0, 0, -0.075>, 3.5, <0, 0, 0.2>, 4, 0.05)
                                                        } 
                                                        cylinder { <0, 0, -0.1> <0, 0, 3.01> 2.01 }       
                                                        
                                                }      
                                                // edge of difference above
                                                torus { 2.01, 0.025 rotate x*90 translate z*-0.05 }  
                                                scale 1+(blurT/10000)
                                        }
                                        // inner part of wheel hub with cone shaped hole
                                        //  (   )
                                        //   \ /  <- this bit..
                                        //    o
                                        union
                                        {
                                                union
                                                {
                                                        cylinder { <-6, 0, 0.05> <0, 0, 0.05> 0.05 }
                                                        box { <-6, 0, 0> <0, 4.0, 2> }           
                                                        box { <-6, 0, 0> <0, 4, 2> rotate <20, 0, 0> translate <0, -0.05, 0.05> } 
                                                        scale 1+(blurT/10000)
                                                        rotate <0, 0, 10> translate <0, -3.0, 0> 
                                                }
                                                union
                                                {     
                                                        cylinder { <-6, 0, 0.05> <0, 0, 0.05> 0.05 }
                                                        box { <-6, -4.0, 0> <0, 0, 2> }             
                                                        box { <-6, -4, 0> <0, 0, 2> rotate <-20, 0, 0> translate <0, 0.05, 0.05> }
                                                        scale 1+(blurT/10000)
                                                        rotate <0, 0, -10> translate <0, 3.0, 0> 
                                                }
                                                union
                                                {
                                                        Round_Cone_Union(0, 3, z*3, 4.5, 0.1)
                                                        scale 1+(blurT/10000)
                                                } 
                                                translate <7.5, 0, 0>  
                                        }
                                        mkWheelHubTex() 
                                }
                                union
                                {
                                        difference 
                                        {
                                                union
                                                {
                                                        cylinder { <0, 0, 0.1> <0, 0, 2> 2 }
                                                        cylinder { <0, 0, -0.1> <0, 0, 2> 1.8 } 
                                                } 
                                                cone { <0, 0, -0.12> 0.675 <0, 0, 0.5> 0.1 }  
                                                scale 1+(blurT/10000)
                                                
                                        }
                                        torus { 1.8, 0.2 scale 1+(blurT/10000) rotate x*90 translate z*0.1 }    
                                        mkWheelHubMidTex()
                                        
                                } 

                                // washer for levers that drive wheels
                                union
                                {     
                                        cylinder { -z*1.5 z*1 1.25 }
                                        Round_Cylinder_Union(0, z*0.5, 2.5, 0.1) 
                                        texture { mkWheelDriveTex(0, dummyTex) }  
                                        translate <7.5, 0, -0.7>
                                        
                                }

                               
                        }
                        object { driveShaft }
                        rotate <0, 0, rotation>  
                        translate <124, 0, 0>
                        
                                  
                }
                
        }       
        #declare blurLevel = blurLevel+1;             
#end // end of while loop
    
#end

/*
#if(clock < 0.5)
        object { Wheels(-1+(clock*4), dirPush) translate <0, -20, 0> }

#else
        object { Wheels(1-((clock-0.5)*4), dirPull) translate <0, -20, 0> }
//#warning str(clock, 10, 10)
#end
*/

#declare trainTop = union
{       
        // top black bit   
        union
        {       
                // back part near cabin
               // need to start at bottom.. Round_Box_Union(<199.5, -10, -31>, <200, 2.5, 31>, 0.1 ) 
          
                // long top part
                Round_Box_Union(<0, 2, -31>, <200, 2.5, -15>, 0.1)     
                             
                
                // rivets
                // top long row row
                #declare rp = 1.5;
                #while(rp < 199)
                        sphere { <0, 0, 0> 0.375 scale <1, 0.5, 1> translate <rp, 2.525, -29.5> }
                        sphere { <0, 0, 0> 0.375 scale <1, 0.5, 1> translate <rp, 2.525, 29.5> }
                        #declare rp=rp+3;
                #end 
                // end of top row at front   
                #declare rp = 1.5;
                #while(rp < 16)
                        sphere { <0, 0, 0> 0.375 scale <1, 0.5, 1> translate <1.5, 2.525, -31+rp> }
                        sphere { <0, 0, 0> 0.375 scale <1, 0.5, 1> translate <1.5, 2.525, 31-rp> }
                        sphere { <0, 0, 0> 0.375 scale <0.5, 1, 1> translate <-0.025, 1, -31+rp> }
                        sphere { <0, 0, 0> 0.375 scale <0.5, 1, 1> translate <-0.025, 1, 31-rp> }
                        #declare rp=rp+3;
                #end    
                
                // Wheel covers/arches
                // Right side
                // Back Wheel
                union
                {
                        difference
                        {
                                object {  Round_Cylinder_Union(<0, 0, 0>, <0, 0, 5>, 22, 0.25) }
                                box { <-23, -23, -0.1> <23, 17, 5.2> }
                        } 
                        difference
                        {
                                cylinder { <0, 0, -0.001> <0, 0, 0>, 21.75 }
                                box { <-23, -23, -0.1> <23, 17, 0.1> } 
                                texture { paintTex3 }
                        } 
                        difference
                        {
                                cylinder { <0, 0, -0.002> <0, 0, 0>, 21.25 }
                                box { <-23, -23, -0.1> <23, 17, 0.1> } 
                                texture { paintTex1 }
                        } 
                        
                        translate <184, -15, -20.5>
                }
                // Middle Wheel
                union
                {
                        difference
                        {
                                object {  Round_Cylinder_Union(<0, 0, 0>, <0, 0, 5>, 22, 0.25) }
                                box { <-23, -23, -0.1> <23, 17, 5.2> }
                        } 
                        difference
                        {
                                cylinder { <0, 0, -0.001> <0, 0, 0>, 21.75 }
                                box { <-23, -23, -0.1> <23, 17, 0.1> } 
                                texture { paintTex3 }
                        } 
                        difference
                        {
                                cylinder { <0, 0, -0.002> <0, 0, 0>, 21.25 }
                                box { <-23, -23, -0.1> <23, 17, 0.1> } 
                                texture { paintTex1 }
                        } 
                        
                        translate <135, -15, -20.5>
                }
                // Front Wheel
                union
                {
                        difference
                        {
                                object {  Round_Cylinder_Union(<0, 0, 0>, <0, 0, 5>, 22, 0.25) }
                                box { <-23, -23, -0.1> <23, 17, 5.2> }
                        } 
                        difference
                        {
                                cylinder { <0, 0, -0.001> <0, 0, 0>, 21.75 }
                                box { <-23, -23, -0.1> <23, 17, 0.1> } 
                                texture { paintTex3 }
                        } 
                        difference
                        {
                                cylinder { <0, 0, -0.002> <0, 0, 0>, 21.25 }
                                box { <-23, -23, -0.1> <23, 17, 0.1> } 
                                texture { paintTex1 }
                        } 
                        
                        translate <88, -15, -20.5>
                }  
                // royal scot sign above wheel arch
                object { WheelNamePlate translate <88, -15, -20.5> }
                object { WheelNamePlate scale <-1, 1, 1> translate <88, -15, -20.5> scale <1, 1, -1> }                                                  
                


                // Left side
                // Back Wheel
                union
                {
                        difference
                        {
                                object {  Round_Cylinder_Union(<0, 0, 0>, <0, 0, 5>, 22, 0.25) }
                                box { <-23, -23, -0.1> <23, 17, 5.2> }
                        } 
                        difference
                        {
                                cylinder { <0, 0, -0.001> <0, 0, 0>, 21.75 }
                                box { <-23, -23, -0.1> <23, 17, 0.1> } 
                                texture { paintTex3 }
                        } 
                        difference
                        {
                                cylinder { <0, 0, -0.002> <0, 0, 0>, 21.25 }
                                box { <-23, -23, -0.1> <23, 17, 0.1> } 
                                texture { paintTex1 }
                        } 
                        scale <1, 1, -1>
                        
                        translate <184, -15, 20.5>
                }
                // Middle Wheel
                union
                {
                        difference
                        {
                                object {  Round_Cylinder_Union(<0, 0, 0>, <0, 0, 5>, 22, 0.25) }
                                box { <-23, -23, -0.1> <23, 17, 5.2> }
                        } 
                        difference
                        {
                                cylinder { <0, 0, -0.001> <0, 0, 0>, 21.75 }
                                box { <-23, -23, -0.1> <23, 17, 0.1> } 
                                texture { paintTex3 }
                        } 
                        difference
                        {
                                cylinder { <0, 0, -0.002> <0, 0, 0>, 21.25 }
                                box { <-23, -23, -0.1> <23, 17, 0.1> } 
                                texture { paintTex1 }
                        } 
                        scale <1, 1, -1>
                        
                        translate <135, -15, 20.5>
                }
                // Front Wheel
                union
                {
                        difference
                        {
                                object {  Round_Cylinder_Union(<0, 0, 0>, <0, 0, 5>, 22, 0.25) }
                                box { <-23, -23, -0.1> <23, 17, 5.2> }
                        } 
                        difference
                        {
                                cylinder { <0, 0, -0.001> <0, 0, 0>, 21.75 }
                                box { <-23, -23, -0.1> <23, 17, 0.1> } 
                                texture { paintTex3 }
                        } 
                        difference
                        {
                                cylinder { <0, 0, -0.002> <0, 0, 0>, 21.25 }
                                box { <-23, -23, -0.1> <23, 17, 0.1> } 
                                texture { paintTex1 }
                        } 
                        scale <1, 1, -1>
                       
                        translate <88, -15, 20.5>
                }

                // front above buffers
                #declare rp = 4.5;
                #while(rp < 60)
                        sphere { <0, 0, 0> 0.375 scale <1, 0.5, 1> translate <-13.5, -7.475, -31+rp> }
                        #declare rp=rp+2.95;
                #end      
                
                // front curved rivets 
                // downward straight part
                #declare rp = 1.5;
                #while(rp < 5)
                        sphere { <0, 0, 0> 0.375 scale <0.5, 1, 1> translate <-0.025, 2.5-rp, -29.5> }
                        sphere { <0, 0, 0> 0.375 scale <0.5, 1, 1> translate <-0.025, 2.5-rp, 29.5> }
                        #declare rp=rp+3;
                #end    
                // curved part
                #declare rp = 25;
                #while(rp < 90)
                        sphere { <0, 0, 0> 0.375 scale <0.5, 1, 1> translate <5.0, 0, -29.5> rotate <0, 0, -rp>  translate <-5, -2.5, 0> }
                        sphere { <0, 0, 0> 0.375 scale <0.5, 1, 1> translate <5.0, 0, 29.5> rotate <0, 0, -rp> translate <-5, -2.5, 0> }
                        #declare rp=rp+30;
                #end  
                // straight part at bottom of curve  
                #declare rp = -13.5;
                #while(rp < -2)
                        sphere { <0, 0, 0> 0.375 scale <1, 0.5, 1> translate <rp, -7.475, -29.5> }
                        sphere { <0, 0, 0> 0.375 scale <1, 0.5, 1> translate <rp, -7.475, 29.5> }
                        #declare rp=rp+3;
                #end      
                  

                
                Round_Box_Union(<0, 2, 15>, <200, 2.5, 31>, 0.1)   
                // flat downward part before curved part at front
                Round_Box_Union(<0, -2.5, -31>, <0.5, 2.5, -15>, 0.1)
                Round_Box_Union(<0, -2.5, 15>, <0.5, 2.5, 31>, 0.1)
                // cover the holes left by the round box
                box { <0, -2.5, -30.9> <0.5, -2.4, -15> }
                box { <0, -2.5, 15> <0.5, -2.4, 30.9> }
                box { <0.1, -2.5, -31> <0.4, -2.4, -15> }    
                box { <0.1, -2.5, 15> <0.4, -2.4, 31> }  
                  
                cylinder { <0.1, -2.5, -30.9> <0.1, -2.4, -30.9> 0.1 }
                cylinder { <0.1, -2.5, 30.9> <0.1, -2.4, 30.9> 0.1 }
                cylinder { <0.4, -2.5, -30.9> <0.4, -2.4, -30.9> 0.1 }
                cylinder { <0.4, -2.5, 30.9> <0.4, -2.4, 30.9> 0.1 }
                
                // lower flat part at front after curve
                union
                {
                        Round_Box_Union(<-10, 0, -31>, <0, 0.5, 31>, 0.1)     
                        // cover joints
                        box { <-0.1, 0, -30.9> <0, 0.5, 30.9> }
                        box { <-0.1, 0.1, -31> <0, 0.4, 31> }
                        cylinder { <-0.1, 0.4, -30.9> <0, 0.4, -30.9> 0.1 } 
                        cylinder { <-0.1, 0.4, 30.9> <0, 0.4, 30.9> 0.1 } 
                        cylinder { <-0.1, 0.1, -30.9> <0, 0.1, -30.9> 0.1 } 
                        cylinder { <-0.1, 0.1, 30.9> <0, 0.1, 30.9> 0.1 } 
                        
                        translate <-5, -8, 0>
                }
                // curved part at front
                union
                {       
                        intersection
                        {    
                                union
                                {
                                        difference
                                        {
                                                cylinder { <0, 0, -31> <0, 0, -15> 5.4 }
                                                cylinder { <0, 0, -32> <0, 0, -14> 5.1 }                 
                                        }                                               
                                        torus { 5.1, 0.1 rotate <90, 0 ,0> translate <0, 0, -30.9> }
                                        torus { 5.4, 0.1 rotate <90, 0 ,0> translate <0, 0, -30.9> }
                                }
                                box { <0, -5.51, -31.1> <5.51, 0, -14.9> }   
                                bounded_by { box { <0, -5.51, -31.1> <5.51, 0, -14.9> } }
                        }
                        intersection
                        {    
                                union
                                {
                                        difference
                                        {
                                                cylinder { <0, 0, 15> <0, 0, 31> 5.4 }
                                                cylinder { <0, 0, 14> <0, 0, 32> 5.1 }                 
                                        }                                               
                                        torus { 5.1, 0.1 rotate <90, 0 ,0> translate <0, 0, 30.9> }
                                        torus { 5.4, 0.1 rotate <90, 0 ,0> translate <0, 0, 30.9> }  
                                }
                                box { <0, -5.51, 14.9> <5.51, 0, 31.1> }   
                                bounded_by { box { <0, -5.51, 14.9> <5.51, 0, 31.1> } }
                        }
                        
                        intersection
                        {
                                difference
                                {
                                        cylinder { <0, 0, -30.9> <0, 0, -15> 5.5 }
                                        cylinder { <0, 0, -32> <0, 0, -14> 5.0 } 
                                }
                                box { <0, -5.51, -31.1> <5.51, 0, -14.9> }   
                                bounded_by { box { <0, -5.51, -31.1> <5.51, 0, -14.9> } }
                        }
                        intersection
                        {
                                difference
                                {
                                        cylinder { <0, 0, 15> <0, 0, 30.9> 5.5 }
                                        cylinder { <0, 0, 14> <0, 0, 32> 5.0 } 
                                }
                                box { <0, -5.51, 14.9> <5.51, 0, 31.1> }   
                                bounded_by { box { <0, -5.51, 14.9> <5.51, 0, 31.1> } }
                        }
                          
                        translate <-5, -2.5, 0>               
                }   
                // flat part at front that buffers are attached to
                union
                {
                        difference
                        {
                                object { Round_Box_Union(<0, -15, -31>, <0.5, 0, 31>, 0.1) } 
                                cylinder { <-0.1, -15, -31> <0.6, -15, -31> 5 }
                                cylinder { <-0.1, -15, 31> <0.6, -15, 31> 5 }                                
                        }
                        translate <-15, -8, 0>
                }
                texture { paintTex2 }
        }   
        // Red part that buffers are attached to
        union
        {
                union
                {
                        difference
                        {
                                object { Round_Box_Union(<0, -14.25, -30.25>, <0.5, -0.75, 30.25>, 0.1) } 
                                cylinder { <-0.1, -15, -31> <0.6, -15, -31> 5.75 }
                                cylinder { <-0.1, -15, 31> <0.6, -15, 31> 5.75 }                                
                        }
                        translate <-15.025, -8, 0>
                }                  
                // rivets
                // top row
                #declare rp = 0;
                #while(rp < 23)
                        sphere { <0, 0, 0> 0.375 scale <0.5, 1, 1> translate <-15.05, -9.75, -29+((58/22)*rp)> }
                        #declare rp=rp+1;
                #end    
                // bottom row
                #declare rp = 0;
                #while(rp < 19)
                        sphere { <0, 0, 0> 0.375 scale <0.5, 1, 1> translate <-15.05, -21.25, -24+((48/18)*rp)> }
                        #declare rp=rp+1;
                #end    
                // side rows                            
                #declare rp = 1;
                #while(rp < 5)
                        sphere { <0, 0, 0> 0.375 scale <0.5, 1, 1> translate <-15.05, -9.75-((8.5/5)*rp), -29> }
                        sphere { <0, 0, 0> 0.375 scale <0.5, 1, 1> translate <-15.05, -9.75-((8.5/5)*rp), 29> }
                        #declare rp=rp+1;
                #end   
                
                // buffer and buffer holder right side
                union
                {        
                        // flat back part
                        Round_Box_Union(<-1, -3.5, -3.5>, <0, 3.5, 3.5>, 0.15)    
                        // hollow hole for buffer
                        difference
                        {
                                cylinder { <-7, 0, 0> <0, 0, 0> 2.75 }
                                cylinder { <-7.01, 0, 0> <0, 0, 0> 2.25 }   
                        }
                        torus { 2.5, 0.25 rotate <0, 0, 90> translate <-7, 0, 0> } // smooth end of buffer hole
                        difference    // smooth joint to flat back part
                        {
                                cylinder { <-1.5, 0, 0> <-1, 0, 0> 3.25 }
                                torus { 3.25, 0.5 rotate <0, 0, 90> translate <-1.5, 0, 0> }
                        }  
                        // nuts       
                        object { nut scale 0.225 translate <-1.255, 2.65, -2.65> }
                        object { nut scale 0.225 translate <-1.255, -2.65, -2.65> }
                        object { nut scale 0.225 translate <-1.255, 2.65, 2.65> }
                        object { nut scale 0.225 translate <-1.255, -2.65, 2.65> }
                               
                        // Buffer
                        union
                        {
                                cylinder { <-10, 0, 0> <0, 0, 0> 2.225 }
                                cylinder { <-10.5, 0, 0> <-10, 0, 0> 6 }
                                torus { 6, 0.25 rotate <0, 0, 90> translate <-10.25, 0, 0> } 
                                rotate <0, -90, 0>
                                mkWheelHubMidTex()  
                                rotate <0, 90, 0>
                        }  
                            
                        translate <-15, -17, -21>
                }   
                // buffer and buffer holder left side
                union
                {        
                        // flat back part
                        Round_Box_Union(<-1, -3.5, -3.5>, <0, 3.5, 3.5>, 0.15)    
                        // hollow hole for buffer
                        difference
                        {
                                cylinder { <-7, 0, 0> <0, 0, 0> 2.75 }
                                cylinder { <-7.01, 0, 0> <0, 0, 0> 2.25 }   
                        }
                        torus { 2.5, 0.25 rotate <0, 0, 90> translate <-7, 0, 0> } // smooth end of buffer hole
                        difference    // smooth joint to flat back part
                        {
                                cylinder { <-1.5, 0, 0> <-1, 0, 0> 3.25 }
                                torus { 3.25, 0.5 rotate <0, 0, 90> translate <-1.5, 0, 0> }
                        }  
                        // nuts       
                        object { nut scale 0.225 translate <-1.255, 2.65, -2.65> }
                        object { nut scale 0.225 translate <-1.255, -2.65, -2.65> }
                        object { nut scale 0.225 translate <-1.255, 2.65, 2.65> }
                        object { nut scale 0.225 translate <-1.255, -2.65, 2.65> }
                               
                        // Buffer
                        union
                        {
                                cylinder { <-10, 0, 0> <0, 0, 0> 2.225 }
                                cylinder { <-10.5, 0, 0> <-10, 0, 0> 6 }
                                torus { 6, 0.25 rotate <0, 0, 90> translate <-10.25, 0, 0> } 
                                rotate <0, -90, 0>
                                mkWheelHubMidTex()  
                                rotate <0, 90, 0>
                        }  
                            
                        translate <-15, -17, 21>
                }   
                
                texture { paintTex1 }        
        }           
        
        // bottom Red bit
        union
        {
                // small curve nearest cabin
               
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, -31> <0, 0, -28> 3 }
                                cylinder { <0, 0, -31.1> <0, 0, -27.9> 1.5 }                                
                        }                                               
                        box { <0, 0, -31.1> <3.01 3.01, -27.9> }   
                        bounded_by { box { <0, 0, -31.1> <3.01, 3.01, -27.9> }  }
                        translate <197, -1, 0> 
                }
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, 28> <0, 0, 31> 3 }
                                cylinder { <0, 0, 27.9> <0, 0, 31.1> 1.5 }                                
                        }                                               
                        box { <0, 0, 27.9> <3.01, 3.01, 31.1> }   
                        bounded_by { box { <0, 0, 27.9> <3.01, 3.01, 31.1> }  }
                        translate <197, -1, 0> 
                }   
                
                // straight part down
                box { <198.5, -7, -31> <200, 1, -28> }                                       
                box { <198.5, -7, 28> <200, 1, 31> }                                       
                
                // curve at bottom of straight part
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, -31> <0, 0, -28> 4.5 }
                                cylinder { <0, 0, -31.1> <0, 0, -27.9> 3.0 }                                
                        }                                               
                        box { <-4.51, -4.51, -31.1> <0, 0, -27.9> }   
                        bounded_by { box { <-4.51, -4.51, -31.1> <0, 0, -27.9> }  }
                        translate <203, -7, 0>                 
                }
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, 28> <0, 0, 31> 4.5 }
                                cylinder { <0, 0, 27.9> <0, 0, 31.1> 3.0 }                                
                        }                                               
                        box { <-4.51, -4.51, 27.9> <0, 0, 31.1> }   
                        bounded_by { box { <-4.51, -4.51, 27.9> <0, 0, 31.1> }  }
                        translate <203, -7, 0>                 
                } 
                
                // straight part under cabin floor
                box { <203, -11.5, -31> <233.5, -10, -28> }
                box { <203, -11.5, 28> <233.5, -10, 31> }  
                
                // small curved section at end of this
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, -31> <0, 0, -28> 3 }
                                cylinder { <0, 0, -31.1> <0, 0, -27.9> 1.5 }                                
                        }                                               
                        box { <0, 0, -31.1> <3.01, 3.01, -27.9> }   
                        bounded_by { box { <0, 0, -31.1> <3.01, 3.01, -27.9> }  }
                        translate <232, -13, 0>                 
                }   
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, 28> <0, 0, 31> 3 }
                                cylinder { <0, 0, 27.9> <0, 0, 31.1> 1.5 }                                
                        }                                               
                        box { <0, 0, 27.9> <3.01, 3.01, 31.1> }   
                        bounded_by { box { <0, 0, 27.9> <3.01, 3.01, 31.1> }  }
                        translate <232, -13, 0>                 
                }   
                
                // small straight part next to cabin step
                box { <233.5, -18, -31> <235, -10, -28> }
                box { <233.5, -18, 28> <235, -10, 31> }  
                
                // small rounded end of above straight part
                intersection
                {
                        cylinder { <0, 0, 0> <0, 0, 3> 1.5 }
                        box { <-1.51, -1.5, -0.01> <0, 0, 3.01> }
                        translate <235, -18, -31>   
                }
                intersection
                {
                        cylinder { <0, 0, 0> <0, 0, 3> 1.5 }
                        box { <-1.51, -1.5, -0.01> <0, 0, 3.01> }
                        translate <235, -18, 28>   
                }
                

                // long straight part __________  
                
                box { <0.5, 0.5, -31> <200, 2, -28> }   
                box { <0.5, 0.5, 28> <200, 2, 31> }   
                
                // straight part above front curve |
                
                box { <0.5, -2.5, -31> <2, 0.5, -28> }  
                box { <0.5, -2.5, 28> <2, 0.5, 31> }  

                // small curve down to straight part before Front curve   
                difference
                {
                        box { <0.5, -1, -31> <3.5, 0.5, -28> }
                        cylinder { <3.5, -1, -31.1> <3.5, -1, -27.9> 1.5 }                        
                }        
                difference
                {
                        box { <0.5, -1, 28> <3.5, 0.5, 31> }
                        cylinder { <3.5, -1, 27.9> <3.5, -1, 31.1> 1.5 }                        
                }        
                
                // Front curve

                intersection
                {
                        difference
                        {                               
                                cylinder { <0, 0, -31> <0, 0, -28> 7 }
                                cylinder { <0, 0, -31.1> <0, 0, -27.9> 5.5 } 
                        }
                        box { <0, -7.1, -31.1> <7.1, 0, -27.9>  }
                        translate <-5, -2.5, 0>
                } 
                intersection
                {
                        difference
                        {                               
                                cylinder { <0, 0, 28> <0, 0, 31> 7 }
                                cylinder { <0, 0, 27.9> <0, 0, 31.1> 5.5 } 
                        }
                        box { <0, -7.1, 27.9> <7.1, 0, 31.1>  }
                        translate <-5, -2.5, 0>
                } 
                
                // straight bit after curve
                box { <-14.5, -9.5, -31> <-5, -8, -28> }
                box { <-14.5, -9.5, 28> <-5, -8, 31> }   
                
                // straight bit down behind buffer part
                box { <-14.5, -15.5, -31> <-13, -9.5, -28> }
                box { <-14.5, -15.5, 28> <-13, -9.5, 31> }  
                
                // small curve at bottom of above
                intersection
                {
                        box { <-14.5, -18, -31> <-13, -15.5, -28> }
                        cylinder { <-14.5, -15.5, -31.1> <-14.5, -15.5, -27.9> 1.5 }
                }        
                intersection
                {
                        box { <-14.5, -18, 28> <-13, -15.5, 31> }
                        cylinder { <-14.5, -15.5, 27.9> <-14.5, -15.5, 31.1> 1.5 }
                }        

                // small curve at top of straight bit above
                difference
                {
                        box { <-13, -11, -31> <-11.5, -9.5, -28> }
                        cylinder { <-11.5, -11, -31.1> <-11.5, -11, -27.9> 1.5 }                        
                }        

                difference
                {
                        box { <-13, -11, 28> <-11.5, -9.5, 31> }
                        cylinder { <-11.5, -11, 27.9> <-11.5, -11, 31.1> 1.5 }                        
                }        
                
                 
                 
                texture { paintTex1 }
        }                
        // bottom Gold bit
        union
        {               
                // small curve at end nearest cabin
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, -31> <0, 0, -28> 1.5 }
                                cylinder { <0, 0, -31.1> <0, 0, -27.9> 1.0 }                                
                        }                                               
                        box { <0, 0, -31.1> <1.51 1.51, -27.9> }   
                        bounded_by { box { <0, 0, -31.1> <1.51, 1.51, -27.9> }  }
                        translate <197, -1, 0> 
                }
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, 28> <0, 0, 31> 1.5 }
                                cylinder { <0, 0, 27.9> <0, 0, 31.1> 1.0 }                                
                        }                                               
                        box { <0, 0, 27.9> <1.51, 1.51, 31.1> }   
                        bounded_by { box { <0, 0, 27.9> <1.51, 1.51, 31.1> }  }
                        translate <197, -1, 0> 
                }                                          
                
                // straight part down
                box { <198, -7, -31> <198.5, -1, -28> }
                box { <198, -7, 28> <198.5, -1, 31> }    
                
                 // curve at bottom of straight part
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, -31> <0, 0, -28> 5.0 }
                                cylinder { <0, 0, -31.1> <0, 0, -27.9> 4.5 }                                
                        }                                               
                        box { <-5.01, -5.01, -31.1> <0, 0, -27.9> }   
                        bounded_by { box { <-5.01, -5.01, -31.1> <0, 0, -27.9> }  }
                        translate <203, -7, 0>                 
                }
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, 28> <0, 0, 31> 5.0 }
                                cylinder { <0, 0, 27.9> <0, 0, 31.1> 4.5 }                                
                        }                                               
                        box { <-5.01, -5.01, 27.9> <0, 0, 31.1> }   
                        bounded_by { box { <-5.01, -5.01, 27.9> <0, 0, 31.1> }  }
                        translate <203, -7, 0>                 
                }
               

                // straight part under cabin floor
                box { <203, -12.0, -31> <232, -11.5, -28> }
                box { <203, -12.0, 28> <232, -11.5, 31> }  
                
                // small curved section at end of this
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, -31> <0, 0, -28> 1.5 }
                                cylinder { <0, 0, -31.1> <0, 0, -27.9> 1 }                                
                        }                                               
                        box { <0, 0, -31.1> <1.51, 1.51, -27.9> }   
                        bounded_by { box { <0, 0, -31.1> <1.51, 1.51, -27.9> }  }
                        translate <232, -13, 0>                 
                }   
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, 28> <0, 0, 31> 1.5 }
                                cylinder { <0, 0, 27.9> <0, 0, 31.1> 1 }                                
                        }                                               
                        box { <0, 0, 27.9> <1.51, 1.51, 31.1> }   
                        bounded_by { box { <0, 0, 27.9> <1.51, 1.51, 31.1> }  }
                        translate <232, -13, 0>                 
                }   
                
                // small straight part next to cabin step
                box { <233, -18, -31> <233.5, -13, -28> }
                box { <233, -18, 28> <233.5, -13, 31> }  
                
                // small rounded end at bottom of straight part
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, 0> <0, 0, 3> 2 }
                                cylinder { <0, 0, -0.01> <0, 0, 3.01> 1.5 }
                        }
                        box { <-2.01, -2.01, -0.01> <0, 0, 3.01> }
                        translate <235, -18, -31>   
                }
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, 0> <0, 0, 3> 2 }
                                cylinder { <0, 0, -0.01> <0, 0, 3.01> 1.5 }
                        }
                        box { <-2.01, -2.01, -0.01> <0, 0, 3.01> }
                        translate <235, -18, 28>   
                }


                
                
                
        
                // long straight part
                box { <3.5, 0, -31> <197.5, 0.5, -28> } 
                box { <3.5, 0, 28> <197.5, 0.5, 31> } 

               
                // small curve at end of long straight part
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, -31> <0, 0, -28> 1.5 }
                                cylinder { <0, 0, -31.1> <0, 0, -27.9> 1.0 }                                
                        }                                               
                        box { <-1.51, 0, -31.1> <0, 1.51, -27.9> }   
                        bounded_by { box { <-1.51, 0, -31.1> <0, 1.51, -27.9> }  }
                        translate <3.5, -1, 0> 
                }
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, 28> <0, 0, 31> 1.5 }
                                cylinder { <0, 0, 27.9> <0, 0, 31.1> 1.0 }                                
                        }                                               
                        box { <-1.51, 0, 27.9> <0, 1.51, 31.1> }   
                        bounded_by { box { <-1.51, 0, 27.9> <0, 1.51, 31.1> }  }
                        translate <3.5, -1, 0> 
                }      
                // small straight bit below small curve above
                box { <2, -2.5, -31> <2.5, -1, -28> }
                box { <2, -2.5, 28> <2.5, -1, 31> }



                // Front curve  )

                intersection
                {
                        difference
                        {                               
                                cylinder { <0, 0, -31> <0, 0, -28> 7.5 }
                                cylinder { <0, 0, -31.1> <0, 0, -27.9> 7 } 
                        }
                        box { <0, -7.6, -31.1> <7.6, 0, -27.9>  }
                        translate <-5, -2.5, 0>
                } 
                intersection
                {
                        difference
                        {                               
                                cylinder { <0, 0, 28> <0, 0, 31> 7.5 }
                                cylinder { <0, 0, 27.9> <0, 0, 31.1> 7 } 
                        }
                        box { <0, -7.6, 27.9> <7.6, 0, 31.1>  }
                        translate <-5, -2.5, 0>
                } 
                                         
                // straight part that goes from above to front part where buffers are attached
                box { <-11.5, -10, -31> <-5, -9.5, -27> }
                box { <-11.5, -10, 27> <-5, -9.5, 31> }        
                
                // straight bit down behind buffer part
                box { <-13, -15.5, -31> <-12.5, -11, -28> }
                box { <-13, -15.5, 28> <-12.5, -11, 31> }  


                // small curve at bottom of above
                intersection
                {       
                        box { <-14.5, -18.5, -31.1> <-12.5, -15.5, -27.9> }
                        difference
                        {                               
                                cylinder { <-14.5, -15.5, -31> <-14.5, -15.5, -28> 2 }  
                                cylinder { <-14.5, -15.5, -31.1> <-14.5, -15.5, -27.9> 1.5 }  
                        }
                }        
                intersection
                {       
                        box { <-14.5, -18.5, 27.9> <-12.5, -15.5, 31.1> }
                        difference
                        {                               
                                cylinder { <-14.5, -15.5, 28> <-14.5, -15.5, 31> 2 }  
                                cylinder { <-14.5, -15.5, 27.9> <-14.5, -15.5, 31.1> 1.5 }  
                        }
                }        
                

                // small curve at top of straight bit above
                intersection
                {    
                        box { <-13, -11, -31.1> <-11.5, -9.5, -27.9> }
                        difference
                        {
                                cylinder { <-11.5, -11, -31> <-11.5, -11, -28> 1.5 }
                                cylinder { <-11.5, -11, -31.1> <-11.5, -11, -27.9> 1 }                        
                        }        
                }
                intersection
                {    
                        box { <-13, -11, 27.9> <-11.5, -9.5, 31.1> }
                        difference
                        {
                                cylinder { <-11.5, -11, 28> <-11.5, -11, 31> 1.5 }
                                cylinder { <-11.5, -11, 27.9> <-11.5, -11, 31.1> 1 }                        
                        }        
                }
                                         
                texture { paintTex3 }
        }                         
        // bottom Black bit
        union
        {      
                // small curve at end nearest cabin
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, -31> <0, 0, -28> 1.0 }
                                cylinder { <0, 0, -31.1> <0, 0, -27.9> 0.5 }                                
                        }                                               
                        box { <0, 0, -31.1> <1.01, 1.01, -27.9> }   
                        bounded_by { box { <0, 0, -31.1> <1.01, 1.01, -27.9> }  }
                        translate <197, -1, 0>                 
                }
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, 31> <0, 0, 28> 1.0 }
                                cylinder { <0, 0, 27.9> <0, 0, 31.1> 0.5 }                                
                        }                                               
                        box { <0, 0, 27.9> <1.01, 1.01, 31.1> }   
                        bounded_by { box { <0, 0, 27.9> <1.01, 1.01, 31.1> }  }
                        translate <197, -1, 0> 
                }   
                // straight part down
                box { <197.5, -7, -31> <198, -1, -28> }                            
                box { <197.5, -7, 28> <198, -1, 31> }       
                
                // curve at bottom of straight part
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, -31> <0, 0, -28> 5.5 }
                                cylinder { <0, 0, -31.1> <0, 0, -27.9> 5.0 }                                
                        }                                               
                        box { <-5.51, -5.51, -31.1> <0, 0, -27.9> }   
                        bounded_by { box { <-5.51, -5.51, -31.1> <0, 0, -27.9> }  }
                        translate <203, -7, 0>                 
                }
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, 28> <0, 0, 31> 5.5 }
                                cylinder { <0, 0, 27.9> <0, 0, 31.1> 5.0 }                                
                        }                                               
                        box { <-5.51, -5.51, 27.9> <0, 0, 31.1> }   
                        bounded_by { box { <-5.51, -5.51, 27.9> <0, 0, 31.1> }  }
                        translate <203, -7, 0>                 
                }
                                     

                // straight part under cabin floor
                box { <203, -12.5, -31> <232, -12, -28> }
                box { <203, -12.5, 28> <232, -12, 31> }  
                
                // small curved section at end of this
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, -31> <0, 0, -28> 1.0 }
                                cylinder { <0, 0, -31.1> <0, 0, -27.9> 0.5 }                                
                        }                                               
                        box { <0, 0, -31.1> <1.01, 1.01, -27.9> }   
                        bounded_by { box { <0, 0, -31.1> <1.01, 1.01, -27.9> }  }
                        translate <232, -13, 0>                 
                }   
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, 28> <0, 0, 31> 1.0 }
                                cylinder { <0, 0, 27.9> <0, 0, 31.1> 0.5 }                                
                        }                                               
                        box { <0, 0, 27.9> <1.01, 1.01, 31.1> }   
                        bounded_by { box { <0, 0, 27.9> <1.01, 1.01, 31.1> }  }
                        translate <232, -13, 0>                 
                }   
                
                // small straight part next to cabin step
                box { <232.5, -18, -31> <233, -13, -28> }
                box { <232.5, -18, 28> <233, -13, 31> }  
                
                // small rounded end of above straight part
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, 0> <0, 0, 3> 2.5 }
                                cylinder { <0, 0, -0.01> <0, 0, 3.01> 2 }
                        }
                        box { <-2.51, -2.51, -0.01> <0, 0, 3.01> }
                        translate <235, -18, -31>   
                }
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, 0> <0, 0, 3> 2.5 }
                                cylinder { <0, 0, -0.01> <0, 0, 3.01> 2 }
                        }
                        box { <-2.51, -2.51, -0.01> <0, 0, 3.01> }
                        translate <235, -18, 28>   
                }
               
         


                // long straight part across engine length 
                box { <3.5, -0.5, -31>, <197.5, 0, -28> }   
                box { <3.5, -0.5, 28>, <197.5, 0, 31> }   
 
                
                // small curve at end of long straight part
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, -31> <0, 0, -28> 1.0 }
                                cylinder { <0, 0, -31.1> <0, 0, -27.9> 0.5 }                                
                        }                                               
                        box { <-1.01, 0, -31.1> <0, 1.01, -27.9> }   
                        bounded_by { box { <-1.01, 0, -31.1> <0, 1.01, -27.9> }  }
                        translate <3.5, -1, 0> 
                }
                intersection
                {
                        difference
                        {
                                cylinder { <0, 0, 28> <0, 0, 31> 1.0 }
                                cylinder { <0, 0, 27.9> <0, 0, 31.1> 0.5 }                                
                        }                                               
                        box { <-1.01, 0, 27.9> <0, 1.01, 31.1> }   
                        bounded_by { box { <-1.01, 0, 27.9> <0, 1.01, 31.1> }  }
                        translate <3.5, -1, 0> 
                }                               
                
                // small straight bit below small curve above
                box { <2.5, -2.5, -31> <3, -1, -28> }
                box { <2.5, -2.5, 28> <3, -1, 31> }



                // Front curve  )

                intersection
                {
                        difference
                        {                               
                                cylinder { <0, 0, -31> <0, 0, -28> 8 }
                                cylinder { <0, 0, -31.1> <0, 0, -27.9> 7.5 } 
                        }
                        box { <0, -8.1, -31.1> <8.1, 0, -27.9>  }
                        translate <-5, -2.5, 0>
                } 
                intersection
                {
                        difference
                        {                               
                                cylinder { <0, 0, 28> <0, 0, 31> 8 }
                                cylinder { <0, 0, 27.9> <0, 0, 31.1> 7.5 } 
                        }
                        box { <0, -8.1, 27.9> <8.1, 0, 31.1>  }
                        translate <-5, -2.5, 0>
                } 
                                         
                // straight part that goes from above to front part where buffers are attached
                box { <-11.5, -10.5, -31> <-5, -10, -27> }
                box { <-11.5, -10.5, 27> <-5, -10, 31> }        
                
                // straight bit down behind buffer part
                box { <-12.5, -15.5, -31> <-12, -11, -28> }
                box { <-12.5, -15.5, 28> <-12, -11, 31> }  


                // small curve at bottom of above
                intersection
                {       
                        box { <-14.5, -19, -31.1> <-12, -15.5, -27.9> }
                        difference
                        {                               
                                cylinder { <-14.5, -15.5, -31> <-14.5, -15.5, -28> 2.5 }  
                                cylinder { <-14.5, -15.5, -31.1> <-14.5, -15.5, -27.9> 2 }  
                        }
                }        
                intersection
                {       
                        box { <-14.5, -19, 27.9> <-12, -15.5, 31.1> }
                        difference
                        {                               
                                cylinder { <-14.5, -15.5, 28> <-14.5, -15.5, 31> 2.5 }  
                                cylinder { <-14.5, -15.5, 27.9> <-14.5, -15.5, 31.1> 2 }  
                        }
                }        
                

                // small curve at top of straight bit above
                intersection
                {    
                        box { <-12.5, -11, -31.1> <-11.5, -10, -27.9> }
                        difference
                        {
                                cylinder { <-11.5, -11, -31> <-11.5, -11, -28> 1 }
                                cylinder { <-11.5, -11, -31.1> <-11.5, -11, -27.9> 0.5 }                        
                        }        
                }
                intersection
                {    
                        box { <-12.5, -11, 27.9> <-11.5, -10, 31.1> }
                        difference
                        {
                                cylinder { <-11.5, -11, 28> <-11.5, -11, 31> 1 }
                                cylinder { <-11.5, -11, 27.9> <-11.5, -11, 31.1> 0.5 }                        
                        }        
                }
                                         
                

                texture { paintTex2 }
        }                               
        // front coupling hook   
        union
        {
                difference
                {
                        union
                        {
                                cylinder { <0, 0, -0.6> <0, 0, 0.6> 2.5 } 
                                torus { 2.5, 0.3 scale <1, 2, 1> rotate <90, 0, 0> } 
                        }
                        cylinder { <0, 0, -0.61> <0, 0, 0.61> 1.6 scale <1, 1.5, 1> rotate <0, 0, -15> translate <0.25, 1.4, 0> }
                }          
                intersection
                {
                        torus { 1.6, 0.3 scale <1, 2, 1> rotate <90, 0, 0> scale <1, 1.5, 1> rotate <0, 0, -15> translate <0.25, 1.4, 0> }
                        union
                        {
                                cylinder { <0, 0, -0.6> <0, 0, 0.6> 2.5 }  
                                torus { 2.5, 0.3 scale <1, 2, 1> rotate <90, 0, 0> } 
                        }
                }  
                union
                {
                        // rear part of hook
                        cylinder { <0, 0, -0.8> <0, 0, 0.8> 2 }
                        torus { 2, 0.4 scale <1, 2, 1> rotate <90, 0, 0> }   
                        // start of coupling
                        
                        Round_Cylinder_Union(<0, 0, -2.1>, <0, 0, -1.1>, 1.75, 0.3)
                        Round_Cylinder_Union(<0, 0, -2.6>, <0, 0, -2.3>, 1.4, 0.1)

                        // first arm part
                        Round_Box_Union(<-0.6, -13, -2.0>, <0.6, -1.5, -1.2>,0.2)             
                        // smooth top joint
                        cone { <-0.55, -1, -1.6> 0.5 <-0.2, -4.5, -1.6> 0.3 }
                        cone { <0.55, -1, -1.6> 0.5 <0.2, -4.5, -1.6> 0.3 }
                        // smooth bottom joint
                        cone { <-0.55, -12.5, -1.6> 0.5 <-0.2, -9, -1.6> 0.3 }
                        cone { <0.55, -12.5, -1.6> 0.5 <0.2, -9, -1.6> 0.3 }
                        Round_Cylinder_Union(<0, -13, -2.1>, <0, -13, -1.1>, 1.25, 0.3)   
                        
                        //holding nut for second joint (at end of first straight part)
                        Round_Cylinder_Union(<0, -13, -2.9>, <0, -13, -2.2>, 0.9, 0.2)
                        Round_Cylinder_Union(<0, -13, -3.1>, <0, -13, -2.9>, 0.5, 0.075)
                         
                        
                        // join two sides
                        // top joint
                        cylinder { <0, 0, -2.3> <0, 0, 2.3> 0.5 }
                        // joint at end of first long part
                        Round_Cylinder_Union(<0, -13, -1.1>, <0, -13, 1.1>, 1, 0.1)
                        cylinder { <0, -13, -3> <0, -13, 3> 0.3 }        
                        
                        // third part - middle single joint
                        union
                        {
                                cylinder { <-8.9, 0, 0> <0, 0, 0> 0.7 }    
                                Round_Cylinder_Union(<-9, 0, 0>, <-8.6, 0, 0>, 1, 0.1)
                                difference
                                {
                                        Round_Box_Union(<-7.25, -1, -1>, <-5.25, 1, 1>, 0.2)
                                        cylinder { <-7.3, 0, 0> <-5, 0, 0> 0.75 }
                                }    
                                // loop part
                                union       
                                {    
                                        // right side
                                        Round_Cylinder_Union(<0, 0, -2>, <0, 0, -1>, 1.25, 0.4) 
                                        Round_Cylinder_Union(<0, 0, -2.2>, <0, 0, -2>, 0.75, 0.075) 
                                        cylinder { <-0.65, 0, -1.5> <0, 2, -1.5> 0.5 }
                                        cylinder { <0.65, 0, -1.5> <0, 2, -1.5> 0.5 }
                                        
                                        cylinder { <0, 0, -1.5> <0, 7, -1.5> 0.5 } 

                                        // left side
                                        Round_Cylinder_Union(<0, 0, 1>, <0, 0, 2>, 1.25, 0.4)    
                                        Round_Cylinder_Union(<0, 0, 2>, <0, 0, 2.2>, 0.75, 0.075) 
                                        
                                        cylinder { <-0.65, 0, 1.5> <0, 2, 1.5> 0.5 }
                                        cylinder { <0.65, 0, 1.5> <0, 2, 1.5> 0.5 }
                                        
                                        cylinder { <0, 0, 1.5> <0, 7, 1.5> 0.5 } 
                                        
                                        // loop
                                        difference
                                        {
                                                torus { 1.5, 0.5 rotate <0, 0, 90> }
                                                box { <-0.51, -2.01, -2.01> <0.51, 0, 2.01> }
                                                translate <0, 7, 0> 
                                        } 
                                        
                                        rotate <0, 0, 21>                                        
                                        translate <-6.25, 0, 0> 
                                }
                                rotate <0, 0, -31.1> 
                                translate <0, -13, 0> 
                        }

                        // left side of arm       
                        Round_Cylinder_Union(<0, 0, 1.1>, <0, 0, 2.1>, 1.75, 0.3)
                        Round_Cylinder_Union(<0, 0, 2.3>, <0, 0, 2.6>, 1.4, 0.1)  

                        Round_Box_Union(<-0.6, -13, 1.2>, <0.6, -1.5, 2>,0.2)             
                        // smooth top joint
                        cone { <-0.55, -1, 1.6> 0.5 <-0.2, -4.5, 1.6> 0.3 }
                        cone { <0.55, -1, 1.6> 0.5 <0.2, -4.5, 1.6> 0.3 }
                        // smooth bottom joint
                        cone { <-0.55, -12.5, 1.6> 0.5 <-0.2, -9, 1.6> 0.3 }
                        cone { <0.55, -12.5, 1.6> 0.5 <0.2, -9, 1.6> 0.3 }
                        Round_Cylinder_Union(<0, -13, 1.1>, <0, -13, 2.1>, 1.25, 0.3)
                        
                        //holding nut for second joint (at end of first straight part)
                        Round_Cylinder_Union(<0, -13, 2.2>, <0, -13, 2.9>, 0.9, 0.2)
                        Round_Cylinder_Union(<0, -13, 2.9>, <0, -13, 3.1>, 0.5, 0.075)   
                        
                        // rear part attached to train
                        union
                        {
                                object { Round_Cylinder_Union(<-4, 0, 0>, <0, 0, 0>, 5, 0.1) scale <1, 1, 0.5> }
                                intersection
                                {
                                        object { Round_Cylinder_Union(<-6, 0, 0>, <0, 0, 0>, 5, 0.1) scale <1, 0.5, 1>}
                                        cylinder { <-6.1, 0, 0> <0.1, 0, 0> 5 scale <1, 1, 0.5> }       
                                }       
                                torus { 1.5, 0.5 rotate <0, 0, 90> scale <0.7, 1, 0.5> translate <-6, 0, 0> }  
                                // add the nuts
                                object { nut scale 0.275 translate <-4.3, 3.5, 0> }
                                object { nut scale 0.275 translate <-4.3, -3.5, 0> }    
                                texture { paintTex1 } 
                                #if(useTestTex = 0)
/* TO_DO                                texture                 // add extra dirt
                                { 
                                        pigment 
                                        {                 
                                                gradient x 
                                                turbulence 0.095
                                                omega 0.675
                                                lambda 2.75
                                                colour_map
                                                {     
                                                        [ 0.0 rgbt <0.025, 0.01, 0.001, 0> ]
                                                        [ 0.8 rgbt <0.025, 0.01, 0.001, 1> ]                                                        
                                                        [ 0.8 rgbt <1, 1, 1, 1> ]                                                        
                                                }  
                                                scale 8
                                                translate <-7, 0, 0>
                                        }         
                                        finish { ambient 0 diffuse 0.3 }
                                        normal { wrinkles 0.2 }
                                                                      
                                }   
                                */
                                #end
                                translate <8, 0, 0>
                        }
                        
                        translate <3.75, 1.5, 0> 
                        
                }            
                scale 0.85
                translate <-22.5, -18, 0> 
                texture { couplingTex }
        }   
        
        // pipe on front of train
        union
        {
                // part attached to front
                union
                {
                
                        cylinder { <-3, 0, 0> <0, 0, 0> 1.25 }   
                        Round_Cylinder_Union(<-2.5, 0, 0> <0, 0, 0> 1.5, 0.1)     
                        // curve
                        intersection
                        {
                                torus { 2, 1.25 rotate <90, 0, 0> }
                                box { <-3.3, -3.3, -1.3> <0, 0, 1.3> }
                                translate <-3, 2, 0>
                        }
                        Round_Cylinder_Union(<-3.1, 0, 0> <-2.1, 0, 0> 1.5, 0.1)
                        Round_Cylinder_Union(<-5, 1.9, 0> <-5, 2.9, 0> 1.5, 0.1)     
                        texture { paintTex1 }
                }
                // straight up part
                union
                {
                        cylinder { <-5, 2, 0> <-5, 8.2, 0> 1.25 }
                        Round_Cylinder_Union(<-5, 8.1, 0> <-5, 9.1, 0> 1.5, 0.1)
                        difference
                        {
                                torus { 3, 1.25 rotate <90, 0, 0> }
                                box { <-6, -6, -1.3> <6, 0, 1.3> }
                                box { <-6, -6, -1.3> <6, 0, 1.3> rotate <0, 0, -45> }
                                translate <-8, 9, 0>
                        } 
                        texture { paintTex2 }
                }       
                

                union
                {
                        union
                        {
                                object 
                                {
                                        Round_Cylinder_Union(<-1, 0, 0>, <0, 0, 0>, 1.5, 0.1) 
                                        translate <0, 3, 0> rotate <0, 0, 45> 
                                        texture
                                        {
                                                pigment 
                                                {
                                                        wrinkles
                                                        scale 0.1
                                                        turbulence 0.0875
                                                        omega 0.7
                                                        lambda 2.75
                                                        colour_map
                                                        {
                                                                [ 0.0 rgb <0.15, 0.125, 0.075> ]
                                                                [ 1.0 rgb <0.05, 0.03, 0.01> ]                                                        
                                                       } 
                                                }
                                                finish { ambient 0 diffuse 0.4 }
                                                normal { granite 0.3 scale 0.1 }
                                        }  
                                }
                                #declare tp=0;
                                #while (tp < 3)
                                        sphere { <0, 0, 0> 1.4 scale <0.2, 1, 1> translate <0, 3, 0> rotate <0, 0, 45> translate <-tp, -tp, 0> }  
                                        #declare tp=tp+0.26;
                                #end               
                                texture
                                {
                                        pigment 
                                        {
                                                gradient x  
                                                frequency 3
                                                turbulence 0.0875
                                                omega 0.7
                                                lambda 2.75
                                                colour_map
                                                {
                                                        [ 0.0 rgb <0.15, 0.125, 0.075> ]
                                                        [ 1.0 rgb <0.05, 0.03, 0.01> ]                                                        
                                                }                            
                                                translate <0, 3, 0> 
                                                
                                                rotate <0, 0, 45>
                                        }    
                                        finish { ambient 0 diffuse 0.4 }
                                        normal { granite 0.3 scale 0.1 }
                                }
                        }
                        union
                        {
                                #declare rp=0;
                                #while (rp < 135)
                                        sphere { <0, 0, 0> 1.4 scale <0.2, 1, 1> translate <0, 10, 0> rotate <0, 0, rp> }  
                                        #declare rp=rp+2;
                                #end       
                                
                                // end of flexible pipe that joins back to front of train 
                                object 
                                {
                                        Round_Cylinder_Union(<-1, 0, 0>, <0, 0, 0>, 1.5, 0.1) 
                                        translate <0, 10, 0> rotate <0, 0, rp-1.5> 
                                        texture
                                        {
                                                pigment 
                                                {
                                                        wrinkles
                                                        scale 0.1
                                                        turbulence 0.0875
                                                        omega 0.7
                                                        lambda 2.75
                                                        colour_map
                                                        {
                                                                [ 0.0 rgb <0.15, 0.125, 0.075> ]
                                                                [ 1.0 rgb <0.05, 0.03, 0.01> ]                                                        
                                                       } 
                                                }
                                                finish { ambient 0 diffuse 0.4 }
                                                normal { granite 0.3 scale 0.1 }
                                        }  
                                }
                                texture
                                {
                                        pigment 
                                        {
                                                radial 
                                                frequency 181
                                                turbulence 0.0875
                                                omega 0.7
                                                lambda 2.75
                                                colour_map
                                                {
                                                        [ 0.0 rgb <0.15, 0.125, 0.075> ]
                                                        [ 1.0 rgb <0.05, 0.03, 0.01> ]                                                        
                                               } 
                                                rotate <90, 0, 0> 
                                               
                                                translate <0, 0, 0>// rotate <0, 0, 45>                          
                                        }
                                        finish { ambient 0 diffuse 0.4 }
                                        normal { granite 0.3 scale 0.1 }
                                        
                                }  
                                translate <0, -10, 0> translate <0, 3, 0> rotate <0, 0, 45> translate <-tp, -tp, 0>
                        }
                        union
                        {
                                cylinder { <-10, 0, 0> <0, 0, 0> 1.25 translate <0, 10, 0> rotate <0, 0, rp-1.5> translate <0, -10, 0> translate <0, 3, 0> rotate <0, 0, 45> translate <-tp, -tp, 0> }
                                object { Round_Cylinder_Union(<-6.2, 0, 0>, <-3.7, 0, 0>, 1.5, 0.1) translate <0, 10, 0> rotate <0, 0, rp-1.5> translate <0, -10, 0> translate <0, 3, 0> rotate <0, 0, 45> translate <-tp, -tp, 0> }
                                texture { paintTex1 }
                        }
                        translate <-8, 9, 0>
                        
                        
                }

                scale 0.7

                translate <-13.5, -11, 8>              
                
        }
        
        // Steps  
        // right side
        union
        {
                difference
                {
                        box { <-6, -19, 0> <6, 0, 0.5> }
                        union
                        {
                                box { <-6, -25, -0.1> <0, 2, 0.6> rotate <0, 0, -4> translate <-3, 0, 0> }
                                box { <0, -25, -0.1> <6, 2, 0.6> rotate <0, 0, 4> translate <3, 0, 0> }                                       
                        }
                        texture { paintTex2 }
                }
                difference
                {
                        box { <-6, -19, 0> <6, 0, 0.5> }
                        union
                        {
                                box { <-6, -25, -0.1> <0, 2, 0.6> rotate <0, 0, -4> translate <-3, 0, 0> }
                                box { <0, -25, -0.1> <6, 2, 0.6> rotate <0, 0, 4> translate <3, 0, 0> }                                       
                        }                  
                        scale <0.9, 0.9, 1>
                        translate <0, 0, -0.001>
                        texture { paintTex3 }
                }
                difference
                {
                        box { <-6, -19, 0> <6, 0, 0.5> }
                        union
                        {
                                box { <-6, -25, -0.1> <0, 2, 0.6> rotate <0, 0, -4> translate <-3, 0, 0> }
                                box { <0, -25, -0.1> <6, 2, 0.6> rotate <0, 0, 4> translate <3, 0, 0> }                                       
                        }                  
                        scale <0.8, 0.88, 1>
                        translate <0, 0, -0.002>
                        texture { paintTex1 }
                }

                union
                { 
                        Round_Box_Union(<-4.5, -19.5, -0.2>, <4.5, -17.5, 0.7>, 0.1)
                        difference
                        {
                                intersection
                                {
                                        object { Round_Box_Union(<-4.25, -19.4, -4>, <4.25, -19, 0>, 0.05) }
                                        object { Round_Cylinder_Union(<0, -19.401, 0>, <0, -18.99, 0>, 5, 0.05) }
                                }
                        
                                #declare cp = -10;
                                #while(cp < 10)
                                        cylinder { <0, -19, -10> <0, -19, 10> 0.075 rotate <0, -45, 0> translate <cp, 0, 0> }
                                        cylinder { <0, -19, -10> <0, -19, 10> 0.075 rotate <0, 45, 0> translate <cp, 0, 0> } 
                                        #declare cp = cp+1;
                                #end                                 
                        }                
                        texture { paintTex2 }
                }
                union
                {
                        Round_Box_Union(<-3.75, -10, -0.2>, <3.75, -8, 0.7>, 0.1)
                        difference
                        {
                                intersection
                                {
                                        object { Round_Box_Union(<-3.5, -9.9, -3.5>, <3.75, -9.5, 0>, 0.05) }
                                        object { Round_Cylinder_Union(<0, -9.901, 0>, <0, -9.499, 0>, 4, 0.05) }
                                }                
                                #declare cp = -10;
                                #while(cp < 10)
                                        cylinder { <0, -9.5, -10> <0, -9.5, 10> 0.075 rotate <0, -45, 0> translate <cp, 0, 0> }
                                        cylinder { <0, -9.5, -10> <0, -9.5, 10> 0.075 rotate <0, 45, 0> translate <cp, 0, 0> } 
                                        #declare cp = cp+1;
                                #end
                                        
                        }                
                        texture { paintTex2 }
                }

                translate <-8, -8, -30>
        }     
        // left side
        union
        {
                difference
                {
                        box { <-6, -19, 0> <6, 0, 0.5> }
                        union
                        {
                                box { <-6, -25, -0.1> <0, 2, 0.6> rotate <0, 0, -4> translate <-3, 0, 0> }
                                box { <0, -25, -0.1> <6, 2, 0.6> rotate <0, 0, 4> translate <3, 0, 0> }                                       
                        }
                        texture { paintTex2 }
                }
                difference
                {
                        box { <-6, -19, 0> <6, 0, 0.5> }
                        union
                        {
                                box { <-6, -25, -0.1> <0, 2, 0.6> rotate <0, 0, -4> translate <-3, 0, 0> }
                                box { <0, -25, -0.1> <6, 2, 0.6> rotate <0, 0, 4> translate <3, 0, 0> }                                       
                        }                  
                        scale <0.9, 0.9, 1>
                        translate <0, 0, -0.001>
                        texture { paintTex3 }
                }
                difference
                {
                        box { <-6, -19, 0> <6, 0, 0.5> }
                        union
                        {
                                box { <-6, -25, -0.1> <0, 2, 0.6> rotate <0, 0, -4> translate <-3, 0, 0> }
                                box { <0, -25, -0.1> <6, 2, 0.6> rotate <0, 0, 4> translate <3, 0, 0> }                                       
                        }                  
                        scale <0.8, 0.88, 1>
                        translate <0, 0, -0.002>
                        texture { paintTex1 }
                }

                union
                { 
                        Round_Box_Union(<-4.5, -19.5, -0.2>, <4.5, -17.5, 0.7>, 0.1)
                        difference
                        {
                                intersection
                                {
                                        object { Round_Box_Union(<-4.25, -19.4, -4>, <4.25, -19, 0>, 0.05) }
                                        object { Round_Cylinder_Union(<0, -19.401, 0>, <0, -18.99, 0>, 5, 0.05) }
                                }
                        
                                #declare cp = -10;
                                #while(cp < 10)
                                        cylinder { <0, -19, -10> <0, -19, 10> 0.075 rotate <0, -45, 0> translate <cp, 0, 0> }
                                        cylinder { <0, -19, -10> <0, -19, 10> 0.075 rotate <0, 45, 0> translate <cp, 0, 0> } 
                                        #declare cp = cp+1;
                                #end                                 
                        }                
                        texture { paintTex2 }
                }
                union
                {
                        Round_Box_Union(<-3.75, -10, -0.2>, <3.75, -8, 0.7>, 0.1)
                        difference
                        {
                                intersection
                                {
                                        object { Round_Box_Union(<-3.5, -9.9, -3.5>, <3.75, -9.5, 0>, 0.05) }
                                        object { Round_Cylinder_Union(<0, -9.901, 0>, <0, -9.499, 0>, 4, 0.05) }
                                }                
                                #declare cp = -10;
                                #while(cp < 10)
                                        cylinder { <0, -9.5, -10> <0, -9.5, 10> 0.075 rotate <0, -45, 0> translate <cp, 0, 0> }
                                        cylinder { <0, -9.5, -10> <0, -9.5, 10> 0.075 rotate <0, 45, 0> translate <cp, 0, 0> } 
                                        #declare cp = cp+1;
                                #end
                                        
                        }                
                        texture { paintTex2 }
                }
                rotate <0, 180, 0>
                translate <-8, -8, 30>
        }     
        
        // Holder for Lights at front of train
        union
        {
                difference
                {
                        object { Round_Box_Union(<-4, 0, -2.5>, <0, 2, 2.5>, 0.3) }
                        object { Round_Box_Union(<-4, 0, -2.81>, <0, 2, 2.81>, 0.3) translate <-0.3, 0.3, 0> } 
                        cylinder { <-2, -0.1, 0> <-2, 1, 0> 0.35 }
                } 
                sphere { <0, 0, 0> 0.3 scale <0.5, 1, 1> translate <-0.3, 1.5, 2> }
                sphere { <0, 0, 0> 0.3 scale <0.5, 1, 1> translate <-0.3, 1.5, 0> }
                sphere { <0, 0, 0> 0.3 scale <0.5, 1, 1> translate <-0.3, 1.5, -2> }
                                
                translate <0.2, -3, -23>                                                                              
                
                texture { paintTex2 }
        }        
        union
        {
                difference
                {
                        object { Round_Box_Union(<-4, 0, -2.5>, <0, 2, 2.5>, 0.3) }
                        object { Round_Box_Union(<-4, 0, -2.81>, <0, 2, 2.81>, 0.3) translate <-0.3, 0.3, 0> } 
                        cylinder { <-2, -0.1, 0> <-2, 1, 0> 0.35 }
                } 
                sphere { <0, 0, 0> 0.3 scale <0.5, 1, 1> translate <-0.3, 1.5, 2> }
                sphere { <0, 0, 0> 0.3 scale <0.5, 1, 1> translate <-0.3, 1.5, 0> }
                sphere { <0, 0, 0> 0.3 scale <0.5, 1, 1> translate <-0.3, 1.5, -2> }
                                
                translate <0.2, -3, 23>                                                                              
                
                texture { paintTex2 }
        }            
        
        // curved flat part at front of train next to lamp holders
        union
        {       
                union
                {
                        difference
                        {
                                Round_Box_Union(<-12, -10, -0.2>, <0, 3, 0.2>, 0.1)   
                        
                                cylinder { <-8, 0, -0.3> <-8, 0, 0.3> 0.65 }
                        }
                        object { Round_Cylinder_Union(<0, 0, -0.2>, <0, 0, 0.2>, 3, 0.1) translate <0, 0, 0> }
                        object { Round_Cylinder_Union(<0, 0, -0.2>, <0, 0, 0.2>, 3, 0.1) translate <-12, 0, 0> }
                        object { Round_Box_Union(<0, -10, -0.2>, <200, 3, 0.2>, 0.1) rotate <0, 0, -35> }
                       
                        rotate <0, 0, 35>
                }
                translate <0, -0.5, -14.8>
                texture { paintTex2 }
        }
        union
        {       
                union
                {
                        difference
                        {
                                Round_Box_Union(<-12, -10, -0.2>, <0, 3, 0.2>, 0.1)   
                        
                                cylinder { <-8, 0, -0.3> <-8, 0, 0.3> 0.65 }
                        }
                        object { Round_Cylinder_Union(<0, 0, -0.2>, <0, 0, 0.2>, 3, 0.1) translate <0, 0, 0> }
                        object { Round_Cylinder_Union(<0, 0, -0.2>, <0, 0, 0.2>, 3, 0.1) translate <-12, 0, 0> }
                        object { Round_Box_Union(<0, -10, -0.2>, <200, 3, 0.2>, 0.1) rotate <0, 0, -35> }
                       
                        rotate <0, 0, 35>
                }
                translate <0, -0.5, 14.8>
                texture { paintTex2 }
        } 
        
/****************************************************************************************************
Main Engine body/cylinder - made of 4 round sections
                         
****************************************************************************************************/        
        union
        {       
                // front section 
                union
                {      
                        Round_Cylinder_Union (<0, 0, 0>, <50, 0, 0>, 20, 0.5)
                        // larger part at end for next section to join to
                        union
                        {     
                                torus { 19.5, 0.75 rotate <0, 0, 90> translate <50, 0, 0> }
                                cylinder { <50, 0, 0> <51.5, 0, 0> 20.25 }
                                torus { 20, 0.25 rotate <0, 0, 90> translate <51.5, 0, 0> }   

                                // rivets around join at end of first section of engine
                                #declare rp = 0;
                                #while (rp <= 360)
                                        sphere { <0, 0, 0> 0.375 scale <1, 1, 0.5> translate <49, 0, 20> rotate <rp, 0, 0> }  
                                        #declare rp=rp+10;
                                #end

                        } 
                        
                        // Round pipe that runs from box that drives wheels on right hand side
                        union
                        {
                                cylinder { <0, 0, 0> <0, 25, 0> 4.25 rotate <23, 0, 0> translate <28, -20, -24> }   
                                // connection to train  
                                intersection 
                                {
                                        cylinder { <0, 0, 0> <0, 25, 0> 6.0 rotate <48, 0, 0> translate <28, -10, -24> } 
                                        cylinder { <20, 0, 0> <40, 0, 0> 20.15 }     
                                                                 
                                }    
                                // add rivets from top to bottom
                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <28, 0, -20.1> rotate <3, 0, 0> }

                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <25.35, 0, -20.1> rotate <-0.5, 0, 0> }
                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <30.65, 0, -20.1> rotate <-0.5, 0, 0> }

                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <23.5, 0, -20.1> rotate <-7, 0, 0>  }
                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <32.5, 0, -20.1> rotate <-7, 0, 0> }

                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <22.75, 0, -20.1> rotate <-15, 0, 0> }
                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <33.25, 0, -20.1> rotate <-15, 0, 0> }

                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <23.125, 0, -20.1> rotate <-23, 0, 0> }
                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <32.875, 0, -20.1> rotate <-23, 0, 0> }

                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <24.9, 0, -20.1> rotate <-29.5, 0, 0> }
                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <31.1, 0, -20.1> rotate <-29.5, 0, 0> }


                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <28, 0, -20.1> rotate <-33, 0, 0> }
                        }
                          
                        // Round pipe that runs from box that drives wheels on left hand side
                        union
                        {
                                cylinder { <0, 0, 0> <0, 25, 0> 4.25 rotate <-23, 0, 0> translate <28, -20, 24> }   
                                // connection to train  
                                intersection 
                                {
                                        cylinder { <0, 0, 0> <0, 25, 0> 6.0 rotate <-48, 0, 0> translate <28, -10, 24> } 
                                        cylinder { <20, 0, 0> <40, 0, 0> 20.15 }     
                                                                 
                                }    
                                // add rivets from top to bottom
                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <28, 0, 20.1> rotate <-3, 0, 0> }

                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <25.35, 0, 20.1> rotate <0.5, 0, 0> }
                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <30.65, 0, 20.1> rotate <0.5, 0, 0> }

                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <23.5, 0, 20.1> rotate <7, 0, 0>  }
                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <32.5, 0, 20.1> rotate <7, 0, 0> }

                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <22.75, 0, 20.1> rotate <15, 0, 0> }
                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <33.25, 0, 20.1> rotate <15, 0, 0> }

                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <23.125, 0, 20.1> rotate <23, 0, 0> }
                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <32.875, 0, 20.1> rotate <23, 0, 0> }

                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <24.9, 0, 20.1> rotate <29.5, 0, 0> }
                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <31.1, 0, 20.1> rotate <29.5, 0, 0> }


                                sphere { <0, 0, 0> 0.35 scale <1, 1, 0.5> translate <28, 0, 20.1> rotate <33, 0, 0> }
                        }   
                        // long pipe that runs length of engine on right hand side
                        union
                        {
                                cylinder { <0, 0, -10> <0, 0, -21> 1.1 }
                                intersection
                                {
                                        torus { 2, 1.1 }
                                        box { <-3.2, -1.2, -3.2> <0, 1.2, 0> }
                                        translate <2, 0, -21> 
                                }                       
                                Round_Cylinder_Union(<1.9, 0, -23>, <2.8, 0, -23>, 1.45, 0.1) 
                                Round_Cylinder_Union(<0, 0, -21.1>, <0, 0, -20.2>, 1.45, 0.1) 
                                
                                cylinder { <2, 0, -23> <180, 0, -23> 1.1 }  
                                
                                // brackets
                                torus { 1.25, 0.2 rotate <0, 0, 90> scale <2.5, 1, 1> translate <45, 0, -23> }
                                cylinder { <0, 0, -23> <0, 0, -15> 0.35 translate <45, 0, 0> }
                                torus { 1.25, 0.2 rotate <0, 0, 90> scale <2.5, 1, 1> translate <95, 0, -23> }
                                cylinder { <0, 0, -23> <0, 0, -15> 0.35 translate <95, 0, 0> }
                                torus { 1.25, 0.2 rotate <0, 0, 90> scale <2.5, 1, 1> translate <145, 0, -23> }
                                cylinder { <0, 0, -23> <0, 0, -15> 0.35 translate <145, 0, 0> }
                                
                                // box at rear end of pipe
                                union
                                {
                                        Round_Box_Union(<0, -2, -3>, <5, 2, 0.25>, 0.1)    
                                        Round_Box_Union(<0, -2, -3.4>, <5, 2, -3>, 0.1)    
                                        // add some rivets
                                        sphere { <0, 0, 0> 0.25 scale <1, 1, 0.5> translate <1, 1.25, -3.45> }
                                        sphere { <0, 0, 0> 0.25 scale <1, 1, 0.5> translate <4, 1.25, -3.45> }
                                        sphere { <0, 0, 0> 0.25 scale <1, 1, 0.5> translate <1, -1.25, -3.45> }
                                        sphere { <0, 0, 0> 0.25 scale <1, 1, 0.5> translate <4, -1.25, -3.45> }
                                        
                                        // down pipe
                                        union
                                        {
                                                cylinder { <0, -6, 0> <0, -1, 0> 1 }  
                                                difference
                                                {
                                                        torus { 3, 1 rotate <0, 0, 90> }
                                                        box { <-1.1, 0, -4.1> <1.1, 4.1, 4.1> }
                                                        box { <-1.1, -4.1, -4.1> <1.1, 0, 4.1> rotate <45, 0, 0> }
                                                        translate <0, -6, -3>
                                                }   
                                                cylinder { <0, -3, 3> <0, 0, 3> 1 rotate <45, 0, 0> translate <0, -6, -3> }  
                                                union
                                                {
                                                        difference
                                                        {
                                                                torus { 3, 1 rotate <0, 0, 90> }
                                                                box { <-1.1, 0, -4.1> <1.1, 4.1, 4.1> }
                                                                box { <-1.1, -4.1, -4.1> <1.1, 0, 4.1> rotate <-45, 0, 0> }
                                                        }
                                                        cylinder { <0, -5, 0> <0, 0, 0> 1 translate <0, 0, -3> rotate <-45, 0, 0> }
                                                        translate <0, -3, 6>
                                                        rotate <45, 0, 0> 
                                                        translate <0, -6, -3>
                                                }   
                                                                                     
                                                         
                                                
                                                translate <2.5, 0, -1.25>
                                                
                                        }
                                        translate <160, 0, -22> 
                                }  
                                
                                translate <20, 0, 0>
                        }   
                        
                        // Long handle rail that runs length of engine 
                        union
                        {
                                cylinder { <0, 0, 0> <190, 0, 0> 0.45 } 
                                Round_Cylinder_Union(<-0.75, 0, 0>, <0, 0, 0>, 0.65, 0.3)
                                Round_Cylinder_Union(<190, 0, 0>, <190.75, 0, 0>, 0.65, 0.3)
                                
                                // brackets
                                object { handRailBracket translate <5, 0, 0> }
                                object { handRailBracket translate <40, 0, 0> }
                                object { handRailBracket translate <75, 0, 0> }
                                object { handRailBracket translate <110, 0, 0> }      
                                object { handRailBracket rotate <-25, 0, 0> translate <145, 0, 0> }
                                object { handRailBracket rotate <-25, 0, 0> translate <185, 0, 0> }
                                                                        
                                
                                translate <5, 0, -24> 
                                rotate <25, 0, 0> 
                        }
                        // left side long handle rail
                        union
                        {
                                cylinder { <0, 0, 0> <190, 0, 0> 0.45 } 
                                Round_Cylinder_Union(<-0.75, 0, 0>, <0, 0, 0>, 0.65, 0.3)
                                Round_Cylinder_Union(<190, 0, 0>, <190.75, 0, 0>, 0.65, 0.3)
                                
                                // brackets
                                object { handRailBracket rotate <180, 0, 0> translate <5, 0, 0> }
                                object { handRailBracket rotate <180, 0, 0> translate <40, 0, 0> }
                                object { handRailBracket rotate <180, 0, 0> translate <75, 0, 0> }
                                object { handRailBracket rotate <180, 0, 0> translate <110, 0, 0> }      
                                object { handRailBracket rotate <180, 0, 0> rotate <25, 0, 0> translate <145, 0, 0> }
                                object { handRailBracket rotate <180, 0, 0> rotate <25, 0, 0> translate <185, 0, 0> }
                                                                        
                                
                                translate <5, 0, 24> 
                                rotate <-25, 0, 0> 
                        }
                        
                          
                        // Funnel
 
                         union
                        {
                        
                                difference
                                {
                                        union
                                        {
                                                box { <-8, -4, -10> <8, 3, 10> }
                                                cylinder { <0, -4, -10> <0, 3, -10> 8 }
                                                cylinder { <0, -4, 10> <0, 3, 10> 8 } 
                                        }        
                                        blob {
                                          // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
                                          threshold 0.6
                                          #declare zp=10;
                                          #while(zp > -10)
                                          
                                                sphere { <-8, 0, zp>, 2, 1 }
                                                sphere { <8, 0, zp>, 2, 1 }
                                                #declare zp=zp-0.1;
                                          #end                                 
                                          
                                          #declare br = 0;  
                                          #declare by = 0;
                                          #while(br < 180)
                                                sphere { <8, 0, 0>, 2-by, 1 rotate <0, br, 0> translate <0, by, zp> }
                                                sphere { <8, 0, 0>, 2-by, 1 rotate <0, -br, 0> translate <0, by, -zp> }
                                                #declare br=br+1;   
                                                #if(br < 90) 
                                                        #declare by=by+(0.35/90);  
                                                #else
                                                        #declare by=by-(0.35/90);  
                                                #end        
                                          #end
                                          
                                          scale <1, 2, 1>
                                        
                                        } 
                                        // holes
                                        cylinder { <0, -4, -8> <0, 4, -8> 5 }
                                        cylinder { <0, -4, 8> <0, 4, 8> 5 }
                                        
                                }  
                                // rivets
                                  #declare zp=10;
                                  #while(zp > -10)
                                  
                                        sphere { <-7.5, 0, zp>, 0.375 scale <1, 0.5, 1> translate <0, -3.35, 0> }
                                        sphere { <7.5, 0, zp>, 0.375 scale <1, 0.5, 1> translate <0, -3.35, 0> }
                                        #declare zp=zp-4;
                                  #end                                 
                                  
                                  #declare br = 0;  
                                  #declare by = 0;
                                  #while(br <= 180)
                                        sphere { <7.5, 0, 0>, 0.375 scale <1, 0.5, 1> rotate <0, br, 0> translate <0, by, zp> translate <0, -3.3, 0> }
                                        sphere { <7.5, 0, 0>, 0.375 scale <1, 0.5, 1> rotate <0, -br, 0> translate <0, by, -zp> translate <0, -3.3, 0> }
                                        #declare br=br+30;   
                                        #if(br <= 90) 
                                                #declare by=by+((1.25/90)*30);  
                                        #else
                                                #declare by=by-((1.25/90)*30);  
                                        #end        
                                  #end
                                                                                   
                        
                                difference
                                {
                                        union 
                                        {
                                                difference
                                                {
                                                        torus { 7, 1  }
                                                        box { <-9, -1.1, 0> <9, 1.1, 9> }   
                                                        translate <0, 3, -10>
                                                }
                                                difference
                                                {
                                                        torus { 7, 1  }
                                                        box { <-9, -1.1, -9> <9, 1.1, 0> }   
                                                        translate <0, 3, 10>
                                                } 
                                                cylinder { <-7, 3, -10> <-7, 3, 10> 1 }
                                                cylinder { <7, 3, -10> <7, 3, 10> 1 }
                                                cylinder { <0, 2, -10> <0, 4, -10> 7 }
                                                cylinder { <0, 2, 10> <0, 4, 10> 7 } 
                                                box { <-7, 2, -10> <7, 4, 10> }   
                                                scale <1.0125, 1, 1.025>
                                                translate <0, 1, 0>
                                                
                                        }
                        
                                        // holes
                                        cylinder { <0, -4, -8> <0, 6, -8> 5 }
                                        cylinder { <0, -4, 8> <0, 6, 8> 5 }
                                }  
                                difference
                                {
                                        union
                                        {
                                                cylinder { <0, 2, 0> <0, 5, 0> 5.1 }
                                                torus { 4.9, 0.2 translate <0, 5, 0> }
                                        }                                             
                                        cylinder { <0, 1, 0> <0, 6, 0> 4.7 }
                                        translate <0, 1, -8>
                                }      
                                difference
                                {
                                        union
                                        {
                                                cylinder { <0, 2, 0> <0, 5, 0> 5.1 }
                                                torus { 4.9, 0.2 translate <0, 5, 0> }
                                        }                                             
                                        cylinder { <0, 1, 0> <0, 6, 0> 4.7 }
                                        translate <0, 1, 8>
                                }
                                scale <0.8, 1, 0.8>                  
                                rotate <0, 90, 0>    
                                translate <25, 22.6, 0>
                        }
                        
                        
                        
                        // door
                        union
                        {
                                sphere { <0, 0, 0> 17 scale <0.1, 1, 1> }
                                difference
                                {
                                        torus { 16.5, 0.51 rotate <0, 0, 90> }
                                        box { <-1.1, -17.1, -17.1> <0, 17.1, 17.1> }
                                }
                                translate <-0.5, 0, 0>
                        }                                 
                        // right hand side bracket
                        union
                        {       
                                cylinder { <-2, -10, -14> <-2, 10, -14> 0.275 } 

                                // top part attached to engine
                                cylinder { <-2, 10, -14> <-2, 11.5, -14> 0.4 } 
                                sphere { <-2, 11.5, -14> 0.4 }   
                                cylinder { <-2, 11.5, -14> <1, 11.5, -14> 0.4 }  
                                Round_Cylinder_Union(<-1, 11.5, -14>, <0, 11.5, -14>, 0.7, 0.15)  
                                
                                // bottom part attached to engine
                                cylinder { <-2, -11.5, -14> <-2, -10, -14> 0.4 } 
                                sphere { <-2, -11.5, -14> 0.4 }   
                                cylinder { <-2, -11.5, -14> <1, -11.5, -14> 0.4 }  
                                Round_Cylinder_Union(<-1, -11.5, -14>, <0, -11.5, -14>, 0.7, 0.15) 
                                
                                // top bracket hinge
                                Round_Cylinder_Union(<-2, 9.5, -14>, <-2, 10, -14>, 0.4, 0.05) 
                                Round_Cylinder_Union(<-2, 7.5, -14>, <-2, 9.5, -14>, 0.5, 0.1) 
                                Round_Cylinder_Union(<-2, 7, -14>, <-2, 7.5, -14>, 0.4, 0.05)              
                                Round_Box_Union(<-1.75, 7.6, -14.2>, <-1.15, 9.4, -13.8>, 0.199999)  // was 0.2 but caused z depth problem
                                intersection
                                {
                                        object { Round_Box_Union(<-2.2, -0.75, -14>, <-1, 0.75, 4>, 0.2) }
                                        sphere { <0, 0, 0> 17 scale <0.1, 1, 1> translate <-0.4, 0, 0> } 
                                        
                                        translate <0, 8.5, 0>
                                }                                 
                                // add rivets
                                object { rivet scale <0.25, 0.25, 0.05> rotate <0, 84, 0> translate <-1.624, 8.5, -12> }
                                object { rivet scale <0.25, 0.25, 0.05> rotate <0, 87, 0> translate <-1.86, 8.5, -9> }
                                object { rivet scale <0.25, 0.25, 0.05> rotate <0, 89, 0> translate <-2.004, 8.5, -6> }
                                object { rivet scale <0.25, 0.25, 0.05> rotate <0, 90, 0> translate <-2.090, 8.5, -3>  }
                                object { rivet scale <0.25, 0.25, 0.05> rotate <0, 90, 0> translate <-2.100, 8.5, 0>  }
                                object { rivet scale <0.25, 0.25, 0.05> rotate <0, 90, 0> translate <-2.090, 8.5, 3>  }
                                

                                // bottom bracket hinge
                                Round_Cylinder_Union(<-2, -10, -14>, <-2, -9.5, -14>, 0.4, 0.05) 
                                Round_Cylinder_Union(<-2, -9.5, -14>, <-2, -7.5, -14>, 0.5, 0.1) 
                                Round_Cylinder_Union(<-2, -7.5, -14>, <-2, -7, -14>, 0.4, 0.05)              
                                Round_Box_Union(<-1.75, -9.4, -14.2>, <-1.15, -7.6, -13.8>, 0.199999) // was 0.2 but caused z depth problem
                                intersection
                                {
                                        object { Round_Box_Union(<-2.2, -0.75, -14>, <-1, 0.75, 4>, 0.2) }
                                        sphere { <0, 0, 0> 17 scale <0.1, 1, 1> translate <-0.4, 0, 0> } 
                                        
                                        translate <0, -8.5, 0>
                                }                                 
                                // add rivets
                                object { rivet scale <0.25, 0.25, 0.05> rotate <0, 84, 0> translate <-1.624, -8.5, -12> }
                                object { rivet scale <0.25, 0.25, 0.05> rotate <0, 87, 0> translate <-1.86, -8.5, -9> }
                                object { rivet scale <0.25, 0.25, 0.05> rotate <0, 89, 0> translate <-2.004, -8.5, -6> }
                                object { rivet scale <0.25, 0.25, 0.05> rotate <0, 90, 0> translate <-2.090, -8.5, -3>  }
                                object { rivet scale <0.25, 0.25, 0.05> rotate <0, 90, 0> translate <-2.100, -8.5, 0>  }
                                object { rivet scale <0.25, 0.25, 0.05> rotate <0, 90, 0> translate <-2.090, -8.5, 3>  }
                                
                                                         
                                texture { Chrome_Handle_Tex }
                        }   
                        
                        // badge
                        union
                        {
                                union
                                {   
                                        difference
                                        {
                                                union
                                                {    
                                                        Round_Box_Union(<-10.5, -1.5, -1>, <10.5, 1.5, 1>, 0.1)
                                                        Round_Box_Union(<-11.5, -0.5, -1>, <11.5, 0.5, 1>, 0.1)
                                                        Round_Cylinder_Union(<-10.5, 0.5, -1>, <-10.5, 0.5, 1>, 1, 0.1)
                                                        Round_Cylinder_Union(<-10.5, -0.5, -1>, <-10.5, -0.5, 1>, 1, 0.1)   
                                                        Round_Cylinder_Union(<10.5, 0.5, -1>, <10.5, 0.5, 1>, 1, 0.1)
                                                        Round_Cylinder_Union(<10.5, -0.5, -1>, <10.5, -0.5, 1>, 1, 0.1)   
                                                }
                                                
                                                union
                                                {    
                                                        Round_Box_Union(<-10.5, -1.2, -1.1>, <10.5, 1.2, -0.8>, 0.1)
                                                        Round_Box_Union(<-11.2, -0.5, -1.1>, <11.2, 0.5, -0.8>, 0.1)
                                                        Round_Cylinder_Union(<-10.5, 0.5, -1.1>, <-10.5, 0.5, -0.8>,0.7, 0.1)
                                                        Round_Cylinder_Union(<-10.5, -0.5, -1.1>, <-10.5, -0.5, -0.8>, 0.7, 0.1)   
                                                        Round_Cylinder_Union(<10.5, 0.5, -1.1>, <10.5, 0.5, -0.8>, 0.7, 0.1)
                                                        Round_Cylinder_Union(<10.5, -0.5, -1.1>, <10.5, -0.5, -0.8>, 0.7, 0.1)  
                                                }
                                        }
                                        union
                                        {    
                                                Round_Box_Union(<-10.51, -1.51, -0.9>, <10.51, 1.51, 1>, 0.1)
                                                Round_Box_Union(<-11.51, -0.51, -0.9>, <11.51, 0.51, 1>, 0.1)
                                                Round_Cylinder_Union(<-10.51, 0.51, -0.9>, <-10.51, 0.51, 1>, 1, 0.1)
                                                Round_Cylinder_Union(<-10.51, -0.51, -0.9>, <-10.51, -0.51, 1>, 1, 0.1)   
                                                Round_Cylinder_Union(<10.51, 0.51, -0.9>, <10.51, 0.51, 1>, 1, 0.1)
                                                Round_Cylinder_Union(<10.51, -0.51, -0.9>, <10.51, -0.51, 1>, 1, 0.1)   
                                                texture { paintTex2 }
                                        }
                                        translate <0, 0, 1>
                                        texture { paintTex3 }  
                                        
                                }
                                text { ttf "crystal.ttf", "THE ROYAL SCOT", 2, 0 translate <-3.5, -0.35, 0> scale 2.75 }
                                rotate <0, 90, 0>
                                translate <-2.5, 5.5, 0>
                                texture { paintTex3 }  
                        }
                        
                        // handle above badge
                        union
                        {
                                Round_Cone_Union(<-1, 10, -11>, 0.7, <-2, 10, -11>, 0.45, 0.15)  
                                cylinder { <-2.75, 10, -11> <-1.9, 10, -11> 0.3 }   
                                torus { 0.4, 0.2 rotate <90, 0, 0> scale <1, 1, 2> translate <-3, 10, -11> } 

                                Round_Cone_Union(<-1, 10, 11>, 0.7, <-2, 10, 11>, 0.45, 0.15)  
                                cylinder { <-2.75, 10, 11> <-1.9, 10, 11> 0.3 }   
                                torus { 0.4, 0.2 rotate <90, 0, 0> scale <1, 1, 2> translate <-3, 10, 11> } 
                                
                                cylinder { <-3, 10, -12.5> <-3, 10, 12.5> 0.3 }
                                torus { 0.3, 0.2 rotate <90, 0, 0> translate <-3, 10, -12.5> }
                                cylinder { <0, 0, 0> <0, 0, -0.2> 0.3 translate <-3, 10, -12.5> }

                                torus { 0.3, 0.2 rotate <90, 0, 0> translate <-3, 10, 12.5> }
                                cylinder { <0, 0, 0> <0, 0, 0.2> 0.3 translate <-3, 10, 12.5> }
                        }    
                        // small bracket/handle at top above handle above 
                        union
                        {
                                Round_Box_Union(<-1.85, -0.6, -0.75>, <0, 0.9, 0.75>, 0.05)
                                Round_Box_Union(<-3.25, 0, -0.75>, <0, 0.3, 0.75>, 0.05)
                                Round_Cylinder_Union( <-3.25, 0, 0>, <-3.25, 0.3, 0>, 0.75, 0.05)  
                                
                                Round_Box_Union(<-2.3, 0.2, -0.75>, <-2, 3.5, 0.75>, 0.05)
                                Round_Cylinder_Union(<-2.3, 3.5, 0>, <-2, 3.5, 0>, 0.75, 0.05)
                                
                                translate <0, 12, 0>
                        }      
                        
                        // handle in center at front of engine
                        union
                        {
                                Round_Cylinder_Union(<-1, 0, 0>, <0, 0, 0>, 2.25, 0.1)
                                difference
                                {
                                        cylinder { <-1.5, 0, 0> <0, 0, 0> 1.25 }
                                        torus { 1.25, 0.5 rotate <0, 0, 90> translate <-1.5, 0, 0> }
                                }      
                                Round_Cylinder_Union(<-3, 0, 0> <-1.5, 0, 0> 0.75, 0.1)
                                difference
                                {
                                        object { Round_Cylinder_Union(<-4.5, 0, 0> <-3, 0, 0> 0.75, 0.1) }
                                        cylinder { <-4.6, 0, 0> <-3, 0, 0> 0.35 }                                         
                                }                                                 
                                cylinder { <-4.75, 0, 0> <0, 0, 0> 0.3 }
                                Round_Cylinder_Union(<-4.9, 0, 0>, <-4.5, 0, 0>, 0.4, 0.175)//sphere { <-5, 0, 0> 0.3 }
                                object { Round_Cylinder_Union(<-2.25, -7, 0> <-2.25, 0, 0> 0.32, 0.1) rotate <-10, 0, 0> }
                                object { Round_Cylinder_Union(<-3.75, -7, 0> <-3.75, 0, 0> 0.32, 0.1) rotate <50, 0, 0> }
                                
                                translate <-1.5, 0, 0>
                                texture { Chrome_Handle_Tex }
                                
                        }
                        // rivets on front of engine
                        #declare rp = 0;
                        #while (rp <= 180)
                                sphere { <0, 0, 0> 0.375 scale <0.5, 1, 1> translate <0, 0, 18.9> rotate <rp, 0, 0> }  
                                #declare rp=rp+15;
                        #end
                                sphere { <0, 0, 0> 0.375 scale <0.5, 1, 1> translate <0, 0, -17.9> }  
                                sphere { <0, 0, 0> 0.375 scale <0.5, 1, 1> translate <0, 0, 17.9> }  

                                sphere { <0, 0, 0> 0.375 scale <0.5, 1, 1> translate <0, 0, 18.9> rotate <7.5, 0, 0> }  
                                sphere { <0, 0, 0> 0.375 scale <0.5, 1, 1> translate <0, 0, 18.9> rotate <172.5, 0, 0> }  
                                sphere { <0, 0, 0> 0.375 scale <0.5, 1, 1> translate <0, 0, 17.9> rotate <7.5, 0, 0> }  
                                sphere { <0, 0, 0> 0.375 scale <0.5, 1, 1> translate <0, 0, 17.9> rotate <172.5, 0, 0> }  


                        // rivets around front of engine
                        #declare rp = 0;
                        #while (rp <= 360)
                                sphere { <0, 0, 0> 0.375 scale <1, 1, 0.5> translate <1.5, 0, 20> rotate <rp, 0, 0> }  
                                #declare rp=rp+10;
                        #end

                        texture { paintTex2 }
                }         
                // Second section
                union
                {
                        cylinder {<0, 0, 0>, <32, 0, 0>, 20 }
                        // larger part at end for next section to join to
                        union
                        {     
                                torus { 19.5, 0.75 rotate <0, 0, 90> translate <32, 0, 0> }
                                cylinder { <32, 0, 0> <33.5, 0, 0> 20.25 }
                                torus { 20, 0.25 rotate <0, 0, 90> translate <33.5, 0, 0> }   

                                // rivets around join at end of first section of engine
                                #declare rp = 0;
                                #while (rp <= 360)
                                        sphere { <0, 0, 0> 0.375 scale <1, 1, 0.5> translate <31, 0, 20> rotate <rp, 0, 0> }  
                                        #declare rp=rp+10;
                                #end

                        }   
                        // funnel type extension on top of middle part
                        union
                        {

                                union
                                {                                
                                        cylinder { <-5, 0, 0> <5, 0, 0> 2 }
                                        sphere { <-5, 0, 0> 2 }
                                        sphere { <5, 0, 0> 2 }
                                        cylinder { <0, -10, 0> <0, 0, 0> 2 rotate <0, 0, 15> translate <5, 0, 0> }
                                        cylinder { <0, -10, 0> <0, 0, 0> 2 rotate <0, 0, -15> translate <-5, 0, 0> }   
                                        difference 
                                        {
                                                box { <-8, -10, -2> <8, 0, 2> }
                                                box { <-10, -15, -2.1> <0, 10, 2.1> rotate <0, 0, -15> translate <-5, 0, 0> }
                                                box { <0, -15, -2.1> <10, 10, 2.1> rotate <0, 0, 15> translate <5, 0, 0> }
                                        }
                                        rotate <0, 90, 0> 
                                        scale <1.25, 1, 1.5>
                                        translate <27, 23, 0>
                                }
                                difference
                                {
                                        intersection
                                        {
                                                union
                                                {
                                                        cylinder { <-5, 0, 0> <5, 0, 0> 2 }
                                                        sphere { <-5, 0, 0> 2 }
                                                        sphere { <5, 0, 0> 2 }
                                                        cylinder { <0, -10, 0> <0, 0, 0> 2 rotate <0, 0, 15> translate <5, 0, 0> }
                                                        cylinder { <0, -10, 0> <0, 0, 0> 2 rotate <0, 0, -15> translate <-5, 0, 0> }   
                                                        difference 
                                                        {
                                                                box { <-8, -10, -2> <8, 0, 2> }
                                                                box { <-10, -15, -2.1> <0, 10, 2.1> rotate <0, 0, -15> translate <-5, 0, 0> }
                                                                box { <0, -15, -2.1> <10, 10, 2.1> rotate <0, 0, 15> translate <5, 0, 0> }
                                                        }
                                                        scale <1.0125, 1.0, 1.4>
                                                        rotate <0, 90, 0>
                                                        scale <1.25, 1, 1.5> 
                                                        translate <27, 23, 0>    
                                                                                                   
                                                        
                                                }
                                                cylinder { <0, 0, 0> <35, 0, 0> 20.2 }     
                                                
                                        }
                                        cylinder { <0, 0, 0> <36, 0, 0> 20.00 }
                                } 
                                torus { 20.05, 0.5 rotate <0, 0, 90> scale <1.5, 1, 1> translate <27, 0, 0> }

                        }
                        translate <51, 0, 0>
                        texture { paintTex1 }
                }
                // Third section
                union
                {
                        cylinder {<0, 0, 0>, <22, 0, 0>, 20 }
                        // larger part at end for next section to join to
                        union
                        {     
                                torus { 19.5, 0.75 rotate <0, 0, 90> translate <22, 0, 0> }
                                cylinder { <22, 0, 0> <23.5, 0, 0> 20.25 }
                                torus { 20, 0.25 rotate <0, 0, 90> translate <23.5, 0, 0> }   

                                // rivets around join at end of first section of engine
                                #declare rp = 0;
                                #while (rp <= 360)
                                        sphere { <0, 0, 0> 0.375 scale <1, 1, 0.5> translate <21, 0, 20> rotate <rp, 0, 0> }  
                                        #declare rp=rp+10;
                                #end

                        }                      
                        translate <84, 0, 0>
                        texture { paintTex1 }
                }
                // Fourth section
                union
                {
                        cylinder {<0, 0, 0>, <22, 0, 0>, 20 }
                        // larger part at end for next section to join to
                        union
                        {     
                                torus { 19.5, 0.75 rotate <0, 0, 90> translate <22, 0, 0> }
                                cylinder { <22, 0, 0> <23.5, 0, 0> 20.25 }
                                torus { 20, 0.25 rotate <0, 0, 90> translate <23.5, 0, 0> }   

                                // rivets around join at end of first section of engine
                                #declare rp = 0;
                                #while (rp <= 360)
                                        sphere { <0, 0, 0> 0.375 scale <1, 1, 0.5> translate <21, 0, 20> rotate <rp, 0, 0> }  
                                        #declare rp=rp+10;
                                #end

                        }        
                        Round_Cone_Union(<11, 15, 0>, 12 <11, 25, 0>, 8, 3)     
                        difference
                        {
                                intersection
                                {
                                        object { Round_Cone_Union(<0, 15, 0>, 12 <0, 25, 0>, 8, 3) scale <1.1, 1, 1.1>  translate <11, 0, 0> }
                                        cylinder { <0, 0, 0> <22, 0, 0> 20.2 }
                                }                                             
                                cylinder { <0, 0, 0> <22, 0, 0> 20.00 }        
                                
                        }          
                        translate <107, 0, 0>
                 
                        texture { paintTex1 }
                }    
                
                // Guard? parts at front of engine    
                // right side
                union
                {
                        union 
                        { 
                                box { <0, -25, -0.1>, <30, 0.02, 0.1> }    
                                cylinder { <0, -25, 0> <0, 0.02, 0> 0.3 }
                                cylinder { <30, -25, 0> <30, 0.02, 0> 0.3 }
                                sphere { <0, 0.02, 0> 0.3 }
                                sphere { <30, 0.02, 0> 0.3 }
                                rotate <10, 0, 0> translate <0, 0, -34> rotate <-20, 0, 0> 
                        }                    
                        
                        union
                        {       
                                difference 
                                {
                                        union
                                        {
                                                cylinder { <0, 0, 0> <30, 0, 0> 34.1 }
                                                torus { 34, 0.3 rotate <0, 0, 90> }
                                                torus { 34, 0.3 rotate <0, 0, 90> translate <30, 0, 0> }
                                        }
                                        cylinder { <-0.01, 0, 0> <30.01, 0, 0> 33.9 } 
                                        box { <-0.4, 0, -40> <30.4, 40, 40> rotate <15, 0, 0> } 
                                        box { <-0.4, -40, -40> <30.4, 0, 40> rotate <-20, 0, 0> }
                                }
                        }
                        // round bit on top           
                        union
                        {                  
                                cylinder { <0, 0, 0> <30, 0, 0> 0.3 }
                                sphere { <0, 0, 0> 0.3 }
                                sphere { <30, 0, 0> 0.3 }
                                translate <0, 0, -34> 
                                rotate <15, 0, 0>
                        }
                        texture { paintTex2 }  
                        rotate <0, 0, 0>
                        translate <-10, 2, 10>
                }
                // left side
                union
                {
                        union 
                        { 
                                box { <0, -25, -0.1>, <30, 0.02, 0.1> }    
                                cylinder { <0, -25, 0> <0, 0.02, 0> 0.3 }
                                cylinder { <30, -25, 0> <30, 0.02, 0> 0.3 }
                                sphere { <0, 0.02, 0> 0.3 }
                                sphere { <30, 0.02, 0> 0.3 }
                                rotate <-10, 0, 0> translate <0, 0, 34> rotate <20, 0, 0> 
                        }                    
                        
                        union
                        {       
                                difference 
                                {
                                        union
                                        {
                                                cylinder { <0, 0, 0> <30, 0, 0> 34.1 }
                                                torus { 34, 0.3 rotate <0, 0, 90> }
                                                torus { 34, 0.3 rotate <0, 0, 90> translate <30, 0, 0> }
                                        }
                                        cylinder { <-0.01, 0, 0> <30.01, 0, 0> 33.9 } 
                                        box { <-0.4, 0, -40> <30.4, 40, 40> rotate <-15, 0, 0> } 
                                        box { <-0.4, -40, -40> <30.4, 0, 40> rotate <20, 0, 0> }
                                }
                        }
                        // round bit on top           
                        union
                        {                  
                                cylinder { <0, 0, 0> <30, 0, 0> 0.3 }
                                sphere { <0, 0, 0> 0.3 }
                                sphere { <30, 0, 0> 0.3 }
                                translate <0, 0, 34> 
                                rotate <-15, 0, 0>
                        }
                        texture { paintTex2 }  
                        rotate <0, 0, 0>
                        translate <-10, 2, -10>
                }
                
/*************************************************************************************************
Square part at back of engine
*************************************************************************************************/

                union
                {                        
                        #declare rc = 10;
                        #declare h = vrotate(<0, 0, -22>, <rc, 0, 0>);  
                        #declare a = VRotationD(<0, 20, 0>, <0, 20, -3>, <0, 0, 0>);
                        #warning str(h.z, 0, 5)
                        difference
                        {
                                union
                                {
                                        cylinder { <0, 0, 0> <70, 0, 0> 22 }
                                        cylinder { <-1, 0, 0> <0, 0, 0> 21 }
                                        torus { 21, 1 rotate <0, 0, 90> }    // round edge
                                }
                                box { <-1.1, h.y, -22.1> <70.1, 22.1, 22.1> }
                        }  
                        difference
                        {
                                box { <0, 0, -22> <70, 18, 22> }
                                union
                                {
                                        box { <-0.1, -10, -32> <70.1, 30, -22> rotate <rc, 0, 0> }
                                        box { <-0.1, -10, 22> <70.1, 30, 32> rotate <-rc, 0, 0> }
                                        box { <-0.1, -22, -23> <70.1, 0, 23> rotate <rc, 0, 0> }                                        
                                        box { <-0.1, -22, -23> <70.1, 0, 23> rotate <-rc, 0, 0> }                                        
                                }                                                                 
                                
                        }              
                        difference
                        {
                                box { <-1, 0, -21> <0, 18, 21> }
                                union
                                {
                                        box { <-1.1, -10, -32> <0.1, 30, -21> rotate <rc, 0, 0> }
                                        box { <-1.1, -10, 21> <0.1, 30, 32> rotate <-rc, 0, 0> }
                                        box { <-1.1, -22, -23> <0.1, 0, 23> rotate <rc, 0, 0> }                                        
                                        box { <-1.1, -22, -23> <0.1, 0, 23> rotate <-rc, 0, 0> }                                        
                                }                                                                 
                                
                        }              
                        // round edges
                        difference
                        {
                                cylinder { <0, 0, -21> <0, 18, -21> 1 rotate <rc, 0, 0> }
                                union
                                {
                                        box { <-1.1, 18, -21> <1.1, 30, 0> }
                                        box { <-1.1, -22, -24> <1.1, 0, 0> rotate <rc, 0, 0> }                                        
                                }                                                                 
                        }              
                        difference
                        {
                                cylinder { <0, 0, 21> <0, 18, 21> 1 rotate <-rc, 0, 0> }
                                union
                                {
                                        box { <-1.1, 18, 0> <1.1, 30, 21> }
                                        box { <-1.1, -22, 0> <1.1, 0, 24> rotate <-rc, 0, 0> }                                        
                                }                                                                                                 
                        }              

                        #declare tempvar1 = vrotate(<0, 14.39848545, -22>, <rc, 0, 0>);    
                        #declare ty = 14.39848545;
                        #warning str(tempvar1.y, 0, 50)                        
                        #declare top_zpos = vrotate(<0, ty, -15>, <rc, 0, 0>);   
                        intersection
                        {
                                union
                                {
                                        cylinder { <0, 0, 0> <70, 0, 0> 7 translate <0, ty, -15> rotate <rc, 0, 0> }
                                        cylinder { <-1, 0, 0> <0, 0, 0> 6 translate <0, ty, -15> rotate <rc, 0, 0> }
                                        torus { 6, 1 rotate <0, 0, 90> translate <0, ty, -15> rotate <rc, 0, 0> }
                                }
                                box { <-1.1, 18, -22> <70.1, 25, top_zpos.z> }
                                
                        }  
                        intersection
                        {
                                union
                                {
                                        cylinder { <0, 0, 0> <70, 0, 0> 7 translate <0, ty, 15> rotate <-rc, 0, 0> }
                                        cylinder { <-1, 0, 0> <0, 0, 0> 6 translate <0, ty, 15> rotate <-rc, 0, 0> }
                                        torus { 6, 1 rotate <0, 0, 90> translate <0, ty, 15> rotate <-rc, 0, 0> }
                                }
                                box { <-1.1, 18, -top_zpos.z> <70.1, 25, 22> }
                                
                        }  
                        // top part
                        #declare top_pos = vrotate(<0, ty+7.1, -15>, <rc, 0, 0>);   
                        box { <0, top_pos.y-7, top_zpos.z> <70, top_pos.y, -top_zpos.z> }
                        box { <-1, top_pos.y-6, top_zpos.z> <0, top_pos.y-1, -top_zpos.z> }
                        cylinder { <0, top_pos.y-1, top_zpos.z> <0, top_pos.y-1, -top_zpos.z> 1 }
                        
                        // small funnel type parts
                        union
                        {       
                                Round_Box_Union(<-4, -1, -4>, <9, 0.25, 4>, 0.1)
                                sphere { <0, 0, 0> 0.25 scale <1, 0.5, 1> translate <-3.5, 0.265, -3.5> }
                                sphere { <0, 0, 0> 0.25 scale <1, 0.5, 1> translate <-3.5, 0.265, 3.5> }
                                sphere { <0, 0, 0> 0.25 scale <1, 0.5, 1> translate <8.5, 0.265, -3.5> }
                                sphere { <0, 0, 0> 0.25 scale <1, 0.5, 1> translate <8.5, 0.265, 3.5> }
                                
                                difference
                                {
                                        cylinder { <0, -1, 0> <0, 3.9 0> 1 }
                                        cylinder { <0, 0.1, 0> <0, 4.1, 0> 0.8 }                                        
                                }                                               
                                Round_Cylinder_Union(<0, 0, 0>, <0, 1, 0> 1.5, 0.4)
                                Round_Cylinder_Union(<0, 1.5, 0>, <0, 2.5, 0> 1.5, 0.4)
                                Round_Cylinder_Union(<0, 3, 0>, <0, 4, 0> 1.5, 0.4)

                                difference
                                {
                                        cylinder { <5, -1, 0> <5, 3.9, 0> 1 }
                                        cylinder { <5, 0.1, 0> <5, 4.1, 0> 0.8 }                                        
                                }                                               
                                Round_Cylinder_Union(<5, 0, 0>, <5, 1, 0> 1.5, 0.4)
                                Round_Cylinder_Union(<5, 1.5, 0>, <5, 2.5, 0> 1.5, 0.4)
                                Round_Cylinder_Union(<5, 3, 0>, <5, 4, 0> 1.5, 0.4)
                                #if(useTestTex)
                                        texture { pigment { Yellow } finish { ambient 0 } }
                                #else
                                        texture { pipeTexCopper }
                                #end
                                translate <35, top_pos.y, 0> 
                        }
                        
                        texture { paintTex1 }     
                        translate <130, 0, 0>
        
        
                }    
                                           
                translate <0, 19, 0>
        }                       

/*************************************************************************************************
Cabin part at back of engine
*************************************************************************************************/
        union
        {       
                
                // right side (facing front of engine)
                union
                {
                        difference 
                        {
                                box { <0, 0, -30.5> <32, 50, -29.5> }  
                                union // cut out window holes
                                {
                                        Round_Box_Union(<4, 30, -33>, <13, 45, -26>, 2 )
                                        Round_Box_Union(<17, 30, -35>, <37, 45, -22>, 5 )
                                        box { <30, -0.1, -31> <33, 35, -29> }
                                }
                        } 
                        // black paint around windows
                        // small window
                        intersection
                        {
                                difference
                                {
                                        Round_Box_Union(<2.75, 28.75, -33>, <14.25, 46.25, -26>, 2 )
                                        Round_Box_Union(<4.0, 30.0, -33>, <13.0, 45, -26>, 2 )
                                }                                            
                                box { <2, 28, -30.5001> <15, 47, -30.25> }
                                bounded_by { box { <2, 28, -30.5001> <15, 47, -30.25> } } 
                                texture { paintTex2 }
                        }  
                        // black paint around large window
                        intersection
                        {
                                difference
                                {
                                        Round_Box_Union(<15.75, 28.75, -35>, <38.25, 46.25, -22>, 5 )
                                        Round_Box_Union(<17, 30, -35>, <38, 45, -22>, 5 )
                                }                                            
                                box { <15, 28, -30.5001> <32, 47, -30.25> }
                                bounded_by { box { <15, 28, -30.5001> <32, 47, -30.25> } } 
                                texture { paintTex2 }
                        }
                                 
                        // gold paint around windows
                        // small window
                        intersection
                        {
                                difference
                                {
                                        Round_Box_Union(<2.5, 28.5, -33>, <14.5, 46.5, -26>, 2 )
                                        Round_Box_Union(<4.0, 30.0, -33>, <13.0, 45, -26>, 2 )
                                }                                            
                                box { <2, 28, -30.50001> <15, 47, -30.25> }
                                bounded_by { box { <2, 28, -30.50001> <15, 47, -30.25> } } 
                                texture { paintTex3 }
                        }  
                        // gold paint aruont large window
                        intersection
                        {
                                difference
                                {
                                        Round_Box_Union(<15.5, 28.5, -35>, <38.5, 46.5, -22>, 5 )
                                        Round_Box_Union(<17, 30, -35>, <38, 45, -22>, 5 )
                                }                                            
                                box { <15, 28, -30.50001> <32, 47, -30.25> }
                                bounded_by { box { <15, 28, -30.50001> <32, 47, -30.25> } } 
                                texture { paintTex3 }
                        }
                        
        
                        // window frames
                        // small window
                        intersection
                        {
                                difference
                                {
                                        Round_Box_Union(<3.75, 29.75, -33>, <13.25, 45.25, -26>, 2 )
                                        Round_Box_Union(<4.5, 30.5, -33>, <12.5, 44.5, -26>, 2 )
                                }                                            
                                box { <3, 29, -30.75> <14, 46, -29.25> }
                                bounded_by { box { <3, 29, -30.75> <14, 46, -29.25> } } 
                                texture { paintTex3 }
                        }  
                        // glass for small side window
                        #if(showGlass)
                                box { <4, 30, -30> <13, 45, -29.75> material { windowGlass scale <9, 15, 1> translate  <8.5, 30, 0> } }
                        #end
                        // large window
                        intersection
                        {
                                difference
                                {
                                        Round_Box_Union(<16.75, 29.75, -35>, <37.25, 45.25, -22>, 5 )
                                        Round_Box_Union(<17.5, 30.5, -35>, <37.5, 44.5, -22>, 5 )
                                }                                            
                                box { <16, 29, -30.75> <32, 46, -29.25> }
                                bounded_by { box { <16, 29, -30.75> <32, 46, -29.25> } } 
                                texture { paintTex3 }
                        }  
                        
                        // side square with number 6100 on it
                        union
                        {
                                union
                                {
                                        box { <0, 3, -30.5001> <30, 26, -30.49> } 
                                        box { <3, 0, -30.5001> <30, 26, -30.49> }
                                        cylinder { <3, 3, -30.5001> <3, 3, -30.49> 3 } 
                                
                                        texture { paintTex2 }   
                                }
                                union
                                {
                                        box { <1, 4, -30.5002> <29, 25, -30.49> } 
                                        box { <4, 1, -30.5002> <29, 25, -30.49> }
                                        cylinder { <4, 4, -30.5002> <4, 4, -30.49> 3 } 
                                
                                        texture { paintTex3 }   
                                }
                                union
                                {
                                        box { <1.25, 4.25, -30.5003> <28.75, 24.75, -30.49> } 
                                        box { <4.25, 1.25, -30.5003> <28.75, 24.75, -30.49> }
                                        cylinder { <4.25, 4.25, -30.5003> <4.25, 4.25, -30.49> 3 } 
                                
                                        texture { paintTex1 }   
                                }  
                                text { ttf "century.ttf", "6100", 0.1, 0 scale <12, 12, 1> translate <2.3, 8.6, -30.5005> texture { paintTex2 } }
                                text { ttf "century.ttf", "6100", 0.1, 0 scale <12, 12, 1> translate <2.0, 9, -30.50055> texture { paintTex3 } }
                        }  
                        
                        // steps up to pole    
                        // right side
                        union
                        {
                                difference
                                {
                                        box { <-8, -19, 0> <8, -2, 0.5> }
                                        cylinder { <0, 0, -0.1> <0, 0, 0.6> 10 scale <1, 1.5, 1> rotate <0, 0, 45> scale <1, 0.7, 1> translate <-11.5, -11.5, 0> }
                                        texture { paintTex2 }
                                }
                                difference
                                {
                                        box { <-7, -18, 0> <7, -3, 0.5> }
                                        cylinder { <0, 0, -0.1> <0, 0, 0.6> 10 scale <1, 1.5, 1> rotate <0, 0, 45> scale <1, 0.75, 1> translate <-10.75, -11.25, 0> }
                                        translate <0, 0, -0.001> 
                                        texture { paintTex3 }
                                }
                                difference
                                {
                                        box { <-6.5, -17.5, 0> <6.5, -3.5, 0.5> }
                                        cylinder { <0, 0, -0.1> <0, 0, 0.6> 10 scale <1, 1.5, 1> rotate <0, 0, 45> scale <1, 0.775, 1> translate <-10.4, -11.1, 0> }
                                        translate <0, 0, -0.002> 
                                        texture { paintTex1 }
                                }
        
                                union
                                { 
                                        Round_Box_Union(<-4.75, -19.5, -0.2>, <4.75, -17.5, 0.7>, 0.1)
                                        difference
                                        {
                                                intersection
                                                {
                                                        object { Round_Box_Union(<-4.5, -19.4, -4>, <4.5, -19, 0>, 0.05) }
                                                        object { Round_Cylinder_Union(<0, -19.401, 0>, <0, -18.99, 0>, 5, 0.05) }
                                                }
                                        
                                                #declare cp = -10;
                                                #while(cp < 10)
                                                        cylinder { <0, -19, -10> <0, -19, 10> 0.075 rotate <0, -45, 0> translate <cp, 0, 0> }
                                                        cylinder { <0, -19, -10> <0, -19, 10> 0.075 rotate <0, 45, 0> translate <cp, 0, 0> } 
                                                        #declare cp = cp+1;
                                                #end                                 
                                        }  
                                        translate <3.75, -0.5, 0>               
                                        texture { paintTex2 }
                                }
                                union
                                { 
                                        Round_Box_Union(<-4.75, -10, -0.2>, <4.75, -8, 0.7>, 0.1)
                                        difference
                                        {
                                                intersection
                                                {
                                                        object { Round_Box_Union(<-4.5, -9.9, -4>, <4.5, -9.5, 0>, 0.05) }
                                                        object { Round_Cylinder_Union(<0, -9.901, 0>, <0, -9.499, 0>, 5, 0.05) }
                                                }
                                        
                                                #declare cp = -10;
                                                #while(cp < 10)
                                                        cylinder { <0, -9.5, -10> <0, -9.5, 10> 0.075 rotate <0, -45, 0> translate <cp, 0, 0> }
                                                        cylinder { <0, -9.5, -10> <0, -9.5, 10> 0.075 rotate <0, 45, 0> translate <cp, 0, 0> } 
                                                        #declare cp = cp+1;
                                                #end                                 
                                        }  
                                        translate <3.75, -2, 0>               
                                        texture { paintTex2 }
                                }
                
                                translate <25, 1, -30>
                        }     
                        
                        // pole 
                        // bottom part
                        union
                        {       
                                // base
                                union
                                {       cone { <0, 0, 0> 1 <0, 2.5, 0> 0.7 }
                                        torus { 0.2, 0.5 translate <0, 2.5, 0> }
                                        texture { poleBaseTex }
                                }    
                                torus { 0.5, 0.1 translate <0, 29.7, 0> }
                                cylinder { <0, 0, 0> <0, 30, 0> 0.475 }
                                torus { 0.325, 0.1 translate <0, 30.55, 0> }
                                cylinder { <0, 30, 0> <0, 45, 0> 0.3 }
                                torus { 0.325, 0.1 translate <0, 44.45, 0> }
                                
                                texture { poleTex }
                                translate <31.5, 0, -29.5> 
                        }
                }

                // left side (facing front of engine)
                union
                {
                        difference 
                        {
                                box { <0, 0, -30.5> <32, 50, -29.5> }  
                                union // cut out window holes
                                {
                                        Round_Box_Union(<4, 30, -33>, <13, 45, -26>, 2 )
                                        Round_Box_Union(<17, 30, -35>, <37, 45, -22>, 5 )
                                        box { <30, -0.1, -31> <33, 35, -29> }
                                }
                        } 
                        // black paint around windows
                        // small window
                        intersection
                        {
                                difference
                                {
                                        Round_Box_Union(<2.75, 28.75, -33>, <14.25, 46.25, -26>, 2 )
                                        Round_Box_Union(<4.0, 30.0, -33>, <13.0, 45, -26>, 2 )
                                }                                            
                                box { <2, 28, -30.5001> <15, 47, -30.25> }
                                bounded_by { box { <2, 28, -30.5001> <15, 47, -30.25> } } 
                                texture { paintTex2 }
                        }  
                        // black paint aruont large window
                        intersection
                        {
                                difference
                                {
                                        Round_Box_Union(<15.75, 28.75, -35>, <38.25, 46.25, -22>, 5 )
                                        Round_Box_Union(<17, 30, -35>, <38, 45, -22>, 5 )
                                }                                            
                                box { <15, 28, -30.5001> <32, 47, -30.25> }
                                bounded_by { box { <15, 28, -30.5001> <32, 47, -30.25> } } 
                                texture { paintTex2 }
                        }
                                 
                        // gold paint around windows
                        // small window
                        intersection
                        {
                                difference
                                {
                                        Round_Box_Union(<2.5, 28.5, -33>, <14.5, 46.5, -26>, 2 )
                                        Round_Box_Union(<4.0, 30.0, -33>, <13.0, 45, -26>, 2 )
                                }                                            
                                box { <2, 28, -30.50001> <15, 47, -30.25> }
                                bounded_by { box { <2, 28, -30.50001> <15, 47, -30.25> } } 
                                texture { paintTex3 }
                        }  
                        // gold paint aruont large window
                        intersection
                        {
                                difference
                                {
                                        Round_Box_Union(<15.5, 28.5, -35>, <38.5, 46.5, -22>, 5 )
                                        Round_Box_Union(<17, 30, -35>, <38, 45, -22>, 5 )
                                }                                            
                                box { <15, 28, -30.50001> <32, 47, -30.25> }
                                bounded_by { box { <15, 28, -30.50001> <32, 47, -30.25> } } 
                                texture { paintTex3 }
                        }
                        
        
                        // window frames
                        // small window
                        intersection
                        {
                                difference
                                {
                                        Round_Box_Union(<3.75, 29.75, -33>, <13.25, 45.25, -26>, 2 )
                                        Round_Box_Union(<4.5, 30.5, -33>, <12.5, 44.5, -26>, 2 )
                                }                                            
                                box { <3, 29, -30.75> <14, 46, -29.25> }
                                bounded_by { box { <3, 29, -30.75> <14, 46, -29.25> } } 
                                texture { paintTex3 }
                        }  
                        // glass for small side window   
                        #if(showGlass)
                                box { <4, 30, -30> <13, 45, -29.75> material { windowGlass scale <9, 15, 1> translate <8.5, 30, 0> } }
                        #end
                        // large window
                        intersection
                        {
                                difference
                                {
                                        Round_Box_Union(<16.75, 29.75, -35>, <37.25, 45.25, -22>, 5 )
                                        Round_Box_Union(<17.5, 30.5, -35>, <37.5, 44.5, -22>, 5 )
                                }                                            
                                box { <16, 29, -30.75> <32, 46, -29.25> }
                                bounded_by { box { <16, 29, -30.75> <32, 46, -29.25> } } 
                                texture { paintTex3 }
                        }  
                        
                        // side square with number 6100 on it
                        union
                        {
                                union
                                {
                                        box { <0, 3, -30.5001> <30, 26, -30.49> } 
                                        box { <3, 0, -30.5001> <30, 26, -30.49> }
                                        cylinder { <3, 3, -30.5001> <3, 3, -30.49> 3 } 
                                
                                        texture { paintTex2 }   
                                }
                                union
                                {
                                        box { <1, 4, -30.5002> <29, 25, -30.49> } 
                                        box { <4, 1, -30.5002> <29, 25, -30.49> }
                                        cylinder { <4, 4, -30.5002> <4, 4, -30.49> 3 } 
                                
                                        texture { paintTex3 }   
                                }
                                union
                                {
                                        box { <1.25, 4.25, -30.5003> <28.75, 24.75, -30.49> } 
                                        box { <4.25, 1.25, -30.5003> <28.75, 24.75, -30.49> }
                                        cylinder { <4.25, 4.25, -30.5003> <4.25, 4.25, -30.49> 3 } 
                                
                                        texture { paintTex1 }   
                                }  
                                text { ttf "century.ttf", "6100", 0.1, 0 scale <12, 12, 1> translate <2.3, 8.6, -30.5005> scale <-1, 1, 1> translate <29.9, 0, 0>  texture { paintTex2 } }
                                text { ttf "century.ttf", "6100", 0.1, 0 scale <12, 12, 1> translate <2.0, 9, -30.50055>  scale <-1, 1, 1> translate <29.9, 0, 0>  texture { paintTex3 } }
                        }  
                        
                        // steps up to pole    
                        // right side
                        union
                        {
                                difference
                                {
                                        box { <-8, -19, 0> <8, -2, 0.5> }
                                        cylinder { <0, 0, -0.1> <0, 0, 0.6> 10 scale <1, 1.5, 1> rotate <0, 0, 45> scale <1, 0.7, 1> translate <-11.5, -11.5, 0> }
                                        texture { paintTex2 }
                                }
                                difference
                                {
                                        box { <-7, -18, 0> <7, -3, 0.5> }
                                        cylinder { <0, 0, -0.1> <0, 0, 0.6> 10 scale <1, 1.5, 1> rotate <0, 0, 45> scale <1, 0.75, 1> translate <-10.75, -11.25, 0> }
                                        translate <0, 0, -0.001> 
                                        texture { paintTex3 }
                                }
                                difference
                                {
                                        box { <-6.5, -17.5, 0> <6.5, -3.5, 0.5> }
                                        cylinder { <0, 0, -0.1> <0, 0, 0.6> 10 scale <1, 1.5, 1> rotate <0, 0, 45> scale <1, 0.775, 1> translate <-10.4, -11.1, 0> }
                                        translate <0, 0, -0.002> 
                                        texture { paintTex1 }
                                }
        
                                union
                                { 
                                        Round_Box_Union(<-4.75, -19.5, -0.2>, <4.75, -17.5, 0.7>, 0.1)
                                        difference
                                        {
                                                intersection
                                                {
                                                        object { Round_Box_Union(<-4.5, -19.4, -4>, <4.5, -19, 0>, 0.05) }
                                                        object { Round_Cylinder_Union(<0, -19.401, 0>, <0, -18.99, 0>, 5, 0.05) }
                                                }
                                        
                                                #declare cp = -10;
                                                #while(cp < 10)
                                                        cylinder { <0, -19, -10> <0, -19, 10> 0.075 rotate <0, -45, 0> translate <cp, 0, 0> }
                                                        cylinder { <0, -19, -10> <0, -19, 10> 0.075 rotate <0, 45, 0> translate <cp, 0, 0> } 
                                                        #declare cp = cp+1;
                                                #end                                 
                                        }  
                                        translate <3.75, -0.5, 0>               
                                        texture { paintTex2 }
                                }
                                union
                                { 
                                        Round_Box_Union(<-4.75, -10, -0.2>, <4.75, -8, 0.7>, 0.1)
                                        difference
                                        {
                                                intersection
                                                {
                                                        object { Round_Box_Union(<-4.5, -9.9, -4>, <4.5, -9.5, 0>, 0.05) }
                                                        object { Round_Cylinder_Union(<0, -9.901, 0>, <0, -9.499, 0>, 5, 0.05) }
                                                }
                                        
                                                #declare cp = -10;
                                                #while(cp < 10)
                                                        cylinder { <0, -9.5, -10> <0, -9.5, 10> 0.075 rotate <0, -45, 0> translate <cp, 0, 0> }
                                                        cylinder { <0, -9.5, -10> <0, -9.5, 10> 0.075 rotate <0, 45, 0> translate <cp, 0, 0> } 
                                                        #declare cp = cp+1;
                                                #end                                 
                                        }  
                                        translate <3.75, -2, 0>               
                                        texture { paintTex2 }
                                }
                
                                translate <25, 1, -30>
                        }     
                        
                        // pole 
                        // bottom part
                        union
                        {       
                                // base
                                union
                                {       cone { <0, 0, 0> 1 <0, 2.5, 0> 0.7 }
                                        torus { 0.2, 0.5 translate <0, 2.5, 0> }
                                        texture { poleBaseTex }
                                }    
                                torus { 0.5, 0.1 translate <0, 29.7, 0> }
                                cylinder { <0, 0, 0> <0, 30, 0> 0.475 }
                                torus { 0.325, 0.1 translate <0, 30.55, 0> }
                                cylinder { <0, 30, 0> <0, 45, 0> 0.3 }
                                torus { 0.325, 0.1 translate <0, 44.45, 0> }
                                
                                texture { poleTex }
                                translate <31.5, 0, -29.5> 
                        }
                        scale <1, 1, -1>
                }
                
                // front part of cabin
                intersection
                {
                        difference
                        {
                                box { <-0.5, 0, -30.5> <0, 60, 30.5> }  
                                box { <-0.51, -0.1, 15> <0.1, 10, 21> }  
                                box { <-0.51, -0.1, -21> <0.1, 10, -15> }  
                                // cut out window
                                intersection
                                {
                                        union
                                        {
                                                box { <-0.51, 34, -29> <0.1, 60, -23> }
                                                box { <-0.51, 34, 23> <0.1, 60, 29> }
                                        }
                                        cylinder { <-0.52, 3, 0> <0.1, 3, 0> 54 }   
                                }                        
                        }
                        cylinder { <-0.51, 4.5, 0> <0.1, 4.5, 0> 54 }   
                            
                        texture { paintTex1 }
                }   
                // window frames for front part of cabin
                difference
                {
                        intersection
                        {
                                box { <-0.75, 0, -30.5> <0.1, 60, 30.5> }  
                                // cut out window
                                intersection
                                {
                                        union
                                        {
                                                box { <-0.751, 33.5, -29.5> <0.2, 60, -22.5> }
                                                box { <-0.751, 33.5, 22.5> <0.2, 60, 29.5> }
                                        }
                                        cylinder { <-0.752, 3.5, 0> <0.25, 3.5, 0> 54 }   
                                }   
                        }                     
                        intersection
                        {
                                union
                                {
                                        box { <-0.81, 34, -29> <0.4, 60, -23> }
                                        box { <-0.81, 34, 23> <0.4, 60, 29> }
                                }
                                cylinder { <-0.82, 3, 0> <0.45, 3, 0> 54 }   
                        }                        
                                    
                        texture { paintTex1 }
                }  
                // glass for front part of cabin
                #if(showGlass)
                        intersection
                        {
                                box { <-0.3, 33, -30> <-0.1, 60, 30> }  
                                cylinder { <-0.32, 3, 0> <-0.05, 3, 0> 54 }
                                material { windowGlass scale <6.2, 18, 1> rotate <0, 90, 0> translate <0, 33, -30.5>  }   
        
        
                        }
                #end
                // floor
                // back part at bottom 
                box { <34, -10, -30.5> <35.05, 0, 30.5> }
                // actual floor
                union
                {
                        box { <5, -0.5, -30> <34, 0.025, 30> } 
                        box { <4, -0.4, -30> <5, 10, 30> }
                        box { <0, 9, -30> <5, 10, 30> }     
                        
                        texture { paintTex2 }       //TO_DO check this texture
                }
                // plates that bridge gap between cabin and coal truck        
                // current part
                union
                {
                        Round_Cylinder_Union(<30, 1.0, -26>, <30, 1.0, -4>, 0.5, 0.1)
                        Round_Cylinder_Union(<30, 1.0, -25.5>, <30, 1.0, -4.5>, 0.65, 0.1)
                        box { <29.5, -1, -25> <30.5, 1, -5> }                        
                        difference
                        {
                                object { Round_Box_Union(<0, 0.0, -25>, <18, 1.0, -5>, 0.3)  }
                                union
                                {             
                                        #declare plateCutter = -24;
                                        #while(plateCutter < -5)
                                                cylinder { <1, 1, plateCutter> <17, 1, plateCutter> 0.2 }
                                                #declare plateCutter = plateCutter+2;
                                        #end     
                                        #declare plateCutter = 1;
                                        #while(plateCutter < 18)
                                                cylinder { <plateCutter, 1, -24> <plateCutter, 1, -6> 0.2 }
                                                
                                                #declare plateCutter = plateCutter+2;
                                        #end     
                                        texture { footPlateTex } 
//                                        texture { dirtTex scale 0.25 }
                                                 
                                        
                                }
                                
                        rotate <0, 0, -5> translate <30, 0.5, 0> }
                        
                        
                        texture { footPlateTex } 
                       
                }
                union
                {
                        Round_Cylinder_Union(<30, 1.0, -26>, <30, 1.0, -4>, 0.5, 0.1)
                        Round_Cylinder_Union(<30, 1.0, -25.5>, <30, 1.0, -4.5>, 0.65, 0.1)
                        box { <29.5, -1, -25> <30.5, 1, -5> }                        
                        difference
                        {
                                object { Round_Box_Union(<0, 0.0, -25>, <18, 1.0, -5>, 0.3)  }
                                union
                                {             
                                        #declare plateCutter = -24;
                                        #while(plateCutter < -5)
                                                cylinder { <1, 1, plateCutter> <17, 1, plateCutter> 0.2 }
                                                #declare plateCutter = plateCutter+2;
                                        #end     
                                        #declare plateCutter = 1;
                                        #while(plateCutter < 18)
                                                cylinder { <plateCutter, 1, -24> <plateCutter, 1, -6> 0.2 }
                                                
                                                #declare plateCutter = plateCutter+2;
                                        #end     
                                        texture { footPlateTex } 
 //                                       texture { dirtTex scale 0.25 }
                                        
                                }
                                
                        rotate <0, 0, -5> translate <30, 0.5, 0> }
                        
                        scale <1, 1, -1> 
                        
                        texture { footPlateTex } 
                }

                // box part under cabin 
                object 
                {
                        Round_Box_Union(<6, -12, -28>, <30, -1, 28>, 3)
                        texture { paintTex2 }
                }
                        
                // roof
                union
                {
                        difference
                        {
                                cylinder { <-0.75, 0, 0> <45, 0, 0> 55 }
                                cylinder { <-0.8, 0, 0> <45.1, 0, 0> 54 }  
                                box { <-0.8, -56, -56> <45.1, 0, 56> rotate <56, 0, 0> }
                                box { <-0.8, -56, -56> <45.1, 0, 56> rotate <-56, 0, 0> } 
                                cylinder { <0, 0, 0> <0, 60, 0> 13 translate <45, 0, -31> }
                                cylinder { <0, 0, 0> <0, 60, 0> 13 translate <45, 0, 31> }
                                translate <0, 4.5, 0>
                        }                           
                        difference
                        {
                                cylinder { <-0.75, 0, 0> <45, 0, 0> 0.5 translate <0, 0, -54.5> rotate <56, 0, 0> translate <0, 4.5, 0> }
                                cylinder { <0, 0, 0> <0, 60, 0> 13 translate <45, 0, -31> }
                        }
                        difference
                        {
                                cylinder { <-0.75, 0, 0> <45, 0, 0> 0.5 translate <0, 0, 54.5> rotate <-56, 0, 0> translate <0, 4.5, 0> }
                                cylinder { <0, 0, 0> <0, 60, 0> 13 translate <45, 0, 31> }
                        }
                        // black part
                        union
                        {
                                difference
                                {
                                        cylinder { <-0.75, 0, 0> <45, 0, 0> 55.5 }
                                        cylinder { <-0.8, 0, 0> <45.1, 0, 0> 55 }  
                                        box { <-0.8, -56, -56> <45.1, 0, 56> rotate <71, 0, 0> }
                                        box { <-0.8, -56, -56> <45.1, 0, 56> rotate <-71, 0, 0> } 
                                        translate <0, 4.5, 0>                     
                                }                           
                                cylinder { <-0.75, 0, 0> <45, 0, 0> 0.25 translate <0, 0, -55.25> rotate <71, 0, 0> translate <0, 4.5, 0> }
                                cylinder { <-0.75, 0, 0> <45, 0, 0> 0.25 translate <0, 0, 55.25> rotate <-71, 0, 0> translate <0, 4.5, 0> }
                                
                                // rivets
                                union
                                {
                                        #declare rp = 1.5;
                                        #while ( rp < 44)
                                                sphere { <0, 0, 0> 0.3 scale <1, 1, 0.6> translate <rp, 0, -55.51> rotate <72, 0, 0> translate <0, 4.5, 0> }
                                                sphere { <0, 0, 0> 0.3 scale <1, 1, 0.6> translate <rp, 0, 55.51> rotate <-72, 0, 0> translate <0, 4.5, 0> }
                                                #declare rp=rp+1.5;
                                        #end
                                        #declare rp = 74;
                                        #while ( rp < 107)
                                                sphere { <0, 0, 0> 0.3 scale <1, 1, 0.6> translate <1.5, 0, -55.51> rotate <rp, 0, 0> translate <0, 4.5, 0> }
                                                sphere { <0, 0, 0> 0.3 scale <1, 1, 0.6> translate <25.5, 0, -55.51> rotate <rp, 0, 0> translate <0, 4.5, 0> }
                                                sphere { <0, 0, 0> 0.3 scale <1, 1, 0.6> translate <27, 0, -55.51> rotate <rp, 0, 0> translate <0, 4.5, 0> }
                                                sphere { <0, 0, 0> 0.3 scale <1, 1, 0.6> translate <43.5, 0, -55.51> rotate <rp, 0, 0> translate <0, 4.5, 0> }
                                                #declare rp=rp+2;
                                        #end
                                         
                                }
                                texture { paintTex2 }
                        }                           


                }                
                texture { paintTex1 }
                translate <200, -10, 0>
        }   
        // rear coupling
        object { coupling translate <242.5, -16, 0>  }     
                        
}          

#declare coalTruckWheel = union
{          
        union
        {       
                Round_Cone_Union(<0, 0, 3>, 11.25, <0, 0, 4>, 12, 0.3)
                 
                difference
                {
                        Round_Cylinder_Union(<0, 0, 0>, <0, 0, 3>, 11, 1)
                        cone { <0, 0, -0.1> 8.5 <0, 0, 1.5> 4 }
                }
                mkWheelRimTex(0, dummyTex)
        }      
        object { driveShaft }
}


#declare coalTruck = union
{
        
                             
        // underneath part that coupling is attached to
        union
        {
                object { Round_Box_Union(<4, -10, -4>, <116, 0, 4>, 0.6) }
                object { Round_Box_Union(<4, -11, -10>, <116, -9, 10>, 0.6) }
                object { Round_Box_Union(<4, -2, -10>, <116, 0, 10>, 0.6) }     
                texture { couplingTex }
                                     
        }
        // right side   
        // outer red part 
        
        difference
        {
                union
                {
                        difference
                        {
                                object { Round_Box_Union(<3, 0, -31>, <120, 46, -30>, 0.2) }
                                box { <-0.1, 45, -31.1> <120.1, 46.17, -29.9> }
                        }  
                        difference 
                        {
                                cylinder { <0, 0, 0> <120, 0, 0> 10 }
                                torus { 9.2 0.2 rotate <0, 0, 90> translate <0.2, 0, 0> }
                                torus { 9.2 0.2 rotate <0, 0, 90> translate <119.8, 0, 0> }
                                cylinder { <-0.1, 0, 0> <120.1, 0, 0> 9 } 
                                box { <-0.1, -10.1, -10.1> <120.1, 0, 10.1> }     
                                box { <-0.1, -10.1, 0> <120.1, 10.1, 10.1> rotate <-30, 0, 0> }     
                                translate <0, 45, -21>
                        }
                } 
                cylinder { <0, 53, -32> <0, 53, -20> 10 scale <1.6, 1, 1> translate <0, 0, 0> } 
                cylinder { <0, 53, -32> <0, 53, -20> 10 scale <1.6, 1, 1> translate <110, 0, 0> } 
                box { <110, 43, -32> <130, 63, -20> }
        }      
        // black part at bottom
        box { <4, 1, -31.001> <119, 41, -30.9> texture { paintTex2 } }
        // gold part at bottom
        box { <5, 2, -31.002> <118, 40, -30.9> texture { paintTex3 } }
        // Red part at bottom with LMS on it
        box { <5.5, 2.5, -31.003> <117.5, 39.5, -30.9> texture { paintTex1 } }
        // LMS
        text { ttf "century.ttf", "L     M     S", 0.1, 0 scale <8, 8, 1> translate <40.3, 17.1, -31.005> texture { paintTex2 } }
        text { ttf "century.ttf", "L     M     S", 0.1, 0 scale <8, 8, 1> translate <40.0, 17.5, -31.0055> texture { paintTex3 } }
        
        // border around top curved part       
        // black part
        difference
        {
                union
                {
                        difference
                        {
                                object { Round_Box_Union(<4, 41.5, -31>, <119, 46, -30>, 0.2) }
                                box { <-0.1, 45, -31.1> <120.1, 46.17, -29.9> }
                        }  
                        difference 
                        {
                                cylinder { <1, 0, 0> <119, 0, 0> 10 }
                                cylinder { <-0.1, 0, 0> <120.1, 0, 0> 9 } 
                                box { <-0.1, -10.1, -10.1> <120.1, 0, 10.1> }     
                                box { <-0.1, -10.1, 0> <120.1, 10.1, 10.1> rotate <-37, 0, 0> }     
                                translate <0, 45, -21>
                        }
                } 
                cylinder { <0, 53, -32> <0, 53, -20> 10 scale <1.6, 1, 1> translate <1, -0.5, 0> } 
                cylinder { <0, 53, -32> <0, 53, -20> 10 scale <1.6, 1, 1> translate <109, -0.5, 0> } 
                box { <109, 42.5, -32> <130, 63, -20> }       
                translate <0, 0, -0.001>
                texture { paintTex2 }
        }      
        // gold part
        difference
        {
                union
                {
                        difference
                        {
                                object { Round_Box_Union(<5, 42.5, -31>, <118, 46, -30>, 0.2) }
                                box { <-0.1, 45, -31.1> <120.1, 46.17, -29.9> }
                        }  
                        difference 
                        {
                                cylinder { <3, 0, 0> <118, 0, 0> 10 }
                                cylinder { <-0.1, 0, 0> <120.1, 0, 0> 9 } 
                                box { <-0.1, -10.1, -10.1> <120.1, 0, 10.1> }     
                                box { <-0.1, -10.1, 0> <120.1, 10.1, 10.1> rotate <-44, 0, 0> }     
                                translate <0, 45, -21>
                        }
                } 
                cylinder { <0, 53, -32> <0, 53, -20> 10 scale <1.6, 1, 1> translate <2, -1.0, 0> } 
                cylinder { <0, 53, -32> <0, 53, -20> 10 scale <1.6, 1, 1> translate <108, -1.0, 0> } 
                box { <108, 42.0, -32> <130, 63, -20> }       
                translate <0, 0, -0.002>
                texture { paintTex3 }
        }      
        // red part
        difference
        {
                union
                {
                        difference
                        {
                                object { Round_Box_Union(<5.5, 43, -31>, <117.5, 46, -30>, 0.2) }
                                box { <-0.1, 45, -31.1> <120.1, 46.17, -29.9> }
                        }  
                        difference 
                        {
                                cylinder { <3.5, 0, 0> <117.5, 0, 0> 10 }
                                cylinder { <-0.1, 0, 0> <120.1, 0, 0> 9 } 
                                box { <-0.1, -10.1, -10.1> <120.1, 0, 10.1> }     
                                box { <-0.1, -10.1, 0> <120.1, 10.1, 10.1> rotate <-47.5, 0, 0> }     
                                translate <0, 45, -21>
                        }
                } 
                cylinder { <0, 53, -32> <0, 53, -20> 10 scale <1.6, 1, 1> translate <2.5, -1.25, 0> } 
                cylinder { <0, 53, -32> <0, 53, -20> 10 scale <1.6, 1, 1> translate <107.5, -1.25, 0> } 
                box { <107.5, 41.75, -32> <130, 63, -20> }       
                translate <0, 0, -0.003>
                texture { paintTex1 }
        }      
        
        
        // pole 
        // bottom part
        union
        {       
                // base
                union
                {       cone { <0, 0, 0> 1 <0, 2.5, 0> 0.7 }
                        torus { 0.2, 0.5 translate <0, 2.5, 0> }
                        texture { poleBaseTex }
                }    
                Round_Cylinder_Union(<0, 0, 0>, <0, 41, 0>, 0.475, 0.1)
                Round_Cylinder_Union(<0, 40.5, 0>, <0, 41.5, 0>, 0.65, 0.25)
                Round_Cylinder_Union(<0, 38.5, 0>, <0, 40.0, 0>, 0.6, 0.1)
                cylinder { <0, 39.25, 0> <3, 39.25, 0> 0.375 }      
                
                // bracked to hold pole onto side of truck
                union
                {
                        Round_Box_Union(<0, -1.5, -0.5>, <4, 1.5, -0.1>, 0.25)
                        difference
                        {
                                object { Round_Cylinder_Union(<0, 0, 0>, <3.5, 0, 0>, 0.5, 0.2)  }
                                cylinder { <-0.1, 0, 0> <3, 0, 0> 0.4  }
                        }    
                        sphere { <0.5, 1, -0.1> 0.2 }
                        sphere { <3.5, 1, -0.1> 0.2 }
                        sphere { <0.5, -1, -0.1> 0.2 }
                        sphere { <3.5, -1, -0.1> 0.2 }
                         
                        translate <1.6, 39.25, 0>  
                }
                
                texture { poleTex }
                translate <1.5, 0, -29.5> 
        }
                                                             
        
        // left side
        difference
        {
                union
                {
                        difference
                        {
                                object { Round_Box_Union(<3, 0, 30>, <120, 46, 31>, 0.2) }
                                box { <-0.1, 45, 29.9> <120.1, 46.17, 31.1> }
                        }  
                        difference 
                        {
                                cylinder { <0, 0, 0> <120, 0, 0> 10 }
                                torus { 9.2 0.2 rotate <0, 0, 90> translate <0.2, 0, 0> }
                                torus { 9.2 0.2 rotate <0, 0, 90> translate <119.8, 0, 0> }
                                cylinder { <-0.1, 0, 0> <120.1, 0, 0> 9 } 
                                box { <-0.1, -10.1, -10.1> <120.1, 0, 10.1> }     
                                box { <-0.1, -10.1, -10.1> <120.1, 10.1, 0> rotate <30, 0, 0> }     
                                translate <0, 45, 21>
                        }
                } 
                cylinder { <0, 53, 20> <0, 53, 32> 10 scale <1.6, 1, 1> translate <0, 0, 0> } 
                cylinder { <0, 53, 20> <0, 53, 32> 10 scale <1.6, 1, 1> translate <110, 0, 0> } 
                box { <110, 43, 20> <130, 63, 32> }
        }                                                              
        // black part at bottom
        box { <4, 1, 30.9> <119, 41, 31.001> texture { paintTex2 } }
        // gold part at bottom
        box { <5, 2, 30.9> <118, 40, 31.002> texture { paintTex3 } }
        // Red part at bottom with LMS on it
        box { <5.5, 2.5, 30.9> <117.5, 39.5, 31.003> texture { paintTex1 } }
        // LMS  NEED TO POSITION THIS CORRECTLY
        text { ttf "century.ttf", "L     M     S", 0.1, 0 scale <8, 8, 1> rotate <0, 180, 0> translate <80.3, 17.1, 31.005> texture { paintTex2 } }
        text { ttf "century.ttf", "L     M     S", 0.1, 0 scale <8, 8, 1> rotate <0, 180, 0> translate <80.0, 17.5, 31.0055> texture { paintTex3 } }
        
//        box { <-1, 22.4, 30> <120, 22.6, 31.2> pigment { Green } }
//        box { <59.9, 0, 30> <60.1, 50, 31.2> pigment { Green } }
         
        // border around top curved part       
        // black part
        difference
        {
                union
                {
                        difference
                        {
                                object { Round_Box_Union(<4, 41.5, 30>, <119, 46, 31>, 0.2) }
                                box { <-0.1, 45, 29.9> <120.1, 46.17, 31.1> }
                        }  
                        difference 
                        {
                                cylinder { <1, 0, 0> <119, 0, 0> 10 }
                                cylinder { <-0.1, 0, 0> <120.1, 0, 0> 9 } 
                                box { <-0.1, -10.1, -10.1> <120.1, 0, 10.1> }     
                                box { <-0.1, -10.1, -10.1> <120.1, 10.1, 0> rotate <37, 0, 0> }     
                                translate <0, 45, 21>
                        }
                } 
                cylinder { <0, 53, 20> <0, 53, 32> 10 scale <1.6, 1, 1> translate <1, -0.5, 0> } 
                cylinder { <0, 53, 20> <0, 53, 32> 10 scale <1.6, 1, 1> translate <109, -0.5, 0> } 
                box { <109, 42.5, 20> <130, 63, 32> }       
                translate <0, 0, 0.001>
                texture { paintTex2 }
        }      
        // gold part
        difference
        {
                union
                {
                        difference
                        {
                                object { Round_Box_Union(<5, 42.5, 30>, <118, 46, 31>, 0.2) }
                                box { <-0.1, 45, 29.9> <120.1, 46.17, 31.1> }
                        }  
                        difference 
                        {
                                cylinder { <3, 0, 0> <118, 0, 0> 10 }
                                cylinder { <-0.1, 0, 0> <120.1, 0, 0> 9 } 
                                box { <-0.1, -10.1, -10.1> <120.1, 0, 10.1> }     
                                box { <-0.1, -10.1, -10.1> <120.1, 10.1, 0> rotate <44, 0, 0> }     
                                translate <0, 45, 21>
                        }
                } 
                cylinder { <0, 53, 20> <0, 53, 32> 10 scale <1.6, 1, 1> translate <2, -1.0, 0> } 
                cylinder { <0, 53, 20> <0, 53, 32> 10 scale <1.6, 1, 1> translate <108, -1.0, 0> } 
                box { <108, 42.0, 20> <130, 63, 32> }       
                translate <0, 0, 0.002>
                texture { paintTex3 }
        }      
        // red part
        difference
        {
                union
                {
                        difference
                        {
                                object { Round_Box_Union(<5.5, 43, 30>, <117.5, 46, 31>, 0.2) }
                                box { <-0.1, 45, 29.9> <120.1, 46.17, 31.1> }
                        }  
                        difference 
                        {
                                cylinder { <3.5, 0, 0> <117.5, 0, 0> 10 }
                                cylinder { <-0.1, 0, 0> <120.1, 0, 0> 9 } 
                                box { <-0.1, -10.1, -10.1> <120.1, 0, 10.1> }     
                                box { <-0.1, -10.1, -10.1> <120.1, 10.1, 0> rotate <47.5, 0, 0> }     
                                translate <0, 45, 21>
                        }
                } 
                cylinder { <0, 53, 20> <0, 53, 32> 10 scale <1.6, 1, 1> translate <2.5, -1.25, 0> } 
                cylinder { <0, 53, 20> <0, 53, 32> 10 scale <1.6, 1, 1> translate <107.5, -1.25, 0> } 
                box { <107.5, 41.75, 20> <130, 63, 32> }       
                translate <0, 0, 0.003>
                texture { paintTex1 }
        }      
        
        

        
        // pole 
        // bottom part
        union
        {       
                // base
                union
                {       cone { <0, 0, 0> 1 <0, 2.5, 0> 0.7 }
                        torus { 0.2, 0.5 translate <0, 2.5, 0> }
                        texture { poleBaseTex }
                }    
                Round_Cylinder_Union(<0, 0, 0>, <0, 41, 0>, 0.475, 0.1)
                Round_Cylinder_Union(<0, 40.5, 0>, <0, 41.5, 0>, 0.65, 0.25)
                Round_Cylinder_Union(<0, 38.5, 0>, <0, 40.0, 0>, 0.6, 0.1)
                cylinder { <0, 39.25, 0> <3, 39.25, 0> 0.375 }      
                
                // bracked to hold pole onto side of truck
                union
                {
                        Round_Box_Union(<0, -1.5, 0.1>, <4, 1.5, 0.5>, 0.25)
                        difference
                        {
                                object { Round_Cylinder_Union(<0, 0, 0>, <3.5, 0, 0>, 0.5, 0.2)  }
                                cylinder { <-0.1, 0, 0> <3, 0, 0> 0.4  }
                        }    
                        sphere { <0.5, 1, 0.1> 0.2 }
                        sphere { <3.5, 1, 0.1> 0.2 }
                        sphere { <0.5, -1, 0.1> 0.2 }
                        sphere { <3.5, -1, 0.1> 0.2 }
                         
                        translate <1.6, 39.25, 0>  
                }
                
                texture { poleTex }
                translate <1.5, 0, 29.5> 
        }
        
        // wall part that keeps coal in 
        intersection
        {
                box { <16, 25, -30.5> <16.5, 53.5, 30.5> }    
                union
                {
                        cylinder { <-0.1, 0, 0> <120.1, 0, 0> 9.99 translate <0, 45, 21> } 
                        cylinder { <-0.1, 0, 0> <120.1, 0, 0> 9.99 translate <0, 45, -21> } 
                        box { <15.9, 19.9, -21> <16.51, 53.51, 21> }
                        box { <15.9, 19.9, -30.51> <16.51, 45, 30.51> }
                }
        }  
        // sides of wall
        box { <16, 0, -30.5> <16.5, 25, -11> }
        box { <16, 0, 11> <16.5, 25, 30.5> }       
        // runners for door
        Round_Box_Union(<15, 4, -14>, <15.5, 40, -13>, 0.1)
        Round_Box_Union(<15.5, 4.5, -13.9>, <16, 38, -13.5>, 0.1)

        Round_Box_Union(<15, 4, 13>, <15.5, 40, 14>, 0.1) 
        Round_Box_Union(<15.5, 4.5, 13.5>, <16, 38, 13.9>, 0.1)
        // door
        union
        {
                Round_Box_Union(<0, 0, -12.9>, <0.5, 30, 12.9>, 0.1) 
                // handle
                Round_Cone_Union(<-2, 5, -5>, 0.4, <0, 5, -5>, 1.2, 0.1)
                Round_Cone_Union(<-2, 5, 5>, 0.4, <0, 5, 5>, 1.2, 0.1) 
                Round_Cylinder_Union (<-1.4, 5, -6>, <-1.4, 5, 6>, 0.4, 0.1)     
                
                translate <15.5, 20, 0>
                 
        } 
        // back wall
        box {<119, 0, -30.5> <119.5, 43, 30.5> }
        // floor
        box { <0, 0, -30.5> <120, 0.5, 30.5> }
        
        // Wheels    
        // right side
        object { coalTruckWheel translate <25, -13, -20> }
        object { coalTruckWheel translate <62.5, -13, -20> }
        object { coalTruckWheel translate <100, -13, -20> }      
        // left side
        object { coalTruckWheel scale <1, 1, -1> translate <25, -13, 20> }
        object { coalTruckWheel scale <1, 1, -1> translate <62.5, -13, 20> }
        object { coalTruckWheel scale <1, 1, -1> translate <100, -13, 20> }      
        
        // join the wheels together
        // right side
        union
        {
                object { wheelSuspension translate <25, -13, -29> }
                object { wheelSuspension translate <62.5, -13, -29> }
                object { wheelSuspension translate <100, -13, -29> }     
                // metal support/bar that runs between bottom of suspension
                object { Round_Box_Union(<0, 0, 0>, <75, 3, 1.25>, 0.2) translate <25, -18, -22.0> }
                
                // curved bit between wheels 
                difference
                {
                        box { <5, 0, 0> <120, 10, 1> translate <0, 0, 0> }
                        cylinder { <0, 0, -0.1> <0, 0, 1.1> 12 translate <25, -2, 0> }
                        cylinder { <0, 0, -0.1> <0, 0, 1.1> 12 translate <62.5, -2, 0> }
                        cylinder { <0, 0, -0.1> <0, 0, 1.1> 12 translate <100, -2, 0> }  
        
                        cylinder { <0, 0, -0.1> <0, 0, 1.1> 5 scale <2, 1, 1> translate <43.75, 0, 0> }
                        cylinder { <0, 0, -0.1> <0, 0, 1.1> 5 scale <2, 1, 1> translate <81.25, 0, 0> }
        
                        translate <0, -10, -22.2>             
                }       
                texture { suspensionTex }                
        } 
        // left side
        union
        {
                object { wheelSuspension translate <25, -13, -29> }
                object { wheelSuspension translate <62.5, -13, -29> }
                object { wheelSuspension translate <100, -13, -29> }     
                // metal support/bar that runs between bottom of suspension
                object { Round_Box_Union(<0, 0, 0>, <75, 3, 1.25>, 0.2) translate <25, -18, -22.0> }
                
                // curved bit between wheels 
                difference
                {
                        box { <5, 0, 0> <120, 10, 1> translate <0, 0, 0> }
                        cylinder { <0, 0, -0.1> <0, 0, 1.1> 12 translate <25, -2, 0> }
                        cylinder { <0, 0, -0.1> <0, 0, 1.1> 12 translate <62.5, -2, 0> }
                        cylinder { <0, 0, -0.1> <0, 0, 1.1> 12 translate <100, -2, 0> }  
        
                        cylinder { <0, 0, -0.1> <0, 0, 1.1> 5 scale <2, 1, 1> translate <43.75, 0, 0> }
                        cylinder { <0, 0, -0.1> <0, 0, 1.1> 5 scale <2, 1, 1> translate <81.25, 0, 0> }
        
                        translate <0, -10, -22.2>             
                }       
                texture { suspensionTex }     
                scale <1, 1, -1>           
        } 
        
        // steps at back of coal truck    
        // right side
        union
        {
                difference
                {
                        box { <-8, -19, 0> <8, -2, 0.5> }
                        cylinder { <0, 0, -0.1> <0, 0, 0.6> 10 scale <1, 1.5, 1> rotate <0, 0, 45> scale <1, 0.7, 1> translate <-11.5, -11.5, 0> }
                        texture { paintTex2 }
                }
                difference
                {
                        box { <-7, -18, 0> <7, -3, 0.5> }
                        cylinder { <0, 0, -0.1> <0, 0, 0.6> 10 scale <1, 1.5, 1> rotate <0, 0, 45> scale <1, 0.75, 1> translate <-10.75, -11.25, 0> }
                        translate <0, 0, -0.001> 
                        texture { paintTex3 }
                }
                difference
                {
                        box { <-6.5, -17.5, 0> <6.5, -3.5, 0.5> }
                        cylinder { <0, 0, -0.1> <0, 0, 0.6> 10 scale <1, 1.5, 1> rotate <0, 0, 45> scale <1, 0.775, 1> translate <-10.4, -11.1, 0> }
                        translate <0, 0, -0.002> 
                        texture { paintTex1 }
                }

                union
                { 
                        Round_Box_Union(<-4.75, -19.5, -0.2>, <4.75, -17.5, 0.7>, 0.1)
                        difference
                        {
                                intersection
                                {
                                        object { Round_Box_Union(<-4.5, -19.4, -4>, <4.5, -19, 0>, 0.05) }
                                        object { Round_Cylinder_Union(<0, -19.401, 0>, <0, -18.99, 0>, 5, 0.05) }
                                }
                        
                                #declare cp = -10;
                                #while(cp < 10)
                                        cylinder { <0, -19, -10> <0, -19, 10> 0.075 rotate <0, -45, 0> translate <cp, 0, 0> }
                                        cylinder { <0, -19, -10> <0, -19, 10> 0.075 rotate <0, 45, 0> translate <cp, 0, 0> } 
                                        #declare cp = cp+1;
                                #end                                 
                        }  
                        translate <3.75, -0.5, 0>               
                        texture { paintTex2 }
                }
                union
                { 
                        Round_Box_Union(<-4.75, -10, -0.2>, <4.75, -8, 0.7>, 0.1)
                        difference
                        {
                                intersection
                                {
                                        object { Round_Box_Union(<-4.5, -9.9, -4>, <4.5, -9.5, 0>, 0.05) }
                                        object { Round_Cylinder_Union(<0, -9.901, 0>, <0, -9.499, 0>, 5, 0.05) }
                                }
                        
                                #declare cp = -10;
                                #while(cp < 10)
                                        cylinder { <0, -9.5, -10> <0, -9.5, 10> 0.075 rotate <0, -45, 0> translate <cp, 0, 0> }
                                        cylinder { <0, -9.5, -10> <0, -9.5, 10> 0.075 rotate <0, 45, 0> translate <cp, 0, 0> } 
                                        #declare cp = cp+1;
                                #end                                 
                        }  
                        translate <3.75, -2, 0>               
                        texture { paintTex2 }
                }

                translate <110, 2.25, -30>
        }     
        // steps at front of coal truck    
        // right side
        union
        {
                difference
                {
                        box { <-8, -19, 0> <8, -2, 0.5> }
                        cylinder { <0, 0, -0.1> <0, 0, 0.6> 10 scale <1, 1.5, 1> rotate <0, 0, 45> scale <1, 0.7, 1> translate <-11.5, -11.5, 0> }
                        texture { paintTex2 }
                }
                difference
                {
                        box { <-7, -18, 0> <7, -3, 0.5> }
                        cylinder { <0, 0, -0.1> <0, 0, 0.6> 10 scale <1, 1.5, 1> rotate <0, 0, 45> scale <1, 0.75, 1> translate <-10.75, -11.25, 0> }
                        translate <0, 0, -0.001> 
                        texture { paintTex3 }
                }
                difference
                {
                        box { <-6.5, -17.5, 0> <6.5, -3.5, 0.5> }
                        cylinder { <0, 0, -0.1> <0, 0, 0.6> 10 scale <1, 1.5, 1> rotate <0, 0, 45> scale <1, 0.775, 1> translate <-10.4, -11.1, 0> }
                        translate <0, 0, -0.002> 
                        texture { paintTex1 }
                }

                union
                { 
                        Round_Box_Union(<-4.75, -19.5, -0.2>, <4.75, -17.5, 0.7>, 0.1)
                        difference
                        {
                                intersection
                                {
                                        object { Round_Box_Union(<-4.5, -19.4, -4>, <4.5, -19, 0>, 0.05) }
                                        object { Round_Cylinder_Union(<0, -19.401, 0>, <0, -18.99, 0>, 5, 0.05) }
                                }
                        
                                #declare cp = -10;
                                #while(cp < 10)
                                        cylinder { <0, -19, -10> <0, -19, 10> 0.075 rotate <0, -45, 0> translate <cp, 0, 0> }
                                        cylinder { <0, -19, -10> <0, -19, 10> 0.075 rotate <0, 45, 0> translate <cp, 0, 0> } 
                                        #declare cp = cp+1;
                                #end                                 
                        }  
                        translate <3.75, -0.5, 0>               
                        texture { paintTex2 }
                }
                union
                { 
                        Round_Box_Union(<-4.75, -10, -0.2>, <4.75, -8, 0.7>, 0.1)
                        difference
                        {
                                intersection
                                {
                                        object { Round_Box_Union(<-4.5, -9.9, -4>, <4.5, -9.5, 0>, 0.05) }
                                        object { Round_Cylinder_Union(<0, -9.901, 0>, <0, -9.499, 0>, 5, 0.05) }
                                }
                        
                                #declare cp = -10;
                                #while(cp < 10)
                                        cylinder { <0, -9.5, -10> <0, -9.5, 10> 0.075 rotate <0, -45, 0> translate <cp, 0, 0> }
                                        cylinder { <0, -9.5, -10> <0, -9.5, 10> 0.075 rotate <0, 45, 0> translate <cp, 0, 0> } 
                                        #declare cp = cp+1;
                                #end                                 
                        }  
                        translate <3.75, -2, 0>               
                        texture { paintTex2 }
                }
                scale <-1, 1, 1> 
                translate <12, 2.25, -30>
        }     

        // steps at back of coal truck    
        // left side
        union
        {
                difference
                {
                        box { <-8, -19, 0> <8, -2, 0.5> }
                        cylinder { <0, 0, -0.1> <0, 0, 0.6> 10 scale <1, 1.5, 1> rotate <0, 0, 45> scale <1, 0.7, 1> translate <-11.5, -11.5, 0> }
                        texture { paintTex2 }
                }
                difference
                {
                        box { <-7, -18, 0> <7, -3, 0.5> }
                        cylinder { <0, 0, -0.1> <0, 0, 0.6> 10 scale <1, 1.5, 1> rotate <0, 0, 45> scale <1, 0.75, 1> translate <-10.75, -11.25, 0> }
                        translate <0, 0, -0.001> 
                        texture { paintTex3 }
                }
                difference
                {
                        box { <-6.5, -17.5, 0> <6.5, -3.5, 0.5> }
                        cylinder { <0, 0, -0.1> <0, 0, 0.6> 10 scale <1, 1.5, 1> rotate <0, 0, 45> scale <1, 0.775, 1> translate <-10.4, -11.1, 0> }
                        translate <0, 0, -0.002> 
                        texture { paintTex1 }
                }

                union
                { 
                        Round_Box_Union(<-4.75, -19.5, -0.2>, <4.75, -17.5, 0.7>, 0.1)
                        difference
                        {
                                intersection
                                {
                                        object { Round_Box_Union(<-4.5, -19.4, -4>, <4.5, -19, 0>, 0.05) }
                                        object { Round_Cylinder_Union(<0, -19.401, 0>, <0, -18.99, 0>, 5, 0.05) }
                                }
                        
                                #declare cp = -10;
                                #while(cp < 10)
                                        cylinder { <0, -19, -10> <0, -19, 10> 0.075 rotate <0, -45, 0> translate <cp, 0, 0> }
                                        cylinder { <0, -19, -10> <0, -19, 10> 0.075 rotate <0, 45, 0> translate <cp, 0, 0> } 
                                        #declare cp = cp+1;
                                #end                                 
                        }  
                        translate <3.75, -0.5, 0>               
                        texture { paintTex2 }
                }
                union
                { 
                        Round_Box_Union(<-4.75, -10, -0.2>, <4.75, -8, 0.7>, 0.1)
                        difference
                        {
                                intersection
                                {
                                        object { Round_Box_Union(<-4.5, -9.9, -4>, <4.5, -9.5, 0>, 0.05) }
                                        object { Round_Cylinder_Union(<0, -9.901, 0>, <0, -9.499, 0>, 5, 0.05) }
                                }
                        
                                #declare cp = -10;
                                #while(cp < 10)
                                        cylinder { <0, -9.5, -10> <0, -9.5, 10> 0.075 rotate <0, -45, 0> translate <cp, 0, 0> }
                                        cylinder { <0, -9.5, -10> <0, -9.5, 10> 0.075 rotate <0, 45, 0> translate <cp, 0, 0> } 
                                        #declare cp = cp+1;
                                #end                                 
                        }  
                        translate <3.75, -2, 0>               
                        texture { paintTex2 }
                }
                scale <1, 1, -1>
                translate <110, 2.25, 30>
        }     
        // steps at front of coal truck    
        // right side
        union
        {
                difference
                {
                        box { <-8, -19, 0> <8, -2, 0.5> }
                        cylinder { <0, 0, -0.1> <0, 0, 0.6> 10 scale <1, 1.5, 1> rotate <0, 0, 45> scale <1, 0.7, 1> translate <-11.5, -11.5, 0> }
                        texture { paintTex2 }
                }
                difference
                {
                        box { <-7, -18, 0> <7, -3, 0.5> }
                        cylinder { <0, 0, -0.1> <0, 0, 0.6> 10 scale <1, 1.5, 1> rotate <0, 0, 45> scale <1, 0.75, 1> translate <-10.75, -11.25, 0> }
                        translate <0, 0, -0.001> 
                        texture { paintTex3 }
                }
                difference
                {
                        box { <-6.5, -17.5, 0> <6.5, -3.5, 0.5> }
                        cylinder { <0, 0, -0.1> <0, 0, 0.6> 10 scale <1, 1.5, 1> rotate <0, 0, 45> scale <1, 0.775, 1> translate <-10.4, -11.1, 0> }
                        translate <0, 0, -0.002> 
                        texture { paintTex1 }
                }

                union
                { 
                        Round_Box_Union(<-4.75, -19.5, -0.2>, <4.75, -17.5, 0.7>, 0.1)
                        difference
                        {
                                intersection
                                {
                                        object { Round_Box_Union(<-4.5, -19.4, -4>, <4.5, -19, 0>, 0.05) }
                                        object { Round_Cylinder_Union(<0, -19.401, 0>, <0, -18.99, 0>, 5, 0.05) }
                                }
                        
                                #declare cp = -10;
                                #while(cp < 10)
                                        cylinder { <0, -19, -10> <0, -19, 10> 0.075 rotate <0, -45, 0> translate <cp, 0, 0> }
                                        cylinder { <0, -19, -10> <0, -19, 10> 0.075 rotate <0, 45, 0> translate <cp, 0, 0> } 
                                        #declare cp = cp+1;
                                #end                                 
                        }  
                        translate <3.75, -0.5, 0>               
                        texture { paintTex2 }
                }
                union
                { 
                        Round_Box_Union(<-4.75, -10, -0.2>, <4.75, -8, 0.7>, 0.1)
                        difference
                        {
                                intersection
                                {
                                        object { Round_Box_Union(<-4.5, -9.9, -4>, <4.5, -9.5, 0>, 0.05) }
                                        object { Round_Cylinder_Union(<0, -9.901, 0>, <0, -9.499, 0>, 5, 0.05) }
                                }
                        
                                #declare cp = -10;
                                #while(cp < 10)
                                        cylinder { <0, -9.5, -10> <0, -9.5, 10> 0.075 rotate <0, -45, 0> translate <cp, 0, 0> }
                                        cylinder { <0, -9.5, -10> <0, -9.5, 10> 0.075 rotate <0, 45, 0> translate <cp, 0, 0> } 
                                        #declare cp = cp+1;
                                #end                                 
                        }  
                        translate <3.75, -2, 0>               
                        texture { paintTex2 }
                }
                scale <-1, 1, -1> 
                translate <12, 2.25, 30>
        }     


        
        texture { paintTex1 }
        translate <245, -12, 0>
}



/*********************************************** Building Textures ***********************************************/
#declare buildingFloorTex = texture
{
        pigment { rgb <0.9, 0.875, 0.865> }
        finish { ambient 0 diffuse 0.6 brilliance 0.9 } 
}  
texture // add grease/dirt
{                         
        pigment 
        {                 
                wrinkles   
                scallop_wave
                turbulence 0.71 
                omega 0.65 
                lambda 3                            
                colour_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.1 rgbt <1, 1, 1, 1> ]
                        [ 0.15 rgbt <0.01, 0.002, 0, 1> ]
                        [ 0.20 rgbt <0.01, 0.002, 0, 0.5> ]
                        [ 0.40 rgbt <0.01, 0.002, 0, 0.2> ]
                        [ 0.45 rgbt <0.025, 0.01, 0.001, 0.4> ]
                        [ 0.5 rgbt <0.01, 0.002, 0, 0.5> ]
                        [ 0.525 rgbt <0.01, 0.002, 0, 1> ]
                        [ 0.525 rgbt <1, 1, 1, 1> ]
                        [ 0.8 rgbt <1, 1, 1, 1> ]
                        [ 0.8 rgbt <0.1, 0.035, 0.005, 1> ] 
                        [ 0.81 rgbt <0.1, 0.035, 0.005, 0.3> ]
                        [ 0.9 rgbt <0.15, 0.085, 0.009, 0.6> ]
                        [ 0.94 rgbt <0.15, 0.085, 0.009, 1> ]
                        [ 1 rgbt <1, 1, 1, 1> ]
                }  
                scale <0.3, 20, 20> 
        }
        finish { ambient 0 diffuse 0.2 }
        normal { wrinkles 1 }

}
texture // add grease/dirt
{                         
        pigment 
        {                 
                wrinkles   
                
                turbulence 0.8 
                omega 0.75 
                lambda 3 
                colour_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.1 rgbt <1, 1, 1, 1> ]
                        [ 0.15 rgbt <0.01, 0.002, 0, 1> ]
                        [ 0.20 rgbt <0.01, 0.002, 0, 0.6> ]
                        [ 0.40 rgbt <0.01, 0.002, 0, 0.5> ]
                        [ 0.45 rgbt <0.025, 0.01, 0.001, 0.3> ]
                        [ 0.5 rgbt <0.01, 0.002, 0, 0.5> ]
                        [ 0.525 rgbt <0.01, 0.002, 0, 1> ]
                        [ 0.525 rgbt <1, 1, 1, 1> ]
                        [ 0.8 rgbt <1, 1, 1, 1> ]
                        [ 0.8 rgbt <0.1, 0.035, 0.005, 1> ] 
                        [ 0.81 rgbt <0.1, 0.035, 0.005, 0.7> ]
                        [ 0.9 rgbt <0.15, 0.085, 0.009, 0.5> ]
                        [ 0.94 rgbt <0.15, 0.085, 0.009, 1> ]
                        [ 1 rgbt <1, 1, 1, 1> ]
                }  
                rotate <20, 30, 10>
                scale <0.25, 25, 25> 
        }
        finish { ambient 0 diffuse 0.2 }
        normal { wrinkles 1 }

}
texture
{
        pigment 
        { 
                gradient x   
                turbulence 0.125
                omega 0.775
                lambda 3.2
                colour_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.15 rgbt <1, 1, 1, 1> ]
                        [ 0.4 rgbt <0.02, 0.01, 0, 0.1> ]
                        [ 0.5 rgbt <0.02, 0.01, 0, 0.1> ]
                        [ 0.6 rgbt <0.02, 0.01, 0, 0.1> ]
                        [ 0.85 rgbt <1, 1, 1, 1> ]
                        [ 1.0 rgbt <1, 1, 1, 1> ]
                }            
                scale <2, 2, 200> 
        }
        finish { ambient 0 diffuse 0.4 }
}



#declare concreteNormal = normal 
{       
        average
        normal_map
        {       
                [ 1 granite 1 omega 0.65 lambda 3.3 turbulence 0.125 scale 3.5 ]
                [ 1 wrinkles 1 omega 0.62 lambda 2.5 turbulence 0.15 scale 2 ]
                [ 1 wrinkles 1 omega 0.7 lambda 3 turbulence 0.25 scale 0.25 ]
        }
}        
                

#declare rock_base = texture
{
        pigment { granite triangle_wave omega 0.6 lambda 3 turbulence 0.275 
                color_map {  [ 0.0 rgb <0.175, 0.175, 0.175> ] [ 1.0 rgb <0.425, 0.425, 0.425> ] } 
                scale 0.25 
                }
        finish { ambient 0 diffuse 0.5 }    
        normal { concreteNormal }
}

#declare rock_tex_1 = texture
{   
        pigment 
        {
                wrinkles            
                turbulence 0.1   
                omega 0.7 lambda 4
                color_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]// rgbt <0.15, 0.09, 0.015, 0.05> ] 
                        [ 0.5 rgbt <1, 1, 1, 1> ]// rgbt <0.15, 0.09, 0.015, 0.05> ] 
                        [ 0.5 rgbt <0.15, 0.09, 0.015, 1> ] //rgbt 1 ]
                        [ 0.8 rgbt <0.15, 0.09, 0.015, 0.25> ] //rgbt 1 ]
                        [ 1.0 rgbt <0.15, 0.091, 0.015, 0.1> ] //rgbt 1 ]
                }                         
                scale 25
        }
        finish { ambient 0 diffuse 0.45 specular 0 phong 0 }
}          

#declare rock_tex_2 = texture
{   
        pigment 
        {
                wrinkles  
                scallop_wave          
                turbulence 0.1   
                omega 0.7 lambda 4
                color_map
                {
                        [ 0.0 rgbt <0.15, 0.09, 0.015, 0.1> ] //rgbt 1 ]
                        [ 0.5 rgbt <0.15, 0.09, 0.015, 0.5> ] //rgbt 1 ]
                        [ 0.75 rgbt <0.15, 0.091, 0.015, 1> ] //rgbt 1 ]
                        [ 0.75 rgbt <1, 1, 1, 1> ]// rgbt <0.15, 0.09, 0.015, 0.05> ] 
                        [ 1.0 rgbt <1, 1, 1, 1> ]// rgbt <0.15, 0.09, 0.015, 0.05> ] 
                }                         
                scale 15
        }
        finish { ambient 0 diffuse 0.45 specular 0 phong 0 }


}          

#declare rock_tex_3 = texture
{   
        pigment 
        {
                bozo scallop_wave           
                turbulence 0.7 
                omega 0.7 lambda 4 octaves 10 
                scale 0.56
                color_map
                {
                        [ 0.0 rgbt 1 ]
                        [ 0.9 rgbt 1 ]
                        [ 0.925 rgbt <0.0075, 0.06, 0.0005, 1> ] 
                        [ 0.975 rgbt <0.0075, 0.06, 0.0005, 0.4> ] 
                        [ 1.0 rgbt <0.0075, 0.06, 0.0005, 0> ] 
                 }
        } 
        finish { ambient 0 diffuse 0.5 specular 0 phong 0 }
        scale 20


}
#declare rock_tex_4 = texture
{   
        pigment 
        {
                granite            
                turbulence 0.2 
                omega 0.6 lambda 2.5 
                color_map
                {
                        [ 0.0 rgbt 1 ]
                        [ 0.1 rgbt 1 ]
                        [ 0.15 rgbt <0.1, 0.06, 0.01, 1> ] 
                        [ 0.3 rgbt <0.1, 0.06, 0.01, 0.1> ] 
                        [ 0.45 rgbt <0.1, 0.06, 0.01, 1> ] 
                        [ 0.5 rgbt 1 ]
                        [ 0.6 rgbt 1 ]
                        [ 0.65 rgbt <0.0075, 0.06, 0.0005, 1> ] 
                        [ 0.75 rgbt <0.0075, 0.06, 0.0005, 0.05> ] 
                        [ 0.9 rgbt <0.0075, 0.06, 0.0005, 1> ] 
                        [ 0.95 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                 }
                scale 0.1
        }          
        finish { ambient 0 diffuse 0.45 specular 0 phong 0 }


}

#declare rock_tex_5 = texture
{   
        pigment 
        {
                gradient y            
                turbulence 0.0085
                omega 0.575 lambda 3.0 
                scale <1, 1, 1>
                color_map
                {
                        [ 0.0 rgbt <0.05, 0.01, 0.0001, 0.025> ]
                        [ 0.4 rgbt <0.085, 0.025, 0.0003, 0.075> ]
                        [ 0.65 rgbt <0.125, 0.04, 0.0006, 0.3> ]
                        [ 0.7 rgbt <0.2, 0.15, 0.005, 0.75> ]
                        [ 0.8 rgbt <0.3, 0.25, 0.0125, 1> ]
                        
                        [ 0.8 rgbt <1, 1, 1, 1> ]
                        [ 1.0 rgbt <1, 1, 1, 1> ]
                        
                 }       
                 translate <0, 0.4, 0>
                 scale <300, 300, 300>
        }  


        
}




#declare land_tex_1 = texture
{   
        pigment 
        {
                granite            
                turbulence 0.05   
                omega 0.7 lambda 4
                scale <0.25, .25, 0.25>        
                color_map
                {
                        [ 0.0 rgbt <0.15, 0.09, 0.015, 0.5> ] 
                        [ 0.4 rgbt <0.15, 0.09, 0.015, 1> ] 
                        [ 0.4 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                }
        }
        finish { ambient 0 diffuse 0.45 specular 0 phong 0 brilliance 0.9 }
        normal { concreteNormal }


}

#declare land_tex_2 = texture
{   
        pigment 
        {
                wrinkles cubic_wave           
                turbulence 0.225   
                omega 0.7 lambda 4
                scale <0.15, .15, 0.15>        
                color_map
                {
                        [ 0.0 rgbt <0.15, 0.09, 0.015, 0.1> ] 
                        [ 0.4 rgbt <0.15, 0.09, 0.015, 1> ] 
                        [ 0.4 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                }
        }
        finish { ambient 0 diffuse 0.45 specular 0 phong 0 brilliance 0.9 }
        normal { concreteNormal }


}

#declare land_tex_3 = texture
{   
        pigment 
        {
                wrinkles sine_wave           
                turbulence 0.35   
                omega 0.65 lambda 4
                scale 0.05
                color_map
                {
                        [ 0.0 rgbt 1 ]
                        [ 0.7 rgbt 1 ]
                        [ 0.7 rgbt <0.15, 0.09, 0.015, 1> ] 
                        [ 1.0 rgbt <0.15, 0.09, 0.015, 0.3> ] 
                 }
        }
        finish { ambient 0 diffuse 0.45 specular 0 phong 0 brilliance 0.9 }
        normal { concreteNormal }


}
#declare land_tex_4 = texture
{   
        pigment 
        {
                bozo scallop_wave           
                turbulence 0.7 
                omega 0.7 lambda 4 octaves 10 
                scale 0.56
                color_map
                {
                        [ 0.0 rgbt 1 ]
                        [ 0.9 rgbt 1 ]
                        [ 0.925 rgbt <0.0075, 0.06, 0.0005, 1> ] 
                        [ 0.975 rgbt <0.0075, 0.06, 0.0005, 0.4> ] 
                        [ 1.0 rgbt <0.0075, 0.06, 0.0005, 0> ] 
                 }
        }
        finish { ambient 0 diffuse 0.45 specular 0 phong 0 brilliance 0.9 }
        normal { concreteNormal }


}
#declare land_tex_5 = texture
{   
        pigment 
        {
                granite            
                turbulence 0.2 
                omega 0.6 lambda 2.5 
                scale 0.01
                color_map
                {
                        [ 0.0 rgbt 1 ]
                        [ 0.1 rgbt 1 ]
                        [ 0.15 rgbt <0.1, 0.06, 0.01, 1> ] 
                        [ 0.3 rgbt <0.1, 0.06, 0.01, 0.1> ] 
                        [ 0.45 rgbt <0.1, 0.06, 0.01, 1> ] 
                        [ 0.5 rgbt 1 ]
                        [ 0.6 rgbt 1 ]
                        [ 0.65 rgbt <0.0075, 0.06, 0.0005, 1> ] 
                        [ 0.75 rgbt <0.0075, 0.06, 0.0005, 0.05> ] 
                        [ 0.9 rgbt <0.0075, 0.06, 0.0005, 1> ] 
                        [ 0.95 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                 }
        }
        finish { ambient 0 diffuse 0.45 specular 0 phong 0 brilliance 1.21 }
        normal { concreteNormal }

}

#declare land_tex_6 = texture
{   
        pigment 
        {
                gradient z            
                turbulence 0.275
                omega 0.626 lambda 3.0 
                scale <10, 5, 1>
                color_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.1 rgbt <1, 1, 1, 1> ]
                        [ 0.1 rgbt <0.3, 0.25, 0.0125, 1> ]
                        [ 0.25 rgbt <0.21, 0.155, 0.0055, 0.75> ]
                        [ 0.35 rgbt <0.175, 0.05, 0.001, 0.3> ]
                        [ 0.4 rgbt <0.12, 0.04, 0.0003, 0.075> ]
                        [ 0.8 rgbt <0.075, 0.016, 0.0001, 0.01> ]
                        [ 0.8 rgbt <1, 1, 1, 1> ]
                        [ 1.0 rgbt <1, 1, 1, 1> ]
                 }
        }
        normal { concreteNormal }

}




#if(useTestTex)                       
#declare rock_tex = texture
{
       rock_base scale 10
}
#else                        
#declare rock_tex_dry = texture
{
       rock_base scale 10
}
texture
{
        rock_tex_1
}
texture
{
        rock_tex_2
}
texture
{
        rock_tex_3
}
texture
{
        rock_tex_4
}
texture
{
        rock_tex_5
        finish { ambient 0 diffuse 0.45 specular 0 phong 0 }
}  

#declare rock_tex_wet = texture
{
       rock_base scale 10
}
texture
{
        rock_tex_1
}
texture
{
        rock_tex_2
}
texture
{
        rock_tex_3
}
texture
{
        rock_tex_4
}
texture
{
        rock_tex_5
        finish { ambient 0 diffuse 0.35 specular 0.5 roughness 0.001 phong 0.5 phong_size 150 }
}


#declare rock_tex = texture 
{
        gradient y    
        scale 100        
        texture_map 
        {
                [ 0.0 rock_tex_wet scale 0.01 ]
                [ 0.25 rock_tex_wet scale 0.01 ]
                [ 0.425 rock_tex_dry scale 0.01 ]
                [ 1.0 rock_tex_dry scale 0.01 ]
         }
}


#end

#if(useTestTex)
#declare land_tex = texture
{
        rock_base
}      
#else 

#declare land_tex_dry = texture
{
        rock_base   
        scale <2, 2, 95>
}      
texture
{
        land_tex_1
        scale <2, 2, 95>
}
texture
{
        land_tex_2
        scale <2, 2, 95>
}
texture
{
        land_tex_3
        scale <2, 2, 95>
}
texture
{
        land_tex_4
        scale <2, 2, 95>
}
texture
{
        land_tex_5
        scale <2, 2, 95>
} 
texture
{
        pigment 
        { 
                gradient x   
                turbulence 0.125
                omega 0.775
                lambda 3.2
                colour_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.3 rgbt <1, 1, 1, 1> ]
                        [ 0.3 rgbt <0.02, 0.01, 0, 1> ]
                        [ 0.4 rgbt <0.02, 0.01, 0, 0.1> ]
                        [ 0.5 rgbt <0.02, 0.01, 0, 0.1> ]
                        [ 0.6 rgbt <0.02, 0.01, 0, 0.1> ]
                        [ 0.7 rgbt <0.02, 0.01, 0, 1> ]
                        [ 0.7 rgbt <1, 1, 1, 1> ]
                        [ 1.0 rgbt <1, 1, 1, 1> ]
                }            
                scale <2, 2, 200> 
        }
        finish { ambient 0 diffuse 0.4 brilliance 0.85 }
        normal { concreteNormal }
}           
#end

#declare wallTex = texture
                {
                        pigment 
                        {
                                wrinkles     
                                scallop_wave
                                colour_map
                                {
                                        [ 0.0 rgb <0.86, 0.8, 0.6> ]
                                        [ 0.3 rgb <0.9, 0.825, 0.77> ]
                                        [ 0.6 rgb <0.95, 0.85, 0.8> ]
                                        [ 0.7 rgb <0.8, 0.625, 0.567> ]
                                        [ 0.9 rgb <0.9, 0.825, 0.77> ]
                                }        
                                
                        }    
                        normal { concreteNormal }
                }  
                texture // add grease/dirt
                {                         
                        pigment 
                        {                 
                                wrinkles   
                                scallop_wave
                                turbulence 0.31 
                                omega 0.65 
                                lambda 3                            
                                colour_map
                                {
                                        [ 0.0 rgbt <1, 1, 1, 1> ]
                                        [ 0.1 rgbt <1, 1, 1, 1> ]
                                        [ 0.15 rgbt <0.01, 0.002, 0, 1> ]
                                        [ 0.20 rgbt <0.01, 0.002, 0, 0.7> ]
                                        [ 0.40 rgbt <0.01, 0.002, 0, 0.6> ]
                                        [ 0.45 rgbt <0.025, 0.01, 0.001, 0.2> ]
                                        [ 0.5 rgbt <0.01, 0.002, 0, 0.7> ]
                                        [ 0.525 rgbt <0.01, 0.002, 0, 1> ]
                                        [ 0.525 rgbt <1, 1, 1, 1> ]
                                        [ 0.8 rgbt <1, 1, 1, 1> ]
                                        [ 0.8 rgbt <0.1, 0.035, 0.005, 1> ] 
                                        [ 0.81 rgbt <0.1, 0.035, 0.005, 0.4> ]
                                        [ 0.9 rgbt <0.15, 0.085, 0.009, 0.8> ]
                                        [ 0.94 rgbt <0.15, 0.085, 0.009, 1> ]
                                        [ 1 rgbt <1, 1, 1, 1> ]
                                }  
                                scale <50, 40, 50> 
                        }
                        finish { ambient 0 diffuse 0.4 }
                        normal { concreteNormal }
                }
                texture // add grease/dirt
                {                         
                        pigment 
                        {                 
                                wrinkles   
                                
                                turbulence 1 
                                omega 0.75 
                                lambda 3 
                                colour_map
                                {
                                        [ 0.0 rgbt <1, 1, 1, 1> ]
                                        [ 0.1 rgbt <1, 1, 1, 1> ]
                                        [ 0.15 rgbt <0.01, 0.002, 0, 1> ]
                                        [ 0.20 rgbt <0.01, 0.002, 0, 0.7> ]
                                        [ 0.40 rgbt <0.01, 0.002, 0, 0.5> ]
                                        [ 0.45 rgbt <0.025, 0.01, 0.001, 0.4> ]
                                        [ 0.5 rgbt <0.01, 0.002, 0, 0.9> ]
                                        [ 0.525 rgbt <0.01, 0.002, 0, 1> ]
                                        [ 0.525 rgbt <1, 1, 1, 1> ]
                                        [ 0.8 rgbt <1, 1, 1, 1> ]
                                        [ 0.8 rgbt <0.1, 0.035, 0.005, 1> ] 
                                        [ 0.81 rgbt <0.1, 0.035, 0.005, 0.8> ]
                                        [ 0.9 rgbt <0.15, 0.085, 0.009, 0.6> ]
                                        [ 0.94 rgbt <0.15, 0.085, 0.009, 1> ]
                                        [ 1 rgbt <1, 1, 1, 1> ]
                                }  
                                rotate <20, 30, 20>
                                scale <45, 55, 35> 
                        }
                        finish { ambient 0 diffuse 0.4 }
                        normal { concreteNormal }
                
                } 
                texture
                {
                        pigment 
                        { 
                                gradient y   
                                turbulence 0.115
                                omega 0.8
                                lambda 2.2
                                colour_map
                                {
                                        [ 0.0 rgbt <0.05, 0.03, 0, 0.0> ]
                                        [ 0.3 rgbt <0.05, 0.03, 0, 0.2> ]
                                        [ 0.6 rgbt <0.05, 0.03, 0, 0.4> ]
                                        [ 0.9 rgbt <0.05, 0.03, 0, 0.9> ]
                                        [ 1.0 rgbt <0.05, 0.03, 0, 0.99> ]
                                }            
                                scale <5, 375, 5>
                                translate <0, -100, 0> 
                        }
                        finish { ambient 0 diffuse 0.3 }
                        normal { concreteNormal }
                }




#macro woodBlockNoTex(xSize, ySize, zSize, rad, texScale)
#if(useIso)
isosurface 
{       
        function{f_rounded_box(x,y,z,rad, xSize, ySize, zSize)+f_bozo(x/20,y*2,z*10)*(0.1*texScale)+f_wrinkles(x*0.1, y*2, z)*(0.1*texScale)}
        threshold 0         
        contained_by {box {<-(xSize*1.1),-(ySize*1.1),-(zSize*1.1)> <(xSize*1.1),(ySize*1.1),(zSize*1.1)>} }
        accuracy 0.001   
        max_gradient 2.45
        all_intersections                               
}
#else
object 
{       
        object { Round_Box_Union(<-xSize, -ySize, -zSize>, <xSize, ySize, zSize>, rad) }
}
#end
#end

 
#macro woodBlock(xSize, ySize, zSize, rad, texScale)
#if(useIso)
isosurface 
{       
        function{f_rounded_box(x,y,z,rad, xSize, ySize, zSize)+f_bozo(x/20,y*2,z*10)*(0.1*texScale)+f_wrinkles(x*0.1, y*2, z)*(0.1*texScale)}
        threshold 0         
        contained_by {box {<-(xSize*1.1),-(ySize*1.1),-(zSize*1.1)> <(xSize*1.1),(ySize*1.1),(zSize*1.1)>} }
        accuracy 0.001
        max_gradient 2.16                               
                                              
        texture { plank_tex rotate <gr(0.25), gr(0.25), 89+gr(2)> translate <gr(500), gr(500), gr(500)> }
}
#else
object 
{       
        object { Round_Box_Union(<-xSize, -ySize, -zSize>, <xSize, ySize, zSize>, rad) }
        texture { plank_tex rotate <gr(0.25), gr(0.25), 89+gr(2)> translate <gr(500), gr(500), gr(500)> }
          
}
#end
#end


#macro concreteBlock(xSize, ySize, zSize, rad, texScale)
object 
{       
        object { Round_Box_Union(<-xSize, -ySize, -zSize>, <xSize, ySize, zSize>, rad) }
}
#end    


#macro shedDoor(numPlanks)
        #declare plankCount=0;
        union
        {
                #while(plankCount<numPlanks)
                        object { woodBlock(74.75+gr(0.25), 4.06, 1, 0.5, 1) translate <75, 0, 0> rotate <0, 0, 90> translate <plankCount*8.125, 0, 0> } 
                        #declare plankCount=plankCount+1;
                #end 
                // frame of door   //30.5          
                object { woodBlock(3.8125*numPlanks, 5, 1.65, 0.5, 1) translate <(3.8125*numPlanks)-1.5, 20, 2.65> } 
                object { woodBlock(3.8125*numPlanks, 5, 1.65, 0.5, 1) translate <(3.8125*numPlanks)-1.5, 130, 2.65> } 
                                   //60
                object { woodBlock(40+(2.5*numPlanks), 3.5, 1.55, 0.5, 1) translate <40+(2.5*numPlanks), 0, 2.55> rotate <0, 0, 90-(3.125*numPlanks)> translate <3, 20, 0> } 
                
                // hinge
                box { <-5, 125, -2> <10, 130, -1> } 
                box { <-5, 70, -2> <10, 75, -1> } 
                box { <-5, 20, -2> <10, 25, -1> } 
                
                texture { paintTex3 }
        }


#end     

#macro windowSplinter(spSize, spDepth)   
        #declare splinterSz=spSize/4+gr(spSize/4)+gr(spSize/4);
        
        union
        {
                difference
                {
                        sphere { <0, 0, 0> splinterSz }   
                        sphere { <0, 0, 0> splinterSz scale <1-gr(0.25), 1-gr(0.25), 1-gr(0.25)> 
                                translate <0, splinterSz*0.85+gr(splinterSz/4), splinterSz*0.5+gr(splinterSz/4)> }    
                        box { <-1, 0, 0> <1, splinterSz, splinterSz> rotate <45, 0, 0> scale <1, 0.1+gr(0.4), 1> translate <0, 0, gr(splinterSz)> rotate <-gr(90), 0, 0> }
                        box { <-1, 0, 0> <1, splinterSz, splinterSz> rotate <45, 0, 0> scale <1, 0.1+gr(0.4), 1> translate <0, 0, gr(splinterSz)> rotate <-gr(90), 0, 0> }
                        box { <-1, 0, 0> <1, splinterSz, splinterSz> rotate <45, 0, 0> scale <1, 0.1+gr(0.4), 1> translate <0, 0, gr(splinterSz)> rotate <-gr(90), 0, 0> }
                        box { <-1, 0, 0> <1, splinterSz, splinterSz> rotate <45, 0, 0> scale <1, 0.1+gr(0.4), 1> translate <0, 0, gr(splinterSz)> rotate <-gr(90), 0, 0> }
                }

                difference
                {
                        sphere { <0, 0, 0> splinterSz }   
                        sphere { <0, 0, 0> splinterSz scale <1-gr(0.25), 1-gr(0.25), 1-gr(0.25)> 
                                translate <0, -splinterSz+gr(splinterSz/3), splinterSz*0.8+gr(splinterSz/3)> }    

                        box { <-1, 0, 0> <1, splinterSz, splinterSz> rotate <45, 0, 0> scale <1, 0.1+gr(0.4), 1> translate <0, 0, gr(splinterSz)> rotate <gr(90), 0, 0> }
                        box { <-1, 0, 0> <1, splinterSz, splinterSz> rotate <45, 0, 0> scale <1, 0.1+gr(0.4), 1> translate <0, 0, gr(splinterSz)> rotate <gr(90), 0, 0> }
                        box { <-1, 0, 0> <1, splinterSz, splinterSz> rotate <45, 0, 0> scale <1, 0.1+gr(0.4), 1> translate <0, 0, gr(splinterSz)> rotate <gr(90), 0, 0> }
                        box { <-1, 0, 0> <1, splinterSz, splinterSz> rotate <45, 0, 0> scale <1, 0.1+gr(0.4), 1> translate <0, 0, gr(splinterSz)> rotate <gr(90), 0, 0> }

                        translate <0, spSize, 0>
                } 
        
                difference
                {
                        sphere { <0, 0, 0> splinterSz }   
                        sphere { <0, 0, 0> splinterSz scale <1-gr(0.25), 1-gr(0.25), 1-gr(0.25)> 
                                translate <0, splinterSz*0.9+gr(splinterSz/4), -splinterSz*0.7+gr(splinterSz/3)> }    

                        box { <-1, 0, 0> <1, splinterSz, splinterSz> rotate <45, 0, 0> scale <1, 0.1+gr(0.4), 1> translate <0, 0, -(splinterSz+gr(splinterSz))> rotate <gr(90), 0, 0> }
                        box { <-1, 0, 0> <1, splinterSz, splinterSz> rotate <45, 0, 0> scale <1, 0.1+gr(0.4), 1> translate <0, 0, -(splinterSz+gr(splinterSz))> rotate <gr(90), 0, 0> }
                        box { <-1, 0, 0> <1, splinterSz, splinterSz> rotate <45, 0, 0> scale <1, 0.1+gr(0.4), 1> translate <0, 0, -(splinterSz+gr(splinterSz))> rotate <gr(90), 0, 0> }
                        box { <-1, 0, 0> <1, splinterSz, splinterSz> rotate <45, 0, 0> scale <1, 0.1+gr(0.4), 1> translate <0, 0, -(splinterSz+gr(splinterSz))> rotate <gr(90), 0, 0> }

                        translate <0, 0, spDepth>
                }

                difference
                {
                        sphere { <0, 0, 0> splinterSz }   
                        sphere { <0, 0, 0> splinterSz scale <1-gr(0.25), 1-gr(0.25), 1-gr(0.25)> 
                                translate <0, -splinterSz*0.9+gr(splinterSz/4), -splinterSz*0.7+gr(splinterSz/4)> }    

                        box { <-1, 0, 0> <1, splinterSz, splinterSz> rotate <45, 0, 0> scale <1, 0.1+gr(0.4), 1> translate <0, 0, -(splinterSz+gr(splinterSz))> rotate <gr(90), 0, 0> }
                        box { <-1, 0, 0> <1, splinterSz, splinterSz> rotate <45, 0, 0> scale <1, 0.1+gr(0.4), 1> translate <0, 0, -(splinterSz+gr(splinterSz))> rotate <gr(90), 0, 0> }
                        box { <-1, 0, 0> <1, splinterSz, splinterSz> rotate <45, 0, 0> scale <1, 0.1+gr(0.4), 1> translate <0, 0, -(splinterSz+gr(splinterSz))> rotate <gr(90), 0, 0> }
                        box { <-1, 0, 0> <1, splinterSz, splinterSz> rotate <45, 0, 0> scale <1, 0.1+gr(0.4), 1> translate <0, 0, -(splinterSz+gr(splinterSz))> rotate <gr(90), 0, 0> }

                        translate <0, spSize, spDepth>
                }

        }



#end

#macro mkBrokenWindow(windowV1, windowV2)     

        #declare wSize=windowV2-windowV1; 
        
        intersection
        {
                box { <0, 0, 0> wSize }
                object { windowSplinter(wSize.y, wSize.z) }
                
                //sphere { 0, wSize.y/3+(gr(wSize.y/2) translate <gr(wSize.y), wSize.y/2+gr(wSize.y), wSize.y/3+gr(wSize.y)> }
                material { windowGlass scale wSize }
                translate windowV1 
        }

       // box { windowV1, windowV2 }
    
#end

#macro windowFrame()
union
{
                                // Window frame
                                union
                                {
                                        box { <-1, 40, 20> <1, 42, 60> }
                                        
                                        box { <-1, 40, 20> <1, 125, 22> }
                                        box { <-1, 40, 58> <1, 125, 60> }
                                        
                                        difference
                                        {
                                                cylinder { <-1, 125, 40> <1, 125, 40> 20 }
                                                cylinder { <-1.5, 125, 40> <1.5, 125, 40> 18 }
                                                box { <-1.5, 100, 19> <1.5, 125, 61> }
                                        }   
                                        
                                        box { <-1, 124, 20> <1, 126, 60> }
                                        
                                        box { <-1, 81, 20> <1, 83, 60> }
                                        
                                        box { <-1, 40, 39> <1, 145, 41> } 

                                        texture { plank_tex scale <1+gr(1), 1+gr(2), 1+gr(1)> rotate gr(5) }      
                                        texture { LowLevelDirt }

                                }    
                                // putty for window
                                union
                                {
                                        cylinder { <0, 42, 20> <0, 42, 60> 0.25 }   
                                        cylinder { <0, 83, 20> <0, 83, 60> 0.25 }   
                                        cylinder { <0, 126, 20> <0, 126, 60> 0.25 }   

                                        cylinder { <0, 42, 22> <0, 125, 22> 0.25 } 
                                        cylinder { <0, 42, 39> <0, 125, 39> 0.25 } 
                                        cylinder { <0, 42, 41> <0, 125, 41> 0.25 } 
                                        cylinder { <0, 42, 58> <0, 125, 58> 0.25 }     
                                        
                                        difference
                                        {
                                                torus { 18, 0.25 rotate <0, 0, 90> translate <0, 125, 0> }
                                                box { <-1, 100, -20> <1, 125, 20> }
                                                translate <0, 0, 40>
                                        }
                                        
                                        texture { puttyTex scale 0.8+gr(0.4) rotate gr(50) }
                                        texture { LowLevelDirt }

                                }          
                                // surround for window frame
                                union
                                {
                                        cylinder { <1, 40, 60> <1, 125, 60> 0.4 }
                                        cylinder { <-1, 40, 60> <-1, 125, 60> 0.4 }
                                        cylinder { <1, 40, 20> <1, 125, 20> 0.4 }
                                        cylinder { <-1, 40, 20> <-1, 125, 20> 0.4 }
                                        
                                        cylinder { <1, 40, 20> <1, 40, 60> 0.4 }
                                        cylinder { <-1, 40, 20> <-1, 40, 60> 0.4 } 
                                        
                                        difference
                                        {
                                                union
                                                {
                                                        torus { 20, 0.4 rotate <0, 0, 90> translate <-1, 125, 40> }
                                                        torus { 20, 0.4 rotate <0, 0, 90> translate <1, 125, 40> }
                                                }
                                                box { <-2, 80, 18> <2, 125, 62> }
                                        }
                                        texture
                                        {
                                               puttyTex scale gr(0.5)+0.75 rotate gr(20)
                                        }     
                                        texture { LowLevelDirt }
                                }   
                                // Glass                        
                                #if(showGlass)
                                        union
                                        {                     
                                                #declare showBWindow=0.0;
                                                #declare bWindow=gr(1);
                                                #if(bWindow > showBWindow)
                                                        mkBrokenWindow(<-0.2, 40, 20>, <0.2, 82, 40>)
                                                #end
                                                #declare bWindow=gr(1);
                                                #if(bWindow > showBWindow)
                                                        mkBrokenWindow(<-0.2, 40, 40>, <0.2, 82, 60>)
                                                #end
        
                                                #declare bWindow=gr(1);
                                                #if(bWindow > showBWindow)
                                                        mkBrokenWindow(<-0.2, 82, 20>, <0.2, 125, 40>)
                                                #end
                                                #declare bWindow=gr(1);
                                                #if(bWindow > showBWindow)
                                                        mkBrokenWindow(<-0.2, 82, 40>, <0.2, 125, 60>)
                                                #end
        
                                                #declare bWindow=gr(1);
                                                #if(bWindow > showBWindow)
                                                        mkBrokenWindow(<-0.2, 125, 20>, <0.2, 150, 40>)
                                                #end
                                                #declare bWindow=gr(1);
                                                #if(bWindow > showBWindow)
                                                        mkBrokenWindow(<-0.2, 125, 40>, <0.2, 150, 60>)
                                                #end
        
                                        }
                                #end                                
                                
}

#end

// Shed

#declare shed = union
{
        
        #if(showWalls)
        // walls
        union
        {
                #declare sections = 0;
                #while (sections < 5)  
                        // right side
                        union
                        {
                                object { Round_Box_Union(<-5, 40, 0>, <5, 150, 20>, 0.1) }
                                difference
                                {
                                        object { Round_Box_Union(<-4.5, 125, 20>, <4.5, 150, 60>, 0.1) } 
                                        union
                                        {
                                                object { torus {20, 2} rotate <0, 0, 90> translate <-5.1, 125, 40> }
                                                object { torus{20, 2} rotate <0, 0, 90> translate <5.1, 125, 40> }
                                                object { sphere{<0, 125, 40>, 20} }
                                        }
                                }   
                                
                                // top part
                                difference
                                {
                                        object { Round_Box_Union(<-6, 150, 0>, <6, 200, 60>, 0.5)  }
                                       
                                        Round_Box_Union(<-7, 160, 10>, <-5.5, 190, 50>, 0.5)                        
                                }   
                                Round_Box_Union(<-6, -10, 0>, <6, 40, 60>, 0.5)


                                // Window frame
                                object { windowFrame() }
                                
                                

                                translate <200, 0, sections*60>
                        } 
                        
                        
                        // right side far part    
                        // frame
                        
                        union
                        {
                                object { Round_Box_Union(<-5, 40, 0>, <5, 150, 20>, 0.1) }
                                difference
                                {
                                        object { Round_Box_Union(<-4.5, 125, 20>, <4.5, 150, 60>, 0.1) } 
                                        union
                                        {
                                        object { torus{20 2} rotate <0, 0, 90> translate <-5.1, 125, 40> }
                                        object { torus{20 2} rotate <0, 0, 90> translate <5.1, 125, 40> }
                                        object { sphere{<0, 125, 40> 20} }         
                                        }
                                }   
                                
                                // top part
                                difference
                                {
                                        object { Round_Box_Union(<-6, 150, 0>, <6, 200, 60>, 0.5)  }
                                       
                                        Round_Box_Union(<-7, 160, 10>, <-5.5, 190, 50>, 0.5)                        
                                }   
                                Round_Box_Union(<-6, -10, 0>, <6, 40, 60>, 0.5)     

                                // Window frame
                                object { windowFrame() }

                                scale <1, 1, -1>

                                translate <200, 0, 600+(sections*60)>
                        } 
        
                        // left side
                        union
                        {
                                object { Round_Box_Union(<-5, 40, 0>, <5, 150, 20>, 0.1) }
                                difference
                                {
                                        object { Round_Box_Union(<-4.5, 125, 20>, <4.5, 150, 60>, 0.1) } 
                                        union
                                        {
                                        object { torus{20 2} rotate <0, 0, 90> translate <-5.1, 125, 40> }
                                        object { torus{20 2} rotate <0, 0, 90> translate <5.1, 125, 40> }
                                        object { sphere{<0, 125, 40> 20} }  
                                        }
                                }   
                                
                                // top part
                                difference
                                {
                                        object { Round_Box_Union(<-6, 150, 0>, <6, 200, 60>, 0.5)  }
                                       
                                        Round_Box_Union(<-7, 160, 10>, <-5.5, 190, 50>, 0.5)                        
                                }   
                                Round_Box_Union(<-6, -10, 0>, <6, 40, 60>, 0.5)    

                                object { windowFrame() }


                                scale <-1, 1, 1> 
                                translate <-200, 0, sections*60>
                        } 
                        // left side far part 
                        union
                        {
                                object { Round_Box_Union(<-5, 40, 0>, <5, 150, 20>, 0.1) }
                                difference
                                {
                                        object { Round_Box_Union(<-4.5, 125, 20>, <4.5, 150, 60>, 0.1) }  
                                        union
                                        {
                                        object { torus{20 2} rotate <0, 0, 90> translate <-5.1, 125, 40> }
                                        object { torus{20 2} rotate <0, 0, 90> translate <5.1, 125, 40> }
                                        object { sphere{<0, 125, 40>, 20} }        
                                        }
                                }   
                                
                                // top part
                                difference
                                {
                                        object { Round_Box_Union(<-6, 150, 0>, <6, 200, 60>, 0.5)  }
                                       
                                        Round_Box_Union(<-7, 160, 10>, <-5.5, 190, 50>, 0.5)                        
                                }   
                                Round_Box_Union(<-6, -10, 0>, <6, 40, 60>, 0.5)     


                                // Window frame
                                object { windowFrame() }

                                scale <-1, 1, -1>
                                translate <-200, 0, 600+(sections*60)>
                        } 
                        
                        #declare sections=sections+1;
                
                #end       
                
                // Doorway half way down on right side
                
                union
                {
                        Round_Box_Union(<-6, -10, 0>, <6, 150, 50>, 0.5)
                        Round_Box_Union(<-6, -10, 190>, <6, 150, 240>, 0.5)
                        difference
                        {
                                Round_Box_Union(<-6, 150, 0>, <6, 200, 240>, 0.5)
                                Round_Box_Union(<-7, 160, 10>, <-5.5, 190, 230>, 0.5)
                        }
                        translate <200, 0, 300>
                }                         
        
                // Doorway half way down on left side
                
                union
                {
                        Round_Box_Union(<-6, -10, 0>, <6, 150, 50>, 0.5)
                        Round_Box_Union(<-6, -10, 190>, <6, 150, 240>, 0.5)
                        difference
                        {
                                Round_Box_Union(<-6, 150, 0>, <6, 200, 240>, 0.5)
                                Round_Box_Union(<-7, 160, 10>, <-5.5, 190, 230>, 0.5)
                        }
                        scale <-1, 1, 1>
                        translate <-200, 0, 300>
                }  
                
                // ends of building 
                union
                {

                        // front
                        difference
                        {
                                Round_Box_Union(<-207, -10, -10>, <-160, 150, 2>, 0.5)   
                                Round_Box_Union(<-187, 10, -14>, <-170, 140, -9.5>, 0.5)
                                Round_Box_Union(<-187, 10, 1.5>, <-170, 140, -4>, 0.5)
                        }
                        
                        difference
                        {
                                Round_Box_Union(<160, -10, -10>, <207, 150, 2>, 0.5)                        
                                Round_Box_Union(<170, 10, -14>, <187, 140, -9.5>, 0.5)
                                Round_Box_Union(<170, 10, 1.5>, <187, 140, -4>, 0.5)
                        }     
                        
                        // middle part
                        difference
                        {
                                Round_Box_Union(<-30, -10, -10>, <30, 150, 2>, 0.5)                        
                                Round_Box_Union(<-20, 10, -14>, <20, 140, -9.5>, 0.5)
                                Round_Box_Union(<-20, 10, 1.5>, <20, 140, -4>, 0.5)
                        }
                        
                        // top part
                        difference
                        {
                                Round_Box_Union(<-207, 150, -10>, <207, 210, 2>, 0.5)                        
                                Round_Box_Union(<-187, 160, -14>, <187, 200, -9.5>, 0.5)
                                Round_Box_Union(<-187, 160, 1.5>, <187, 200, -4>, 0.5)
                        }
                            
                // back

                        difference
                        {
                                Round_Box_Union(<-207, -10, 838>, <-160, 150, 850>, 0.5)   
                                Round_Box_Union(<-187, 10, 830>, <-170, 140, 838.5>, 0.5)
                                Round_Box_Union(<-187, 10, 849.5>, <-170, 140, 858>, 0.5)
                        }
                        
                        difference
                        {
                                Round_Box_Union(<160, -10, 838>, <207, 150, 850>, 0.5)                        
                                Round_Box_Union(<170, 10, 830>, <187, 140, 838.5>, 0.5)
                                Round_Box_Union(<170, 10, 849.5>, <187, 140, 858>, 0.5)
                        }
                        
                        // middle part
                        difference
                        {
                                Round_Box_Union(<-30, -10, 838>, <30, 150, 850>, 0.5)                        
                                Round_Box_Union(<-20, 10, 830>, <20, 140, 838.5>, 0.5)
                                Round_Box_Union(<-20, 10, 849.5>, <20, 140, 858>, 0.5)
                        }
        
                        // top part
                        difference
                        {
                                Round_Box_Union(<-207, 150, 838>, <207, 210, 850>, 0.5)                        
                                Round_Box_Union(<-187, 160, 830>, <187, 200, 838.5>, 0.5)
                                Round_Box_Union(<-187, 160, 849.5>, <187, 200, 858>, 0.5)
                        }

                        texture                                 
                        {
                                gradient y   
                                turbulence 0.1
                                texture_map
                                {
                                        [ 0.0 land_tex_dry scale <1, 0.01, 0.0002> ]
                                        [ 0.1 land_tex_dry scale <1, 0.01, 0.0002> ]
                                        [ 0.7 wallTex scale 0.004 ]
                                        [ 1.0 wallTex scale 0.004 ]
                                        
                                
                                }         
                                scale 275
                                translate <0, -30, 0>   
                                rotate <0, 90, 0>
                        }         
                }                               
                texture                                 
                {
                        gradient y   
                        turbulence 0.1
                        texture_map
                        {
                                [ 0.0 land_tex_dry scale <1, 0.01, 0.0002> ]
                                [ 0.1 land_tex_dry scale <1, 0.01, 0.0002> ]
                                [ 0.7 wallTex scale 0.004 ]
                                [ 1.0 wallTex scale 0.004 ]
                                
                        
                        }         
                        scale 275
                        translate <0, -30, 0> 
                }         
        }
        
        #end // end of show walls
        
        // beams
        #if(showBeams)
        #declare sections = 0;
        #while (sections < 15) 
                
                // straight beam across width of building
                object { woodBlock(200, 4, 3, 0.5, 1) translate <0, 192, sections*60> }  
                
                // pitch/slope part
                object { woodBlock(120, 3, 2.75, 0.5, 1) translate <120, 0, 0> rotate <0, 0, 35> translate <-200, 192, sections*60> }  
                object { woodBlock(120, 3, 2.75, 0.5, 1) translate <-120, 0, 0> rotate <0, 0, -35> translate <200, 192, sections*60> }  
                
                // straight part up between bottom and pitch part
                object { woodBlock(52, 2, 2.25, 0.5, 1) rotate <0, 0, 90> translate <50, 244, sections*60> }  
                object { woodBlock(52, 2, 2.25, 0.5, 1) rotate <0, 0, 90> translate <-50, 244, sections*60> }  

                object { woodBlock(52, 2, 2.25, 0.5, 1) translate <0, 292, sections*60> }  
             //   object { woodBlock(52, 2, 2.25, 0.5, 1) translate <0, 242, sections*60> }  

                // small sloped section
                object { woodBlock(41, 1.85, 1.85, 0.5, 1) translate <41, 0, 0> rotate <0, 0, 35> translate <50, 205, sections*60> }  
                object { woodBlock(41, 1.85, 1.85, 0.5, 1) translate <-41, 0, 0> rotate <0, 0, -35> translate <-50, 205, sections*60> }  
                
                #declare sections=sections+1;
        
        #end       
                // top beam runs length of building
                object { woodBlock(422, 5, 5, 0.5, 1) rotate <0, 90, 0> translate <0, 330, 420> }  

        #end   
        
        // Doors
        
        #if(showShedDoors)
        // Front left left door
        object { shedDoor(8) translate <4.06, 0, 0> rotate <0, 50, 0> translate <-160, 0, -2> }

        // Front left right door
        object { shedDoor(8) scale <-1, 1, 1> translate <-4.06, 0, 0> rotate <0, -33, 0> translate <-30, 0, -2> }

        // Front right left door
        object { shedDoor(8) translate <4.06, 0, 0> rotate <0, 50, 0> translate <30, 0, -2> }

        // Front right right door
        object { shedDoor(8) scale <-1, 1, 1> translate <-4.06, 0, 0> rotate <0, -33, 0> translate <160, 0, -2> }
        

        // Back left left door
        object { shedDoor(8) scale <1, 1, -1> translate <4.06, 0, 0> rotate <0, -50, 0> translate <-160, 0, 842> }

        // Back left right door
        object { shedDoor(8) scale <-1, 1, -1> translate <-4.06, 0, 0> rotate <0, 33, 0> translate <-30, 0, 842> }

        // Back right left door
        object { shedDoor(8) scale <1, 1, -1> translate <4.06, 0, 0> rotate <0, -72, 0> translate <30, 0, 842> }

        // Back right right door
        object { shedDoor(8) scale <-1, 1, -1> translate <-4.06, 0, 0> rotate <0, 22, 0> translate <160, 0, 842> }
        
        // right side door
        object { shedDoor(9) scale <1, 1, 1> translate <4.06, 0, 0> rotate <0, -36, 0> translate <198, 0, 350> }
        object { shedDoor(9) scale <-1, 1, 1> translate <-4.06, 0, 0> rotate <0, -175, 0> translate <198, 0, 490> }

        // left side door
        object { shedDoor(9) scale <1, 1, 1> translate <4.06, 0, 0> rotate <0, 140, 0> translate <-198, 0, 490> }
        object { shedDoor(9) scale <-1, 1, 1> translate <-4.06, 0, 0> rotate <0, 42, 0> translate <-198, 0, 350> }
        
        #end // end of show shed doors
        
        // add the floor

/*
        object { concreteBlock(45, 5, 450, 1.5, 3) texture { buildingFloorTex scale <40, 0.6, 0.6> translate <5, 0, 0> } translate <-167, -5, 420> }  
        object { concreteBlock(15, 5, 450, 1.5, 3) texture { buildingFloorTex scale <15, 0.3, 0.3> } translate <-100, -5, 420> }  

        object { concreteBlock(78, 5, 450, 1.5, 3) texture { buildingFloorTex scale <78, 1, 1> } translate <0, -5, 420> }  

        object { concreteBlock(45, 5, 450, 1.5, 3) texture { buildingFloorTex scale <45, 0.7, 0.7> } translate <167, -5, 420> }  
        object { concreteBlock(15, 5, 450, 1.5, 3) texture { buildingFloorTex scale <15, 0.3, 0.3> } translate <100, -5, 420> }  
*/
        object { concreteBlock(45, 5, 450, 1.5, 3) texture { land_tex_dry scale <40, 0.6, 0.6> translate <5, 0, 0> } translate <-167, -5, 420> }  
        object { concreteBlock(15, 5, 450, 1.5, 3) texture { land_tex_dry scale <15, 0.3, 0.3> } translate <-100, -5, 420> }  

        object { concreteBlock(78, 5, 450, 1.5, 3) texture { land_tex_dry scale <78, 1, 1> } translate <0, -5, 420> }  

        object { concreteBlock(45, 5, 450, 1.5, 3) texture { land_tex_dry scale <45, 0.7, 0.7> } translate <167, -5, 420> }  
        object { concreteBlock(15, 5, 450, 1.5, 3) texture { land_tex_dry scale <15, 0.3, 0.3> } translate <100, -5, 420> }  
        

} 


#macro addRandMossPatch(shedObj, patchLoc)
/*
        #local patchWidth=2+gr(8);
        #local patchLength=3+gr(12);
        #local patchRand=0.85+gr(0.1);
        #local patchScale=0.5+gr(0.4);
        #local patchStep1=patchWidth*(5+gr(2));
        #local patchStep2=patchLength*(6+gr(3));                                                                                     
        #local patchClumpSize=0.4+gr(0.3);
        object { Place_Moss(shedObj, patchLoc, patchLoc+<patchWidth, 0, patchLength>, patchRand <0, -1, 0>, 
                patchClumpSize, <1, patchScale, 1>, patchStep1, patchStep2, false, 0.065, 11, MOSS_TYPE_2, mHairTex, mEarthTex) }
*/
        #local patchWidth=2+gr(8);
        #local patchLength=3+gr(12);
        #local patchRand=0.85+gr(0.1);
        #local patchScale=0.35+gr(0.3);
        #local patchStep1=patchWidth*(3+gr(3));
        #local patchStep2=patchLength*(4+gr(3));                                                                                     
        #local patchClumpSize=0.6+gr(0.45);
        object { Place_Moss(shedObj, patchLoc, patchLoc+<patchWidth, 0, patchLength>, patchRand <0, -1, 0>, 
                patchClumpSize, <1, patchScale, 1>, patchStep1, patchStep2, false, 0.065, 11, MOSS_TYPE_2, mHairTex, mEarthTex) }

#end
                                                        

#declare ladderIsoSurface=0.825;
                             
// build steps
#declare stepLadder = union
{
        union
        {
                object { woodBlockNoTex(8, 0.4, 2, 0.1, ladderIsoSurface) translate <0, 0, 0> }
                object { woodBlockNoTex(8, 0.4, 2, 0.1, ladderIsoSurface) translate <0, 3, 4> }
                object { woodBlockNoTex(8, 0.4, 2, 0.1, ladderIsoSurface) translate <0, 6, 8> }
                object { woodBlockNoTex(8, 0.4, 2, 0.1, ladderIsoSurface) translate <0, 9, 12> }
                object { woodBlockNoTex(8, 0.4, 2, 0.1, ladderIsoSurface) translate <0, 12, 16> }
                object { woodBlockNoTex(8, 0.4, 2, 0.1, ladderIsoSurface) translate <0, 15, 20> }
                object { woodBlockNoTex(8, 0.4, 2, 0.1, ladderIsoSurface) translate <0, 18, 24> }
        
                // top platform
                difference
                {
                        object { woodBlockNoTex(8, 0.5, 3, 0.1, ladderIsoSurface) translate <0, 21, 28> }  
                        object { Round_Box_Union(<-0.55, 0, -0.05>, <0.55, 48, 2.05>, 0.2) translate <7.8, 0, 31> }
                        object { Round_Box_Union(<-0.55, 0, -0.05>, <0.55, 48, 2.05>, 0.2) translate <-7.8, 0, 31> }
                }
                object { woodBlockNoTex(8, 0.5, 3, 0.1, ladderIsoSurface) translate <0, 21, 32> }  
                object { woodBlockNoTex(8, 0.5, 3, 0.1, ladderIsoSurface) translate <0, 21, 38> }  
                object { woodBlockNoTex(8, 0.5, 3, 0.1, ladderIsoSurface) translate <0, 21, 44> }  
                object { woodBlockNoTex(8, 0.5, 3, 0.1, ladderIsoSurface) translate <0, 21, 50> }      
                
                texture 
                {
                        pigment 
                        {       wood
                                turbulence 0.075
                                omega 0.8
                                lambda 3
                                colour_map
                                { 
                                        [ 0.0 rgb <0.05, 0.035, 0.01> ] 
                                        [ 0.6 rgb <0.1, 0.08, 0.035> ] 
                                        [ 1.0 rgb <0.05, 0.035, 0.01>*0.1 ] 
                                }  
                                rotate <0, 90, 2> 
                                scale <5, 1, 1>
                                
                        }
                        
                        finish { ambient 0 }    
                        normal { dents 1 scale <25, 1, 0.5> }
                } 
                texture
                {
                        pigment
                        {
                                wrinkles   
                                turbulence 0.34
                                omega 0.8
                                lambda 2.4
                                colour_map
                                {
                                        [ 0.0 rgbt <0.02, 0.01, 0, 0.05> ]
                                        [ 0.2 rgbt <0.02, 0.01, 0, 0.5> ]
                                        [ 0.5 rgbt <0.02, 0.01, 0, 1> ]
                                        [ 0.7 rgbt <0.02, 0.01, 0, 0.2> ]
                                        [ 0.9 rgbt <0.02, 0.01, 0, 0.85> ]
                                        [ 1.0 rgbt <0.02, 0.01, 0, 0.05> ]
                                }
                        }         
                        finish { ambient 0 diffuse 0.5 }
                        normal { dents 1 scale <25, 1, 0.5> }
                }
                texture
                {
                        pigment
                        {
                                wrinkles   
                                turbulence 0.52
                                omega 0.8
                                lambda 2.4
                                colour_map
                                {
                                        [ 0.0 rgbt <1, 1, 1, 1> ]
                                        [ 0.6 rgbt <1, 1, 1, 1> ]
                                        [ 0.6 rgbt <0.0, 0.03, 0.0, 1> ]
                                        [ 0.7 rgbt <0.0, 0.03, 0.0, 0.1> ]
                                        [ 0.8 rgbt <0.0, 0.03, 0.0, 0.1> ]
                                        [ 0.9 rgbt <0.0, 0.03, 0.0, 1> ]
                                        [ 0.9 rgbt <1, 1, 1, 1> ]
                                        [ 1.0 rgbt <1, 1, 1, 1> ]
                                }
                        }         
                        finish { ambient 0 diffuse 0.5 }
                        normal { dents 1 scale <25, 1, 0.5> }
                }
                
                
                translate <0, 3, 5>
        }        
        // metal frame
        
        difference
        {
                object { Round_Box_Union(<-0.5, 0, 0>, <0.5, 45, 2>, 0.2) rotate <53, 0, 0> translate <7.8, 0, 0> }

                box { <6, -5, 0> <10, 0, 15> }
                box { <6, 0, 31> <10, 33, 50> }

                union
                {
                        box { <6, -0.4, -2> <8, 0.45, 2> translate <0, 0, 0> }
                        box { <6, -0.4, -2> <8, 0.45, 2> translate <0, 3, 4> }
                        box { <6, -0.4, -2> <8, 0.45, 2> translate <0, 6, 8> }
                        box { <6, -0.4, -2> <8, 0.45, 2> translate <0, 9, 12> }
                        box { <6, -0.4, -2> <8, 0.45, 2> translate <0, 12, 16> }
                        box { <6, -0.4, -2> <8, 0.45, 2> translate <0, 15, 20> }
                        box { <6, -0.4, -2> <8, 0.45, 2> translate <0, 18, 24> }
                        translate <0, 3, 5>
                }
                
        }         
        difference
        {
                object { Round_Box_Union(<-0.5, 0, 0>, <0.5, 45, 2>, 0.2) rotate <53, 0, 0> translate <-7.8, 0, 0> }

                box { <-10, -5, 0> <-6, 0, 15> }
                box { <-10, 0, 31> <-6, 33, 50> }

                union
                {
                        box { <-8, -0.4, -2> <-6, 0.45, 2> translate <0, 0, 0> }
                        box { <-8, -0.4, -2> <-6, 0.45, 2> translate <0, 3, 4> }
                        box { <-8, -0.4, -2> <-6, 0.45, 2> translate <0, 6, 8> }
                        box { <-8, -0.4, -2> <-6, 0.45, 2> translate <0, 9, 12> }
                        box { <-8, -0.4, -2> <-6, 0.45, 2> translate <0, 12, 16> }
                        box { <-8, -0.4, -2> <-6, 0.45, 2> translate <0, 15, 20> }
                        box { <-8, -0.4, -2> <-6, 0.45, 2> translate <0, 18, 24> }
                        translate <0, 3, 5>
                }
                
        }         

        // legs under platform
        object { Round_Box_Union(<-0.5, 0, 0>, <0.5, 48, 2>, 0.2) translate <7.8, 0, 31> }
        object { Round_Box_Union(<-0.5, 0, 0>, <0.5, 48, 2>, 0.2) translate <-7.8, 0, 31> }
        object { Round_Box_Union(<-0.5, 0, 0>, <0.5, 48, 2>, 0.2) translate <7.8, 0, 56> } 
        object { Round_Box_Union(<-0.5, 0, 0>, <0.5, 48, 2>, 0.2) translate <-7.8, 0, 56> } 
        
        // top support
        object { Round_Box_Union(<-0.5, 0, 0>, <0.5, 2, 23>, 0.2) translate <7.8, 46, 33> }
        object { Round_Box_Union(<-8, 0, 0>, <8, 2, 1>, 0.1) translate <0, 46, 57> }

        // support under platform
        object { Round_Box_Union(<-0.5, 0, 0>, <0.5, 2, 23>, 0.2) translate <7.8, 22, 33> }
        object { Round_Box_Union(<-8, 0, 0>, <8, 2, 1>, 0.1) translate <0, 22, 57> }
        object { Round_Box_Union(<-0.5, 0, 0>, <0.5, 2, 23>, 0.2) translate <-7.8, 22, 33> }
        object { Round_Box_Union(<-8, 0, 0>, <8, 2, 1>, 0.1) translate <0, 22, 31> }

        // support at base
        object { Round_Box_Union(<-0.5, 0, 0>, <0.5, 1, 23>, 0.2) translate <7.8, 4, 33> }
        object { Round_Box_Union(<-8, 0, 0>, <8, 1, 1>, 0.1) translate <0, 4, 57> }
        object { Round_Box_Union(<-0.5, 0, 0>, <0.5, 1, 23>, 0.2) translate <-7.8, 4, 33> }
        object { Round_Box_Union(<-8, 0, 0>, <8, 1, 1>, 0.1) translate <0, 4, 31> }

        object { Round_Box_Union(<-0.5, 0, 0>, <0.5, 1, 25>, 0.2) translate <7.8, 4, 8> }
        object { Round_Box_Union(<-0.5, 0, 0>, <0.5, 1, 25>, 0.2) translate <-7.8, 4, 8> }
        
        // rods under steps
        union
        {
                object { Round_Box_Union(<-8, -1, -1.5> <8, -0.4, -1.0>, 0.2) }
                object { Round_Box_Union(<-8, -1, -1.5> <8, -0.4, -1.0>, 0.2) translate <0, 3, 4> }
                object { Round_Box_Union(<-8, -1, -1.5> <8, -0.4, -1.0>, 0.2) translate <0, 6, 8> }
                object { Round_Box_Union(<-8, -1, -1.5> <8, -0.4, -1.0>, 0.2) translate <0, 9, 12> }
                object { Round_Box_Union(<-8, -1, -1.5> <8, -0.4, -1.0>, 0.2) translate <0, 12, 16> }
                object { Round_Box_Union(<-8, -1, -1.5> <8, -0.4, -1.0>, 0.2) translate <0, 15, 20> }
                object { Round_Box_Union(<-8, -1, -1.5> <8, -0.4, -1.0>, 0.2) translate <0, 18, 24> }
                translate <0, 3, 5>
        }
        #declare rustColour=rgb <0.17, 0.07, 0.0>*0.6;
        texture
        {
                pigment { rgb <0.2, 0.2, 0.2> }
                finish { phong 0.2 ambient 0 }
        }                                     
        texture
        {
                pigment 
                { 
                        granite 
//                        scallop_wave
                        turbulence 0.7
                        omega 0.75 lambda 2.5
                        colour_map
                        {
                                [ 0.0 rgbt <1, 1, 1, 1> ]
                                [ 0.1 rgbt <1, 1, 1, 1> ]
                                [ 0.1 rgbt <rustColour.red, rustColour.green, rustColour.blue, 1> ] 
                                [ 0.325 rgbt <rustColour.red, rustColour.green, rustColour.blue, 0.0> ]
                                [ 0.775 rgbt <rustColour.red, rustColour.green, rustColour.blue, 0.0> ]
                                [ 0.9 rgbt <rustColour.red, rustColour.green, rustColour.blue, 0, 1> ]
                                [ 0.9 rgbt <1, 1, 1, 1> ]
                                [ 1.0 rgbt <1, 1, 1, 1> ]
                        } 
                        scale 1
                } 
                finish { ambient 0 diffuse 0.55 }
                normal { granite 1.5 scale 0.3 }
        }
        texture
        {
                pigment 
                { 
                        wrinkles      
                        scallop_wave
                        turbulence 0.6
                        omega 0.7
                        lambda 3
                        colour_map
                        {
                                [ 0.0 rgbt <1, 1, 1, 1> ]
                                [ 0.1 rgbt <1, 1, 1, 1> ]
                                [ 0.1 rgbt <rustColour.red, rustColour.green, rustColour.blue, 1> ] 
                                [ 0.35 rgbt <rustColour.red, rustColour.green, rustColour.blue, 0.0> ]
                                [ 0.65 rgbt <rustColour.red, rustColour.green, rustColour.blue, 0.0> ]
                                [ 0.9 rgbt <rustColour.red, rustColour.green, rustColour.blue, 1> ]
                                [ 0.9 rgbt <1, 1, 1, 1> ]
                                [ 1.0 rgbt <1, 1, 1, 1> ]
                        } 
                        scale 4
                } 
                finish { ambient 0 diffuse 0.55 }
                normal { granite 1.5 scale 0.3 }
        }
        texture
        {
                pigment
                {
                        wrinkles   
                        turbulence 0.34
                        omega 0.8
                        lambda 2.4
                        colour_map
                        {
                                [ 0.0 rgbt <0.02, 0.01, 0, 0.05> ]
                                [ 0.2 rgbt <0.02, 0.01, 0, 0.5> ]
                                [ 0.5 rgbt <0.02, 0.01, 0, 1> ]
                                [ 0.7 rgbt <0.02, 0.01, 0, 0.2> ]
                                [ 0.9 rgbt <0.02, 0.01, 0, 0.85> ]
                                [ 1.0 rgbt <0.02, 0.01, 0, 0.05> ]
                        }
                }         
                finish { ambient 0 diffuse 0.5 }
                normal { granite 1 scale 0.25 }
        }
        texture
        {
                pigment
                {
                        wrinkles   
                        turbulence 0.52
                        omega 0.8
                        lambda 2.4
                        colour_map
                        {
                                [ 0.0 rgbt <1, 1, 1, 1> ]
                                [ 0.6 rgbt <1, 1, 1, 1> ]
                                [ 0.6 rgbt <rustColour.red, rustColour.green, rustColour.blue, 1> ]
                                [ 0.7 rgbt <rustColour.red, rustColour.green, rustColour.blue, 0.1> ]
                                [ 0.8 rgbt <0.0, 0.03, 0.0, 0.1> ]
                                [ 0.9 rgbt <0.0, 0.03, 0.0, 1> ]
                                [ 0.9 rgbt <1, 1, 1, 1> ]
                                [ 1.0 rgbt <1, 1, 1, 1> ]
                        }
                }         
                finish { ambient 0 diffuse 0.5 }
                normal { granite 1.25 scale 0.3 }
        }        

} 



#declare sleeperTex = texture 
{
        pigment 
        {       wood
                turbulence 0.075
                omega 0.65
                lambda 3
                colour_map
                { 
                        [ 0.0 rgb <0.05, 0.035, 0.01>*0.7 ] 
                        [ 0.6 rgb <0.1, 0.08, 0.035>*0.5 ] 
                        [ 1.0 rgb <0.05, 0.035, 0.01>*0.3 ] 
                }  
                rotate <0, 90, 2> 
                
        }
        
        finish { ambient 0 }
} 
texture
{
        pigment
        {
                wrinkles   
                turbulence 0.34
                omega 0.8
                lambda 2.4
                colour_map
                {
                        [ 0.0 rgbt <0.02, 0.01, 0, 0.05> ]
                        [ 0.2 rgbt <0.02, 0.01, 0, 0.5> ]
                        [ 0.5 rgbt <0.02, 0.01, 0, 1> ]
                        [ 0.7 rgbt <0.02, 0.01, 0, 0.2> ]
                        [ 0.9 rgbt <0.02, 0.01, 0, 0.85> ]
                        [ 1.0 rgbt <0.02, 0.01, 0, 0.05> ]
                }
        }         
        finish { ambient 0 diffuse 0.5 }
}
texture
{
        pigment
        {
                wrinkles   
                turbulence 0.52
                omega 0.8
                lambda 2.4
                colour_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.6 rgbt <1, 1, 1, 1> ]
                        [ 0.6 rgbt <0.0, 0.001, 0.0, 1> ]
                        [ 0.7 rgbt <0.0, 0.002, 0.0, 0.3> ]
                        [ 0.8 rgbt <0.0, 0.003, 0.0, 0.2> ]
                        [ 0.9 rgbt <0.0, 0.001, 0.0, 1> ]
                        [ 0.9 rgbt <1, 1, 1, 1> ]
                        [ 1.0 rgbt <1, 1, 1, 1> ]
                }      
                scale 5
        }         
        finish { ambient 0 diffuse 0.5 }
}

#if(showBuilding)
object { shed }        

//#macro Place_Moss(objectSurface, sVect, eVect, random, fallDirection, clumpSize, clumpScale, clumpStep1, clumpStep2, showHairs, hairSize, hairAmount)

#if(showMoss)
/*
object { Place_Moss(shed, <-194, 20, 212>, <-193, 20, 218>, 0.7, <0, -1, 0>, 0.3, <1, 0.8, 1>, 10, 18, useMossHair, 0.065, 11, MOSS_TYPE_2) }
object { Place_Moss(shed, <-194, 20, 220>, <-193, 20, 224>, 0.7, <0, -1, 0>, 0.3, <1, 0.8, 1>, 10, 15, useMossHair, 0.065, 11, MOSS_TYPE_2) }
object { Place_Moss(shed, <-194, 20, 227>, <-192.5, 20, 233>, 0.7, <0, -1, 0>, 0.3, <1, 0.8, 1>, 12, 15, useMossHair, 0.065, 12, MOSS_TYPE_2) }
object { Place_Moss(shed, <-194, 20, 240>, <-193, 20, 246>, 0.7, <0, -1, 0>, 0.3, <1, 0.8, 1>, 10, 18, useMossHair, 0.065, 13, MOSS_TYPE_2) }
object { Place_Moss(shed, <-194, 20, 249>, <-193, 20, 252>, 0.7, <0, -1, 0>, 0.3, <1, 0.8, 1>, 10, 12, useMossHair, 0.065, 11, MOSS_TYPE_2) }
*/
object { Place_Moss(shed, <-194, 20, 202>, <-191, 20, 258>, 0.8, <0, -1, 0>, 0.5, <1, 0.8, 1>, 20, 128, false, 0.065, 11, MOSS_TYPE_2, mHairTex, mEarthTex) }

/*
object { addRandMossPatch(shed, <-95, 20, 200>) }
object { addRandMossPatch(shed, <-25, 20, 275>) }
object { addRandMossPatch(shed, <-5, 20, 280>) }
object { addRandMossPatch(shed, <2, 20, 290>) }

object { addRandMossPatch(shed, <45, 20, 350>) }
object { addRandMossPatch(shed, <-20, 20, 375>) }

object { addRandMossPatch(shed, <-125, 20, 220>) }
object { addRandMossPatch(shed, <20, 20, 400>) }
object { addRandMossPatch(shed, <95, 20, 270>) }
object { addRandMossPatch(shed, <-40, 20, 310>) }
object { addRandMossPatch(shed, <85, 20, 325>) }
object { addRandMossPatch(shed, <65, 20, 335>) }
*/
#end     


//object { Place_Moss(shed, <-194.5, 20, 219>, <-191, 20, 225>, 0.6, <0, -1, 0>, 0.75, <1, 0.6, 1>, 10, 26, true, 0.4, 9, MOSS_TYPE_2) }

//object { Place_Moss(shed, <-194.5, 10, 215>, <-192, 10, 224>, 0.7, <0, -1, 0>, 1.0, <1, 0.6, 1>, 7, 30, true, 0.4, 9, MOSS_TYPE_2) }


//object { Place_Moss(shed, <-194.5, 10, 232>, <-192, 10, 250>, 0.6, <0, -1, 0>, 0.9, <1, 0.7, 1>, 7, 38, true, 0.4, 9, MOSS_TYPE_2) }

object { stepLadder rotate <0, 5, 0> translate <-50, 0, 200> } 

//object { stepLadder rotate <0, 125, 0> translate <45, 0, 200> } 
union
{
        object { stepLadder }
        object { Place_Moss(stepLadder, <0, 60, 32.5>, <-4, 60, 36.75>, 0.85, <0, -1, 0>, 0.85, <1, 0.6, 1>, 20, 20, useMossHair, 0.12, 11, MOSS_TYPE_2, mHairTex, mEarthTex) }
        rotate <0, 125, 0> translate <48, 0, 79> 
} 


// sleepers
union
{
#declare sleeperStack=0;
#while(sleeperStack < 3)
        #declare sleeperHeight=0;
        #while(sleeperHeight < 5)     
                #declare sleeperPos=0;
                #while(sleeperPos < 6)
                        object { woodBlockNoTex(40, 3, 4, 0.7, 1) rotate <0, -1+gr(2), 0> translate <sleeperStack*-(110+gr(25))+(-1+gr(1)), (sleeperHeight*6), (sleeperPos*8)+0.5-gr(0.5)> 
                                texture { sleeperTex rotate <gr(1), gr(1), gr(2)> scale 0.3+gr(0.2) }  }   
                        #declare sleeperPos=sleeperPos+1;
                #end
                #declare sleeperHeight=sleeperHeight+1;
        #end
        #declare sleeperStack=sleeperStack+1;
#end
        rotate <0, 90, 0> 
        translate <10, 3, 330>   
}
#end















#declare railTex1 = texture
{
        pigment 
        { 
                granite
                colour_map
                {
                        [ 0.0 rgb <0.3, 0.3, 0.3> ]
                        [ 0.6 rgb <0.3, 0.3, 0.3> ]
                        [ 0.7 rgb <0.3, 0.2, 0.0> ]
                        [ 1.0 rgb <0.3, 0.1, 0.0> ]
                
                }                                  
                scale 0.2 
        }
        finish { specular 0.4 roughness 0.02 ambient 0 diffuse 0.45 brilliance 10 metallic reflection 0.025 }
}                      

#declare railTex2 = texture
{
        pigment 
        { 
                wrinkles
                colour_map 
                { 
                        [ 0.0 rgb <0.2, 0.2, 0.2> ]
                        [ 1 rgb <0.3, 0.2, 0.01> ]
                }
                scale 0.4
        }
        finish { ambient 0 diffuse 0.5 }
        normal { wrinkles 2 scale 0.4 }                
}                                      
texture
{
        pigment 
        { 
                granite
                colour_map 
                { 
                        [ 0.0 rgbt <0.2, 0.1, 0, 1> ]
                        [ 1 rgbt <0.2, 0.1, 0, 0.2> ]
                }
                scale 0.2
        }
        finish { ambient 0 diffuse 0.4 }
        normal { granite 1 scale 0.2 }                
}                                      


#declare railTex = texture
{
        slope { <0.02, -1, 0.01> }
        texture_map
        {
                [ 0 railTex1 ] 
                [ 0.2 railTex1  ] 
                [ 0.5 railTex2  ]   
                [ 1 railTex2  ]   
        }     
} 

#declare railNail=union
{
        difference
        {
                sphere { <0, 0, 0> 0.525 scale <1, 0.5, 1> }
                box { <-1, -1, -1> <1, -0.1, 1> }  
                box { <-1, 0.25, -1> <1, 1, 1> }  
                translate <0, 0, 0.25>
        }
        cone { <0, -4, 0> 0.1 <0, 0, 0> 0.25 }
}


#macro track(len, pieces)
        #local pieceLen=(len/pieces);  
        
        union
        {
        #local pieceCount=0;
        #while(pieceCount < pieces)  
                union
                {
                        object { Round_Box_Union( <-(pieceLen-0.2), -1.5, -1.5>, <pieceLen-0.2, 0, 1.5>, 0.65) }
                        box {  <-(pieceLen-0.2), -5, -0.5>, <pieceLen-0.2, -1.5, 0.5> }
                        object { Round_Box_Union( <-(pieceLen-0.2), -1.25, 0>, <pieceLen-0.2, 0, 2.5>, 0.5) rotate <-25, 0, 0> translate <0, -5, -2.5> } 
                        object { Round_Box_Union( <-(pieceLen-0.2), -1.25, -2.5>, <pieceLen-0.2, 0, 0>, 0.5) rotate <25, 0, 0> translate <0, -5, 2.5> } 
                        
                        // add brackets
                        #local bracketSpace=pieceLen/10;
                        #local bracketPos=-pieceLen+bracketSpace;
                        #while(bracketPos < pieceLen) 
                                union
                                {                                                    
                                        box { <bracketPos-1.8, -6.5, -5> <bracketPos+1.8, -6.25, 5> }  
                                        Round_Box_Union(<bracketPos-2, -6.5, -6>, <bracketPos+2, -5, -2.5>, 0.2)  
                                        Round_Box_Union(<bracketPos-2, -6.5, 2.5>, <bracketPos+2, -5, 6>, 0.2)  
                                        
                                        difference
                                        {
                                                box { <bracketPos-2, -6.5, -3> <bracketPos+2, -4.6, -2> } 
                                                cylinder { <bracketPos-3, -4.6, -3> <bracketPos+3, -4.6, -3> 0.4 }  
                                                cylinder { <bracketPos-3, -5.6, -2> <bracketPos+3, -5.6, -2> 0.65 }  
                                                
                                        }

                                        difference
                                        {
                                                box { <bracketPos-2, -6.5, 2> <bracketPos+2, -4.6, 3> } 
                                                cylinder { <bracketPos-3, -4.6, 3> <bracketPos+3, -4.6, 3> 0.4 }  
                                                cylinder { <bracketPos-3, -4.6, 2> <bracketPos+3, -4.6, 2> 0.525 }  
                                                
                                        }
                                        
                                        // nails
                                        object { railNail translate <bracketPos-1.2, -4.5+gr(0.2), -2.4> }
                                        object { railNail translate <bracketPos+1.2, -4.5+gr(0.2), -2.4> }
                                        object { railNail translate <bracketPos, -4.9+gr(0.1), -4.25> }


                                        object { railNail rotate <0, 180, 0> translate <bracketPos-1.2, -4.5+gr(0.2), 2.4> }
                                        object { railNail rotate <0, 180, 0> translate <bracketPos+1.2, -4.5+gr(0.2), 2.4> }
                                        object { railNail rotate <0, 180, 0> translate <bracketPos, -4.9+gr(0.1), 4.25> }
                                }     
                                
                                #local bracketPos=bracketPos+bracketSpace;
                        #end
                                                
                        translate <(-len)+(pieceLen*(pieceCount*2)), gr(0.2), gr(0.1)> 
                }  
                #local pieceCount=pieceCount+1;
        #end
        }
#end





#if(showTrain)

union
{
union
{

        union { Wheels(clock*360+90, 1, 0) scale <1, 1, 1> translate <0, 0, -20> }
        union { Wheels(clock*360+90, 1, 0) scale <1, 1, -1> translate <0, 0, 20> }
        object { trainTop translate <-60, 16, 0> }     
        object { coalTruck translate <-60, 16, 0> }
}   

object { track(2000, 10) translate <0, -19.51, -18.5> }
object { track(2000, 10) translate <0, -19.51, 18.5> }

texture  { railTex }

rotate <0, -90, 0>    
translate <-100, 19, 300>
} 

union
{
object { track(2000, 10) translate <0, -19.51, -18.5> }
object { track(2000, 10) translate <0, -19.51, 18.5> }

texture  { railTex }
rotate <0, -90, 0>    
translate <100, 19, 300>
}          

#end

#declare treeBaseTex = texture
{
        pigment 
        { 
                wrinkles             
                turbulence 0.2                
                colour_map
                {
                        [ 0.0 rgb <0.175, 0.1, 0>*0.7 ] 
                        [ 0.1 rgb <0.175, 0.1, 0>*0.5 ] 
                        [ 0.3 rgb <0.005, 0.06, 0>*0.5 ] 
                        [ 0.5 rgb <0.175, 0.1, 0>*0.4 ] 
                        [ 0.7 rgb <0.01, 0.1, 0>*0.5 ] 
                        [ 1.0 rgb <0.175, 0.1, 0>*0.8 ] 
                }
                scale <0.15, 2, 0.075>     
        }
        finish { ambient 0.0 diffuse 0.5 } 
        normal 
        { 
                average 
                normal_map 
                { 
                        [ 1 wrinkles scale <0.15, 2, 0.1> turbulence 3 omega 0.65 ]
                        [ 1 granite 0.1 scale <0.5, 1, 0.4> turbulence 3 omega 0.65 ]
                }   
        }
}        

 

#if(showTree)
#declare tree = object { black_tupelo_13_stems    
texture
{
        treeBaseTex    
}
         rotate 90*y 
} 

#declare tree2 = object { my_quaking_aspen_13_stems
texture
{
                treeBaseTex 
}     
rotate 90*y } 

#declare tree3 = object { my_lombardy_poplar_13_stems
texture
{
                treeBaseTex    
}
rotate 90*y } 

// add landscape

#macro placeTrees(landObj, startPos, endPos, treeSpace, treeScale)
#declare treeZ=startPos.z;                                           
#declare treeCount=0;
#while(treeZ < endPos.z)
        #declare treeZ=treeZ+gr(treeSpace); 
        #declare treeX=startPos.x;  
        #while(treeX < endPos.x)
                #declare treeX=treeX+gr(treeSpace);
                #local treeHit = <0, 0, 0>;
                #local treePos = trace(landObj, <treeX, 100000, treeZ>, <0, -1, 0>, treeHit);  
                #if(vlength(treeHit) > 0) // hit     
                        #declare treeCount=treeCount+1;
                        #declare treeType=gr(10);
                        #if(treeType < 4)        
                                object { tree rotate <gr(1), gr(360), gr(1)> translate <0, -(0.1+gr(0.25)), 0> scale treeScale+gr(treeScale) translate treePos }     
                        #else
                                #if(treeType < 7)
                                        object { tree2 rotate <gr(1), gr(360), gr(1)> translate <0, -(0.1+gr(0.25)), 0> scale treeScale+gr(treeScale) translate treePos }     
                                #else
                                        object { tree3 rotate <gr(1), gr(360), gr(1)> translate <0, -(0.1+gr(0.25)), 0> scale treeScale+gr(treeScale) translate treePos }                        
                                #end
                        #end
                #end   
                #declare treeX=treeX+treeSpace+gr(treeSpace);
        #end   
        #declare treeZ=treeZ+treeSpace+gr(treeSpace);   
        
#end
        #warning concat(str(treeCount,5,5), " Trees added")
#end
#end

#if(showLandscape)
// Main land
#declare Land1=function{pattern{quilted
   turbulence 0.275 scale <1.1, 1.0, 1.2> translate <-0.7, 0, 0.4> }}
#declare Land2=function{pattern{marble 
   turbulence 0.42 scale <0.95, 1, 1> }}
#declare Land3=function{pattern{crackle 
   turbulence 0.3 scale <0.7, 1, 0.25> rotate <0, 0, 0> translate <0.6, 0, 0.2> }}
#declare Land4=function{pattern{wrinkles
   turbulence 0.275 scale 0.05  }}

#declare Land=function{(sin(z*x*pi*4)+1)/4+Land1(x*5,0,z*5)*0.35+Land4(x*0.4, 0, z*0.8)*0.2+Land4(x*400, 0, z*800)*0.001}//Land1(x*5,0,z*5)*0.6+Land4(x*0.4, 0, z*0.8)*0.1}

#declare nearLand = height_field{function hfLandRes,hfLandRes {Land(x,0,y)} smooth 
  translate <-0.5,0,-0.5>
   scale <2000, 70, 2000>  // was 50 
   translate <-1000, -60, 1000>
   texture { treeBaseTex }
}                                       

#declare farLand = height_field{function hfLandRes,hfLandRes {Land(x,0,y)} smooth 
  translate <-0.5,0,-0.5>    
   scale <5000, 600, 4000>  // was 50 
  rotate <-10, 0, -10>
   translate <-2000, -420, 2000>
   texture { treeBaseTex }
}                                       

object { nearLand }
object { farLand }   

#if(showTree)
union
{
        placeTrees(nearLand, <-700, 500, 100>, <-500, 500, 1000>, 50, 10)
        placeTrees(farLand, <-5000, 1500, 2500>, <-2000, 1500, 5000>, 60, 18)
        placeTrees(farLand, <-2000, 1500, 3400>, <2000, 1500, 4500>, 60, 17)
} 
#end
#end 